(*
 * lablgtksourceview, OCaml binding for the GtkSourceView text widget
 *
 * Copyright (C) 2005  Stefano Zacchiroli <zack@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *)

open Gtk_sourceview
open Gaux
open Gobject
open Gtk
open Tags
open GtkSourceViewProps
open GtkBase

(* external gslist_of_string_list: string list -> 'a obj =
  "ml_gslist_of_string_list" *)

external _gtk_source_language_init: unit -> unit = "ml_gtk_source_language_init"
external _gtk_source_languages_manager_init: unit -> unit =
  "ml_gtk_source_languages_manager_init"
external _gtk_source_buffer_init: unit -> unit = "ml_gtk_source_buffer_init"
external _gtk_source_view_init: unit -> unit = "ml_gtk_source_view_init"

let () =
  _gtk_source_language_init ();
  _gtk_source_languages_manager_init ();
  _gtk_source_buffer_init ();
  _gtk_source_view_init ()

module SourceLanguage =
struct
  include SourceLanguage
  external new_from_file:
    string -> [>`sourcelanguagesmanager] obj -> source_language obj option
  =
    "ml__gtk_source_language_new_from_file"
  external get_name: [>`sourcelanguage] obj -> string =
    "ml_gtk_source_language_get_name"
  external get_section: [>`sourcelanguage] obj -> string =
    "ml_gtk_source_language_get_section"
(*   external get_tags: [>`sourcelanguage] obj -> source_tag list *)
  external get_escape_char: [>`sourcelanguage] obj -> Glib.unichar =
    "ml_gtk_source_language_get_escape_char"
(*   external get_mime_types: [>`sourcelanguage] obj -> string list *)
(*   external set_mime_types: [>`sourcelanguage] obj -> string list -> unit *)
(*   external get_style_scheme: [>`sourcelanguage] obj -> style_scheme *)
(*   external set_style_char: [>`sourcelanguage] obj -> style_scheme -> unit *)
(*   external get_tag_style: [>`sourcelanguage] obj -> tag_style *)
(*   external set_tag_style: [>`sourcelanguage] obj -> string -> tag_style -> unit *)
(*   external get_tag_default_style: [>`sourcelanguage] obj -> string -> tag_style *)
end

module SourceLanguagesManager =
struct
  include SourceLanguagesManager
  external new_: unit -> source_languages_manager obj =
    "ml_gtk_source_languages_manager_new"
(*   external get_available_languages:
    [>`sourcelanguagesmanager] obj -> source_language obj list
    = "ml_gtk_source_languages_manager_get_available_languages" *)
  external get_language_from_mime_type:
    [>`sourcelanguagesmanager] obj -> string -> source_language obj option
    = "ml_gtk_source_languages_manager_get_language_from_mime_type"
  external get_lang_files_dirs:
    [>`sourcelanguagesmanager] obj -> string list
    = "ml_gtk_source_languages_manager_get_lang_files_dirs"
(*   external set_lang_files_dirs:
    [>`sourcelanguagesmanager] obj -> string list -> unit
    = "ml_gtk_source_languages_manager_set_lang_files_dirs" *)
end

module SourceBuffer =
struct
  include SourceBuffer
(*   external new_: unit -> source_buffer obj = "ml_gtk_source_buffer_new" *)
(*   external new_with_buffer: [>`sourcelanguage] obj -> source_buffer obj =
    "ml_gtk_source_buffer_new_with_language" *)
  external can_undo: [>`sourcebuffer] obj -> bool =
    "ml_gtk_source_buffer_can_undo"
  external can_redo: [>`sourcebuffer] obj -> bool =
    "ml_gtk_source_buffer_can_redo"
  external undo: [>`sourcebuffer] obj -> unit = "ml_gtk_source_buffer_undo"
  external redo: [>`sourcebuffer] obj -> unit = "ml_gtk_source_buffer_redo"
  external begin_not_undoable_action: [>`sourcebuffer] obj -> unit =
    "ml_gtk_source_buffer_begin_not_undoable_action"
  external end_not_undoable_action: [>`sourcebuffer] obj -> unit =
    "ml_gtk_source_buffer_end_not_undoable_action"
end

module SourceView =
struct
  include SourceView
  external new_: unit -> source_view obj = "ml_gtk_source_view_new"
  external new_with_buffer: [>`sourcebuffer] obj -> source_view obj =
    "ml_gtk_source_view_new_with_buffer"
end

module SourceViewMisc =
struct
  external find_matching_bracket: text_iter -> bool =
    "ml_gtk_source_iter_find_matching_bracket"
end

