#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include <string.h>

#include "xmalloc.h"

extern void term_printf (const char *fmt, ...);
extern void hx_exit (int);

static void
xdie (size_t size)
{
	term_printf("xmalloc: could not allocate %lu bytes\n", (unsigned long)size);
	hx_exit(111);
}

void *
xmalloc (size_t size)
{
	void *p;

	if (!(p = malloc(size)))
		xdie(size);

	return p;
}

void *
xrealloc (void *ptr, size_t size)
{
	void *p;

	if (!(p = ptr ? realloc(ptr, size) : malloc(size)))
		xdie(size);

	return p;
}

void
xfree (void *ptr)
{
	if (ptr)
		free(ptr);
}

char *
xstrdup (const char *str)
{
	char *p;

	if (!str)
		return 0;
	strcpy((p = xmalloc(strlen(str) + 1)), str);

	return p;
}
