#include "hx_types.h"
#include "hxlib.h"
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include "term.h"
#include "screen.h"
#include "input.h"
#include "htlc.h"
#include "xmalloc.h"
#include "auto_array.h"

extern char last_msg[16];

void input_puts (struct input *ip)
{
	term_goto_line(LI);
	if (ip->pos > CO)
		write(1, &(ip->buf[ip->pos - (ip->pos % CO)]), (size_t)(ip->len % CO));
	else
		write(1, ip->buf, ip->len > (unsigned)CO ? (unsigned)CO : ip->len);
	term_ce();
	term_move_cursor(LI, ip->pos % CO);
}

void input_getchar (void)
{
	register struct input *ip;
	unsigned char c;

	ip = curscr->history.cur;

	if (read(0, &c, 1) <= 0) {
		if (errno == EINTR)
			return;
		term_printf("EOF from fd 0");
		hx_exit(-1);
	}

	switch (c) {
		case '\10':
		case '\177':
			if (!ip->pos)
				return;
			if (!(ip->pos % CO)) {
				term_goto_line(LI);
				write(1, ip->buf, (size_t)CO);
			}
			ip->pos--;
			memcpy(&(ip->buf[ip->pos]), &(ip->buf[ip->pos + 1]),
				(size_t)(ip->len - ip->pos));
			ip->len--;
			term_move_cursor(LI, ip->pos % CO);
			term_char_delete();
			break;
		case '\33':
			read(0, &c, 1);
			if (c == '\t') {
				if (!last_msg[0])
					return;
				if (ip->len)
					hist_add(&(curscr->history));
				ip = curscr->history.cur;
				ip->len = strlen(last_msg);
				ip->pos = ip->len % CO;
				ip->buf = xrealloc(ip->buf, 5 + ip->len);
				memcpy(ip->buf, last_msg, ip->len);
				input_puts(ip);
				return;
			}
			if ((c == '\n' || c == '\r') && ip->len) {
				auto_array(ip->buf, buf, ip->len);

				hist_add(&(curscr->history));
				write(1, "\r", 1);
				term_ce();
				strexpand(buf);
				if (!curchat)
					htlc_snd_chat_action(buf, (u_int16_t)strlen(buf));
				else
					htlc_snd_chat_chat_action(curchat->ref, buf, (u_int16_t)strlen(buf));
			}
			if (c != '[')
				return;
			read(0, &c, 1);
			switch (c) {
				case 'A':
					input_puts(hist_prev(&(curscr->history)));
					break;
				case 'B':
					input_puts(hist_next(&(curscr->history)));
					break;
				case 'C':
					if (ip->pos < ip->len) {
						ip->pos++;
						if (!(ip->pos % CO)) {
							term_goto_line(LI);
							write(1, &(ip->buf[ip->pos]),
								(ip->len - ip->pos) % (unsigned)CO);
							term_ce();
						}
						term_move_cursor(LI, ip->pos % CO);
					}
					break;
				case 'D':
					if (ip->pos) {
						if (!(ip->pos % CO)) {
							term_goto_line(LI);
							write(1, &(ip->buf[ip->pos - CO]),(unsigned)CO);
						} else
							term_move_cursor(LI, (ip->pos -1) % CO);
						ip->pos--;
					}
					break;
				case '5':
					read(0, &c, 1);
					if (c == '~')
						scr_page_up(curscr);
					break;
				case '6':
					read(0, &c, 1);
					if (c == '~')
						scr_page_down(curscr);
					break;
				case '1':
				case '7':
					read(0, &c, 1);
					if (c == '~')
						scr_page_home(curscr);
					break;
				case '4':
				case '8':
					read(0, &c, 1);
					if (c == '~')
						scr_page_end(curscr);
					break;
				case '2':
					read(0, &c, 1);
					if (c == '~')
						scr_line_up(curscr);
					break;
				case '3':
					read(0, &c, 1);
					if (c == '~')
						scr_line_down(curscr);
					break;
			}
			break;
		case 14:
			break;
		case '\t':
			if (!curscr->history.msg)
				return;
			if (ip->len)
				hist_add(&(curscr->history));
			ip = curscr->history.cur;
			ip->len = strlen(curscr->history.msg);
			ip->pos = ip->len % CO;
			ip->buf = xrealloc(ip->buf, 5 + ip->len);
			memcpy(ip->buf, curscr->history.msg, ip->len);
			input_puts(ip);
			break;
		case 0x0c:
			term_set_scroll_region(0, (signed)curscr->li);
			scr_draw(curscr);
			break;
		case '\n':
		case '\r':
			if (ip->len) {
				hist_add(&(curscr->history));
				write(1, "\r", 1);
				term_ce();
				curscr->history.fun(ip);
			}
			break;
		default:
			ip->buf = xrealloc(ip->buf, 5 + ip->len);
			if (ip->pos != ip->len++) {
				memmove(&(ip->buf[ip->pos + 1]), &(ip->buf[ip->pos]),
					(size_t)(ip->len - ip->pos));
				term_char_insert();
			}
			ip->buf[ip->pos++] = c;
			write(1, &c, 1);
			if (!(ip->pos % CO)) {
				term_goto_line(LI);
				term_ce();
			}
	}
}
