#include "hx_types.h"
#include "hxlib.h"
#include "input.h"
#include <string.h>
#include "xmalloc.h"

void
hist_init (struct history_list *list)
{
	struct input *cur;

	cur = xmalloc(sizeof *cur);
	memset(cur, 0, sizeof *cur);
	cur->buf = xmalloc(4);
	list->cur = cur;
	list->cur->next = list->cur->prev = list->next = list->prev = cur;

	list->count = 0;
	list->max = 100;
}

void
hist_add (struct history_list *list)
{
	struct input *new;

	new = xmalloc(sizeof *new);
	memset(new, 0, sizeof *new);
	new->buf = xmalloc(4);
	if (list->count >= list->max) {
		struct input *next = list->next ? list->next->next : new;
		if (list->cur->next == list->next)
			list->cur->next = next;
		xfree(list->next);
		list->next = next;
	} else
		list->count++;
	if (list->cur->next != list->next && list->cur != list->prev) {
		list->cur->prev->next = list->cur->next;
		list->cur->next->prev = list->cur->prev;
		list->cur->prev = list->prev;
		list->prev->next = list->cur;
	}
	if (list->cur == list->next)
		list->next = list->next->next;
	list->cur->next = new;
	new->prev = list->prev = list->cur;
	new->next = list->next;
	list->next->prev = list->cur = new;
}

struct input *
hist_next (struct history_list *list)
{
	return (list->cur = list->cur->next);
}

struct input *
hist_prev (struct history_list *list)
{
	return (list->cur = list->cur->prev);
}
