#include "hx_types.h"
#include "htlc.h"
#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include "hxlib.h"
#include "xmalloc.h"
#include "auto_array.h"

static int use_colourz;

int cmd_colourz (void);

int
cmd_colourz (void)
{
	use_colourz = use_colourz ? 0 : 1;

	return use_colourz;
}

void
colourz (char *str)
{
	if (!use_colourz) {
		if (!curchat)
			htlc_snd_chat(str, (u_int16_t)strlen(str));
		else
			htlc_snd_chat_chat(curchat->ref, str, (u_int16_t)strlen(str));
	} else {
		register char *p, *b;
		static unsigned short asf = 31;
		register unsigned short col = asf;
		auto_array(str, buf, (strlen(str) * 5) + 0xff);

		b = buf;
		strcpy(b, "\033[1m");
		b += 4;
		for (p = str; *p; p++) {
			if (isspace(*p)) {
				*b++ = *p;
				continue;
			}
			sprintf(b, "\033[%um%c", col++, *p);
			b += 6;
			if (col == 37)
				col = 31;
		}
		strcpy(b, "\033[0m");
		b += 4;
		if (!curchat)
			htlc_snd_chat(buf, b - buf);
		else
			htlc_snd_chat_chat(curchat->ref, buf, b - buf);
		asf = col;
		auto_free(buf);
	}
}
