/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.
 */

/* Prototypes of `exported' functions of mtest.c and cacherefr.c */

#ifndef HAVE_MTEST_H
#define HAVE_MTEST_H

/* Types */
typedef unsigned long long pattern64;
/* From update_adr.c */
#define ADRCODE_LEN 1024
typedef unsigned char adrbitmap_t[32];
typedef unsigned char adrcode_t[ADRCODE_LEN];	/* MUST be uchar!! */

/* Variables; declared in mtest.c */
extern volatile unsigned long param[];
extern volatile unsigned long sub_errorno;
extern volatile unsigned long sub_errors[];
extern volatile unsigned long *error_p;
extern volatile unsigned long *lasterror_p;

extern unsigned long startadr;
extern unsigned long endadr;

extern adrbitmap_t adrbitmap_list[];
extern adrbitmap_t *adrbitmap_p;

extern adrbitmap_t pretest_adrbitmap;
extern adrcode_t pre_adrcode;
extern adrcode_t real_adrcode;
extern unsigned long pre_adrcode_len;
extern unsigned long real_adrcode_len;

extern volatile char pseudor_data[];
extern volatile char *pseudor_start1;
extern volatile char *pseudor_end1;
extern volatile char *pseudor_start2;
extern volatile char *pseudor_end2;
extern volatile pattern64 currentpr64;
extern volatile pattern64 startpr64;
extern volatile pattern64 endpr64;

extern unsigned long sub_cachemode;
extern unsigned long total_error_count;
extern unsigned long pass;
extern unsigned long testset;
extern int cache_mode;
extern int refresh_mode;
extern unsigned long patterncount;
extern unsigned long patterngen;

/* Function prototypes */
void clear_sub_errors (void);
void showerrors64 (char *testname);
void printtestname64_2 (char *testname, pattern64 p, pattern64 n);
void printtestname64_1 (char *testname, pattern64 p);
void printtestname_0 (char *testname);
void printsubtestname64_2 (char *testname, pattern64 p, pattern64 n);
void printsubtestname64_1 (char *testname, pattern64 p);
void println (void);
void cprint (char *s);
void bprint (unsigned char val);
void hprint (unsigned long val);
void p64print (pattern64 val);
void memdump (unsigned long start, signed long count);
void set_cache ();
void set_refresh ();
void input_buffer (void);
void delay (unsigned long seconds);

/* Prototype for main test sequence from tests.c */
void testseq (void);

/* Prototype for main pattern generator from pattern_gen.c */
int pattern_generate64 (pattern64 * p, pattern64 * n);



/* From update_adr.c */
int prepare_update_adr_up (adrbitmap_t adrbitmap, unsigned long procstartadr,
			   unsigned long procendadr, char allowranges,
			   adrcode_t adrcode);
int prepare_update_adr_dn (adrbitmap_t adrbitmap, unsigned long procstartadr,
			   unsigned long procendadr, char allowranges,
			   adrcode_t adrcode);


#endif /* HAVE_MTEST_H */
