/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.
 */

/* Here are the prototypes of the test routines */

/* For the types: */
#include "mtest.h"

/* March elements */
void marchel_up_template (char *testname, void (mltest) (void), char argno,
			  pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_template (char *testname, void (mltest) (void), char argno,
			  pattern64 pattern_p, pattern64 pattern_n);
void prmarchel_up_template (char *testname, void (mltest) (void), char argno,
			    pattern64 * pattern_p, pattern64 * pattern_n);

void marchel_up_wp (pattern64 pattern_p);
void marchel_dn_wp (pattern64 pattern_p);
void marchel_up_rp (pattern64 pattern_p);
void marchel_dn_rp (pattern64 pattern_p);

void marchel_up_rp_wn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_rp_wn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_up_rp_rn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_rp_rn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_up_wp_rn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_wp_rn (pattern64 pattern_p, pattern64 pattern_n);

void marchel_up_rp_rp_wn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_rp_rp_wn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_up_rp_wn_rn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_rp_wn_rn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_up_rp_wn_wp (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_rp_wn_wp (pattern64 pattern_p, pattern64 pattern_n);
void marchel_up_wp_wn_rn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_wp_wn_rn (pattern64 pattern_p, pattern64 pattern_n);

void marchel_up_rp_wn_rn_rn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_rp_wn_rn_rn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_up_rp_wn_rn_wp (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_rp_wn_rn_wp (pattern64 pattern_p, pattern64 pattern_n);
void marchel_up_rp_wn_wp_wn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_rp_wn_wp_wn (pattern64 pattern_p, pattern64 pattern_n);

void marchel_up_rp_wn_rn_rn_wp (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_rp_wn_rn_rn_wp (pattern64 pattern_p, pattern64 pattern_n);
void marchel_up_rp_wn_wp_wn_rn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_rp_wn_wp_wn_rn (pattern64 pattern_p, pattern64 pattern_n);

void marchel_up_rp_wn_rn_wp_rp_wn (pattern64 pattern_p, pattern64 pattern_n);
void marchel_dn_rp_wn_rn_wp_rp_wn (pattern64 pattern_p, pattern64 pattern_n);

void prmarchel_up_rp (pattern64 * pattern_p);
void prmarchel_up_wp (pattern64 * pattern_p);

void prmarchel_up_rp_wn (pattern64 * pattern_p, pattern64 * pattern_n);

void prmarchel_up_rp_wn_rn (pattern64 * pattern_p, pattern64 * pattern_n);

#if 0

void prdmarchel_up_wp (pattern64 * pattern_p);
#endif

/* Complete march tests */
void march_a (pattern64 pattern_p, pattern64 pattern_n);
void march_b (pattern64 pattern_p, pattern64 pattern_n);
void march_cminus (pattern64 pattern_p, pattern64 pattern_n);
void march_cminus_r (pattern64 pattern_p, pattern64 pattern_n);
void march_g (pattern64 pattern_p, pattern64 pattern_n);
void march_la (pattern64 pattern_p, pattern64 pattern_n);
void march_lr (pattern64 pattern_p, pattern64 pattern_n);
void march_matsplus (pattern64 pattern_p, pattern64 pattern_n);
void march_matsplusplus (pattern64 pattern_p, pattern64 pattern_n);
void march_pmovi (pattern64 pattern_p, pattern64 pattern_n);
void march_pmovi_r (pattern64 pattern_p, pattern64 pattern_n);
void march_scan (pattern64 pattern_p, pattern64 pattern_n);
void march_u (pattern64 pattern_p, pattern64 pattern_n);
void march_u_r (pattern64 pattern_p, pattern64 pattern_n);
void march_ud (pattern64 pattern_p, pattern64 pattern_n);
void march_y (pattern64 pattern_p, pattern64 pattern_n);

void prmarch_prscan (unsigned long passes);
void prmarch_prcminus (unsigned long passes);
void prmarch_prpmovi (unsigned long passes);
