/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.  
 */

/* Test the various sizes from defines.h */

/* Arguments: 
   ".text-size .rodata-size .data-size .bss-size make-testadr make-dataadr"
   all hex, incl. "0x" */

#include <stdio.h>
#include "defines.h"

int
main (int argc, char **argv)
{
  unsigned long
    realtextsize, realrodatasize, realdatasize, realbsssize, maketestadr,
    makedataadr;

  if (argc != 6 + 1)
    {
      fprintf (stderr, "Wrong #args to checksizes, %i\n", argc);
      return 1;
    }

  /* Get real sizes from commandline */
  if (sscanf (argv[1], "%li", &realtextsize) != 1)
    return 10;
  if (sscanf (argv[2], "%li", &realrodatasize) != 1)
    return 11;
  if (sscanf (argv[3], "%li", &realdatasize) != 1)
    return 12;
  if (sscanf (argv[4], "%li", &realbsssize) != 1)
    return 13;
  if (sscanf (argv[5], "%li", &maketestadr) != 1)
    return 14;
  if (sscanf (argv[6], "%li", &makedataadr) != 1)
    return 15;

  if (realtextsize + realrodatasize > CODESZ)
    {
      fprintf (stderr, "CODESZ too small. Adjust defines.h and Makefile\n");
      return 101;
    }
  if (realdatasize > DATASZ)
    {
      fprintf (stderr, "DATASZ too small. Adjust defines.h\n");
      return 102;
    }
  if (realbsssize > UDATASZ)
    {
      fprintf (stderr, "UDATASZ too small. Adjust defines.h\n");
      return 103;
    }

  if (maketestadr != TESTADR)
    {
      fprintf (stderr, "TESTADR in Makefile doesn't match defines.h\n");
      return 104;
    }
  if (makedataadr != TESTADR + CODESZ)
    {
      fprintf (stderr, "DATAADR in Makefile doesn't match defines.h\n");
      return 105;
    }

  if (TESTSZ != CODESZ + DATASZ)
    {
      fprintf (stderr, "TESTSZ != CODESZ + DATASZ in defines.h\n");
      return 106;
    }
  if (TESTSZ != TESTSZ2)
    {
      fprintf (stderr, "TESTSZ2 != TESTSZ in defines.h\n");
      return 107;
    }

  /* all ok */
  printf ("All sizes are okay.\n");
  return 0;
}
