// Code generated by gqlclientgen - DO NOT EDIT

package metasrht

import (
	"context"
	gqlclient "git.sr.ht/~emersion/gqlclient"
)

type AccessKind string

const (
	AccessKindRo AccessKind = "RO"
	AccessKindRw AccessKind = "RW"
)

type AccessScope string

const (
	AccessScopeAuditLog AccessScope = "AUDIT_LOG"
	AccessScopeBilling  AccessScope = "BILLING"
	AccessScopePgpKeys  AccessScope = "PGP_KEYS"
	AccessScopeSshKeys  AccessScope = "SSH_KEYS"
	AccessScopeProfile  AccessScope = "PROFILE"
)

// A cursor for enumerating a list of audit log entries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type AuditLogCursor struct {
	Results []AuditLogEntry `json:"results"`
	Cursor  *Cursor         `json:"cursor,omitempty"`
}

type AuditLogEntry struct {
	Id        int32          `json:"id"`
	Created   gqlclient.Time `json:"created"`
	IpAddress string         `json:"ipAddress"`
	EventType string         `json:"eventType"`
	Details   *string        `json:"details,omitempty"`
}

type Cursor string

type Entity struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Updated gqlclient.Time `json:"updated"`
	// The canonical name of this entity. For users, this is their username
	// prefixed with '~'. Additional entity types will be supported in the future.
	CanonicalName string `json:"canonicalName"`
}

type Invoice struct {
	Id        int32          `json:"id"`
	Created   gqlclient.Time `json:"created"`
	Cents     int32          `json:"cents"`
	ValidThru gqlclient.Time `json:"validThru"`
	Source    *string        `json:"source,omitempty"`
}

// A cursor for enumerating a list of invoices
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type InvoiceCursor struct {
	Results []Invoice `json:"results"`
	Cursor  *Cursor   `json:"cursor,omitempty"`
}

type OAuthClient struct {
	Id          int32   `json:"id"`
	Uuid        string  `json:"uuid"`
	RedirectUrl string  `json:"redirectUrl"`
	Name        string  `json:"name"`
	Description *string `json:"description,omitempty"`
	Url         *string `json:"url,omitempty"`
	Owner       *Entity `json:"owner"`
}

type OAuthClientRegistration struct {
	Client *OAuthClient `json:"client"`
	Secret string       `json:"secret"`
}

type OAuthGrant struct {
	Id        int32          `json:"id"`
	Client    *OAuthClient   `json:"client"`
	Issued    gqlclient.Time `json:"issued"`
	Expires   gqlclient.Time `json:"expires"`
	TokenHash string         `json:"tokenHash"`
}

type OAuthGrantRegistration struct {
	Grant  *OAuthGrant `json:"grant"`
	Grants string      `json:"grants"`
	Secret string      `json:"secret"`
}

type OAuthPersonalToken struct {
	Id      int32          `json:"id"`
	Issued  gqlclient.Time `json:"issued"`
	Expires gqlclient.Time `json:"expires"`
	Comment *string        `json:"comment,omitempty"`
}

type OAuthPersonalTokenRegistration struct {
	Token  *OAuthPersonalToken `json:"token"`
	Secret string              `json:"secret"`
}

type PGPKey struct {
	Id          int32          `json:"id"`
	Created     gqlclient.Time `json:"created"`
	User        *User          `json:"user"`
	Key         string         `json:"key"`
	Fingerprint string         `json:"fingerprint"`
}

// A cursor for enumerating a list of PGP keys
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type PGPKeyCursor struct {
	Results []PGPKey `json:"results"`
	Cursor  *Cursor  `json:"cursor,omitempty"`
}

type PGPKeyEvent struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`
	Key   *PGPKey        `json:"key"`
}

type ProfileUpdateEvent struct {
	Uuid    string         `json:"uuid"`
	Event   WebhookEvent   `json:"event"`
	Date    gqlclient.Time `json:"date"`
	Profile *User          `json:"profile"`
}

type ProfileWebhookInput struct {
	Url    string         `json:"url"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
}

type ProfileWebhookSubscription struct {
	Id         int32                  `json:"id"`
	Events     []WebhookEvent         `json:"events"`
	Query      string                 `json:"query"`
	Url        string                 `json:"url"`
	Client     *OAuthClient           `json:"client,omitempty"`
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	Sample     string                 `json:"sample"`
}

type SSHKey struct {
	Id          int32          `json:"id"`
	Created     gqlclient.Time `json:"created"`
	LastUsed    gqlclient.Time `json:"lastUsed,omitempty"`
	User        *User          `json:"user"`
	Key         string         `json:"key"`
	Fingerprint string         `json:"fingerprint"`
	Comment     *string        `json:"comment,omitempty"`
}

// A cursor for enumerating a list of SSH keys
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type SSHKeyCursor struct {
	Results []SSHKey `json:"results"`
	Cursor  *Cursor  `json:"cursor,omitempty"`
}

type SSHKeyEvent struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`
	Key   *SSHKey        `json:"key"`
}

type User struct {
	Id               int32          `json:"id"`
	Created          gqlclient.Time `json:"created"`
	Updated          gqlclient.Time `json:"updated"`
	CanonicalName    string         `json:"canonicalName"`
	Username         string         `json:"username"`
	Email            string         `json:"email"`
	Url              *string        `json:"url,omitempty"`
	Location         *string        `json:"location,omitempty"`
	Bio              *string        `json:"bio,omitempty"`
	UserType         UserType       `json:"userType"`
	SuspensionNotice *string        `json:"suspensionNotice,omitempty"`
	SshKeys          *SSHKeyCursor  `json:"sshKeys"`
	PgpKeys          *PGPKeyCursor  `json:"pgpKeys"`
}

// Omit these fields to leave them unchanged, or set them to null to clear
// their value.
type UserInput struct {
	Url      *string `json:"url,omitempty"`
	Location *string `json:"location,omitempty"`
	Bio      *string `json:"bio,omitempty"`
	// Note: changing the user's email address will not take effect immediately;
	// the user is sent an email to confirm the change first.
	Email *string `json:"email,omitempty"`
}

type UserType string

const (
	UserTypeUnconfirmed      UserType = "UNCONFIRMED"
	UserTypeActiveNonPaying  UserType = "ACTIVE_NON_PAYING"
	UserTypeActiveFree       UserType = "ACTIVE_FREE"
	UserTypeActivePaying     UserType = "ACTIVE_PAYING"
	UserTypeActiveDelinquent UserType = "ACTIVE_DELINQUENT"
	UserTypeAdmin            UserType = "ADMIN"
	UserTypeSuspended        UserType = "SUSPENDED"
)

type Version struct {
	Major int32 `json:"major"`
	Minor int32 `json:"minor"`
	Patch int32 `json:"patch"`
	// If this API version is scheduled for deprecation, this is the date on which
	// it will stop working; or null if this API version is not scheduled for
	// deprecation.
	DeprecationDate gqlclient.Time `json:"deprecationDate,omitempty"`
}

type WebhookDelivery struct {
	Uuid         string               `json:"uuid"`
	Date         gqlclient.Time       `json:"date"`
	Event        WebhookEvent         `json:"event"`
	Subscription *WebhookSubscription `json:"subscription"`
	RequestBody  string               `json:"requestBody"`
	// These details are provided only after a response is received from the
	// remote server. If a response is sent whose Content-Type is not text/*, or
	// cannot be decoded as UTF-8, the response body will be null. It will be
	// truncated after 64 KiB.
	ResponseBody    *string `json:"responseBody,omitempty"`
	ResponseHeaders *string `json:"responseHeaders,omitempty"`
	ResponseStatus  *int32  `json:"responseStatus,omitempty"`
}

// A cursor for enumerating a list of webhook deliveries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookDeliveryCursor struct {
	Results []WebhookDelivery `json:"results"`
	Cursor  *Cursor           `json:"cursor,omitempty"`
}

type WebhookEvent string

const (
	// Used for user profile webhooks
	WebhookEventProfileUpdate WebhookEvent = "PROFILE_UPDATE"
	WebhookEventPgpKeyAdded   WebhookEvent = "PGP_KEY_ADDED"
	WebhookEventPgpKeyRemoved WebhookEvent = "PGP_KEY_REMOVED"
	WebhookEventSshKeyAdded   WebhookEvent = "SSH_KEY_ADDED"
	WebhookEventSshKeyRemoved WebhookEvent = "SSH_KEY_REMOVED"
)

type WebhookPayload struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`
}

type WebhookSubscription struct {
	Id     int32          `json:"id"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
	Url    string         `json:"url"`
	// If this webhook was registered by an authorized OAuth 2.0 client, this
	// field is non-null.
	Client *OAuthClient `json:"client,omitempty"`
	// All deliveries which have been sent to this webhook.
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	// Returns a sample payload for this subscription, for testing purposes
	Sample string `json:"sample"`
}

// A cursor for enumerating a list of webhook subscriptions
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookSubscriptionCursor struct {
	Results []WebhookSubscription `json:"results"`
	Cursor  *Cursor               `json:"cursor,omitempty"`
}

func FetchMe(client *gqlclient.Client, ctx context.Context) (me *User, err error) {
	op := gqlclient.NewOperation("query fetchMe {\n\tme {\n\t\t... user\n\t}\n}\nfragment user on User {\n\tcanonicalName\n\temail\n\turl\n\tlocation\n\tbio\n}\n")
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func FetchUser(client *gqlclient.Client, ctx context.Context, username string) (userByName *User, err error) {
	op := gqlclient.NewOperation("query fetchUser ($username: String!) {\n\tuserByName(username: $username) {\n\t\t... user\n\t}\n}\nfragment user on User {\n\tcanonicalName\n\temail\n\turl\n\tlocation\n\tbio\n}\n")
	op.Var("username", username)
	var respData struct {
		UserByName *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserByName, err
}

func ListSSHKeys(client *gqlclient.Client, ctx context.Context) (me *User, err error) {
	op := gqlclient.NewOperation("query listSSHKeys {\n\tme {\n\t\t... sshKeys\n\t}\n}\nfragment sshKeys on User {\n\tsshKeys {\n\t\tresults {\n\t\t\tid\n\t\t\tfingerprint\n\t\t\tcomment\n\t\t}\n\t}\n}\n")
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func ListSSHKeysByUser(client *gqlclient.Client, ctx context.Context, username string) (userByName *User, err error) {
	op := gqlclient.NewOperation("query listSSHKeysByUser ($username: String!) {\n\tuserByName(username: $username) {\n\t\t... sshKeys\n\t}\n}\nfragment sshKeys on User {\n\tsshKeys {\n\t\tresults {\n\t\t\tid\n\t\t\tfingerprint\n\t\t\tcomment\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	var respData struct {
		UserByName *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserByName, err
}

func ListRawSSHKeys(client *gqlclient.Client, ctx context.Context) (me *User, err error) {
	op := gqlclient.NewOperation("query listRawSSHKeys {\n\tme {\n\t\t... sshKeysRaw\n\t}\n}\nfragment sshKeysRaw on User {\n\tsshKeys {\n\t\tresults {\n\t\t\tkey\n\t\t}\n\t}\n}\n")
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func ListRawSSHKeysByUser(client *gqlclient.Client, ctx context.Context, username string) (userByName *User, err error) {
	op := gqlclient.NewOperation("query listRawSSHKeysByUser ($username: String!) {\n\tuserByName(username: $username) {\n\t\t... sshKeysRaw\n\t}\n}\nfragment sshKeysRaw on User {\n\tsshKeys {\n\t\tresults {\n\t\t\tkey\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	var respData struct {
		UserByName *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserByName, err
}

func ListPGPKeys(client *gqlclient.Client, ctx context.Context) (me *User, err error) {
	op := gqlclient.NewOperation("query listPGPKeys {\n\tme {\n\t\t... pgpKeys\n\t}\n}\nfragment pgpKeys on User {\n\tpgpKeys {\n\t\tresults {\n\t\t\tid\n\t\t\tfingerprint\n\t\t}\n\t}\n}\n")
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func ListPGPKeysByUser(client *gqlclient.Client, ctx context.Context, username string) (userByName *User, err error) {
	op := gqlclient.NewOperation("query listPGPKeysByUser ($username: String!) {\n\tuserByName(username: $username) {\n\t\t... pgpKeys\n\t}\n}\nfragment pgpKeys on User {\n\tpgpKeys {\n\t\tresults {\n\t\t\tid\n\t\t\tfingerprint\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	var respData struct {
		UserByName *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserByName, err
}

func ListRawPGPKeys(client *gqlclient.Client, ctx context.Context) (me *User, err error) {
	op := gqlclient.NewOperation("query listRawPGPKeys {\n\tme {\n\t\t... pgpKeysRaw\n\t}\n}\nfragment pgpKeysRaw on User {\n\tpgpKeys {\n\t\tresults {\n\t\t\tkey\n\t\t}\n\t}\n}\n")
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func ListRawPGPKeysByUser(client *gqlclient.Client, ctx context.Context, username string) (userByName *User, err error) {
	op := gqlclient.NewOperation("query listRawPGPKeysByUser ($username: String!) {\n\tuserByName(username: $username) {\n\t\t... pgpKeysRaw\n\t}\n}\nfragment pgpKeysRaw on User {\n\tpgpKeys {\n\t\tresults {\n\t\t\tkey\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	var respData struct {
		UserByName *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserByName, err
}

func AuditLog(client *gqlclient.Client, ctx context.Context) (auditLog *AuditLogCursor, err error) {
	op := gqlclient.NewOperation("query auditLog {\n\tauditLog {\n\t\tresults {\n\t\t\tcreated\n\t\t\tipAddress\n\t\t\teventType\n\t\t\tdetails\n\t\t}\n\t}\n}\n")
	var respData struct {
		AuditLog *AuditLogCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.AuditLog, err
}

func UserWebhooks(client *gqlclient.Client, ctx context.Context) (profileWebhooks *WebhookSubscriptionCursor, err error) {
	op := gqlclient.NewOperation("query userWebhooks {\n\tprofileWebhooks {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t}\n}\n")
	var respData struct {
		ProfileWebhooks *WebhookSubscriptionCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.ProfileWebhooks, err
}

func CreateSSHKey(client *gqlclient.Client, ctx context.Context, key string) (createSSHKey *SSHKey, err error) {
	op := gqlclient.NewOperation("mutation createSSHKey ($key: String!) {\n\tcreateSSHKey(key: $key) {\n\t\tfingerprint\n\t\tcomment\n\t}\n}\n")
	op.Var("key", key)
	var respData struct {
		CreateSSHKey *SSHKey
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateSSHKey, err
}

func CreatePGPKey(client *gqlclient.Client, ctx context.Context, key string) (createPGPKey *PGPKey, err error) {
	op := gqlclient.NewOperation("mutation createPGPKey ($key: String!) {\n\tcreatePGPKey(key: $key) {\n\t\tfingerprint\n\t}\n}\n")
	op.Var("key", key)
	var respData struct {
		CreatePGPKey *PGPKey
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreatePGPKey, err
}

func DeleteSSHKey(client *gqlclient.Client, ctx context.Context, id int32) (deleteSSHKey *SSHKey, err error) {
	op := gqlclient.NewOperation("mutation deleteSSHKey ($id: Int!) {\n\tdeleteSSHKey(id: $id) {\n\t\tfingerprint\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteSSHKey *SSHKey
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteSSHKey, err
}

func DeletePGPKey(client *gqlclient.Client, ctx context.Context, id int32) (deletePGPKey *PGPKey, err error) {
	op := gqlclient.NewOperation("mutation deletePGPKey ($id: Int!) {\n\tdeletePGPKey(id: $id) {\n\t\tfingerprint\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeletePGPKey *PGPKey
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeletePGPKey, err
}

func CreateUserWebhook(client *gqlclient.Client, ctx context.Context, config ProfileWebhookInput) (createWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation createUserWebhook ($config: ProfileWebhookInput!) {\n\tcreateWebhook(config: $config) {\n\t\tid\n\t}\n}\n")
	op.Var("config", config)
	var respData struct {
		CreateWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateWebhook, err
}

func DeleteUserWebhook(client *gqlclient.Client, ctx context.Context, id int32) (deleteWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation deleteUserWebhook ($id: Int!) {\n\tdeleteWebhook(id: $id) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteWebhook, err
}
