/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <xpl.h>
#include <msgapi.h>
#include <nmap.h>
#include <hulautil.h>

#include <modweb.h>		/* APIs */
#include <mwtempl.h>		/* Token definition */

#include "mwmail.h"

#define	FOLDER_BLOCK_SIZE		1024

BOOL
MwMailProcessFolderManagementForm(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long Action)
{
	unsigned long	ValueSize;
	unsigned char	FieldName[128];
	unsigned long	Offset = 0;
	unsigned long	RetVal;
	unsigned long	SelectedFolder = 0;
	unsigned char	NewNameUTF8[XPL_MAX_PATH * 3 + 1];
	unsigned char	NewNameUTF7[XPL_MAX_PATH * 4 + 1];
	unsigned char	*ptr;
	BOOL				NewCalendar = FALSE;

	/* We'll be ignoring any form fields that are irrelevant for us */

	if (Session->FolderList == NULL || Session->FolderList->Used == 0 || Session->ReadOnly) {
		return(FALSE);
	}

	NewNameUTF8[0] = '\0';
	while (MWGetFormName(Client, FieldName, 128)) {
		ValueSize = BUFSIZE - Offset;

		while ((RetVal = MWGetFormValue(Client, Client->Temp + Offset, &ValueSize)) != FORMFIELD_NEXT) {
			ValueSize += Offset;

			if (MWQuickCmp("NewName", FieldName)) {
				HulaStrNCpy(NewNameUTF8, Client->Temp, sizeof(NewNameUTF8));
			} else if (MWQuickCmp("FolderName", FieldName)) {
				SelectedFolder = atol(Client->Temp);
			} else if (MWQuickCmp("Type", FieldName)) {
				if (toupper(Client->Temp[0]) == 'C') {
					NewCalendar = TRUE;
				}
			}
			ValueSize = BUFSIZE - Offset;
		}
		Offset = 0;
	}

	if (SelectedFolder > Session->FolderList->Used) {
		/* They sent a folder number that is higher than what we have*/
		return(FALSE);
	}

	switch (Action) {
		case AA_CREATEFOLDER: {
			Session->FolderListIsDirty = TRUE;

			NewNameUTF7[MwMailFolderUTF8toUTF7(NewNameUTF8, strlen(NewNameUTF8), NewNameUTF7, sizeof(NewNameUTF7))] = '\0';

			if (!NewCalendar) {
				if (SelectedFolder == 0) {
					RetVal = snprintf(Client->Temp, sizeof(Client->Temp), "CREA %s\r\n", NewNameUTF7);
				} else {
					RetVal = snprintf(Client->Temp, sizeof(Client->Temp), "CREA %s/%s\r\n", Session->FolderList->Value[SelectedFolder - 1] + 3, NewNameUTF7);
				}
			} else {
				/* Create a calendar instead of a mailbox */
				if (SelectedFolder == 0) {
					RetVal = snprintf(Client->Temp, sizeof(Client->Temp), "CSCREA %s\r\n", NewNameUTF7);
				} else {
					RetVal = snprintf(Client->Temp, sizeof(Client->Temp), "CSCREA %s/%s\r\n", Session->FolderList->Value[SelectedFolder - 1] + 3, NewNameUTF7);
				}
			}
			MWSendNMAPServer(Session, Client->Temp, strlen(Client->Temp));
			RetVal = MWGetNMAPAnswer(Session, Client->Temp, BUFSIZE, TRUE);
			if (RetVal != 1000) {
				MailSession->Error = ERROR_CREATING_FOLDER__CREA;
			}

			return(TRUE);
		}

		case AA_RENAMEFOLDER: {
			if (SelectedFolder >= 2) {
				Session->FolderListIsDirty = TRUE;

				SelectedFolder--;

				NewNameUTF7[MwMailFolderUTF8toUTF7(NewNameUTF8, strlen(NewNameUTF8), NewNameUTF7, sizeof(NewNameUTF7))] = '\0';
				ptr = strrchr(Session->FolderList->Value[SelectedFolder] + 3, '/');

				if (ptr) {
					if (Session->FolderList->Value[SelectedFolder][0] != 'C') {
						RetVal = snprintf(Client->Temp, sizeof(Client->Temp), "RNAM %s ", Session->FolderList->Value[SelectedFolder] + 3);
					} else {
						RetVal = snprintf(Client->Temp, sizeof(Client->Temp), "CSRNAM %s ", Session->FolderList->Value[SelectedFolder] + 3);
					}

					*ptr = '\0';
					strncat(Client->Temp, Session->FolderList->Value[SelectedFolder] + 3, sizeof(Client->Temp));
					RetVal += strlen(Session->FolderList->Value[SelectedFolder] + 3);
					*ptr = '/';

					strncat(Client->Temp, "/", sizeof(Client->Temp));
					RetVal += 1;

					strncat(Client->Temp, NewNameUTF7, sizeof(Client->Temp));
					RetVal += strlen(NewNameUTF7);

					strncat(Client->Temp, "\r\n", sizeof(Client->Temp));
					
					RetVal += 2;
				} else {
					if (Session->FolderList->Value[SelectedFolder][0] != 'C') {
						RetVal = snprintf(Client->Temp, sizeof(Client->Temp), "RNAM %s %s\r\n", Session->FolderList->Value[SelectedFolder] + 3, NewNameUTF7);
					} else {
						RetVal = snprintf(Client->Temp, sizeof(Client->Temp), "CSRNAM %s %s\r\n", Session->FolderList->Value[SelectedFolder] + 3, NewNameUTF7);
					}
				}

				MWSendNMAPServer(Session, Client->Temp, RetVal);
				RetVal = MWGetNMAPAnswer(Session, Client->Temp, BUFSIZE, TRUE);
				if (RetVal == 1000) {
					return(TRUE);
				}

				MailSession->Error = ERROR_RENAMING_FOLDER__RNAM;
				return(FALSE);
			}

			MailSession->Error = ERROR_NO_FOLDER_SELECTED;
			return(FALSE);
		}

		case AA_DELETEFOLDER: {
			if (SelectedFolder >= 2) {
				Session->FolderListIsDirty = TRUE;
				/* Select INBOX before removing folder */
				/* This will just return if INBOX is already selected */
				MwMailSelectFolder(0, Session, MailSession);

				SelectedFolder--;
				if (Session->FolderList->Value[SelectedFolder][0] != 'C') {
					RetVal = snprintf(Client->Temp, sizeof(Client->Temp), "RMOV %s\r\n", Session->FolderList->Value[SelectedFolder] + 3);
				} else {
					RetVal = snprintf(Client->Temp, sizeof(Client->Temp), "CSRMOV %s\r\n", Session->FolderList->Value[SelectedFolder] + 3);
				}
				MWSendNMAPServer(Session, Client->Temp, strlen(Client->Temp));
				RetVal = MWGetNMAPAnswer(Session, Client->Temp, BUFSIZE, TRUE);
				if (RetVal == 1000) {
					return(TRUE);
				}

				MailSession->Error = ERROR_REMOVING_FOLDER__RMOV;
				return(FALSE);
			}

			MailSession->Error = ERROR_NO_FOLDER_SELECTED;
			return(FALSE);
		}
	}

	return(FALSE);
}
