/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <xpl.h>
#include <msgapi.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <hulautil.h>
#include <mdb.h>

#include "webadminp.h"
#include "webadmin.ary"

#define	ProcessModifyForm(Session)				ProcessCreateForm(Session, NULL, NULL);


#define	CMWriteDN(Object, Attribute, ValueStruct)																	\
	{																																\
		if (Create) {																											\
			for (z = 0; z < (ValueStruct)->Used; z++) {																\
				MDBAddDNAttribute((Attribute), (ValueStruct)->Value[z], CreateName, CreateValue);		\
			}																														\
		} else {																													\
			MDBWriteDN(Object, Attribute, ValueStruct);																\
		}																															\
	}

#define	CMWrite(Object, Attribute, ValueStruct)																	\
	{																																\
		if (Create) {																											\
			for (z = 0; z < (ValueStruct)->Used; z++) {																\
				MDBAddStringAttribute((Attribute), (ValueStruct)->Value[z], CreateName, CreateValue);	\
			}																														\
		} else {																													\
			MDBWrite(Object, Attribute, ValueStruct);																	\
		}																															\
	}

#define	CMAddDN(Object, Attribute, Data, ValueStruct)															\
	{																																\
		if (Create) {																											\
			MDBAddDNAttribute((Attribute), Data, CreateName, CreateValue);										\
		} else {																													\
			MDBAddDN(Object, Attribute, Data, ValueStruct);															\
		}																															\
	}

static BOOL
ProcessCreateForm(SessionStruct *Session, unsigned char *ObjectName, unsigned char *ObjectClass)
{
	unsigned long		i;
	unsigned long		z;
	unsigned long		c;
	BOOL					Create = FALSE;
	unsigned char		*PasswordNew = NULL;
	unsigned char		*PasswordOld = NULL;
	BOOL					PasswordsMatch = FALSE;
	MDBValueStruct		*CreateName;
	MDBValueStruct		*CreateValue;
	MDBValueStruct		*ReferenceObject = NULL;
	MDBValueStruct		*ReferenceAttr = NULL;
	MDBValueStruct		*ReferenceValue = NULL;

	if (ObjectName && ObjectClass) {
		Create = TRUE;

		CreateName = MDBCreateValueStruct(Session->AuthHandle, Session->CurrentObject);

		strcat(Session->CurrentObject, "\\");
		strcat(Session->CurrentObject, ObjectName);
	} else {
		CreateName = MDBShareContext(Session->V);
	}

	CreateValue = MDBShareContext(Session->V);

	for (c = 0; (c < Session->LastFormNames->Used && c < Session->LastFormValues->Used); c++) {
		unsigned char		*Name = Session->LastFormNames->Value[c];
		unsigned char		*Value = Session->LastFormValues->Value[c];

		/* Parse out the names generated by the Write.* Tokens */
		switch (toupper(Name[0])) {
			case 'D': {
				if (toupper(Name[1]) == '_') {		/* DN */
					long					Attribute = -1;
					long					ReferenceAttribute = -1;
					MDBValueStruct		*DN;
					MDBValueStruct		*ReferenceDN;
					BOOL					Multi = FALSE;
					BOOL					ReferenceMulti = FALSE;
					unsigned char		*Begin;
					unsigned char		*End;

					DN = MDBShareContext(Session->V);
					ReferenceDN = MDBShareContext(Session->V);

					/* Min length for DN */
					if (strlen(Name) > 6) {
						unsigned char		*Reference;

						if (Name[2] == 'M') {
							Multi = TRUE;
						}

						/* Find the attribute name */
						Attribute = atol(Name + 5);
						if (!(((Attribute % 9) == (Name[3] - '0')) && ((Attribute % 7) == (Name[4] - '0')))) {
							Attribute = -1;
						}

						/* Find the reference attribute name */
						Reference = strchr(Name + 2, '_');
						if (Reference) {
							if (Reference[1] == 'M') {
								ReferenceMulti = TRUE;
							}

							ReferenceAttribute = atol(Reference + 4);
							if (!(((ReferenceAttribute % 9) == (Reference[2] - '0')) && ((ReferenceAttribute % 7) == (Reference[3] - '0')))) {
								ReferenceAttribute = -1;
							}
						}
					}

					/* At this point we have parsed the name, and have our attribute and reference attribute names, so lets parse the data and write it */
					if (Attribute != -1) {
						if (ReferenceAttribute != -1) {
							/* Remove old references before writting new ones */

							MDBReadDN(Session->CurrentObject, Session->Strings[Attribute], DN);
							for (i = 0; i < DN->Used; i++) {
								MDBRemoveDN(DN->Value[i], Session->Strings[ReferenceAttribute], Session->CurrentObject, DN);
							}
							MDBFreeValues(DN);
						}

						if (Value[0] == '\001') {
							MDBClear(Session->CurrentObject, Session->Strings[Attribute], DN);
						} else {
							/* Seperate out the strings */

							Begin = Value;
							do {
								End = strchr(Begin, '\n');
								if (End) {
									End[0] = '\0';
									if (End[-1] == '\r') {
										End[-1] = '\0';
									}
								}

								WAX500toMDB(Begin, Session->ObjectBuffer, DN);
								MDBAddValue(Session->ObjectBuffer, DN);

								if (End) {
									Begin = End + 1;
								} else {
									Begin = NULL;
								}
							} while (Begin);

							if (Multi) {
								CMWriteDN(Session->CurrentObject, Session->Strings[Attribute], DN);
							} else {
								/* Make sure we only write one value */
								while (DN->Used > 1) {
									MDBFreeValue(DN->Used - 1, DN);
								}

								if (DN->Used > 0) {
									CMWrite(Session->CurrentObject, Session->Strings[Attribute], DN);
								} else {
									MDBClear(Session->CurrentObject, Session->Strings[Attribute], DN);
								}
							}
						}
					}

					if (ReferenceAttribute != -1) {
						for (i = 0; i < DN->Used; i++) {
							if (!ReferenceMulti) {
								MDBClear(DN->Value[i], Session->Strings[ReferenceAttribute], DN);
							}
							if (Create) {
								/* We can't write the reference right now because the object we are referencing doesn't exist yet */

								if (!ReferenceObject) {
									ReferenceObject = MDBShareContext(Session->V);
									ReferenceAttr = MDBShareContext(Session->V);
									ReferenceValue = MDBShareContext(Session->V);
								}
								MDBAddValue(DN->Value[i], ReferenceObject);
								MDBAddValue(Session->Strings[ReferenceAttribute], ReferenceAttr);
								MDBAddValue(Session->CurrentObject, ReferenceValue);
							} else {
								MDBAddDN(DN->Value[i], Session->Strings[ReferenceAttribute], Session->CurrentObject, DN);
							}
						}
					}
					MDBDestroyValueStruct(DN);
					MDBDestroyValueStruct(ReferenceDN);
				} else if (toupper(Name[1]) == 'E') {		/* Delete */
					MDBGetObjectDetails(Session->CurrentObject, Session->CurrentClass, NULL, NULL, Session->V);

					if (WAQuickCmp(Session->CurrentClass, "Top")) {
						Session->LastError = WAERR_CONTAINER_NOT_EMPTY;
					} else if (!MDBDeleteObject(Session->CurrentObject, FALSE, Session->V)) {
						if (Session->V->ErrNo==ERR_ENTRY_IS_NOT_LEAF) {
							Session->LastError=WAERR_CONTAINER_NOT_EMPTY;
						} else if (Session->V->ErrNo==DSERR_NO_DELETE_PRIVILEGE) {
							Session->LastError=WAERR_NOT_ENOUGH_RIGHTS;
						} else {
							Session->LastError=WAERR_OBJECT_NOT_DELETED;
						}
					}

					/*
						Rename and delete can not be handle at the same time as other fields,
						because the object will not be there when its done, so bail
					*/
					goto Leave;
				}

				break;
			}

			case 'S': {		/* String */
				long					Attribute = -1;
				MDBValueStruct		*Strings;
				BOOL					Multi = FALSE;
				BOOL					Number = FALSE;
				unsigned char		*Begin;
				unsigned char		*End;

				Strings = MDBShareContext(Session->V);

				/* Min length for strings */
				if (strlen(Name) > 6) {
					if (Name[2] == 'M') {
						Multi = TRUE;
					} else if (Name[2] == 'N') {
						Number = TRUE;
					}

					/* Find the attribute name */
					Attribute = atol(Name + 5);
					if (!(((Attribute % 9) == (Name[3] - '0')) && ((Attribute % 7) == (Name[4] - '0')))) {
						Attribute = -1;
					}
				}

				/* At this point we have parsed the name, and have our attribute, so lets parse the data and write it */
				if (Attribute != -1) {
					if (Value[0] == '\001') {
						MDBClear(Session->CurrentObject, Session->Strings[Attribute], Strings);
					} else if (Multi) {
						/* Seperate out the strings */

						Begin = Value;
						do {
							unsigned char		*Escaped;

							End = strchr(Begin, '\n');
							if (End) {
								End[0] = '\0';
								if (End[-1] == '\r') {
									End[-1] = '\0';
								}
							}

							/* If there are any "\\n"s in the string put in a real crlf */
							Escaped = Begin;
							do {
								Escaped = strstr(Escaped, "\\n");
								if (Escaped) {
									*Escaped++ = '\r';
									*Escaped++ = '\n';
								}
							} while (Escaped);

							MDBAddValue(Begin, Strings);

							if (End) {
								Begin = End + 1;
							} else {
								Begin = NULL;
							}
						} while (Begin);

						CMWrite(Session->CurrentObject, Session->Strings[Attribute], Strings);
					} else {
						if (!Number) {
						  char scratch[25]; /* enough room to hold largest integer string */

							if (strlen(Value) > MDB_MAX_ATTRIBUTE_VALUE_CHARS) {
								Value[MDB_MAX_ATTRIBUTE_VALUE_CHARS] = '\0';
							}


							MDBAddValue(Value, Strings);
							CMWrite(Session->CurrentObject, Session->Strings[Attribute], Strings);

							if ((XplStrCaseCmp(Session->Strings[Attribute], MSGSRV_A_CONNMGR_CONFIG)) &&
							    (XplStrCaseCmp(Session->Strings[Attribute], MSGSRV_A_IP_ADDRESS))) {
							  ;
							} else {
							  MDBFreeValues(Strings);
							  MDBRead(MSGSRV_ROOT, MSGSRV_A_CONFIG_CHANGED, Strings);						  
							  if (Strings->Used > 0) {
							    int Changed; 
							    Changed = atol(Strings->Value[0]);
							    Changed += 1;
							    snprintf(scratch, sizeof(scratch), "%d", Changed);
							  } else {
							    snprintf(scratch, sizeof(scratch), "0");
							  }
							  MDBFreeValues(Strings);
							  MDBAddValue(scratch, Strings);
							  CMWrite(MSGSRV_ROOT, MSGSRV_A_CONFIG_CHANGED, Strings);						  
							}

						} else {
							unsigned char		*In = Value;
							unsigned char		*Out = Session->ObjectBuffer;

							/* Clean up number values in case dummy put in other chars */
							while (In && *In) {
								if (*In >= '0' && *In <= '9') {
									*Out = *In;
									In++;
									Out++;
								} else if (*In == ',') {
									In++;
								} else {
									/* Terminate if we find anything other than a comma */

									*Out = '\0';
									In = NULL;
								}
							}
							*Out = '\0';

							MDBAddValue(Session->ObjectBuffer, Strings);
							CMWrite(Session->CurrentObject, Session->Strings[Attribute], Strings);
						}
					}
				}

				MDBDestroyValueStruct(Strings);

				break;
			}

			case 'I': {		/* Compare */
				long					Attribute = -1;
				long		Prefix = 0;
				MDBValueStruct		*Compare;
				BOOL					Multi = FALSE;

				Compare = MDBShareContext(Session->V);

				/* Min length for compare */
				if (strlen(Name) > 6) {
					unsigned char		*PrefixString;

					if (Name[2] == 'M') {
						Multi = TRUE;
					}

					/* Find the attribute name */
					Attribute = atol(Name + 4);
					if (!(((Attribute % 9) == (Name[2] - '0')) && ((Attribute % 7) == (Name[3] - '0')))) {
						Attribute = -1;
					}

					/* Find the Prefix String */
					PrefixString = strrchr(Name, '_');
					if (PrefixString) {

						Prefix = atol(PrefixString + 3);
						if (!(((Prefix % 9) == (PrefixString[1] - '0')) && ((Prefix % 7) == (PrefixString[2] - '0')))) {
							Prefix = 0;
						}
					}
				}

				/* At this point we have parsed the name, and have our attribute, and our prefix, so lets parse the data and write it */
				if (Attribute != -1) {
					if (Prefix != 0) {
						MDBRead(Session->CurrentObject, Session->Strings[Attribute], Compare);

						for (i = 0; i < Compare->Used; i++) {
							if (WAQuickNCmp(Session->Strings[Prefix], Compare->Value[i], strlen(Session->Strings[Prefix]))) {
								MDBFreeValue(i, Compare);
								if (i > 0) {
									i--;
								}
							}
						}

						if (Value[0] != '\001') {
							snprintf(Session->ObjectBuffer, sizeof(Session->ObjectBuffer), "%s%s", Session->Strings[Prefix], Value);
							MDBAddValue(Session->ObjectBuffer, Compare);
						}
					} else {
						if (Value[0] != '\001') {
							MDBAddValue(Value, Compare);
						}
					}
					CMWrite(Session->CurrentObject, Session->Strings[Attribute], Compare);
				}

				MDBDestroyValueStruct(Compare);

				break;
			}

			case 'B': {		/* BitField */
				long					Attribute = -1;
				unsigned long		Prefix = 0;
				unsigned long		Bit = 0;
				MDBValueStruct		*BitField;

				BitField = MDBShareContext(Session->V);

				/* Min length for BitField */
				if (strlen(Name) > 6) {
					unsigned char		*ptr = strchr(Name, '_');
					unsigned long		Counter = 0;

					while (ptr && *ptr) {
						long		Value = atol(ptr + 3);

						if (((Value % 9) == (ptr[1] - '0')) && ((Value % 7) == (ptr[2] - '0'))) {
							switch (Counter) {
								case 0:		Attribute = Value;	break;
								case 1:		Bit = Value;			break;
								case 2:		Prefix = Value;		break;
							}
						}

						Counter++;
						ptr++;
						ptr = strchr(ptr, '_');
					}
				}

				/* At this point we have parsed the name, and have our attribute, and our prefix, so lets parse the data and write it */
				if (Attribute != -1) {
					if (Value[0] == '\001') {
						MDBClear(Session->CurrentObject, Session->Strings[Attribute], BitField);
					} else {
						unsigned long		BitFieldValue = 0;

						MDBRead(Session->CurrentObject, Session->Strings[Attribute], BitField);

						if (Prefix != 0) {
							for (i = 0; i < BitField->Used; i++) {
								if (WAQuickNCmp(Session->Strings[Prefix], BitField->Value[i], strlen(Session->Strings[Prefix]))) {
									BitFieldValue = atol(BitField->Value[i] + strlen(Session->Strings[Prefix]));
									MDBFreeValue(i, BitField);
									if (i > 0) {
										i--;
									}
								}
							}
						} else if (BitField->Used > 0) {
							BitFieldValue = atol(BitField->Value[0]);
							MDBFreeValues(BitField);
						}

						if (WAQuickCmp(Value, "On") || WAQuickCmp(Value, "Yes") || WAQuickCmp(Value, "True") || WAQuickCmp(Value, "1")) {
							BitFieldValue |= (1 << Bit);
						} else {
							BitFieldValue &= ~(1 << Bit);
						}

						if (Prefix != 0) {
							snprintf(Session->ObjectBuffer, sizeof(Session->ObjectBuffer), "%s%lu", Session->Strings[Prefix], BitFieldValue);
						} else {
							snprintf(Session->ObjectBuffer, sizeof(Session->ObjectBuffer), "%lu", BitFieldValue);
						}
						MDBAddValue(Session->ObjectBuffer, BitField);

						CMWrite(Session->CurrentObject, Session->Strings[Attribute], BitField);
					}
				}

				MDBDestroyValueStruct(BitField);

				break;
			}

			case 'X': {		/* Remove */
				long					Attribute = -1;
				MDBValueStruct		*Remove;

				Remove = MDBShareContext(Session->V);

				/* Min length for Remove */
				if (strlen(Name) > 5) {

					/* Find the attribute name */
					Attribute = atol(Name + 4);
					if (!(((Attribute % 9) == (Name[2] - '0')) && ((Attribute % 7) == (Name[3] - '0')))) {
						Attribute = -1;
					}
				}

				/* At this point we have parsed the name, and have our attribute, so lets parse the data and write it */
				if (Attribute != -1) {
					MDBClear(Session->CurrentObject, Session->Strings[Attribute], Remove);
				}

				MDBDestroyValueStruct(Remove);

				break;
			}

			case 'P': {		/* Password */
				if (strlen(Name) > 8 && Value[0] != '\001') {
					switch (toupper(Name[8])) {
						case 'O': {
							if (!PasswordOld) {
								PasswordOld = strdup(Value);
							}
							break;
						}
						case 'N':
						case 'R': {
							if (!PasswordNew) {
								PasswordNew = strdup(Value);
							} else if (WAQuickCmp(PasswordNew, Value)) {
								PasswordsMatch = TRUE;
							}
							break;
						}
					}
				}
				break;
			}

			case 'R': {		/* Rename */
				unsigned char		*ptr;

				if (Value[0] != '\001') {
					unsigned long		i;
					WARenameFunc		RenameFunc = NULL;
					void					*RenameData = NULL;

					if (Value[0] == '.')  {
						/* Absolute DN */

						WAX500toMDB(Value, Session->ObjectBuffer, Session->V);
					} else if ((ptr = strchr(Value, '.')) == NULL || ((ptr > Value) && ptr[-1] == '\\')) {
						/* Simple rename inside same container */

						ptr = strrchr(Session->CurrentObject, '\\');
						if (ptr) {
							memcpy(Session->ObjectBuffer, Session->CurrentObject, ptr-Session->CurrentObject+1);
							memcpy(Session->ObjectBuffer + (ptr - Session->CurrentObject) + 1, Value, strlen(Value) + 1);
						} else {
							/* Darn, just make it an absolute path */
							WAX500toMDB(Value, Session->ObjectBuffer, Session->V);
						}
					} else {
						unsigned long	Skip;

						/* We have a relative DN, but with path elements */
						/* First, get a (wrong) absolute DN */
						WAX500toMDB(Value, Session->ObjectBuffer, Session->V);

						/* Make place for our current context */
						Skip = strlen(Session->CurrentTree) + 1;

						memmove(Session->ObjectBuffer + strlen(Session->CurrentObject), Session->ObjectBuffer + Skip, strlen(Session->ObjectBuffer + Skip) + 1);
						memcpy(Session->ObjectBuffer, Session->CurrentObject, strlen(Session->CurrentObject));
					}

					MDBGetObjectDetails(Session->CurrentObject, Session->CurrentClass, NULL, NULL, Session->V);

					for (i = 0; i < RModuleCount; i++) {
						if (WAQuickCmp(Session->CurrentClass, RModules[i].ObjectClass) && RModules[i].RenameFunction) {
							RenameFunc = RModules[i].RenameFunction;
							RenameData = Session->ModuleData[TModuleCount + OModuleCount + SModuleCount + DModuleCount + i];

							Session->LastError = RenameFunc(Session, Session->CurrentClass, Session->CurrentObject, Session->ObjectBuffer, RenameData);
						}
					}

					if (Session->LastError == 0) {
						Session->LastError = WAERR_SHOW_SUCCESS;
					}

					if (Session->LastError == WAERR_SHOW_SUCCESS) {
						if (WAQuickCmp(Session->CurrentClass, "Top")) {
							Session->LastError = WAERR_NOT_ENOUGH_RIGHTS;
						} else if (!MDBRenameObject(Session->CurrentObject, Session->ObjectBuffer, Session->V)) {
							if (Session->V->ErrNo == DSERR_NO_DELETE_PRIVILEGE) {
								Session->LastError = WAERR_NOT_ENOUGH_RIGHTS;
							} else {
								Session->LastError = WAERR_OBJECT_NOT_RENAMED;
							}
						} else {
							HulaStrNCpy(Session->CurrentObject, 
								    Session->ObjectBuffer,
								    sizeof(Session->CurrentObject));
							
							MDBGetObjectDetails(Session->CurrentObject, Session->CurrentClass, NULL, NULL, Session->V);
						}
					}
					/*
						Rename and delete can not be handle at the same time as other fields,
						because the object will not be there when its done, so bail
					*/
					goto Leave;
				}
				break;
			}
		}
	}

	/* Create the object if we need to */
	if (Create) {
		if (MDBCreateObject(ObjectName, ObjectClass, CreateName, CreateValue, CreateName)) {
			MDBGetObjectDetails(Session->CurrentObject, Session->CurrentClass, NULL, NULL, Session->V);
			Session->LastError = WAERR_SHOW_SUCCESS;

			/* Now that the object exists lets write its references */
			if (ReferenceObject) {
				for (z = 0; z < ReferenceObject->Used; z++) {
					MDBAddDN(ReferenceObject->Value[z], ReferenceAttr->Value[z], ReferenceValue->Value[z], Session->V);
				}
			}
		} else {
			if (CreateName->ErrNo == ERR_ENTRY_ALREADY_EXISTS) {
				Session->LastError = WAERR_OBJECT_EXISTS;
			} else {
				Session->LastError = WAERR_OBJECT_NOT_CREATED;
			}
		}
	}

	/* Should we set a password on this object? */
	if (PasswordOld && PasswordNew && PasswordsMatch) {
		MDBChangePassword(Session->CurrentObject, PasswordOld, PasswordNew, Session->V);
	} else if (PasswordNew && PasswordsMatch) {
		MDBChangePasswordEx(Session->CurrentObject, PasswordOld, PasswordNew, Session->V);
	}

Leave:

	if (PasswordNew) {
		free(PasswordNew);
	}
	if (PasswordOld) {
		free(PasswordOld);
	}

	MDBDestroyValueStruct(CreateName);
	MDBDestroyValueStruct(CreateValue);

	if (ReferenceObject) {
		MDBDestroyValueStruct(ReferenceObject);
	}

	if (ReferenceAttr) {
		MDBDestroyValueStruct(ReferenceAttr);
	}

	if (ReferenceValue) {
		MDBDestroyValueStruct(ReferenceValue);
	}

	return(TRUE);
}

BOOL
FreeObjectList(ObjectListStruct *ObjectList)
{
	if (!ObjectList) {
		return(FALSE);
	}

	if (ObjectList->Child) {
		FreeObjectList(ObjectList->Child);
	}

	if (ObjectList->Next) {
		FreeObjectList(ObjectList->Next);
	}

	free(ObjectList);
	return(TRUE);
}

static BOOL
ClearObjectListFlags(ObjectListStruct *ObjectList, BOOL ClearExpanded)
{
	if (!ObjectList) {
		return(FALSE);
	}

	ObjectList->Displayed = FALSE;
	if (ClearExpanded) {
		ObjectList->Expanded = FALSE;
	}

	if (ObjectList->Child) {
		ClearObjectListFlags(ObjectList->Child, ClearExpanded);
	}

	if (ObjectList->Next) {
		ClearObjectListFlags(ObjectList->Next, ClearExpanded);
	}

	return(TRUE);
}

static ObjectListStruct
*FindObjectListEntry(ObjectListStruct *FindIn, unsigned char *Name)
{
	if (!FindIn) {
		return(NULL);
	}

	if (WAQuickCmp(Name, FindIn->Name)) {
		return(FindIn);
	}

	if (FindIn->Child) {
		ObjectListStruct		*Result;

		Result = FindObjectListEntry(FindIn->Child, Name);
		if (Result) {
			return(Result);
		}
	}

	if (FindIn->Next) {
		ObjectListStruct		*Result;

		Result = FindObjectListEntry(FindIn->Next, Name);
		if (Result) {
			return(Result);
		}
	}

	return(NULL);
}

static ObjectListStruct
*AddObjectListEntry(SessionStruct *Session, BOOL Browse, unsigned char *Name)
{
	ObjectListStruct		*ContainerList;
	ObjectListStruct		*AddItHere;
	unsigned char			*Endptr;

	if ((!Session->ObjectListCache && !Browse) || (!Session->BrowseListCache && Browse)) {
		/* Setup our container cache */

		if (!Browse) {
			Session->ObjectListCache = malloc(sizeof(ObjectListStruct));
			memset(Session->ObjectListCache, 0, sizeof(ObjectListStruct));

			snprintf(Session->ObjectListCache->Name, 
				 sizeof(Session->ObjectListCache->Name),
				 "\\%s", Session->CurrentTree);

			return(Session->ObjectListCache);
		} else {
			Session->BrowseListCache = malloc(sizeof(ObjectListStruct));
			memset(Session->BrowseListCache, 0, sizeof(ObjectListStruct));

			snprintf(Session->BrowseListCache->Name, 
				 sizeof(Session->BrowseListCache->Name),
				 "\\%s", Session->CurrentTree);

			return(Session->BrowseListCache);
		}
	}

	if (!Browse) {
		ContainerList = Session->ObjectListCache;
	} else {
		ContainerList = Session->BrowseListCache;
	}

	Endptr = strrchr(Name, '\\');
	if (Endptr) {
		*Endptr = '\0';
	}

	if (!Session->ObjectListCurrent) {
		Session->ObjectListCurrent = ContainerList;
	}

	ContainerList = FindObjectListEntry(Session->ObjectListCurrent, Name);

	/* Restore the DN */
	if (Endptr) {
		*Endptr = '\\';
	}

	if ((ContainerList && !Endptr) || (ContainerList && !Endptr[1]) || (ContainerList && Endptr[1] == '.')) {
		/* If there is no DN to restore, that means we actually found the object we are trying to add, and not its parent */
		return(ContainerList);
	}

	if (!ContainerList) {
		/* The parent doesn't exist, so we can't add the object. */
		return(NULL);
	}

	/* At this point we should be able to add it - Lets figure out where it goes */
	if (ContainerList->Child) {
		BOOL						Exists = FALSE;
		BOOL						Found = FALSE;

		ContainerList = ContainerList->Child;

		while (!Found && !Exists) {
			if (WAQuickCmp(Name, ContainerList->Name)) {
				Exists = TRUE;
			} else if (!ContainerList->Next) {
				Found = TRUE;
			} else {
				ContainerList = ContainerList->Next;
			}
		}

		if (Exists) {
			AddItHere = ContainerList;
		} else {
			ContainerList->Next = malloc(sizeof(ObjectListStruct));
			memset(ContainerList->Next, 0, sizeof(ObjectListStruct));
			AddItHere = ContainerList->Next;
			AddItHere->Parent = ContainerList->Parent;
		}

	} else {
		ContainerList->Child = malloc(sizeof(ObjectListStruct));
		memset(ContainerList->Child, 0, sizeof(ObjectListStruct));

		AddItHere = ContainerList->Child;
		AddItHere->Parent = ContainerList;
	}

	HulaStrNCpy(AddItHere->Name, Name, sizeof(AddItHere->Name));
	return(AddItHere);
}

BOOL
SendHTTPHeaderDynamic(ConnectionStruct *Client, unsigned char *contentType, unsigned long contentTypeLen)
{
	if (Client->SentHeader==FALSE) {
		WASendClient(Client, "HTTP/1.1 200 Ok\r\nPragma: no-cache\r\nCache-Control: no-cache\r\nConnection: ", 72);

		if (Client->KeepAlive) {
			WASendClient(Client, "keep-alive\r\n", 12);
		} else {
			WASendClient(Client, "close\r\n", 7);
		}

		if (Client->Cookie) {
			WASendClient(Client, Client->Temp, snprintf(Client->Temp, sizeof(Client->Temp), "Set-Cookie: WAS-ID=%lu\r\n", Client->Cookie));
		}

		switch (Client->DeviceType) {
			case DEVICE_HTML: 
			default: {
				WASendClient(Client, "Content-type: ", strlen("Content-type: "));
				WASendClient(Client, contentType, contentTypeLen);
				WASendClient(Client, "\r\n\r\n", strlen("\r\n\r\n"));
				break;
			}

			case DEVICE_WML: {
			    if ((contentTypeLen != strlen("text/html")) || !WAQuickCmp(contentType, "text/html")) {
				WASendClient(Client, "Content-type: ", strlen("Content-type: "));
				WASendClient(Client, contentType, contentTypeLen);
				WASendClient(Client, "\r\n\r\n", strlen("\r\n\r\n"));
				break;
			    } else {
				WASendClient(Client, "Content-type: text/vnd.wap.wml\r\n\r\n", 34);
				break;
			    }
			}
		}

		Client->SentHeader=TRUE;
	}
	return(TRUE);
}

BOOL
WASendHTTPHeader(ConnectionStruct *Client, unsigned char *Type, unsigned long Size, unsigned char *Filename, BOOL Cache)
{
	WASendClient(Client, "HTTP/1.1 200 Ok\r\n", 17);
	if (!Cache) {
		WASendClient(Client, "Pragma: no-cache\r\nCache-Control: no-cache\r\n", 43);
	}
	if (Client->KeepAlive) {
		WASendClient(Client, "Connection: keep-alive\r\n", 24);
	} else {
		WASendClient(Client, "Connection: close\r\n", 19);
	}
	if (Client->Cookie) {
		WASendClient(Client, Client->Temp, snprintf(Client->Temp, sizeof(Client->Temp), "Set-Cookie: WAS-ID=%lu\r\n", Client->Cookie));
	}
	if (Filename) {
		WASendClient(Client, Client->Temp, snprintf(Client->Temp, sizeof(Client->Temp), "Content-Disposition: attachment; filename=\"%s\"\r\n", Filename));
	}
	if (Size>0) {
		WASendClient(Client, Client->Temp, snprintf(Client->Temp, sizeof(Client->Temp), "Content-Type: %s\r\nContent-length: %lu\r\n\r\n", Type, Size));
	} else {
		WASendClient(Client, Client->Temp, snprintf(Client->Temp, sizeof(Client->Temp), "Content-Type: %s\r\n\r\n", Type));
	}
	return(TRUE);
}

static BOOL
HandleImage(ConnectionStruct *Client, unsigned long Template, unsigned long Language, unsigned long ImageID)
{
	unsigned char		*Image;
	unsigned long		Length;
	unsigned long		*LanguageList = (unsigned long *)((unsigned char *)Templates[Template] + sizeof(TemplateStruct));
	unsigned long		i;

	Client->KeepAlive = TRUE;

	for (i = 0; i < Templates[Template]->LanguageCount; i++) {
		if (LanguageList[i] == Language) {
			Language = i;
			break;
		}
	}

	if (i == Templates[Template]->LanguageCount) {
		Language = 0;
	}

	if (Template >= TemplateCount || ImageID >= Templates[Template]->ImageCount) {
		Client->KeepAlive = FALSE;

		return(FALSE);
	}

	Image = TemplateImages[Template * TemplateMaxLanguages + Language][ImageID];

	Length = *(unsigned long *)Image;
	Image += sizeof(unsigned long);

	if (Image[0] == 'G') {
		WASendHTTPHeader(Client, "image/gif", Length, NULL, TRUE);
	} else {
		WASendHTTPHeader(Client, "image/jpeg", Length, NULL, TRUE);
	}

	WASendClient(Client, Image, Length);

	return(TRUE);
}

static BOOL
TemplateHandleStaticObject(ConnectionStruct *Client, TemplateObjectOverlay *StaticObject)
{
    Client->KeepAlive=FALSE;

    if (!WebAdmin.CheckDiskForTemplateUpdates) {
	WASendHTTPHeader(Client, StaticObject->ContentType, StaticObject->ObjectLen, NULL, TRUE);
	WASendClient(Client, StaticObject->Object, StaticObject->ObjectLen);

	return(TRUE);
    } else {
	unsigned char *path;

	int pathSize;
	struct stat sb;
	unsigned char *object;
	FILE *objectFile;
	long ret;

	pathSize = strlen(Templates[Client->Session->TemplateID]->SourcePath) + StaticObject->FileNameLen;
	path = MemMalloc(pathSize);
	if (path) {
	    snprintf(path, pathSize, "%s%s", Templates[Client->Session->TemplateID]->SourcePath, StaticObject->FileName);
	    ret = stat(path, &sb);
	    if ((ret != 0) || (sb.st_mtime == StaticObject->FileModTime)) {
		WASendHTTPHeader(Client, StaticObject->ContentType, StaticObject->ObjectLen, NULL, TRUE);
		WASendClient(Client, StaticObject->Object, StaticObject->ObjectLen);
		MemFree(path);
		return(TRUE);
	    } else {
		object = MemMalloc(sb.st_size);
		if (object) {
		    objectFile = fopen(path, "r");
		    if (objectFile) {
			fread(object, sizeof(unsigned char), sb.st_size, objectFile);
			WASendHTTPHeader(Client, StaticObject->ContentType, sb.st_size, NULL, TRUE);
			WASendClient(Client, object, sb.st_size);
			MemFree(object);
			MemFree(path);
			fclose(objectFile);
			return(TRUE);
		    }
		    MemFree(object);
		}
		
	    }
	    MemFree(path);
	}

	WASendHTTPHeader(Client, StaticObject->ContentType, 26, NULL, TRUE);
	WASendClient(Client, "HULAMODWEB: Out of Memmory!", 26);

	return(FALSE);
    }
}

BOOL
HandleLogo(ConnectionStruct *Client, unsigned long LogoID)
{
	long		Length;
	unsigned long		Read;
	struct stat			sb;
	unsigned char		Path[XPL_MAX_PATH+1];
	FILE					*Image;
	BOOL					JPEG = FALSE;

	snprintf(Path, sizeof(Path), "%s/%lu.gif", LogoDir, LogoID);
	if (stat(Path, &sb) != 0) {
	    snprintf(Path, sizeof(Path), "%s/%lu.jpg", LogoDir, LogoID);
		if (stat(Path, &sb) != 0) {
			Client->KeepAlive = FALSE;
			return(FALSE);
		}
		JPEG = TRUE;
	}

	Image = fopen(Path, "rb");
	if (!Image) {
		Client->KeepAlive = FALSE;
		return(FALSE);
	}
	Client->KeepAlive = TRUE;

	WADebug("HandleLogo(Path:%s) called\n", Path);

	if (!JPEG) {
		WASendHTTPHeader(Client, "image/gif", sb.st_size, NULL, TRUE);
	} else {
		WASendHTTPHeader(Client, "image/jpeg", sb.st_size, NULL, TRUE);
	}

	Length = 0;
	while ((Length < sb.st_size) && !feof(Image) && !ferror(Image)) {
		if ((Read = fread(Client->Temp, sizeof(unsigned char), BUFSIZE, Image)) > 0) {
			WASendClient(Client, Client->Temp, Read);
			Length += Read;
		}
	}
	fclose(Image);
	return(TRUE);
}

#if 0
static BOOL
WAHandleNamedTemplate(void *ClientIn, unsigned char *TemplateName, void *ObjectData)
{
    TemplateObjectOverlay *localObject;
	ConnectionStruct			*Client=(ConnectionStruct *)ClientIn;
	SessionStruct				*Session=Client->Session;
	unsigned long				TemplateID;
	unsigned char				URL[256];
	unsigned char				Answer[BUFSIZE+1];
	unsigned long				ReplyInt;
	unsigned char				*nextTokenAddress;
	TokenOverlayStruct		*Token;
	register unsigned char	*ptr;
	WAHandleTemplateFunc		TemplateHandler = NULL;

	if (!Client || !Session || !ObjectData || !TemplateName || (TemplateID=WAFindTemplatePage(TemplateName, Session->TemplateID))==(unsigned long)-1) {
		return(FALSE);
	}

	localObject = Session->Pages[TemplateID];
	nextTokenAddress = localObject->Object;
	Token = (TokenOverlayStruct *)nextTokenAddress;

	SendHTTPHeaderDynamic(Client, localObject->ContentType, localObject->ContentTypeLen);

NextToken:
	while (Token->TokenID!=0) {
		switch(Token->TokenID) {
			case T_TEXT: {
				WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				break;
			}

			case T_QSTRING:
			case T_STRING: {
				ptr=Session->Strings[Token->ArgumentOffsetOrID[0]];
				WASendClient(Client, ptr, strlen(ptr));
				break;
			}

			case T_IMAGE: {
				WAEncodeURL(Session, URL, URL_TYPE_IMAGE, DISPLAY_IMAGE, Session->TemplateID, Session->Language, Token->ArgumentOffsetOrID[0], 0);
				WASendClient(Client, URL, strlen(URL));
				break;
			}

			case T_STATIC_PAGE: {
				WAEncodeURL(Session, URL, URL_TYPE_LINK, DISPLAY_STATIC_PAGE, Session->TemplateID, Token->ArgumentOffsetOrID[0], 0, 0);
				WASendClient(Client, URL, strlen(URL));
				break;
			}

			case T_LOGOUT: {
				WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_LOGOUT, Token->ArgumentOffsetOrID[0], 0, 0, 0);
				WASendClient(Client, URL, strlen(URL));
				break;
			}

			case T_PAGEID:
			case T_PAGE: {
				WAEncodeURL(Session, URL, URL_TYPE_LINK, DISPLAY_TEMPLATE, Token->ArgumentOffsetOrID[0], 0, 0, 0);
				WASendClient(Client, URL, strlen(URL));

				strncpy(Answer, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
				Answer[Token->ArgumentSize[1]] = '\0';

				WASendURLExtra(Client, Answer);
				break;
			}

			case T_RETURN_HOME: {
				if (Session->returnURL[0] != '\0') {
					WASendClient(Client, Session->returnURL, strlen(Session->returnURL));
				} else {
					WAEncodeURL(Session, URL, URL_TYPE_LINK, SWITCH_TEMPLATE, Session->InitialTemplate, Templates[Session->InitialTemplate]->InitialTemplate, FALSE, 0);
					WASendClient(Client, URL, strlen(URL));
				}

				break;
			}

			case T_SET_HOME: {
				if (Session->returnURL[0] == '\0') {
					WAEncodeURL(Session, URL, URL_TYPE_LINK, SWITCH_TEMPLATE, Session->InitialTemplate, Token->ArgumentOffsetOrID[0], FALSE, 0);
					HulaStrNCpy(Session->returnURL, sizeof(Session->returnURL), URL);
				}
			}

			case T_TEMPLATE_PAGE: {
				unsigned long		CurrentTemplate = Session->TemplateID;
				long					Template;
				long					Page = -1;
				unsigned char		Buffer[1024];

				memcpy(Buffer, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				Buffer[Token->ArgumentSize[0]] = '\0';
				Template = WAFindTemplate(Buffer);

				if (Template != -1) {
					memcpy(Buffer, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
					Buffer[Token->ArgumentSize[1]] = '\0';
					Page = WAFindTemplatePage(Buffer, Template);
				}

				if (Page != -1) {
					/* Switch into the other template */
					WASetSessionTemplate(Template, Session->Language, Session);

					/* Encode the URL */
					WAEncodeURL(Session, URL, URL_TYPE_LINK, DISPLAY_TEMPLATE, Page, 0, 0, 0);
					WASendClient(Client, URL, strlen(URL));

					/* Switch back to our original template */
					WASetSessionTemplate(CurrentTemplate, Session->Language, Session);
				} else if (Token->ArgumentOffsetOrID[2] != 0) {
					/* Generate link to fall back page */

					WAEncodeURL(Session, URL, URL_TYPE_LINK, DISPLAY_TEMPLATE, Token->ArgumentOffsetOrID[2], 0, 0, 0);
					WASendClient(Client, URL, strlen(URL));
				}

				break;
			}

			case T_TEMPLATE_INC: {
				unsigned long		CurrentTemplate = Session->TemplateID;
				long					Template;
				long					Page = -1;
				unsigned char		Buffer[1024];

				memcpy(Buffer, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				Buffer[Token->ArgumentSize[0]] = '\0';
				Template = WAFindTemplate(Buffer);

				if (Template != -1) {
					memcpy(Buffer, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
					Buffer[Token->ArgumentSize[1]] = '\0';
					Page = WAFindTemplatePage(Buffer, Template);
				}

				if (Page != -1) {
					/* Switch into the other template */
					WASetSessionTemplate(Template, Session->Language, Session);

					/* Display the page */
					WAHandleTemplate(Client, Session, Page, FALSE);

					/* Switch back to our original template */
					WASetSessionTemplate(CurrentTemplate, Session->Language, Session);
				}

				break;
			}

			case T_LOGO: {
				if (Session->LogoID==0) {
					WAEncodeURL(Session, URL, URL_TYPE_IMAGE, DISPLAY_IMAGE, Session->TemplateID, Session->Language, Token->ArgumentOffsetOrID[0], 0);
				} else {
					WAEncodeURL(Session, URL, URL_TYPE_IMAGE, DISPLAY_LOGO, Session->LogoID, 0, 0, 0);
				}
				WASendClient(Client, URL, strlen(URL));
				break;
			}

			case T_APP_TITLE: {
				if (Session->Title) {
					WASendClient(Client, Session->Title, strlen(Session->Title));
				} else if (DefaultTitle) {
					WASendClient(Client, DefaultTitle, strlen(DefaultTitle));
				} else {
					WASendClient(Client, Templates[Session->TemplateID]->Name, strlen(Templates[Session->TemplateID]->Name));
				}
				break;
			}

			case T_COLOR: {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_PAGEFG: {
						WASendClient(Client, Session->Colors[COLOR_PAGE_FG], 6);
						break;
					}

					case AA_PAGEBG: {
						WASendClient(Client, Session->Colors[COLOR_PAGE_BG], 6);
						break;
					}

					case AA_BORDERFG: {
						WASendClient(Client, Session->Colors[COLOR_BORDER_FG], 6);
						break;
					}

					case AA_BORDERBG: {
						WASendClient(Client, Session->Colors[COLOR_BORDER_BG], 6);
						break;
					}

					case AA_SECTIONFG: {
						WASendClient(Client, Session->Colors[COLOR_SECTION_FG], 6);
						break;
					}

					case AA_SECTIONBG: {
						WASendClient(Client, Session->Colors[COLOR_SECTION_BG], 6);
						break;
					}

					case AA_FIELDNAMEFG: {
						WASendClient(Client, Session->Colors[COLOR_FIELDNAME_FG], 6);
						break;
					}

					case AA_FIELDNAMEBG: {
						WASendClient(Client, Session->Colors[COLOR_FIELDNAME_BG], 6);
						break;
					}

					case AA_FIELDBODYFG: {
						WASendClient(Client, Session->Colors[COLOR_FIELDBODY_FG], 6);
						break;
					}

					case AA_FIELDBODYBG: {
						WASendClient(Client, Session->Colors[COLOR_FIELDBODY_BG], 6);
						break;
					}
				}
				break;
			}

			case T_USERNAME: {
				WASendClient(Client, Session->User, strlen(Session->User));
				break;
			}

			case T_LANGUAGELIST: {
				unsigned long	*LanguageList = (unsigned long *)Templates[Session->TemplateID] +sizeof(TemplateStruct);
				unsigned long	i;

				for (i=0; i<Templates[Session->TemplateID]->LanguageCount; i++) {
					if (XplReturnLanguageName(LanguageList[i], URL)==0) {
						ReplyInt=snprintf(Answer, sizeof(Answer), "<OPTION VALUE=\"%lu\"%s>%s</OPTION>\r\n", LanguageList[i], (Session->Language==i) ? " SELECTED" : "", URL);
						WASendClient(Client, Answer, ReplyInt);
					}
				}
				break;
			}

			case T_SESS_OVERRIDE: {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_LANGUAGE: {
						Session->Language = Token->ArgumentOffsetOrID[1];
						break;
					}	
					
					case AA_LOGOID: {
						Session->LogoID = Token->ArgumentOffsetOrID[1];
						break;
					}	

					case AA_CONNECTIONTIMEOUT: {
						Session->ConnectionTimeout = Token->ArgumentOffsetOrID[1];
						break;
					}	

					default: {
						break;
					}	
				}
				break;
			}

			default: {
				unsigned long	GotoToken;

				if (TemplateHandler) {
					ReplyInt=TemplateHandler(Client, Session, TemplateID, Token, &GotoToken, ObjectData);

					if (ReplyInt==TOKEN_DONE) {
						nextTokenAddress+=Token->Length;
						Token=(TokenOverlayStruct *)nextTokenAddress;
						goto NextToken;
					} else if (ReplyInt==TOKEN_MOVE_FORWARD) {
						while (Token->TokenID!=GotoToken && Token->TokenID!=0) {
							nextTokenAddress+=Token->Length;
							Token=(TokenOverlayStruct *)nextTokenAddress;
						}
						goto NextToken;
					} else if (ReplyInt==TOKEN_MOVE_BACKWARD) {
						while (Token->TokenID != GotoToken && (unsigned char *)Token != localObject->Object) {
							nextTokenAddress-=Token->PrevSize;
							Token=(TokenOverlayStruct *)nextTokenAddress;
						}
						goto NextToken;
					}
				}

				break;
			}
		}
		nextTokenAddress+=Token->Length;
		Token=(TokenOverlayStruct *)nextTokenAddress;
	} 
	return(TRUE);
}
#endif

BOOL
WAHandleTemplate(ConnectionStruct *Client, SessionStruct *Session, unsigned long TemplateID, BOOL SendHeader)
{
    TemplateObjectOverlay *localObject;
	unsigned char				URL[256];
	unsigned char				Answer[BUFSIZE+1];
	unsigned long				ReplyInt;
	unsigned char				*nextTokenAddress;
	TokenOverlayStruct		*Token;
	register unsigned char	*ptr;

	if (!Session || TemplateID == -1) {
		WASendClient(Client, "HTTP/1.1 404 Document does not exist\r\nPragma: no-cache\r\nCache-Control: no-cache\r\nContent-type: text/html\r\nConnection: close\r\n", 125);
		Client->KeepAlive=FALSE;
		WASendClient(Client, "<H1>Document not found</H1>", 27);

		return(TRUE);
	}

	localObject = Session->Pages[TemplateID];
	nextTokenAddress = localObject->Object;
	Token = (TokenOverlayStruct *)nextTokenAddress;

	if (SendHeader) {
		if (Client->ContentType && Client->ContentType[0]) {
			WASendHTTPHeader(Client, Client->ContentType, 0, NULL, FALSE);
			free(Client->ContentType);
			Client->ContentType = NULL;
		} else {
			SendHTTPHeaderDynamic(Client, localObject->ContentType, localObject->ContentTypeLen);
		}
	}

	/* This function always generates unpredictable size data, we don't want to ever keep the connection */
	Client->KeepAlive=FALSE;

NextToken:
	while (Token->TokenID != 0) {
		switch (Token->TokenID) {
			case T_TEXT: {
				WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				break;
			}

			case T_QSTRING:
			case T_STRING: {
				ptr=Session->Strings[Token->ArgumentOffsetOrID[0]];
				WASendClient(Client, ptr, strlen(ptr));
				break;
			}

			case T_IMAGE: {
				WAEncodeURL(Session, URL, URL_TYPE_IMAGE, DISPLAY_IMAGE, Session->TemplateID, Session->Language, Token->ArgumentOffsetOrID[0], 0);
				WASendClient(Client, URL, strlen(URL));
				break;
			}

			case T_STATIC_PAGE: {
				WAEncodeURL(Session, URL, URL_TYPE_LINK, DISPLAY_STATIC_PAGE, Session->TemplateID, Token->ArgumentOffsetOrID[0], 0, 0);
				WASendClient(Client, URL, strlen(URL));
				break;
			}

			case T_ERROR: {
				if (Session->LastError) {
					ptr = Session->Strings[Token->ArgumentOffsetOrID[0] + Session->LastError];
					WASendClient(Client, ptr, strlen(ptr));

					Session->LastError = WAERR_SUCCESS;
				}

				break;
			}

			case T_LOGOUT: {
				WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_LOGOUT, Token->ArgumentOffsetOrID[0], 0, 0, 0);
				WASendClient(Client, URL, strlen(URL));
				break;
			}

			case T_PAGEID:
			case T_PAGE: {
				WAEncodeURL(Session, URL, URL_TYPE_LINK, DISPLAY_TEMPLATE, Token->ArgumentOffsetOrID[0], 0, 0, 0);
				WASendClient(Client, URL, strlen(URL));

				strncpy(Answer, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
				Answer[Token->ArgumentSize[1]] = '\0';

				WASendURLExtra(Client, Answer);

				break;
			}

			case T_RETURN_HOME: {
				if (Session->returnURL[0] != '\0') {
					WASendClient(Client, Session->returnURL, strlen(Session->returnURL));
				} else {
					WAEncodeURL(Session, URL, URL_TYPE_LINK, SWITCH_TEMPLATE, Session->InitialTemplate, Templates[Session->InitialTemplate]->InitialTemplate, FALSE, 0);
					WASendClient(Client, URL, strlen(URL));
				}

				break;
			}

			case T_SET_HOME: {
				if (Session->returnURL[0] == '\0') {
					WAEncodeURL(Session, URL, URL_TYPE_LINK, SWITCH_TEMPLATE, Session->InitialTemplate, Token->ArgumentOffsetOrID[0], FALSE, 0);
					HulaStrNCpy(Session->returnURL, URL, sizeof(Session->returnURL));
				}
			}

			case T_TEMPLATE_PAGE: {
				unsigned long		CurrentTemplate = Session->TemplateID;
				long					Template;
				long					Page = -1;
				unsigned char		Buffer[1024];

				memcpy(Buffer, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				Buffer[Token->ArgumentSize[0]] = '\0';
				Template = WAFindTemplate(Buffer);

				if (Template != -1) {
					memcpy(Buffer, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
					Buffer[Token->ArgumentSize[1]] = '\0';
					Page = WAFindTemplatePage(Buffer, Template);
				}

				if (Page != -1) {
					/* Switch into the other template */
					WASetSessionTemplate(Template, Session->Language, Session);

					/* Encode the URL */
					WAEncodeURL(Session, URL, URL_TYPE_LINK, DISPLAY_TEMPLATE, Page, 0, 0, 0);
					WASendClient(Client, URL, strlen(URL));

					/* Switch back to our original template */
					WASetSessionTemplate(CurrentTemplate, Session->Language, Session);
				} else if (Token->ArgumentOffsetOrID[2] != 0) {
					/* Generate link to fall back page */

					WAEncodeURL(Session, URL, URL_TYPE_LINK, DISPLAY_TEMPLATE, Token->ArgumentOffsetOrID[2], 0, 0, 0);
					WASendClient(Client, URL, strlen(URL));
				}

				break;
			}

			case T_TEMPLATE_INC: {
				unsigned long		CurrentTemplate = Session->TemplateID;
				long					Template;
				long					Page = -1;
				unsigned char		Buffer[1024];

				memcpy(Buffer, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				Buffer[Token->ArgumentSize[0]] = '\0';
				Template = WAFindTemplate(Buffer);

				if (Template != -1) {
					memcpy(Buffer, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
					Buffer[Token->ArgumentSize[1]] = '\0';
					Page = WAFindTemplatePage(Buffer, Template);
				}

				if (Page != -1) {
					/* Switch into the other template */
					WASetSessionTemplate(Template, Session->Language, Session);

					/* Display the page */
					WAHandleTemplate(Client, Session, Page, FALSE);

					/* Switch back to our original template */
					WASetSessionTemplate(CurrentTemplate, Session->Language, Session);
				}

				break;
			}

			case T_TEMPLATE_BROWSE: {
				unsigned long		CurrentTemplate = Session->TemplateID;
				long					Template;
				long					Page = -1;
				unsigned char		Buffer[1024];

				/* We need to include a page to display a browse button,
					after we figure out which page based on the arguments */

				memcpy(Buffer, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				Buffer[Token->ArgumentSize[0]] = '\0';
				Template = WAFindTemplate(Buffer);

				if (Template != -1) {
					unsigned char		*ptr;

					if (Token->ArgumentOffsetOrID[1] == AA_SINGLE) {
						if (Token->ArgumentOffsetOrID[2] == AA_LEAF) {
							ptr = "BrowseSingleLeaf";
						} else if (Token->ArgumentOffsetOrID[2] == AA_CONTAINER) {
							ptr = "BrowseSingleContainer";
						} else {
							ptr = "BrowseSingleBoth";
						}
					} else {
						if (Token->ArgumentOffsetOrID[2] == AA_LEAF) {
							ptr = "BrowseMultiLeaf";
						} else if (Token->ArgumentOffsetOrID[2] == AA_CONTAINER) {
							ptr = "BrowseMultiContainer";
						} else {
							ptr = "BrowseMultiBoth";
						}
					}

					Page = WAFindTemplatePage(ptr, Template);
				}

				if (Page != -1) {
					/* Switch into the other template */
					WASetSessionTemplate(Template, Session->Language, Session);

					/* Generate the URL */
					WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_BROWSE, Page, Token->ArgumentOffsetOrID[4], CurrentTemplate, 0);

					strncpy(Client->Temp, Token->Data+Token->ArgumentOffsetOrID[3], Token->ArgumentSize[3]);
					Client->Temp[Token->ArgumentSize[3]] = '\0';

					WASendClient(Client, URL, strlen(URL));
					WASendURLExtra(Client, Client->Temp);


					/* Switch back to our original template */
					WASetSessionTemplate(CurrentTemplate, Session->Language, Session);
				}

				break;
			}

			case T_LOGO: {
				if (Session->LogoID==0) {
					WAEncodeURL(Session, URL, URL_TYPE_IMAGE, DISPLAY_IMAGE, Session->TemplateID, Session->Language, Token->ArgumentOffsetOrID[0], 0);
				} else {
					WAEncodeURL(Session, URL, URL_TYPE_IMAGE, DISPLAY_LOGO, Session->LogoID, 0, 0, 0);
				}
				WASendClient(Client, URL, strlen(URL));
				break;
			}

			case T_RELOGIN: {
				int				count;

				/* First, accquire a TSession */
				Client->TSession=CreateTSession();

				/* Now store all data in the session */
				snprintf(Answer, sizeof(Answer), "%s/T%lu", WorkDir, Client->TSession->SessionID);
				Client->PostData=fopen(Answer, "wb");
				fprintf(Client->PostData, "%lu\r\n", Client->ContentLength+Client->BufferPtr);
				fprintf(Client->PostData, "%c%s\r\n", Client->EncodingType==FORM_DATA_ENCODED ? 'f' : 'u', Client->FormSeparator ? Client->FormSeparator : (unsigned char *)"");
				fprintf(Client->PostData, "%s\r\n", Client->URL);

				if (Client->BufferPtr>0) {
					fwrite(Client->Buffer, 1, Client->BufferPtr, Client->PostData);
					Client->BufferPtr=0;
				}
				while (Client->ContentLength>0) {
					count=DoClientRead(Client, Client->Buffer+Client->BufferPtr, BUFSIZE-Client->BufferPtr);
					if ((count<1) || (Exiting)) {
						return(EndClientConnection(Client));
					}
					Client->BufferPtr+=count;
					if ((unsigned long)Client->BufferPtr>Client->ContentLength) {
						fwrite(Client->Buffer, 1, Client->ContentLength, Client->PostData);
						memmove(Client->Buffer, Client->Buffer+Client->ContentLength, Client->BufferPtr-Client->ContentLength);
						Client->BufferPtr-=Client->ContentLength;
						Client->ContentLength=0;
					} else {
						fwrite(Client->Buffer, 1, Client->BufferPtr, Client->PostData);
						Client->ContentLength-=Client->BufferPtr;
						Client->BufferPtr=0;
					}
				}
				fclose(Client->PostData);
				Client->PostData=NULL;
				Client->TSession->Timestamp=time(NULL);

				//WAEncodeURL(Session, URL, 'f', REQUEST_RELOGIN, (unsigned long)Client->TSession, 0, 0, 0);
				WASendClient(Client, "f", 1);
				break;
			}

			case T_STOREDDATA: {
				if (Client->TSession) {
					WAEncodeURL(Session, URL, 'x', 0, Client->TSession->SessionID, Client->TSession->SessionUID, 0, 0);
					ReplyInt=snprintf(Answer, sizeof(Answer), "<INPUT TYPE=\"Hidden\" NAME=\"TSession\" VALUE=\"%s\">", URL);
					ReleaseTSession(Client->TSession);
					Client->SessionUID=0;
					Client->TSession=NULL;
					WASendClient(Client, Answer, ReplyInt);
				}
				break;
			}

			case T_APP_TITLE: {
				if (Session->Title) {
					WASendClient(Client, Session->Title, strlen(Session->Title));
				} else if (DefaultTitle) {
					WASendClient(Client, DefaultTitle, strlen(DefaultTitle));
				} else {
					WASendClient(Client, Templates[Session->TemplateID]->Name, strlen(Templates[Session->TemplateID]->Name));
				}
				break;
			}


			case T_COLOR: {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_PAGEFG: {
						WASendClient(Client, Session->Colors[COLOR_PAGE_FG], 6);
						break;
					}

					case AA_PAGEBG: {
						WASendClient(Client, Session->Colors[COLOR_PAGE_BG], 6);
						break;
					}

					case AA_BORDERFG: {
						WASendClient(Client, Session->Colors[COLOR_BORDER_FG], 6);
						break;
					}

					case AA_BORDERBG: {
						WASendClient(Client, Session->Colors[COLOR_BORDER_BG], 6);
						break;
					}

					case AA_SECTIONFG: {
						WASendClient(Client, Session->Colors[COLOR_SECTION_FG], 6);
						break;
					}

					case AA_SECTIONBG: {
						WASendClient(Client, Session->Colors[COLOR_SECTION_BG], 6);
						break;
					}

					case AA_FIELDNAMEFG: {
						WASendClient(Client, Session->Colors[COLOR_FIELDNAME_FG], 6);
						break;
					}

					case AA_FIELDNAMEBG: {
						WASendClient(Client, Session->Colors[COLOR_FIELDNAME_BG], 6);
						break;
					}

					case AA_FIELDBODYFG: {
						WASendClient(Client, Session->Colors[COLOR_FIELDBODY_FG], 6);
						break;
					}

					case AA_FIELDBODYBG: {
						WASendClient(Client, Session->Colors[COLOR_FIELDBODY_BG], 6);
						break;
					}
				}
				break;
			}

			case T_USERNAME: {
				WASendClient(Client, Session->User, strlen(Session->User));
				break;
			}

			case T_LANGUAGELIST: {
				unsigned long	*LanguageList = (unsigned long *)Templates[Session->TemplateID] + sizeof(TemplateStruct);
				unsigned long	i;

				for (i = 0; i < Templates[Session->TemplateID]->LanguageCount; i++) {
					if (XplReturnLanguageName(LanguageList[i], URL) == 0) {
						ReplyInt = snprintf(Answer, sizeof(Answer), "<OPTION VALUE=\"%lu\"%s>%s</OPTION>\r\n", LanguageList[i], (Session->Language==i) ? " SELECTED" : "", URL);
						WASendClient(Client, Answer, ReplyInt);
					}
				}
				break;
			}

			case T_SESS_OVERRIDE: {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_LANGUAGE: {
						Session->Language = Token->ArgumentOffsetOrID[1];
						break;
					}	
					
					case AA_LOGOID: {
						Session->LogoID = Token->ArgumentOffsetOrID[1];
						break;
					}	

					case AA_CONNECTIONTIMEOUT: {
						Session->ConnectionTimeout = Token->ArgumentOffsetOrID[1];
						break;
					}	

					default: {
						break;
					}	
				}
				break;
			}

			case T_TEMPLATE_SELECT: {
				if (Token->ArgumentSize[1]) {
					unsigned long		i = 0;
					unsigned long		c = Session->InitialTemplate;

					while (i < TemplateCount) {
						if (WAQuickNCmp(Templates[i]->Name, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1])) {
							c = i;
						}
						i++;
					}

					WAEncodeURL(Session, URL, URL_TYPE_LINK, SWITCH_TEMPLATE, c, Templates[c]->InitialTemplate, TRUE, 0);
					WASendClient(Client, URL, strlen(URL));
				} else {
					WAEncodeURL(Session, URL, URL_TYPE_LINK, SWITCH_TEMPLATE, Session->InitialTemplate, Templates[Session->InitialTemplate]->InitialTemplate, FALSE, 0);
					WASendClient(Client, URL, strlen(URL));
				}

				break;
			}

			case T_TEMPLATE_ALLOWED: {
				unsigned long		i = 0;
				BOOL					Found = FALSE;

				while (!Found && i < Session->AllowedTemplates->Used) {
					if (WAQuickNCmp(Session->AllowedTemplates->Value[i], Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]) &&
							(strlen(Session->AllowedTemplates->Value[i]) == Token->ArgumentSize[0])) {
						Found = TRUE;
					} else {
						i++;
					}
				}

				if (Found) {
					WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
				} else {
					WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
				}

				break;
			}

			case T_TASKLIST_BEGIN: {
				BOOL			Found = FALSE;

				if (Session->Task.Template >= TemplateCount) {
					Session->Task.Template = 0;
				}

				strncpy(Session->TemplateBuffer, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				Session->TemplateBuffer[Token->ArgumentSize[0]] = '\0';

				if (Token->ArgumentOffsetOrID[1]) {
					/* We have to put a ':' after the class name, to seperate it from the rest of the string.
						This is needed so that simliar classes won't get the wrong pages, such as NIMS:ListAgent and NIMS:List
					*/
					snprintf(Session->TemplateBuffer + Token->ArgumentSize[0], 
						 sizeof(Session->TemplateBuffer) - Token->ArgumentSize[0],
						 "%s:", Session->CurrentClass);
				}

				while ((Session->Task.Template < TemplateCount) && !Found) {
					unsigned long			i = 0;

					/* Is this an allowed template? */
					while (!Found && i < Session->AllowedTemplates->Used) {
						if ((WAQuickCmp(Session->AllowedTemplates->Value[i], Templates[Session->Task.Template]->Name)) &&
								(WAFindTaskPageEx(Session->TemplateBuffer, strlen(Session->TemplateBuffer), &(Session->Task)) != -1)) {
							Found = TRUE;
						} else {
							i++;
						}
					}

					if (!Found) {
						Session->Task.Template++;
					}
				}

				if (Session->Task.Template >= TemplateCount) {
					while (Token->TokenID != T_TASKLIST_END && Token->TokenID != 0) {
						nextTokenAddress += Token->Length;
						Token = (TokenOverlayStruct *)nextTokenAddress;
					}
					goto NextToken;
				}
				break;
			}

			case T_TASKLIST_END: {
				if (Session->Task.Template < TemplateCount) {

					while (Token->TokenID != T_TASKLIST_BEGIN && (unsigned char *)Token != localObject->Object) {
						nextTokenAddress -= Token->PrevSize;
						Token = (TokenOverlayStruct *)nextTokenAddress;
					}
					goto NextToken;
				}
				memset(&Session->Task, 0, sizeof(TaskStruct));

				break;
			}

			case T_TASKLIST_VALUE: {
				unsigned long		CurrentTemplate = Session->TemplateID;
				unsigned long		TemplateID;
				unsigned char		Buffer[1024];

				/* Switch into another template, display the page that matches, and switch back */

				WASetSessionTemplate(Session->Task.Template, Session->Language, Session);

				snprintf(Buffer, sizeof(Buffer), "%s%s", Session->TemplateBuffer, Session->Task.Name);
				TemplateID = WAFindTemplatePage(Buffer, Session->TemplateID);
				WAHandleTemplate(Client, Session, TemplateID, FALSE);

				WASetSessionTemplate(CurrentTemplate, Session->Language, Session);

				break;
			}

			case T_IS_SELECTED: {
				/* Do we have an object selected? (Top is "protected" so we don't display it) */
				if (Session->CurrentObject[0] && !WAQuickCmp(Session->CurrentClass, "Top")) {
					WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				} else {
					WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
				}			

				break;
			}

			case T_SELECT_OBJECT: {
				WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_SELECT_OBJECT, Token->ArgumentOffsetOrID[0], 0, 0, 0);
				WASendClient(Client, URL, strlen(URL));

				break;
			}

			case T_BROWSE_FILTER: {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_FILTERFORM: {
						WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_DEFINE_FILTER, Token->ArgumentOffsetOrID[1], TRUE, 0, 0);
						WASendClient(Client, URL, strlen(URL));
						break;
					}
					case AA_FILTERCLEAR: {
						WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_CLEAR_FILTER, Token->ArgumentOffsetOrID[1], TRUE, 0, 0);
						WASendClient(Client, URL, strlen(URL));
						break;
					}
					case AA_FILTERNAME: {
						if (!WAQuickCmp(Session->BrowseFilterName, "*")) {
							WASendClient(Client, Session->BrowseFilterName, strlen(Session->BrowseFilterName));
						}
						break;
					}
					case AA_FILTERCLASS: {
						if (!WAQuickCmp(Session->BrowseFilterClass, "*")) {
							WASendClient(Client, Session->BrowseFilterClass, strlen(Session->BrowseFilterClass));
						}
						break;
					}
					case AA_CLASSCOMPARE:	{
						if (WAQuickCmp(Session->CurrentFilterClass, Token->Data+Token->ArgumentOffsetOrID[2])) {
							WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[3], Token->ArgumentSize[3]);
						} else {
							WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[4], Token->ArgumentSize[4]);
						}
						break;
					}
				}
				break;
			}

			case T_FILTER: {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_FILTERFORM: {
						WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_DEFINE_FILTER, Token->ArgumentOffsetOrID[1], 0, 0, 0);
						WASendClient(Client, URL, strlen(URL));
						break;
					}
					case AA_FILTERCLEAR: {
						WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_CLEAR_FILTER, Token->ArgumentOffsetOrID[1], 0, 0, 0);
						WASendClient(Client, URL, strlen(URL));
						break;
					}
					case AA_FILTERNAME: {
						if (!WAQuickCmp(Session->CurrentFilterName, "*")) {
							WASendClient(Client, Session->CurrentFilterName, strlen(Session->CurrentFilterName));
						}
						break;
					}
					case AA_FILTERCLASS: {
						if (!WAQuickCmp(Session->CurrentFilterClass, "*")) {
							WASendClient(Client, Session->CurrentFilterClass, strlen(Session->CurrentFilterClass));
						}
						break;
					}
					case AA_CLASSCOMPARE:	{
						if (WAQuickNCmp(Session->CurrentFilterClass, Token->Data+Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2])) {
							WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[3], Token->ArgumentSize[3]);
						} else {
							WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[4], Token->ArgumentSize[4]);
						}
						break;
					}
				}
				break;
			}

			case T_SET_FILTER: {
				if (Token->ArgumentSize[0] > 0) {
				    strncpy(Session->CurrentFilterName, Token->Data + Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				    Session->CurrentFilterName[Token->ArgumentSize[0]] = '\0';
				} else {
				    Session->CurrentFilterName[0] = '\0';
				}

				if (Token->ArgumentSize[1] > 0) {
				    strncpy(Session->CurrentFilterClass, Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
				    Session->CurrentFilterClass[Token->ArgumentSize[1]] = '\0';
				} else {
				    Session->CurrentFilterClass[0] = '\0';
				}

				break;
			}

			case T_SET_BROWSE_FILTER: {
				if (Token->ArgumentSize[0] > 0) {
					strncpy(Session->BrowseFilterName, Token->Data + Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
					Session->BrowseFilterName[Token->ArgumentSize[0]] = '\0';
				} else {
					Session->BrowseFilterName[0] = '\0';
				}

				if (Token->ArgumentSize[1] > 0) {
				    strncpy(Session->BrowseFilterClass, Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
				    Session->BrowseFilterClass[Token->ArgumentSize[1]] = '\0';
				} else {
					Session->BrowseFilterClass[0] = '\0';
				}

				break;
			}


			case T_BROWSELIST_BEGIN:
			case T_OBJLIST_BEGIN: {
				unsigned char			*Container = NULL;
				BOOL						Found = FALSE;
				BOOL						End = FALSE;
				BOOL						Browse = FALSE;
				unsigned char			*Class = NULL;
				unsigned char			*Name = NULL;

				if (Session->CurrentObject[0]) {
					Container = Session->CurrentObject;
				} else {
					Container = Session->CurrentTree;
				}

				if (Token->TokenID == T_BROWSELIST_BEGIN) {
					Browse = TRUE;
				}

				if (Browse && Session->BrowseFilterClass[0]) {
					Class = Session->BrowseFilterClass;
				} else if (!Browse && Session->CurrentFilterClass[0]) {
					Class = Session->CurrentFilterClass;
				}

				if (Browse && Session->BrowseFilterName[0]) {
					Name = Session->BrowseFilterName;
				} else if (!Browse && Session->CurrentFilterName[0]) {
					Name = Session->CurrentFilterName;
				}

				if (Token->ArgumentOffsetOrID[1] == AA_CONTAINERVIEW) {
					if (!Session->ObjectListV) {
						/*
							If we don't have Session->ObjectListV then we are at the begining of a display.
						*/

						/* Set the current object to the top of the cache tree */
						Session->ObjectListV = MDBCreateValueStruct(Session->AuthHandle, NULL);
						Session->ObjectListEnum = MDBCreateEnumStruct(Session->ObjectListV);

						Session->ObjectListCount = 0;
					}

					Session->ObjectListElement = (unsigned char *)MDBEnumerateObjectsEx(Container, Class, Name, TRUE, Session->ObjectListEnum, Session->ObjectListV);
					if (Session->ObjectListElement) {
						MDBGetObjectDetails(Session->ObjectListElement, Session->ObjectListClass, NULL, (unsigned char *)Session->ObjectListElement, Session->V);
						MDBFreeValues(Session->V);

						MDBListContainableClasses(Session->ObjectListElement, Session->V);
						if (Session->V->Used) {
							Session->CurrentElementIsContainer = TRUE;
							MDBFreeValues(Session->V);
						} else {
							Session->CurrentElementIsContainer = FALSE;
						}

						if ((Token->ArgumentOffsetOrID[2] != 0) && (Token->ArgumentOffsetOrID[3] != 0)) {
							if ((Session->ObjectListCount % Token->ArgumentOffsetOrID[2]) == 0) {
								WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[3], Token->ArgumentSize[3]);
							}
						}
						Session->ObjectListCount++;

					} else {
						/* We are done */

						MDBDestroyEnumStruct(Session->ObjectListEnum, Session->ObjectListV);
						Session->ObjectListEnum = NULL;

						MDBDestroyValueStruct(Session->ObjectListV);
						Session->ObjectListV = NULL;

						while (Token->TokenID != T_OBJLIST_END && Token->TokenID != T_BROWSELIST_END && Token->TokenID != 0) {
							nextTokenAddress += Token->Length;
							Token = (TokenOverlayStruct *)nextTokenAddress;
						}
						goto NextToken;
					}
				} else if (Token->ArgumentOffsetOrID[1] == AA_TREEVIEW) {
					if (Token->TokenID == T_BROWSELIST_BEGIN) {
						/* If we are browsing then the cache gets reset every time */

						Browse = TRUE;
					}

					if (!Session->ObjectListV) {
						ObjectListStruct	*Expand;
						/*
							If we don't have Session->ObjectListV then we are at the begining of a display.
							We need to add the currently selected container to our container cache here
						*/

						if ((!Browse && !Session->ObjectListCache) || (Browse && !Session->BrowseListCache)) {
							Expand = AddObjectListEntry(Session, Browse, Container);
							if (Expand) {
								Expand->Expanded = !(Expand->Expanded);
							}
							if (Browse && Session->BrowseListCache) {
								ClearObjectListFlags(Session->BrowseListCache, TRUE);
								Session->BrowseListCache->Expanded = TRUE;
							}
						}

						/* Set the current object to the top of the cache tree */

						Session->ObjectListV = MDBCreateValueStruct(Session->AuthHandle, NULL);
						Session->ObjectListEnum = MDBCreateEnumStruct(Session->ObjectListV);

						if (!Browse) {
							Session->ObjectListCurrent = Session->ObjectListCache;
						} else {
							Session->ObjectListCurrent = Session->BrowseListCache;
						}

						Session->ObjectListIndention = 1;
					}

					/*
						Now we have to decide what object to display this time through.  We loop until we either
						find something to display, or are finished with the tree.
					*/

					while (!Found && !End) {
						BOOL					SkipObject = FALSE;

						/*
							In order to ensure that children are drawn under their parents we display all containers from
							the cache, and not from the enumeration.  We have to make sure that we do not display them more
							than once though, so we have the displayed flag.  We also check for a parent pointer here
							because the only cache entry that does not have a parent is the top entry (the tree name) which
							we do not want to display.
						*/
						if (!Session->ObjectListCurrent->Displayed) {
							/* We found a container in our cache that hasn't been displayed, so we display it now */



							/* Make sure it hasn't been deleted since it was added to the cache */
							if (MDBGetObjectDetails(Session->ObjectListCurrent->Name, Session->ObjectListClass, NULL, NULL, Session->V)) {
								Found = TRUE;
								Session->ObjectListElement = Session->ObjectListCurrent->Name;
								Session->CurrentElementIsContainer = TRUE;
							}

							Session->ObjectListCurrent->Displayed = TRUE;
						} else {
							Session->CurrentElementIsContainer = FALSE;

							if (Session->ObjectListCurrent->Expanded) {
								Session->ObjectListElement = (unsigned char*)MDBEnumerateObjectsEx(Session->ObjectListCurrent->Name, Class, Name, TRUE, Session->ObjectListEnum, Session->ObjectListV);
								if (Session->ObjectListElement) {

									MDBGetObjectDetails(Session->ObjectListElement, Session->ObjectListClass, NULL, (unsigned char *)Session->ObjectListElement, Session->V);
									MDBFreeValues(Session->V);

									MDBListContainableClasses(Session->ObjectListElement, Session->V);
									if (Session->V->Used) {
										/* This is a container, so we don't display it here, but we need to add it to the cache */
										AddObjectListEntry(Session, Browse, Session->ObjectListElement);

										SkipObject = TRUE;
										MDBFreeValues(Session->V);
									} else if (Token->ArgumentOffsetOrID[0] == AA_TRUE) {
										/* Show Leaves */

										Found = TRUE;
										Session->ObjectListCount += 1;
									} else {
										/* Hide Leaves */

										SkipObject = TRUE;
									}
								}
							}
						}

						if (!Found && !SkipObject) {
							if (Session->ObjectListCurrent->Child && Session->ObjectListCurrent->Expanded && !Session->ObjectListCurrent->Child->Displayed) {
								/* Is there a child to walk to that has not already been displayed? */

								Session->ObjectListIndention++;
								Session->ObjectListCurrent = Session->ObjectListCurrent->Child;
							} else if (Session->ObjectListCurrent->Next) {
								/* No children, so is there anything else at this level */

								Session->ObjectListCurrent = Session->ObjectListCurrent->Next;
							} else if (Session->ObjectListCurrent->Parent) {
								/* Nothing left, so we go back to the parent */

								Session->ObjectListIndention--;
								Session->ObjectListCurrent = Session->ObjectListCurrent->Parent;

								while (Session->ObjectListCurrent->Displayed && !End) {
									if (Session->ObjectListCurrent->Next) {
										Session->ObjectListCurrent = Session->ObjectListCurrent->Next;
									} else if (Session->ObjectListCurrent->Parent) {
										Session->ObjectListCurrent = Session->ObjectListCurrent->Parent;
									} else {
										End = TRUE;

										MDBDestroyEnumStruct(Session->ObjectListEnum, Session->ObjectListV);
										Session->ObjectListEnum = NULL;

										MDBDestroyValueStruct(Session->ObjectListV);
										Session->ObjectListV = NULL;

										while (Token->TokenID != T_OBJLIST_END && Token->TokenID != T_BROWSELIST_END && Token->TokenID != 0) {
											nextTokenAddress += Token->Length;
											Token = (TokenOverlayStruct *)nextTokenAddress;
										}
										goto NextToken;
									}
								}
							} else {
								/* We walked back to the root, and there still isn't anything so we're done */

								End = TRUE;

								MDBDestroyEnumStruct(Session->ObjectListEnum, Session->ObjectListV);
								Session->ObjectListEnum = NULL;

								MDBDestroyValueStruct(Session->ObjectListV);
								Session->ObjectListV = NULL;

								while (Token->TokenID != T_OBJLIST_END && Token->TokenID != T_BROWSELIST_END && Token->TokenID != 0) {
									nextTokenAddress += Token->Length;
									Token = (TokenOverlayStruct *)nextTokenAddress;
								}
								goto NextToken;
							}
						}
					}
				}
				break;
			}

			case T_BROWSELIST_END:
			case T_OBJLIST_END: {
				if (!Session->ObjectListV) {
					/*
						If this is NULL then we either puked, or are done.
						Either way we leave here
					*/

					Session->ObjectListCurrent = NULL;

					if (Session->ObjectListEnum) {
						MDBDestroyEnumStruct(Session->ObjectListEnum, Session->V);
						Session->ObjectListEnum = NULL;
					}
					/* Reset Session->ObjectListCount */
					Session->ObjectListCount = 0;

					/* Reset the Displayed flag on every container */
					if (Session->ObjectListCache) {
						ClearObjectListFlags(Session->ObjectListCache, FALSE);
					}
					if (Session->BrowseListCache) {
						ClearObjectListFlags(Session->BrowseListCache, FALSE);
					}
				} else {
					/* Jump back up to begin */

					while (Token->TokenID != T_OBJLIST_BEGIN && Token->TokenID != T_BROWSELIST_BEGIN && (unsigned char *)Token != localObject->Object) {
						nextTokenAddress -= Token->PrevSize;
						Token = (TokenOverlayStruct *)nextTokenAddress;
					}
					goto NextToken;
				}

				break;
			}

			case T_BROWSELIST:
			case T_OBJLIST:
			case T_OBJECT: {
				BOOL		Browse;
				BOOL		SendExtra = FALSE;

				if (Token->TokenID == T_BROWSELIST) {
					/* If we are browsing then the cache gets reset every time */

					Browse = TRUE;
				} else {
					Browse = FALSE;
				}

				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_SELECT: {
						WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_OBJECT, Token->ArgumentOffsetOrID[1], Browse, FALSE, FALSE);
						WASendClient(Client, URL, strlen(URL));
						SendExtra = TRUE;
						break;
					}

					case AA_DISPLAY: {
						WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_OBJECT, Token->ArgumentOffsetOrID[1], Browse, TRUE, FALSE);
						WASendClient(Client, URL, strlen(URL));
						SendExtra = TRUE;
						break;
					}

					case AA_DISPLAYPAGE: {
						WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_OBJECT, Token->ArgumentOffsetOrID[1], Browse, TRUE, TRUE);
						WASendClient(Client, URL, strlen(URL));
						SendExtra = TRUE;
						break;
					}

					case AA_PARENT: {
						WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_OBJECT, Token->ArgumentOffsetOrID[1], Browse, TRUE, FALSE);
						WASendClient(Client, URL, strlen(URL));

						HulaStrNCpy(Session->ObjectBuffer, Session->CurrentObject, sizeof(Session->ObjectBuffer));
						ptr=strrchr(Session->ObjectBuffer, '\\');
						if (ptr && ptr!=Session->ObjectBuffer) {
							ptr[0]='\0';
						}

						WASendURLExtra(Client, Session->ObjectBuffer);
						break;
					}

					case AA_CLASS: {
						WASendClientEscaped(Client, Session->CurrentClass, strlen(Session->CurrentClass));
						break;
					}

#if 0
					case AA_CREATE: {
						WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_CREATE_PAGE, Token->ArgumentOffsetOrID[1], 0, TRUE, 0);
						WASendClient(Client, URL, strlen(URL));
						SendExtra = TRUE;
						break;
					}
#endif

					case AA_DELETE: {
						WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_DELETE, Token->ArgumentOffsetOrID[1], 0, 0, 0);
						WASendClient(Client, URL, strlen(URL));
						SendExtra = TRUE;
						break;
					}

					case AA_CREATECLASS: {
						WASendClient(Client, Session->CurrentCreateClass, strlen(Session->CurrentCreateClass));
						break;
					}

					case AA_CREATENAME: {
						unsigned long	i;

						for (i=0; i<Session->ClassListCount; i++) {
							if (WAQuickCmp(Session->CurrentCreateClass, Session->ClassList[i].Class)) {
								WASendClientEscaped(Client, Session->ClassList[i].Description, strlen(Session->ClassList[i].Description));
								break;
							}
						}
						break;
					}

					case AA_NAME: {
						unsigned char		*dn;

						if ((Token->TokenID == T_BROWSELIST) || (Token->TokenID == T_OBJLIST)) {
							dn = Session->ObjectListElement;
						} else {
							dn = Session->CurrentObject;
						}

						ptr=strrchr(dn, '\\');
						if (ptr) {
							ptr++;
							WASendClientEscaped(Client, ptr, strlen(ptr));
						} else {
							WASendClientEscaped(Client, dn, strlen(dn));
						}
						break;
					}

					case AA_FULLDN: {
						unsigned char		X500[MDB_MAX_OBJECT_CHARS+1];

						if ((Token->TokenID == T_BROWSELIST) || (Token->TokenID == T_OBJLIST)) {
							WAMDBtoX500(Session->ObjectListElement, X500, Session->V);
						} else {
							WAMDBtoX500(Session->CurrentObject, X500, Session->V);
						}
						WASendClientEscaped(Client, X500, strlen(X500));

						break;
					}

					case AA_ESCAPEDDN: {
						unsigned char		X500[MDB_MAX_OBJECT_CHARS+1];
						unsigned char		Escaped[MDB_MAX_OBJECT_CHARS+1];
						unsigned char		*X500Ptr = X500;
						unsigned char		*EscapedPtr	= Escaped;

						if ((Token->TokenID == T_BROWSELIST) || (Token->TokenID == T_OBJLIST)) {
							WAMDBtoX500(Session->ObjectListElement, X500, Session->V);
						} else {
							WAMDBtoX500(Session->CurrentObject, X500, Session->V);
						}
						
						while (*X500Ptr) {
							if (*X500Ptr == '\\' || *X500Ptr == ' ' || *X500Ptr == '\'') {
								*EscapedPtr = '\\';
								EscapedPtr++;
							}
							*EscapedPtr = *X500Ptr;

							EscapedPtr++;
							X500Ptr++;
						}
						*EscapedPtr = '\0';

						WASendClient(Client, Escaped, strlen(Escaped));

						break;
					}

					case AA_OBJECTID: {
						unsigned char		X500[MDB_MAX_OBJECT_CHARS+1];

						if ((Token->TokenID == T_BROWSELIST) || (Token->TokenID == T_OBJLIST)) {
							WAMDBtoX500(Session->ObjectListElement, X500, Session->V);
						} else {
							WAMDBtoX500(Session->CurrentObject, X500, Session->V);
						}
						
						WASendURLExtra(Client, X500);

						break;
					}

					case AA_INDENTATION: {
						unsigned long		i;

						if (Session->CurrentElementIsContainer) {
							i = 1;
						} else {
							i = 0;
						}

						for (; i < Session->ObjectListIndention; i++) {
							WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
						}
						break;
					}

					case AA_IMAGE: {
						unsigned long		i;
						BOOL					Found=FALSE;
						unsigned char		*Class;

						if ((Token->TokenID == T_BROWSELIST) || (Token->TokenID == T_OBJLIST)) {
							Class = Session->ObjectListClass;
						} else {
							Class = Session->CurrentClass;
						}

						for (i=0; i<Session->ClassListCount; i++) {
							if (WAQuickCmp(Class, Session->ClassList[i].Class)) {
								WAEncodeURL(Session, URL, URL_TYPE_IMAGE, DISPLAY_IMAGE, Session->ClassList[i].TemplateID, Session->Language, Session->ClassList[i].Image, 0);
								WASendClient(Client, URL, strlen(URL));
								Found=TRUE;
								break;
							}
						}
						if (!Found) {
							WAEncodeURL(Session, URL, URL_TYPE_IMAGE, DISPLAY_IMAGE, Session->UnknownImageTemplate, Session->Language, Session->UnknownImage, 0);
							WASendClient(Client, URL, strlen(URL));
						}
						break;
					}

					case AA_ISEXPANDEDORLEAF: {
						BOOL			Expanded;
						BOOL			Container;

						if ((Token->TokenID == T_BROWSELIST) || (Token->TokenID == T_OBJLIST)) {
							if (Session->CurrentElementIsContainer && Session->ObjectListCurrent) {
								Container = TRUE;

								if (Session->ObjectListCurrent->Expanded) {
									/* Its expanded, send the second Image */
									Expanded = TRUE;
								} else {
									/* Its not expanded, send the first Image */
									Expanded = FALSE;
								}
							} else if (Session->CurrentElementIsContainer) {
								Container = TRUE;
								Expanded = FALSE;
							} else {
								/* Its a leaf, send the third Image */
								Container = FALSE;
								Expanded = FALSE;
							}
						} else {
							Expanded = FALSE;

							MDBListContainableClasses(Session->CurrentObject, Session->V);
							if (Session->V->Used) {
								MDBFreeValues(Session->V);
								Container = TRUE;
							} else {
								Container = FALSE;
							}
						}

						if (Container) {
							if (Expanded) {
								/* Its expanded, send the second Image */
								WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[3], Token->ArgumentSize[3]);
							} else {
								/* Its not expanded, send the first Image */
								WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
							}
						} else {
							/* Its a leaf, send the third Image */
							WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[4], Token->ArgumentSize[4]);
						}
						break;
					}
				}

				if (SendExtra) {
					if ((Token->TokenID == T_BROWSELIST) || (Token->TokenID == T_OBJLIST)) {
						WASendURLExtra(Client, Session->ObjectListElement);
					} else {
						WASendURLExtra(Client, Session->CurrentObject);
					}
				}
				break;
			}

			case T_OBJECTSELECT: {
				if (Token->ArgumentOffsetOrID[2]) {
					/* Generate a link */

					WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_OBJECT, Token->ArgumentOffsetOrID[2], FALSE, TRUE, FALSE);
					WASendClient(Client, URL, strlen(URL));

					switch (Token->ArgumentOffsetOrID[0]) {
						case AA_SELF: {
							WASendURLExtra(Client, Session->UserDN);
							break;
						}
						case AA_RELATIVE_DN: {
							HulaStrNCpy(Session->ObjectBuffer, Session->CurrentObject, sizeof(Session->ObjectBuffer));
							memcpy(Session->ObjectBuffer + strlen(Session->CurrentObject), Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
							*(Session->ObjectBuffer + strlen(Session->CurrentObject) + Token->ArgumentSize[1]) = '\0';

							WASendURLExtra(Client, Session->ObjectBuffer);
							break;
						}
						case AA_FULL_DN: {
							memcpy(Session->ObjectBuffer, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
							*(Session->ObjectBuffer + Token->ArgumentSize[1]) = '\0';

							WASendURLExtra(Client, Session->ObjectBuffer);

							break;
						}
					}
				} else {
					/* Simply select the object */

					switch (Token->ArgumentOffsetOrID[0]) {
						case AA_SELF: {
							HulaStrNCpy(Session->CurrentObject, Session->UserDN, sizeof(Session->CurrentObject));
							break;
						}
						case AA_RELATIVE_DN: {
							if (*Session->CurrentObject) {
								memcpy(Session->CurrentObject + strlen(Session->CurrentObject), Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
								*(Session->CurrentObject + strlen(Session->CurrentObject) + Token->ArgumentSize[1]) = '\0';
							} else {
								Session->CurrentObject[0] = '\\';
								HulaStrNCpy(Session->CurrentObject + 1, Session->CurrentTree, sizeof(Session->CurrentObject) - 1);
								Session->CurrentObject[strlen(Session->CurrentTree) + 1] = '\\';

								memcpy(Session->CurrentObject + strlen(Session->CurrentTree) + 2, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
								*(Session->CurrentObject + strlen(Session->CurrentTree) + 2 + Token->ArgumentSize[1]) = '\0';
							}

							break;
						}
						case AA_FULL_DN: {
							/* First char gets a '\', then the tree name, then another '\', and finally the DN */

							Session->CurrentObject[0] = '\\';
							HulaStrNCpy(Session->CurrentObject + 1, Session->CurrentTree, sizeof(Session->CurrentObject) - 1);
							Session->CurrentObject[strlen(Session->CurrentTree) + 1] = '\\';

							memcpy(Session->CurrentObject + strlen(Session->CurrentTree) + 2, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
							*(Session->CurrentObject + strlen(Session->CurrentTree) + 2 + Token->ArgumentSize[1]) = '\0';

							break;
						}
					}

					if (!MDBGetObjectDetails(Session->CurrentObject, Session->CurrentClass, NULL, NULL, Session->V)) {
						/* Report an Error - Couldn't select object */
						Session->CurrentObject[0] = '\0';
						Session->LastError = WAERR_COULD_NOT_SELECT;
					}
				}
				break;
			}

			case T_CURRENT_DN_BEGIN: {
				if (!Session->ObjectListV) {
					unsigned long			i;
					BOOL						Ok = FALSE;

					/* First time through */

					Session->ObjectListV = MDBCreateValueStruct(Session->AuthHandle, Session->CurrentObject);
					MDBGetObjectDetails(Session->CurrentObject, NULL, NULL, (unsigned char *)Session->ObjectBuffer, Session->ObjectListV);

					while (!Ok) {
						i = strlen(Session->ObjectBuffer);

						if ((Session->ObjectBuffer[i - 1] == '.') || (Session->ObjectBuffer[i - 1] == '\\')) {
							Session->ObjectBuffer[i - 1] = '\0';
						} else {
							Ok = TRUE;
						}
					}

					Session->ObjectListElement = Session->ObjectBuffer;
				} else {
					Session->ObjectListElement = strrchr(Session->ObjectBuffer, '\\');
					if (Session->ObjectListElement && Session->ObjectListElement != Session->ObjectBuffer) {
						Session->ObjectListElement[0] = '\0';
					} else {
						Session->ObjectListElement = NULL;
						Session->ObjectBuffer[0] = '\0';

						MDBDestroyValueStruct(Session->ObjectListV);
						Session->ObjectListV = NULL;

						while (Token->TokenID != T_CURRENT_DN_END && Token->TokenID != 0) {
							nextTokenAddress += Token->Length;
							Token = (TokenOverlayStruct *)nextTokenAddress;
						}
						goto NextToken;
					}
				}

				break;
			}

			case T_CURRENT_DN_END: {
				if (Session->ObjectListV) {
					while (Token->TokenID != T_CURRENT_DN_BEGIN && (unsigned char *)Token != localObject->Object) {
						nextTokenAddress -= Token->PrevSize;
						Token = (TokenOverlayStruct *)nextTokenAddress;
					}
					goto NextToken;
				}

				break;
			}

			case T_CURRENT_DN_VALUE: {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_SELECT: {
						WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_OBJECT, Token->ArgumentOffsetOrID[2], FALSE, TRUE, FALSE);
						WASendClient(Client, URL, strlen(URL));

						WASendURLExtra(Client, Session->ObjectBuffer);
						break;
					}

					case AA_NAME: {
						unsigned char		*ptr;

						ptr = strrchr(Session->ObjectBuffer, '\\');
						if (ptr) {
							ptr++;
							if ((strlen(ptr) > 0) && (ptr != Session->ObjectBuffer) && (ptr != Session->ObjectBuffer + 1)) {
								WASendClient(Client, ptr, strlen(ptr));
							} else {
								if (Token->ArgumentOffsetOrID[1]) {
									WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
								}
							}
						}

						break;
					}

					case AA_SEPERATOR: {
						unsigned char		*ptr;

						ptr = strrchr(Session->ObjectBuffer, '\\');
						if (ptr && ptr != Session->ObjectBuffer) {
							WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
						}

						break;
					}
				}

				break;
			}

			case T_BROWSE: {
				
				WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_BROWSE, Token->ArgumentOffsetOrID[1], Token->ArgumentOffsetOrID[2], Session->TemplateID, 0);

				strncpy(Client->Temp, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				Client->Temp[Token->ArgumentSize[0]] = '\0';

				WASendClient(Client, URL, strlen(URL));
				WASendURLExtra(Client, Client->Temp);

				break;
			}

			case T_BROWSE_LOCATION: {
				if (Session->BrowseLocation) {
					WASendClient(Client, Session->BrowseLocation, strlen(Session->BrowseLocation));
				}
				break;
			}

			case T_CLEAR_ASSIGNED: {
				FreeClassList(Session);

				break;
			}

			case T_ASSIGN: {
				unsigned char	Class[MDB_MAX_OBJECT_CHARS+1];

				memcpy(Class, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);
				Class[Token->ArgumentSize[0]]='\0';

				if (!WAQuickCmp(Class, "Unknown")) {
					BOOL				Found=FALSE;
					unsigned long	i;

					for (i=0; i<Session->ClassListCount; i++) {
						if (WAQuickCmp(Class, Session->ClassList[i].Class)) {
							Found=TRUE;
							break;
						}
					}

					if (!Found) {
						AddClass(Session, Class, Token->ArgumentOffsetOrID[1], Token->ArgumentOffsetOrID[2]);
					}
				} else {
					/* Assigning "unknown" */
					Session->UnknownImage = Token->ArgumentOffsetOrID[2];
					Session->UnknownImageTemplate = Session->TemplateID;
				}
				break;
			}

			case T_NAME: {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_TREE: {
						WASendClient(Client, Session->CurrentTree, strlen(Session->CurrentTree));
						break;
					}

					case AA_USER: {
						WASendClient(Client, Session->User, strlen(Session->User));
						break;
					}
				}
				break;
			}

			case T_CLASSLIST_BEGIN: {
				BOOL					Found = FALSE;
				unsigned long		i;

				if (Session->V->Used == 0) {
					MDBListContainableClasses(Session->CurrentObject, Session->V);

					Session->ObjectListCount = 0;
				}

				if (Session->V->Used == 0) {
					while (Token->TokenID != T_CLASSLIST_END && Token->TokenID != 0) {
						nextTokenAddress += Token->Length;
						Token = (TokenOverlayStruct *)nextTokenAddress;
					}
					goto NextToken;
				}

				/* We are abusing ObjectListCount */
				for (i=0; i < Session->ClassListCount; i++) {
					if (WAQuickCmp(Session->V->Value[0], Session->ClassList[i].Class)) {
						Found=TRUE;
						break;
					}
				}

				if (Found) {
					Session->ObjectListCount = i;
				} else {
					while (Token->TokenID != T_CLASSLIST_END && Token->TokenID != 0) {
						nextTokenAddress += Token->Length;
						Token = (TokenOverlayStruct *)nextTokenAddress;
					}
					goto NextToken;
				}
				break;
			}

			case T_CLASSLIST_END	: {
				if (Session->V->Used != 0) {
					/* Always act on the first value.  Once we are out of values we just leave */
					MDBFreeValue(0, Session->V);
				}

				if (Session->V->Used != 0) {
					while (Token->TokenID != T_CLASSLIST_BEGIN && (unsigned char *)Token != localObject->Object) {
						nextTokenAddress -= Token->PrevSize;
						Token = (TokenOverlayStruct *)nextTokenAddress;
					}
					goto NextToken;
				}

				/* We abused it so we set it back */
				Session->ObjectListCount = 0;
				break;
			}

			case T_CLASSLIST_VALUE: {
				if (Session->V->Used) {
					switch (Token->ArgumentOffsetOrID[0]) {
						case AA_NAME: {
							WASendClient(Client, Session->ClassList[Session->ObjectListCount].Description, strlen(Session->ClassList[Session->ObjectListCount].Description));
							break;
						}

						case AA_IMAGE: {
							WAEncodeURL(Session, URL, URL_TYPE_IMAGE, DISPLAY_IMAGE, Session->ClassList[Session->ObjectListCount].TemplateID, Session->Language, Session->ClassList[Session->ObjectListCount].Image, 0);
							WASendClient(Client, URL, strlen(URL));

							break;
						}

						case AA_SELECT: {
							long					Template	= -1;
							BOOL					Create = TRUE;
							unsigned long		TemplateID;

							TemplateID = Session->TemplateID;

							if ((Session->ObjectListCount >= 0) && (Session->ObjectListCount <= Session->ClassListCount) && Create) {
								unsigned long		i;
								BOOL					Found = FALSE;

								memcpy(Client->Temp, Token->Data+Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
								snprintf(Client->Temp + Token->ArgumentSize[1], 
									 sizeof(Client->Temp) - Token->ArgumentSize[1],
									 "Create%s", Session->ClassList[Session->ObjectListCount].Class);

								for (i = 0; i < TemplateCount && !Found; i++) {
									WASetSessionTemplate(i, Session->Language, Session);
									Template=(unsigned long)WAFindTemplatePage(Client->Temp, Session->TemplateID);
									if (Template != -1) {
										Found = TRUE;
									}
								}
							}

							if (Template!=-1) {
								WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_CREATE_PAGE, Template, Session->ObjectListCount, 0, 0);
								WASendClient(Client, URL, strlen(URL));

								/* Restore the template */
								WASetSessionTemplate(TemplateID, Session->Language, Session);
							} else {
								/* Restore the template */
								WASetSessionTemplate(TemplateID, Session->Language, Session);

								WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_CREATE_PAGE, Token->ArgumentOffsetOrID[2], Session->ObjectListCount, 0, 0);
								WASendClient(Client, URL, strlen(URL));
							}


							break;
						}

						case AA_CLASSID: {
							unsigned long		Len;

							Len = snprintf(Session->ObjectBuffer, sizeof(Session->ObjectBuffer), 
								       "%lu", Session->ObjectListCount);
							WASendClient(Client, Session->ObjectBuffer, Len);
						}
					}
				}
				break;
			}

			case T_MODIFY_OBJECT_LIST: {
				WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_MODIFY_OBJECT, Token->ArgumentOffsetOrID[0], Token->ArgumentOffsetOrID[1], 0, 0);
				WASendClient(Client, URL, strlen(URL));
				WASendURLExtra(Client, Session->ObjectListElement);

				break;
			}
			case T_MODIFY_OBJECT: {
				WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_MODIFY_OBJECT, Token->ArgumentOffsetOrID[0], Token->ArgumentOffsetOrID[1], 0, 0);
				WASendClient(Client, URL, strlen(URL));
				WASendURLExtra(Client, Session->CurrentObject);

				break;
			}

			case T_CREATE_OBJECT: {
				WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_CREATE_OBJECT, Token->ArgumentOffsetOrID[0], Token->ArgumentOffsetOrID[1], 0, 0);
				WASendClient(Client, URL, strlen(URL));
				WASendURLExtra(Client, Session->CurrentObject);

				break;
			}

			case T_WRITE_DN: {
				if (Token->ArgumentOffsetOrID[2] == 0) {
					/* Only send one attribute */

					ReplyInt = snprintf(Answer, sizeof(Answer), "D_%c%c%c%05d",
								(Token->ArgumentOffsetOrID[0] == AA_SINGLE) ? 'S' : 'M',					// Single/Multi
								(unsigned char)(Token->ArgumentOffsetOrID[1] % 9) + '0',					// Attribute Mod 9
								(unsigned char)(Token->ArgumentOffsetOrID[1] % 7) + '0',					// Attribute Mod 7
								(unsigned int)Token->ArgumentOffsetOrID[1]);									// Attribute
				} else {
					/* Send the reference attribute as well */

					ReplyInt = snprintf(Answer, sizeof(Answer), "D_%c%c%c%05d_%c%c%c%05d",
								(Token->ArgumentOffsetOrID[0] == AA_SINGLE) ? 'S' : 'M',					// Single/Multi
								(unsigned char)(Token->ArgumentOffsetOrID[1] % 9) + '0',					// Attribute mod 9
								(unsigned char)(Token->ArgumentOffsetOrID[1] % 7) + '0',					// Attribute mod 7
								(unsigned int)Token->ArgumentOffsetOrID[1],									// Attribute

								(Token->ArgumentOffsetOrID[2] == AA_SINGLE) ? 'S' : 'M',					// Single/Multi
								(unsigned char)(Token->ArgumentOffsetOrID[3] % 9) + '0',					// Attribute mod 9
								(unsigned char)(Token->ArgumentOffsetOrID[3] % 7) + '0',					// Attribute mod 7
								(unsigned int)Token->ArgumentOffsetOrID[3]);									// Attribute
				}
				WASendClient(Client, Answer, ReplyInt);

				break;
			}

			case T_WRITE_STRING: {
				unsigned char			Type;

				if (Token->ArgumentOffsetOrID[0] == AA_SINGLE) {
					Type = 'S';
				} else if (Token->ArgumentOffsetOrID[0] == AA_NUMBER) {
					Type = 'N';
				} else {
					Type = 'M';
				}

				ReplyInt = snprintf(Answer, sizeof(Answer), "S_%c%c%c%05d",
								Type,																						// Single/Multi/Number
								(unsigned char)(Token->ArgumentOffsetOrID[1] % 9) + '0',					// Attribute mod 9
								(unsigned char)(Token->ArgumentOffsetOrID[1] % 7) + '0',					// Attribute mod 7
								(unsigned int)Token->ArgumentOffsetOrID[1]);									// Attribute
				WASendClient(Client, Answer, ReplyInt);

				break;
			}

			case T_WRITE_COMPARE: {
				if (Token->ArgumentOffsetOrID[1] == 0) {
					ReplyInt = snprintf(Answer, sizeof(Answer), "I_%c%c%05d",
									(unsigned char)(Token->ArgumentOffsetOrID[0] % 9) + '0',				// Attribute mod 9
									(unsigned char)(Token->ArgumentOffsetOrID[0] % 7) + '0',				// Attribute mod 7
									(unsigned int)Token->ArgumentOffsetOrID[0]);								// Attribute
				} else {
					ReplyInt = snprintf(Answer, sizeof(Answer), "I_%c%c%05d_%c%c%05d",
									(unsigned char)(Token->ArgumentOffsetOrID[0] % 9) + '0',				// Attribute mod 9
									(unsigned char)(Token->ArgumentOffsetOrID[0] % 7) + '0',				// Attribute mod 7
									(unsigned int)Token->ArgumentOffsetOrID[0],								// Attribute

									(unsigned char)(Token->ArgumentOffsetOrID[1] % 9) + '0',				// Prefix mod 9
									(unsigned char)(Token->ArgumentOffsetOrID[1] % 7) + '0',				// Prefix mod 7
									(unsigned int)Token->ArgumentOffsetOrID[1]);								// Prefix
				}
				WASendClient(Client, Answer, ReplyInt);

				break;
			}

			case T_WRITE_BITFIELD: {
				if (Token->ArgumentOffsetOrID[2] == 0) {
					ReplyInt = snprintf(Answer, sizeof(Answer), "B_%c%c%05d_%c%c%05d",
									(unsigned char)(Token->ArgumentOffsetOrID[0] % 9) + '0',				// Attribute mod 9
									(unsigned char)(Token->ArgumentOffsetOrID[0] % 7) + '0',				// Attribute mod 7
									(unsigned int)Token->ArgumentOffsetOrID[0],								// Attribute

									(unsigned char)(Token->ArgumentOffsetOrID[1] % 9) + '0',				// Bit mod 9
									(unsigned char)(Token->ArgumentOffsetOrID[1] % 7) + '0',				// Bit mod 7
									(unsigned int)Token->ArgumentOffsetOrID[1]);								// Bit
				} else {
					ReplyInt = snprintf(Answer, sizeof(Answer), "B_%c%c%05d_%c%c%05d_%c%c%05d",
									(unsigned char)(Token->ArgumentOffsetOrID[0] % 9) + '0',				// Attribute mod 9
									(unsigned char)(Token->ArgumentOffsetOrID[0] % 7) + '0',				// Attribute mod 7
									(unsigned int)Token->ArgumentOffsetOrID[0],								// Attribute

									(unsigned char)(Token->ArgumentOffsetOrID[1] % 9) + '0',				// Bit mod 9
									(unsigned char)(Token->ArgumentOffsetOrID[1] % 7) + '0',				// Bit mod 7
									(unsigned int)Token->ArgumentOffsetOrID[1],								// Bit

									(unsigned char)(Token->ArgumentOffsetOrID[2] % 9) + '0',				// Prefix mod 9
									(unsigned char)(Token->ArgumentOffsetOrID[2] % 7) + '0',				// Prefix mod 7
									(unsigned int)Token->ArgumentOffsetOrID[2]);								// Prefix
				}
				WASendClient(Client, Answer, ReplyInt);

				break;
			}

			case T_WRITE_CUSTOM: {
				WASendClient(Client, "O", 1);
				WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[0], Token->ArgumentSize[0]);

				break;
			}

			case T_WRITE_REMOVE: {
				ReplyInt = snprintf(Answer, sizeof(Answer), "X_%c%c%05d",
								(unsigned char)(Token->ArgumentOffsetOrID[1] % 9) + '0',					// Attribute mod 9
								(unsigned char)(Token->ArgumentOffsetOrID[1] % 7) + '0',					// Attribute mod 7
								(unsigned int)Token->ArgumentOffsetOrID[1]);									// Attribute
				WASendClient(Client, Answer, ReplyInt);

				break;
			}

			case T_READ_DN: {
				unsigned char			X500[MDB_MAX_OBJECT_CHARS+1];
				MDBValueStruct			*Reference;
				unsigned long			i;
				unsigned long			c;

				Reference = MDBShareContext(Session->V);

				/* Single/Multi */
				if (MDBReadDN(Session->CurrentObject, Session->Strings[Token->ArgumentOffsetOrID[1]], Session->V)) {
					if (Token->ArgumentOffsetOrID[0] == AA_SINGLE) {
						BOOL			ReferenceMatch = TRUE;

						/* Do we need to verify it with its reference? */

						if (Token->ArgumentOffsetOrID[3] != 0) {
							ReferenceMatch = FALSE;

							if (MDBReadDN(Session->V->Value[0], Session->Strings[Token->ArgumentOffsetOrID[3]], Reference)) {
								for (i = 0; i < Reference->Used; i++) {
									if (WAQuickCmp(Session->CurrentObject, Reference->Value[i])) {
										ReferenceMatch = TRUE;
									}
								}
							}
						}

						if (ReferenceMatch) {
							WAMDBtoX500(Session->V->Value[0], X500, Session->V);
							WASendClient(Client, X500, strlen(X500));
						}
					} else {
						if (Token->ArgumentOffsetOrID[3] != 0) {
							for (i = 0; i < Session->V->Used; i++) {
								BOOL		ReferenceMatch = FALSE;

								if (MDBReadDN(Session->V->Value[i], Session->Strings[Token->ArgumentOffsetOrID[3]], Reference)) {
									for (c = 0; c < Reference->Used; c++) {
										if (WAQuickCmp(Session->CurrentObject, Reference->Value[c])) {
											ReferenceMatch = TRUE;
										}
									}
									MDBFreeValues(Reference);
								}
								if (!ReferenceMatch) {
									MDBFreeValue(i, Session->V);
									if (i > 0) {
										i--;
									}
								}
							}
						}

						for (i = 0; i < Session->V->Used; i++) {
							WAMDBtoX500(Session->V->Value[i], X500, Session->V);
							WASendClient(Client, X500, strlen(X500));
							if (i + 1 < Session->V->Used) {
								if (Token->ArgumentSize[4] == 0) {
									WASendClient(Client, "\r\n", 2);
								} else {
									WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[4], Token->ArgumentSize[4]);
								}
							}
						}
					}
					MDBFreeValues(Session->V);
				}
				MDBDestroyValueStruct(Reference);

				break;
			}

			case T_READ_STRING: {
				unsigned long		i;

				if (MDBRead(Session->CurrentObject, Session->Strings[Token->ArgumentOffsetOrID[1]], Session->V)) {
					if (Token->ArgumentOffsetOrID[0] == AA_SINGLE) {
						/* Single */

						WASendClientEscaped(Client, Session->V->Value[0], strlen(Session->V->Value[0]));
					} else if (Token->ArgumentOffsetOrID[0] == AA_NUMBER) {
						unsigned long		Value = 0;

						/* Number */
						Value = atol(Session->V->Value[0]);
						snprintf(Session->ObjectBuffer, sizeof(Session->ObjectBuffer), "%lu", Value);

						WASendClientEscaped(Client, Session->ObjectBuffer, strlen(Session->ObjectBuffer));
					} else {
						/* Multi */

						for (i = 0; i < Session->V->Used; i++) {
							WASendClientEscaped(Client, Session->V->Value[i], strlen(Session->V->Value[i]));
							if (i + 1 < Session->V->Used) {
								if (Token->ArgumentSize[2] == 0) {
									WASendClient(Client, "\r\n", 2);
								} else {
									WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
								}
							}
						}
					}

					MDBFreeValues(Session->V);
				} else if ((Token->ArgumentSize[2] != 0) && (Token->ArgumentOffsetOrID[0] != AA_MULTI)) {
					/* Send the default if needed */

					WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
				}

				break;
			}

			case T_READ_COMPARE: {
				unsigned long		i;
				unsigned long		Match = 0;

				/* Do we have it in the cache already? */
				if ((Session->CachedValues->Used <= 0) || (!WAQuickCmp(Session->CachedValues->Value[0], Session->Strings[Token->ArgumentOffsetOrID[0]]))) {
					MDBFreeValues(Session->CachedValues);

					/* Add the attribute name as the first value so we can be sure our cache is still valid */
					MDBAddValue(Session->Strings[Token->ArgumentOffsetOrID[0]], Session->CachedValues);
					MDBRead(Session->CurrentObject, Session->Strings[Token->ArgumentOffsetOrID[0]], Session->CachedValues);
				}

				/* First value is the attribute name so skip it */
				if (Session->CachedValues->Used > 1) {
					for (i = 1; i < Session->CachedValues->Used; i++) {
						if (WAQuickNCmp(Session->CachedValues->Value[i], Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1])) {
							Match = i;
						}
					}
				}

				if (Match) {
					if (Token->ArgumentOffsetOrID[2]) {
						/* They gave a value, so send it */
						WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
					} else {
						unsigned char		*Value = Session->CachedValues->Value[Match] + Token->ArgumentSize[1];
						/* No value given on the token, so send the actual value */

						WASendClient(Client, Value, strlen(Value));
					}
				} else {
					WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[3], Token->ArgumentSize[3]);
				}

				break;
			}

			case T_READ_BITFIELD: {
				unsigned long		i;
				unsigned long		BitField = 0;

				/* Do we have it in the cache already? */
				if ((Session->CachedValues->Used <= 0) || (!WAQuickCmp(Session->CachedValues->Value[0], Session->Strings[Token->ArgumentOffsetOrID[0]]))) {
					MDBFreeValues(Session->CachedValues);

					/* Add the attribute name as the first value so we can be sure our cache is still valid */
					MDBAddValue(Session->Strings[Token->ArgumentOffsetOrID[0]], Session->CachedValues);
					MDBRead(Session->CurrentObject, Session->Strings[Token->ArgumentOffsetOrID[0]], Session->CachedValues);
				}

				/* First value is the attribute name so skip it */
				if (Session->CachedValues->Used > 1) {
					for (i = 0; i < Session->CachedValues->Used; i++) {
						if (Token->ArgumentOffsetOrID[4] == 0) {
							BitField = atol(Session->CachedValues->Value[i]);
						} else if (WAQuickNCmp(Session->CachedValues->Value[i], Session->Strings[Token->ArgumentOffsetOrID[4]], strlen(Session->Strings[Token->ArgumentOffsetOrID[4]]))) {
							BitField = atol(Session->CachedValues->Value[i] + strlen(Session->Strings[Token->ArgumentOffsetOrID[4]]));
						}
					}
				}

				if (BitField & (1 << Token->ArgumentOffsetOrID[1])) {
					WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
				} else {
					WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[3], Token->ArgumentSize[3]);
				}

				break;
			}

			case T_READ_DOES_EXIST: {
				if (MDBRead(Session->CurrentObject, Session->Strings[Token->ArgumentOffsetOrID[0]], Session->V)) {
					MDBFreeValues(Session->V);

					WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
				} else {
					WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
				}
			}

			case T_READ_CUSTOM: {

				break;
			}

#if 0
			case T_OBJTEMPLATES_BEGIN: {
				if (Session->ObjectListCount == 0 && !Session->V->Used) {
					switch (Token->ArgumentOffsetOrID[0]) {
						case AA_ALLOWED: {
							MDBRead(Session->CurrentObject, MSGSRV_A_WA_ALLOWED_TEMPLATES, Session->V);
							break;
						}

						case AA_DISALLOWED: {
							MDBRead(Session->CurrentObject, MSGSRV_A_WA_DISALLOWED_TEMPLATES, Session->V);
							break;
						}

						case AA_DEFAULT: {
							MDBRead(Session->CurrentObject, MSGSRV_A_WA_DEFAULT_TEMPLATE, Session->V);

							while (Session->ObjectListCount < TemplateCount && !WAQuickNCmp("Default", Templates[Session->ObjectListCount]->Name, 7)) {
								Session->ObjectListCount++;
							}

							break;
						}
					}
				}

				if (Session->ObjectListCount >= TemplateCount) {
					while (Token->TokenID != T_OBJTEMPLATES_END && Token->TokenID != 0) {
						nextTokenAddress += Token->Length;
						Token = (TokenOverlayStruct *)nextTokenAddress;
					}
					goto NextToken;
				}
				break;
			}

			case T_OBJTEMPLATES_END: {
				Session->ObjectListCount++;

				if (Session->ObjectListCount <= TemplateCount) {

					while (Token->TokenID != T_OBJTEMPLATES_BEGIN && (unsigned char *)Token != localObject->Object) {
						nextTokenAddress -= Token->PrevSize;
						Token = (TokenOverlayStruct *)nextTokenAddress;
					}
					goto NextToken;
				}
				Session->ObjectListCount = 0;
				MDBFreeValues(Session->V);

				break;
			}

			case T_OBJTEMPLATES_VALUE: {
				switch (Token->ArgumentOffsetOrID[0]) {
					case AA_NAME: {
						WASendClient(Client, Templates[Session->ObjectListCount]->Name, strlen(Templates[Session->ObjectListCount]->Name));
						break;
					}

					case AA_DESCRIPTION: {
						unsigned char		*Name;

						if (Templates[Session->ObjectListCount]->DescriptionString != 0xffffffff) {
							unsigned char		**Strings;

							/* We need to get access to the strings for that template */
							Strings = (unsigned char **)((unsigned char *)Templates[Session->ObjectListCount] + 
							sizeof(TemplateStruct) + 
							sizeof(unsigned long)*Templates[Session->ObjectListCount]->LanguageCount+ 
							(
								sizeof(unsigned char *) *
								(
									Templates[Session->ObjectListCount]->StringCount+
									Templates[Session->ObjectListCount]->ImageCount
								)*
								Session->Language
							));


							/* DescriptionString is a 0 based index, with -1 indicating No Description */
							Name = Strings[Templates[Session->ObjectListCount]->DescriptionString];
						} else {
							Name = Templates[Session->ObjectListCount]->Name;
						}

						WASendClient(Client, Name, strlen(Name));
						break;
					}

					case AA_CHECKED: {
						unsigned long			i = 0;
						BOOL						Found = FALSE;

						if (Session->V->Used == 0 && Token->ArgumentOffsetOrID[1] == AA_DEFAULT) {
							if (WAQuickCmp("Default", Templates[Session->ObjectListCount]->Name)) {
								Found = TRUE;
							}
						} else {
							while (!Found && i < Session->V->Used) {
								if (WAQuickCmp(Session->V->Value[i], Templates[Session->ObjectListCount]->Name)) {
									Found = TRUE;
								} else {
									i++;
								}
							}
						}

						if (Found) {
							WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
						} else {
							WASendClient(Client, Token->Data+Token->ArgumentOffsetOrID[3], Token->ArgumentSize[3]);
						}

						break;
					}
				}
				break;
			}
#endif

			case T_FLAG_SET: {
				BOOL			Flag;

				if (Token->ArgumentOffsetOrID[0] < 16) {
					if (Token->ArgumentOffsetOrID[1] == AA_TRUE) {
						Flag = TRUE;
					} else {
						Flag = FALSE;
					}

					/* URL arg0 = flag to set, arg1 = value, arg2 = Page */
					WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_FLAG, Token->ArgumentOffsetOrID[0], Flag, Token->ArgumentOffsetOrID[2], FALSE);
					WASendClient(Client, URL, strlen(URL));
				}
				break;
			}

			case T_FLAG_TOGGLE: {
				BOOL			Flag;

				if (Token->ArgumentOffsetOrID[0] < 16) {
					if (Session->Flags & (1 << Token->ArgumentOffsetOrID[0])) {
						Flag = FALSE;
					} else {
						Flag = TRUE;
					}

					/* URL arg0 = flag to set, arg1 = value, arg2 = Page */
					WAEncodeURL(Session, URL, URL_TYPE_LINK, REQUEST_FLAG, Token->ArgumentOffsetOrID[0], Flag, Token->ArgumentOffsetOrID[1], FALSE);
					WASendClient(Client, URL, strlen(URL));
				}
				break;
			}

			case T_FLAG_READ: {
				if (Token->ArgumentOffsetOrID[0] < 16) {
					if (Session->Flags & (1 << Token->ArgumentOffsetOrID[0])) {
						WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[1], Token->ArgumentSize[1]);
					} else {
						WASendClient(Client, Token->Data + Token->ArgumentOffsetOrID[2], Token->ArgumentSize[2]);
					}
				}
				break;
			}

			case T_ADVANCED_FEATURES_BEGIN: {
#if 0
				/*
					The restrictions on features, by license, has been suppressed at this point.
				*/

				int LicensedFlags;
				char *ptr;

				/* Based on licenced feature either ignore or move to end token */				
				if ((MDBRead(Session->CurrentObject, MSGSRV_A_CONFIGURATION, Session->V)) && 
				    (Session->V->Used == 1) && 
					 (ptr = strchr(Session->V->Value[0], '=')) && 
					 ((LicensedFlags = atoi(ptr + 1)) != -1 ) &&  
					 (LicensedFlags & LICENSE_FLAGS_UNLIMITED))	 {

					break;
				} else {
					/* This feature is not licenced */
					/* Move to the end token */
					unsigned long	GotoToken;

					GotoToken = T_ADVANCED_FEATURES_END;

					while (Token->TokenID != GotoToken && Token->TokenID != 0) {
						nextTokenAddress += Token->Length;
						Token = (TokenOverlayStruct *)nextTokenAddress;
					}

					goto NextToken;

				}
#endif

				break;
			}

			case T_ADVANCED_FEATURES_END: {
				break;
			}

			case T_WEAKSSL_BEGIN: {
#if 0
				/*
					The restrictions on features, by license, has been suppressed at this point.
				*/

				int LicensedFlags;
				char *ptr;

				/* Based on licenced feature either ignore or move to end token */				
				if ((MDBRead(Session->CurrentObject, MSGSRV_A_CONFIGURATION, Session->V)) && 
				    (Session->V->Used == 1) && 
					 (ptr = strchr(Session->V->Value[0], '=')) && 
					 ((LicensedFlags = atoi(ptr + 1)) != -1 ) &&  
					 (LicensedFlags & LICENSE_FLAGS_WEAK_SSL))	 {
					break;
				} else {
					/* This feature is not licenced */
					/* Move to the end token */
					unsigned long	GotoToken;

					GotoToken = T_WEAKSSL_END;

					while (Token->TokenID != GotoToken && Token->TokenID != 0) {
						nextTokenAddress += Token->Length;
						Token = (TokenOverlayStruct *)nextTokenAddress;
					}

					goto NextToken;
				}
#endif

				break;
			}

			case T_WEAKSSL_END: {
				break;
			}

			default: {
				unsigned long	i;
				unsigned long	GotoToken;

				for (i=0; i<TModuleCount; i++) {
					if (TModules[i].TokenRangeStart<=Token->TokenID && Token->TokenID<=TModules[i].TokenRangeEnd) {
						ReplyInt=TModules[i].HandleTemplate(Client, Session, TemplateID, Token, &GotoToken, Session->ModuleData[i]);

						if (ReplyInt==TOKEN_DONE) {
							nextTokenAddress+=Token->Length;
							Token=(TokenOverlayStruct *)nextTokenAddress;
							goto NextToken;
						} else if (ReplyInt==TOKEN_MOVE_FORWARD) {
							while (Token->TokenID!=GotoToken && Token->TokenID!=0) {
								nextTokenAddress+=Token->Length;
								Token=(TokenOverlayStruct *)nextTokenAddress;
							}
							goto NextToken;
						} else if (ReplyInt==TOKEN_MOVE_BACKWARD) {
							while (Token->TokenID!=GotoToken && (unsigned char *)Token != localObject->Object) {
								nextTokenAddress-=Token->PrevSize;
								Token=(TokenOverlayStruct *)nextTokenAddress;
							}
							goto NextToken;
						}
					}
				}

				break;
			}
		}
		nextTokenAddress+=Token->Length;
		Token=(TokenOverlayStruct *)nextTokenAddress;
	}

	if (Session->CachedValues && Session->CachedValues->Used) {
		MDBFreeValues(Session->CachedValues);
	}
	return(TRUE);
}

BOOL
HandleURL(ConnectionStruct *Client, SessionStruct *Session, URLStruct *URL)
{
	if (Session && URL->Template != Session->TemplateID) {
		//FreeClassList(Session);
		WASetSessionTemplate(URL->Template, Session->Language, Session);
	}

	switch(URL->Request) {
		case DISPLAY_TEMPLATE: {
			WAURLExtraDecode(Client, Client->Temp, sizeof(Client->Temp));
			if (Client->Temp[0]) {
				Client->ContentType = strdup(Client->Temp);
			}

			WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);
			return(TRUE);
		}

		case SWITCH_TEMPLATE: {
			WASetSessionTemplate(URL->Argument[0], Session->Language, Session);

			if (URL->Argument[1]) {
				WAHandleTemplate(Client, Session, URL->Argument[1], TRUE);
			} else {
				WAHandleTemplate(Client, Session, Templates[Client->Session->TemplateID]->InitialTemplate, TRUE);
			}

			if (URL->Argument[2]) {
				Session->InitialTemplate = URL->Argument[0];
			}
			return(TRUE);
		}

		case DISPLAY_IMAGE: {
			HandleImage(Client, URL->Argument[0], URL->Argument[1], URL->Argument[2]);
			return(TRUE);
		}

		case DISPLAY_STATIC_PAGE: {
			if (URL->Argument[1]>=Templates[URL->Argument[0]]->CommonStaticObjectCount) {
				Client->KeepAlive=FALSE;
				return(FALSE);
			}
			TemplateHandleStaticObject(Client, Session->StaticPages[URL->Argument[1]]);
			return(TRUE);
		}

		case DISPLAY_LOGO: {
			HandleLogo(Client, URL->Argument[0]);
			return(TRUE);
		}

		case REQUEST_LOGOUT: {
			WADebug("Have logout request\n");
			Client->KeepAlive=FALSE;
			if (!UseFormLogoutRedirectURL) {
				WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);
			} else {
				WARedirectClient(Client, FormLogoutRedirectURL);
			}
			WADestroySession(Session);
			Client->Session=NULL;
			return(TRUE);
		}

		case REQUEST_LOGOUT_REDIR: {
			WADebug("Have logout redirect request\n");
			WARedirectClient(Client, Session->Strings[URL->Argument[0]]);
			WADestroySession(Session);
			Client->Session=NULL;
			return(TRUE);
		}

		case REQUEST_RELOGIN: {
			WADebug("Have relogin request\n");
			return(TRUE);
		}

		case REQUEST_OBJECT: {
			ObjectListStruct	*Expand;
			BOOL					Browse = FALSE;

			if (URL->Argument[1]) {
				Browse = TRUE;
			}

			WAURLExtraDecode(Client, Session->CurrentObject, sizeof(Session->CurrentObject));

			MDBGetObjectDetails(Session->CurrentObject, Session->CurrentClass, NULL, Session->CurrentObject, Session->V);

			/* URL->Argument[2] will be true if we are just displaying the object, and false if we are selecting it */
			if (URL->Argument[2]) {
				/* URL->Argument[3] will be true if we are forcing it to use the page given */

				if (URL->Argument[3]) {
					WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);
				} else {
					WAHandleTemplate(Client, Session, FindClassTemplate(Session, Session->CurrentClass, URL->Argument[0]), TRUE);
				}
			} else {
				Expand = AddObjectListEntry(Session, Browse, Session->CurrentObject);
				if (Expand) {
					Expand->Expanded = !(Expand->Expanded);
				}

				WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);
			}
			return(TRUE);
		}

		case REQUEST_SELECT_OBJECT: {
			unsigned long		Allocated = 0;
			unsigned long		ValueSize;
			unsigned char		*Data = NULL;
			unsigned char		*ptr;

			/* If there isn't any valid data in the form then we just unselect the object we have */
			Session->CurrentObject[0] = '\0';

			/* Select an object from a form */
			Allocated = BUFSIZE;
			Data = malloc(Allocated * sizeof(unsigned char));
			Data[0] = '\0';

			while (WAGetFormNameEx(Client, Client->Temp, NULL, NULL, BUFSIZE)) {
				ptr = Data;
				ValueSize = Allocated - (ptr - Data);
				while (WAGetFormValue(Client, ptr, &ValueSize) != FORMFIELD_NEXT) {
					ptr += ValueSize;

					/* Abuse ValueSize to keep track of the difference between ptr and Data in case Data gets moved with realloc */
					ValueSize = ptr - Data;

					if ((ValueSize + 512) > Allocated) {
						Data = realloc(Data, (Allocated + BUFSIZE) * sizeof(unsigned char));
						Allocated += BUFSIZE;
						ptr = Data + ValueSize;
					}
					ValueSize = Allocated - (ptr - Data);
				}

				/* Client->Temp has the name */
				if (WAQuickCmp(Client->Temp, "Name")) {
					WAX500toMDB(Data, Session->CurrentObject, Session->V);

					if (!MDBGetObjectDetails(Session->CurrentObject, Session->CurrentClass, NULL, NULL, Session->V)) {
						/* Report an Error - Couldn't select object */
						Session->CurrentObject[0] = '\0';
						Session->LastError = WAERR_COULD_NOT_SELECT;
					}
				}
			}

			if (Data) {
				free(Data);
			}

			WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);
			return(TRUE);
		}

		case REQUEST_DELETE: {
			unsigned long		i;
			WADeleteFunc		DeleteFunc = NULL;
			void					*DeleteData = NULL;

			/* Right now we simply delete the thing, no questions asked */
			WAURLExtraDecode(Client, Session->CurrentObject, sizeof(Session->CurrentObject));
			MDBGetObjectDetails(Session->CurrentObject, Session->CurrentClass, NULL, NULL, Session->V);

			for (i = 0; i < DModuleCount; i++) {
				if (WAQuickCmp(Session->CurrentClass, DModules[i].ObjectClass) && DModules[i].DeleteFunction) {
					DeleteFunc = DModules[i].DeleteFunction;
					DeleteData = Session->ModuleData[TModuleCount + OModuleCount + SModuleCount + i];

					Session->LastError = DeleteFunc(Session, Session->CurrentClass, Session->CurrentObject, DeleteData);
				}
			}

			if (Session->LastError == 0) {
				Session->LastError = WAERR_SHOW_SUCCESS;
			}

			if (Session->LastError == WAERR_SHOW_SUCCESS) {
				if (WAQuickCmp(Session->CurrentClass, "Top")) {
					Session->LastError=WAERR_CONTAINER_NOT_EMPTY;
				} else if (!MDBDeleteObject(Session->CurrentObject, TRUE, Session->V)) {
					if (Session->V->ErrNo == ERR_CLASS_ALREADY_EXISTS) {
						Session->LastError = WAERR_OBJECT_EXISTS;
					} else {
						Session->LastError = WAERR_OBJECT_NOT_DELETED;
					}
				} else {
					unsigned char	*ptr;

					ptr=strrchr(Session->CurrentObject, '\\');
					if (ptr) {
						ptr[0]='\0';
					}
					MDBGetObjectDetails(Session->CurrentObject, Session->CurrentClass, NULL, NULL, Session->V);
				}
			}

			WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);
			return(TRUE);
		}

		case REQUEST_CREATE_PAGE: {
			unsigned long		ClassID = URL->Argument[1];

			if ((URL->Argument[1] >= 0) && (URL->Argument[1] <= Session->ClassListCount)) {
			    HulaStrNCpy(Session->CurrentCreateClass, Session->ClassList[ClassID].Class, sizeof(Session->CurrentCreateClass));
			}

			WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);
			return(TRUE);
		}

		case REQUEST_CREATE_OBJECT: {
		    long		Allocated = 0;
			unsigned long		ValueSize;
			unsigned long		i;
			unsigned char		*Data;
			unsigned char		*ptr;
			MDBValueStruct		*CustomName;
			MDBValueStruct		*CustomValue;
			BOOL					Tried = FALSE;
			BOOL					Try = FALSE;
			unsigned char		*ObjectClass = NULL;
			unsigned char		*ObjectName = NULL;

			MDBFreeValues(Session->LastFormNames);
			MDBFreeValues(Session->LastFormValues);

			MDBFreeValues(Session->ErrorNames);
			MDBFreeValues(Session->ErrorStrings);
			Session->LastError = WAERR_SHOW_SUCCESS;

			CustomName = MDBShareContext(Session->V);
			CustomValue = MDBShareContext(Session->V);

			WAURLExtraDecode(Client, Session->CurrentObject, sizeof(Session->CurrentObject));

			Allocated = BUFSIZE;
			Data = malloc(Allocated * sizeof(unsigned char));

			while (WAGetFormNameEx(Client, Client->Temp, NULL, NULL, BUFSIZE)) {
				ptr = Data;
				ValueSize = Allocated - (ptr - Data);
				while (WAGetFormValue(Client, ptr, &ValueSize) != FORMFIELD_NEXT) {
					ptr += ValueSize;

					/* Abuse ValueSize to keep track of the difference between ptr and Data in case Data gets moved with realloc */
					ValueSize = ptr - Data;

					if ((ptr - Data + 512) > Allocated) {
						Data = realloc(Data, (Allocated + BUFSIZE) * sizeof(unsigned char));
						Allocated += BUFSIZE;
						ptr = Data + ValueSize;
					}
					ValueSize = Allocated - (ptr - Data);
				}

				/* Keep around in case we have an error */
				MDBAddValue(Client->Temp, Session->LastFormNames);
				if (*Data) {
					MDBAddValue(Data, Session->LastFormValues);
				} else {
					MDBAddValue("\001", Session->LastFormValues);
				}
			}

			for (i = 0; i < Session->LastFormNames->Used; i++) {
				switch (toupper(Session->LastFormNames->Value[i][0])) {
					case 'O': {													/* Custom */
						Try = TRUE;	/* Only pass it on to a snapin if there is at least one custom value */

						/* Custom handling.  Pass on to snapin. */
						if (Session->LastFormValues->Value[i][0] != '\001') {
							MDBAddValue(Session->LastFormNames->Value[i] + 1, CustomName);
							MDBAddValue(Session->LastFormValues->Value[i], CustomValue);
						}

						break;
					}

					case 'C': {													/* Class */
						if (WAQuickCmp(Session->LastFormNames->Value[i], "Class")) {
							ObjectClass = Session->LastFormValues->Value[i];
						}
						break;
					}

					case 'N': {													/* Name */
						if (WAQuickCmp(Session->LastFormNames->Value[i], "Name")) {
							ObjectName = Session->LastFormValues->Value[i];
						}
						break;
					}
				}
			}

			if (Data) {
				free(Data);
			}

			snprintf(Session->ObjectBuffer, sizeof(Session->ObjectBuffer), "%s\\%s", Session->CurrentObject, ObjectName);
			if (MDBIsObject(Session->ObjectBuffer, Session->V)) {
				Session->LastError = WAERR_OBJECT_EXISTS;
				MDBFreeValues(Session->V);
			} else {
				/* Call object creation function */

				if (ObjectName && ObjectClass && Try) {
					for (i=0; i<OModuleCount; i++) {
						if (WAQuickCmp(ObjectClass, OModules[i].ObjectClass)) {
							if (OModules[i].Flags & WAOBJ_PRIMARY_HANDLER) {
								Session->LastError = OModules[i].CreateFunction(Session, ObjectClass, ObjectName, Session->CurrentObject, CustomName, CustomValue, Session->ModuleData[TModuleCount+i]);
								Tried = TRUE;
							}
						}
					}
				}

				if (!Tried) {
					/* It seems that there are no snapins registered for this class.  Lets assume that all the required attributes are here, and try to create the object */

					/* ProcessCreateForm will set the new name */
					ProcessCreateForm(Session, ObjectName, ObjectClass);
				} else if (Session->LastError == WAERR_SHOW_SUCCESS || Session->LastError == WAERR_SUCCESS) {
					/* The object was created, so lets set everything else we have */

					strcat(Session->CurrentObject, "\\");
					strcat(Session->CurrentObject, ObjectName);

					ProcessModifyForm(Session);
				}
			}

			if (Session->LastError != WAERR_SHOW_SUCCESS && Session->LastError != WAERR_SUCCESS) {
				WAHandleTemplate(Client, Session, URL->Argument[1], TRUE);
			} else {
				MDBFreeValues(Session->LastFormNames);
				MDBFreeValues(Session->LastFormValues);

				MDBFreeValues(Session->ErrorNames);
				MDBFreeValues(Session->ErrorStrings);

				WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);
			}

			return(TRUE);
		}

		case REQUEST_MODIFY_OBJECT: {
			long		Allocated = 0;
			unsigned long		ValueSize;
			unsigned long		i;
			unsigned char		*Data;
			unsigned char		*ptr;
			WASaveFunc			ModifyFunc = NULL;
			void					*ModifyData = NULL;

			MDBFreeValues(Session->LastFormNames);
			MDBFreeValues(Session->LastFormValues);

			MDBFreeValues(Session->ErrorNames);
			MDBFreeValues(Session->ErrorStrings);
			Session->LastError = WAERR_SHOW_SUCCESS;

			WAURLExtraDecode(Client, Session->CurrentObject, sizeof(Session->CurrentObject));

			Allocated = BUFSIZE;
			Data = malloc(Allocated * sizeof(unsigned char));

			while (WAGetFormNameEx(Client, Client->Temp, NULL, NULL, BUFSIZE)) {
				*Data = '\0';
				ptr = Data;
				ValueSize = Allocated - (ptr - Data);
				while (WAGetFormValue(Client, ptr, &ValueSize) != FORMFIELD_NEXT) {
					ptr += ValueSize;

					/* Abuse ValueSize to keep track of the difference between ptr and Data in case Data gets moved with realloc */
					ValueSize = ptr - Data;

					if ((ptr - Data + 512) > Allocated) {
						Data = realloc(Data, (Allocated + BUFSIZE) * sizeof(unsigned char));
						Allocated += BUFSIZE;
						ptr = Data + ValueSize;
					}
					ValueSize = Allocated - (ptr - Data);
				}

				/* Keep around in case we have an error */
				MDBAddValue(Client->Temp, Session->LastFormNames);
				if (*Data) {
					MDBAddValue(Data, Session->LastFormValues);
				} else {
					MDBAddValue("\001", Session->LastFormValues);
				}
			}

			if (Data) {
				free(Data);
			}

			ProcessModifyForm(Session);

			if (Session->LastError == WAERR_SHOW_SUCCESS || Session->LastError == WAERR_SUCCESS) {
				if (MDBGetObjectDetails(Session->CurrentObject, Session->CurrentClass, NULL, Session->CurrentObject, Session->V)) {
					for (i = 0; i < SModuleCount; i++) {
						unsigned long		c;

						if (WAQuickCmp(Session->CurrentClass, SModules[i].ObjectClass) && SModules[i].SaveFunction) {
							ModifyFunc = SModules[i].SaveFunction;
							ModifyData = Session->ModuleData[TModuleCount + OModuleCount + i];

							for (c = 0; c < Session->LastFormNames->Used; c++) {
								if (toupper(Session->LastFormNames->Value[c][0]) == 'O') {
									Session->LastError = ModifyFunc(Session, Session->CurrentClass, Session->CurrentObject, Session->LastFormNames->Value[c] + 1, Session->LastFormValues->Value[c], ModifyData);
								}
							}
							/* Call the function one more time without values to let the snapin known it has seen all values */
							Session->LastError = ModifyFunc(Session, Session->CurrentClass, Session->CurrentObject, NULL, NULL, ModifyData);
						}
					}

					if (Session->LastError == 0) {
						Session->LastError = WAERR_SHOW_SUCCESS;
					}

					if (Session->LastError != WAERR_SHOW_SUCCESS && Session->LastError != WAERR_SUCCESS) {
						WAHandleTemplate(Client, Session, URL->Argument[1], TRUE);
					} else {
						MDBFreeValues(Session->LastFormNames);
						MDBFreeValues(Session->LastFormValues);

						MDBFreeValues(Session->ErrorNames);
						MDBFreeValues(Session->ErrorStrings);

						WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);
					}
				} else {
					unsigned char	*ptr;

					/* If the object doesn't exist then it must have been deleted by ProcessModifyForm so lets find its parent */
					ptr = strrchr(Session->CurrentObject, '\\');
					if (ptr) {
						ptr[0] = '\0';
					}
					MDBGetObjectDetails(Session->CurrentObject, Session->CurrentClass, NULL, NULL, Session->V);


					if (Session->LastError != WAERR_SHOW_SUCCESS && Session->LastError != WAERR_SUCCESS) {
						WAHandleTemplate(Client, Session, URL->Argument[1], TRUE);
					} else {
						MDBFreeValues(Session->LastFormNames);
						MDBFreeValues(Session->LastFormValues);

						MDBFreeValues(Session->ErrorNames);
						MDBFreeValues(Session->ErrorStrings);
						WAHandleTemplate(Client, Session, FindClassTemplate(Session, Session->CurrentClass, URL->Argument[0]), TRUE);
					}
				}
			} else {
				WAHandleTemplate(Client, Session, URL->Argument[1], TRUE);
			}

			return(TRUE);
		}

		case REQUEST_CLEAR_FILTER: {
			if (URL->Argument[1]) {
				Session->BrowseFilterName[0] = '\0';
				Session->BrowseFilterClass[0] = '\0';
			} else {
				Session->CurrentFilterName[0] = '\0';
				Session->CurrentFilterClass[0] = '\0';
			}

			WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);

			return(TRUE);
		}

		case REQUEST_DEFINE_FILTER: {
			unsigned char			*Data;
			unsigned char			*ptr;
			long			Allocated=0;
			unsigned long			ValueSize;
			BOOL						Browse = URL->Argument[1];

			Allocated=BUFSIZE;
			Data=malloc(Allocated*sizeof(unsigned char));
			ptr=Data;

			while (WAGetFormNameEx(Client, Client->Temp, NULL, NULL, BUFSIZE)) {
				ptr=Data;
				ValueSize = Allocated-(ptr-Data);

				while (WAGetFormValue(Client, ptr, &ValueSize) != FORMFIELD_NEXT) {
					ptr+=ValueSize;

					/* Abuse ValueSize to keep track of the difference between ptr and Data in case Data gets moved with realloc */
					ValueSize = ptr - Data;

					if ((ptr - Data + 512) > Allocated) {
						Allocated += BUFSIZE;
						Data = realloc(Data, Allocated*sizeof(unsigned char));
						ptr = Data + ValueSize;
					}
					ValueSize = Allocated - (ptr-Data);
				}

				/*
					Right now we have both the form name (in Client->Temp) and the form
					data (in Data) so lets do sumfin.
				*/

				if ((ptr - Data) > MDB_MAX_OBJECT_CHARS) {
					/* Value is too big, so we aren't going to do anything with it */

					WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);
					return(TRUE);
				}

				switch (toupper(Client->Temp[0])) {
					case 'N':	{	/* Name */
						if (Browse) {
							HulaStrNCpy(Session->BrowseFilterName, Data, sizeof(Session->BrowseFilterName));
						} else {
							HulaStrNCpy(Session->CurrentFilterName, Data, sizeof(Session->CurrentFilterName));
						}
						break;
					}
					case 'C':	{	/* Class */
						if (toupper(Client->Temp[1]) == 'L') {
							if (Browse) {
							    HulaStrNCpy(Session->BrowseFilterClass, Data, sizeof(Session->BrowseFilterClass));
							} else {
							    HulaStrNCpy(Session->CurrentFilterClass, Data, sizeof(Session->CurrentFilterClass));
							}
						} else {
							if (Browse) {
								if (WAQuickCmp(Data, "On") || WAQuickCmp(Data, "Yes") || WAQuickCmp(Data, "True") || WAQuickCmp(Data, "1")) {
									Session->BrowseContainers = TRUE;
								} else {
									Session->BrowseContainers = FALSE;
								}
							} else {
								if (WAQuickCmp(Data, "On") || WAQuickCmp(Data, "Yes") || WAQuickCmp(Data, "True") || WAQuickCmp(Data, "1")) {
									Session->FilterContainers = TRUE;
								} else {
									Session->FilterContainers = FALSE;
								}
							}
						}
						break;
					}
				}
				if (Data) {
					Data[0] = '\0';
				}
				if (!Session->CurrentFilterName[0]) {
					strcpy(Session->CurrentFilterName, "*");
				}
				if (!Session->CurrentFilterClass[0]) {
					strcpy(Session->CurrentFilterClass, "*");
				}

				if (!Session->BrowseFilterName[0]) {
					strcpy(Session->BrowseFilterName, "*");
				}
				if (!Session->BrowseFilterClass[0]) {
					strcpy(Session->BrowseFilterClass, "*");
				}

			}

			if (Data) {
				free(Data);
			}
			WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);

			return(TRUE);
		}

		case REQUEST_BROWSE: {
			unsigned long		CurrentTemplate = Session->TemplateID;

			WAURLExtraDecode(Client, Session->BrowseLocation, sizeof(Session->BrowseLocation));

			WASetSessionTemplate(URL->Argument[2], Session->Language, Session);

			if (URL->Argument[1]) {
			    HulaStrNCpy(Session->BrowseFilterClass, Session->Strings[URL->Argument[1]], sizeof(Session->BrowseFilterClass));
			} else {
				Session->BrowseFilterClass[0] = '\0';
			}
			Session->BrowseFilterName[0] = '\0';

			WASetSessionTemplate(CurrentTemplate, Session->Language, Session);

			WAHandleTemplate(Client, Session, URL->Argument[0], TRUE);
			return(TRUE);
		}

		case REQUEST_FLAG: {
			/* URL arg0 = flag to set, arg1 = value, arg2 = Page */

			if (URL->Argument[1]) {
				Session->Flags |= (1 << URL->Argument[0]);
			} else {
				Session->Flags &= ~(1 << URL->Argument[0]);
			}
			WAHandleTemplate(Client, Session, URL->Argument[2], TRUE);
		}

		default: {
			unsigned long	i;

			Client->KeepAlive=FALSE;
			for (i=0; i<TModuleCount; i++) {
				if (TModules[i].TokenRangeStart<=URL->Request && URL->Request<=TModules[i].TokenRangeEnd) {
					if (TModules[i].HandleURL(Client, Session, URL, Session->ModuleData[i])) {
						break;
					}
				}
			}
			break;
		}
	}

	return(TRUE);
}
