/****************************************************************************
 *
 * Copyright (c) 1997-2004 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef _HULA_NMAP_LIBRARY_H
#define _HULA_NMAP_LIBRARY_H

#include <mdb.h>

#include <connio.h>

/*
    NMAP Library Return Codes

    fixme - need to describe return code value definitions ...
*/

/*
*/
#define NMAP_REGISTRATION_CLIENT_STACK_SIZE (128 * 1024)

/*
*/
typedef enum _RegistrationStates {
    REGISTRATION_LOADING, 
    REGISTRATION_ALLOCATING, 
    REGISTRATION_CONNECTING, 
    REGISTRATION_REGISTERING, 
    REGISTRATION_COMPLETED, 
    REGISTRATION_ABORT, 
    REGISTRATION_FAILED, 

    REGISTRATION_MAX_STATES
} RegistrationStates;

/*
*/
#define NMAPAlloc(b) ConnAlloc((b))
#define NMAPFree(c) ConnFree((c))

#define NMAPClose(c, f) ConnClose((c), (f))

#define NMAPRead(c, b, l) ConnRead((c), (b), (l))
#define NMAPReadToFile(c, f, l) ConnReadToFile((c), (f), (l))
#define NMAPReadToConn(s, d, l) ConnReadToConn((c), (d), (l))

#define NMAPWrite(c, b, l) ConnWrite((c), (b), (l))
#define NMAPWriteFromFile(c, f, l) ConnWriteFromFile((c), (f), (l))

#define NMAPSend(c, b, l) ConnSend((c), (b), (l))
#define NMAPReceive(c, b, l) ConnReceive((c), (b), (l))

/*
*/
BOOL NMAPInitialize(MDBHandle directoryHandle);

int NMAPSendCommand(Connection *conn, const unsigned char *command, size_t length);
int NMAPSendCommandF(Connection *conn, const char *format, ...);

int NMAPReadAnswer(Connection *conn, unsigned char *response, size_t length, BOOL checkForResult);
int NMAPReadAnswerLine(Connection *conn, unsigned char *response, size_t length, BOOL checkForResult);

Connection *NMAPConnect(unsigned char *address, struct sockaddr_in *addr);

BOOL NMAPAuthenticate(Connection *conn, unsigned char *response, int length);

void NMAPQuit(Connection *conn);

RegistrationStates NMAPRegister(unsigned char *dn, unsigned long queue, unsigned short port);

#endif  /* _HULA_NMAP_LIBRARY_H */
