/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef _SAVEFORM_
#define _SAVEFORM_

#define	NUM_OF_TIMEZONES		75

/* OLD Charsets */

typedef struct {
	unsigned char		*Charset;
} OldCharsetStruct;

#define	NUM_OF_OLD_CHARSETS	35

typedef struct {
	unsigned char	*Title;
	BOOL				IMAP;
	BOOL				KeepMail;
    BOOL SSL;
	BOOL				GotPassword1;
	BOOL				GotPassword2;
	char				*Host;
	char				*User;
	char				*Password;
	char				*UID;
} ProxyListStruct;

/* Rule stuff */
#define	RULE_NONE							-1
#define	RULE_ACTION_NONE					-1

/*
#define	RULE_ACTIVE							'A'
#define	RULE_DEACTIVE						'B'
*/

/* String offsets */
#define	IFFROM								0
#define	IFTO									1
#define	IFCC									2
#define	IFSUBJECT							3
#define	IFBODY								4
#define	ALL									5
#define	THENMOVE								6
#define	THENCC								7
#define	THENDELETE							8
#define	THENFORWARD							9
#define	THENREPLY							10
#define	STOP									11

typedef struct {
	BOOL					Active;
	unsigned char		Type;
	unsigned char		Action;
	unsigned char		*ConditionData;
	unsigned char		*ActionData;
	unsigned long		ActionFolderIndex;
	unsigned long		ID;
	BOOL					Stop;
} RuleRecord;


#define	MAX_PROXY_ENTRIES					3


#define	PREFS_HS_SHIFT				0			/* Shift-left values for the MSGSRV_A_PREFERENCES */
#define	PREFS_BBAR_SHIFT			2			/* attribute on a user */
#define	PREFS_PURGE_SHIFT			4
#define	PREFS_EXCOMPOSE_SHIFT	5
#define	PREFS_HS_MASK				0x03		/* Bitmasks for the MSGSRV_A_PREFERENCES attribute */
#define	PREFS_BBAR_MASK			0x0C
#define	PREFS_PURGE_MASK			0x10
#define	PREFS_EXCOMPOSE_MASK		0x20

/* Names */
#define	PURGE									" name=\"Purge\" "
#define	FORWARDON							" name=\"ForwardEnabled\" "
#define	FORWARDKEEP							" name=\"ForwardKeepCopy\" "
#define	SIGON									" name=\"SignatureEnabled\" "
#define	AUTOREPLYON							" name=\"AutoReplyEnabled\" "

#define	ALLOW_IMAP							" name=\"Imap\" "
#define	ALLOW_POP							" name=\"Pop\" "
#define	ALLOW_ADDRESSBOOK					" name=\"AddressBook\" "
#define	ALLOW_PROXY							" name=\"Proxy\" "
#define	ALLOW_FORWARD						" name=\"Forward\" "
#define	ALLOW_AUTOREPLY					" name=\"AutoReply\" "
#define	ALLOW_RULES							" name=\"Rules\" "
#define	ALLOW_MODWEB						" name=\"Modweb\" "
#define	ALLOW_ANTIVIRUS					" name=\"AntiVirus\" "
#define	USER_DISABLED						" name=\"UserDiabled\" "



#define	RULECREATE_FROM					"<option value=\"from\">"
#define	RULECREATE_TO						"<option value=\"to\">"
#define	RULECREATE_CC						"<option value=\"cc\">"
#define	RULECREATE_SUBJECT				"<option value=\"subject\">"
#define	RULECREATE_BODY					"<option value=\"body\">"
#define	RULECREATE_ALL						"<option value=\"all\">"

/* String Offsets */
#define	RULE_FROM							0
#define	RULE_TO								1
#define	RULE_CC								2
#define	RULE_SUBJECT						3
#define	RULE_BODY							4
#define	RULE_ALL								5

/*
ProxyHost
ProxyUsername
ProxyPassword1
ProxyPassword2
ProxyType
ProxyLeave
*/

/* Rules helper macros */

/* Increment the rule pointer by x, and check for errors */
#define	RuleInc(x)	{											\
	if (Rule + (x) <= RuleEnd) {								\
		Rule += (x);												\
	} else {															\
		MWSendClient(Client, "Broken Rule", 11);			\
		return(FALSE);												\
	}																	\
}

/* Check to make sure the rule has x more chars */
#define	RuleCheck(x) {											\
	if (Rule + (x) > (RuleEnd + 1)) {						\
		MWSendClient(Client, "Broken Rule", 11);			\
		return(FALSE);												\
	}																	\
}

/* Send a rule argument */
#define	RuleSendArgument(Send) {													\
	unsigned long		Length;															\
																								\
	RuleCheck(4);																			\
	Length = ((Rule[0] - '0') * 100)													\
		+ ((Rule[1] - '0') * 10)														\
		+ (Rule[2] - '0');																\
	Rule += 3;																				\
																								\
	if (Length > 0) {																		\
		unsigned long		i;																\
		BOOL					Matched = FALSE;											\
																								\
		RuleCheck(Length);																\
		if (Rule[Length] != 'Z') {														\
			MWSendClient(Client, "Broken argument", 15);							\
			return(FALSE);																	\
		}																						\
																								\
		for (i = 0; i < Session->FolderList->Used; i++) {						\
			unsigned char		*Folder = Session->FolderList->Value[i];		\
																								\
			if (*Folder == 'M' && MWQuickCmp(Rule, Folder + 3)) {				\
				Matched = TRUE;															\
				if (Send) {																	\
					Folder = Session->FolderDisplayNames->Value[i];				\
																								\
					MWSendClient(Client, Folder, strlen(Folder));				\
				}																				\
			}																					\
		}																						\
																								\
		if (!Matched && Send) {															\
			MWSendClient(Client, Rule, Length);										\
		}																						\
		Rule += Length;																	\
																								\
		if (Send) {																			\
			MWSendClient(Client, " ", 1);												\
		}																						\
	}																							\
	Rule ++; /* The Z */																	\
}

/* HTML Strings */
#define	CHECKED								" CHECKED "
#define	OPTION								"<OPTION>"
#define	OPTION_SELECTED					"<OPTION SELECTED>"
#define	RADIO									"<INPUT TYPE=\"RADIO\" %s%s VALUE=\"ON\">%s<INPUT TYPE=\"RADIO\" %s%s VALUE=\"OFF\">%s"
#define	OPTION_FULL							"<OPTION %svalue=\"%d\">"

/* Preference constants */
#define	PRIVACY_NONE						0
#define	PRIVACY_LIMITED					1
#define	PRIVACY_UNLISTED					2

/* Status/Errors */

#define	CREATED_USER				1
#define	PASSWORDS_DONT_MATCH		2
#define	NO_USERNAME					3
#define	NO_FULLNAME					4
#define	NO_DOMAIN					5
#define	USER_EXISTS					6
#define	SAVED_SETTINGS				7
#define	IMPORT_SUCCESS				8
#define	IMPORT_FAILED				9
#define	ILLEGAL_USER_NAME			10
#define	WRONG_PASSWORD				11
#define	TOO_MANY_USERS				12
#define	GARBAGE_DATA				13
#define	NETWORK_ERROR				14
#define	INVALID_HOST				15
#define	CONNECTION_FAILED			16
#define	INVALID_USER				17

/* saveform.c */
unsigned long	ProcessSaveForm(ConnectionStruct *Client, SessionStruct *Session, MDBValueStruct *V, BOOL SetSession);
BOOL				SendRuleString(ConnectionStruct *Client, unsigned char *CurrentRule, SessionStruct *Session);
BOOL				CheckRuleString(ConnectionStruct *Client, unsigned char *CurrentRule, SessionStruct *Session);
RuleRecord		ParseRule(char *Value);
BOOL				ProcessRuleListForm(ConnectionStruct *Client, unsigned char *User);
BOOL				ParseProxyList(MDBValueStruct *V, ProxyListStruct *ProxyList);

#endif
