/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <streamio.h>
#include <msgdate.h>
#include <mwtempl.h>
/** Request definitions (submitted via URL) **/

/* Basic request types, handled by the engine */
#define	DISPLAY_TEMPLATE			1
#define	REDIRECT_CLIENT			2
#define	REQUEST_LOGOUT				3
#define	DISPLAY_IMAGE				4
#define	REQUEST_LOGOUT_REDIR		5
#define	REQUEST_LOGIN				7
#define	REQUEST_PROXY_SWITCH		9
#define	REQUEST_SELECT_FOLDER	10

/* Semi-internal - index for colors kept in session structure */
#define	COLOR_PAGE_FG				0
#define	COLOR_PAGE_BG				1
#define	COLOR_BORDER_FG			2
#define	COLOR_BORDER_BG			3
#define	COLOR_SECTION_FG			4
#define	COLOR_SECTION_BG			5
#define	COLOR_FIELDNAME_FG		6
#define	COLOR_FIELDNAME_BG		7
#define	COLOR_FIELDBODY_FG		8
#define	COLOR_FIELDBODY_BG		9

#define	MODULE_TEMPLATE			1
#define	MODULE_MIME					2
#define	MODULE_SEND					3

#define	URL_TYPE_LINK				'w'
#define	URL_TYPE_IMAGE				'p'
#define	URL_TYPE_REDIRECT			'r'
#define	URL_TYPE_PUBLIC			'a'
#define URL_TYPE_STATIC         'j'

#define	TOKEN_UNKNOWN				0
#define	TOKEN_DONE					1
#define	TOKEN_MOVE_FORWARD		2
#define	TOKEN_MOVE_BACKWARD		3

/* Returned by MWGetFormValue */
#define	FORMFIELD_NEXT				0
#define	FORMFIELD_DONE				1
#define	FORMFIELD_PARTIAL			2
#define	FORMFIELD_ERROR			-1

/* Returned by MWGetQuotedString */
#define	QP_STRING					1
#define	HAS_EXTENDED_CHARS		0
#define	BUFFER_TOO_SHORT			-1

/* Legal Values for ANESend and ANERecv */
#define	ANE_RESTRICT_TO_7BIT		1
#define	ANE_RFC2231					2
#define	ANE_ALLOW_8BIT				4
#define	ANE_RFC2047					8

enum MWClientFlags {
    MWCLIENT_FLAG_WINDOWS = (1 << 0)
};

#ifndef MODWEB_BUILD_INTERNAL

#define  BUFSIZE						1023  
#define  MTU							(1480*3)

/*
	This structure contains all information relevant to a session
	including user preferences, the template to use and mailbox state.
	This structure may seem "biased" towards email; but the module
	design actually allows any kind of data stored in the session
	structure, should there be a need to use the framework for other
	purposes.

	The published structures do not contain all information that is 
	available internally; for data integrity purposes ModWeb uses
	a slighly larger structure internally.
*/

typedef struct _UserValue {
    struct _UserValue *next;
    struct _UserValue *prev;
    unsigned long id;
    unsigned char *value;
} UserValue;

typedef struct _SessionStruct {
	/* User data, public */
	unsigned char	*User;
	unsigned char	*UserDN;
	unsigned long	Language;
	unsigned char	Colors[10][7];
	unsigned char	*Charset;
	unsigned char	*EMailAddress;
	unsigned char	*DisplayName;
	unsigned char	*OfficialDomain;

	BOOL				ReadOnly;

	unsigned long	MailBoxIcon;
	unsigned long	MailBoxSharedIcon;
	unsigned long	MailBoxSharingIcon;
	unsigned long	CalendarIcon;
	unsigned long	CalendarSharedIcon;
	unsigned long	CalendarSharingIcon;
	unsigned long	HierarchicalElementIcon;

	/* User preferences; time & date */
	long				TimezoneOffset;
	unsigned long	TimezoneID;
	unsigned long	StartWeekday;
	unsigned char	*DateFormatShort;
	unsigned char	*DateFormatLong;
	unsigned char	*TimeFormat;
	MsgDateFormat	DateFormat;

	/* Mailstore address */
	struct in_addr	NMAPAddress;

	/* Folder Structure */
	MDBValueStruct	*FolderList;
	MDBValueStruct	*FolderDisplayNames;
	unsigned long	*FolderUnreadCount;
	unsigned long	*FolderTotalCount;

	unsigned long	CurrentFolder;
	unsigned long	CurrentCalendar;
	unsigned long	CurrentDisplayFolder;
	BOOL				ShowUnsubscribedFolders;
	unsigned char	*SentFolder;

	/* Allow modules to reset mailbox and calendar cache */
	BOOL				FolderListIsDirty;
	BOOL				DirtyMessage;
	unsigned long	DirtyMessageFolder;
	unsigned long	DirtyMessageID;

	/* Message data */
	unsigned long	*IDList;
	unsigned long	*UIDList;
	unsigned long	NumOfMessages;
	unsigned long	MessagesPerPage;
	BOOL				NMAPChanged;

	/* Calendar data */
	signed long		CurrentDay;
	signed long		CurrentMonth;
	signed long		CurrentYear;
	unsigned long	CurrentRataDie;

	/* Calendar entries */
	unsigned long	NumOfEvents;
	unsigned long	CurrentEvent;

	/* Template data */
	long				TemplateID;
	unsigned char	**Strings;
	unsigned char	**Images;
	TemplateObjectOverlay **Pages;
	TemplateObjectOverlay **StaticObjects;

	/* NMAP Connection */
	int				NMAPs;					/* NMAP Socket					*/
	int				NBufferPtr;				/* Current NMAP pointer		*/
	unsigned char	NBuffer[BUFSIZE+1];	/* NMAP Input buffer			*/

	/* Time Stamps */
	unsigned long	ConnectionTimeout;
	time_t			Timestamp;
	time_t			NMAPTimestamp;

	/* A unique session identifier */
	unsigned long	SessionID;
    UserValue *UserValues;
} SessionStruct;

typedef struct _ConnectionStruct {
    unsigned long Flags;
	int						s;							/* Socket						*/
	SessionStruct			*Session;				/* Current session			*/
	unsigned char			Temp[BUFSIZE+1];		/* Temp work buffer			*/
	struct sockaddr_in	cs;						/* Client info					*/
	BOOL						KeepAlive;				/* Keep connection?			*/
	unsigned char			Command[BUFSIZE+1];	/* Current command			*/
	unsigned char			*URLExtra;				/* Addtl. URL info			*/
	BOOL						NMAPProtected;			/* NMAP Transaction active	*/
	unsigned char			ClientSSL;				/* Doing SSL?					*/
	unsigned long			DeviceType;				/* Current Device Type		*/
    unsigned char *URLHost;
} ConnectionStruct;

typedef struct _URLStruct {
	unsigned long	Request;
	unsigned long	Argument[6];
} URLStruct;

#endif /* !MODWEB_BUILD_INTERNAL */

#ifdef __cplusplus
extern "C" {
#endif

/** Little helpers **/
extern BOOL					*MWExiting;

#if defined(MODWEB_DEBUG_BUILD)
extern int					MWModuleScreen;
#define	ModDebug			SetCurrentScreen(MWModuleScreen); printf("[%d] ", __LINE__); printf
#else																																																   
#define	ModDebug			if (0) printf
#endif


/*** Module function descriptions ***/

/** All modules **/
/* Module initialization */
typedef	void	(*MWModuleShutdownFunc)(void);
typedef	BOOL	(*MWModuleInitFunc)(void *MWAPIIn);

/** Template modules **/
/* These functions are called everytime a new session is created and destroyed */
typedef	BOOL	(*MWSessionInitFunc)(struct _SessionStruct *Session, void **ModuleData);
typedef	BOOL	(*MWSessionDestroyFunc)(struct _SessionStruct *Session, void *ModuleData);

/* Template processing; here's where it's happening */
typedef	BOOL	(*MWHandleURLFunc)(struct _ConnectionStruct *Client, struct _SessionStruct *Session, struct _URLStruct *URL, void *ModuleData);
typedef struct _TokenOverlayStruct _TokenOverlayStruct;
typedef	BOOL	(*MWHandleTemplateFunc)(struct _ConnectionStruct *Client, struct _SessionStruct *Session, unsigned long Page, struct _TokenOverlayStruct *Token, unsigned long *GotoToken, void *ModuleData);

/** MIME modules **/
typedef	int	(*MWHandleStreamFunc)(struct _ConnectionStruct *Client, struct _SessionStruct *Session);

/** Send modules **/
//typedef int		(*MWHandleStreamFunc)(struct _ConnectionStruct *Client, struct _SessionStruct *Session);


/** Here's the fun part: The structure that a module must fill out when registering with MW during init */
typedef struct {
	MWSessionInitFunc			InitSession;
	MWSessionDestroyFunc		DestroySession;
	MWHandleURLFunc			HandleURL;
	MWHandleTemplateFunc		HandleTemplate;
	unsigned long				TokenRangeStart;
	unsigned long				TokenRangeEnd;
} TemplateModuleStruct;

typedef struct {
	unsigned char				*Name;
	MWHandleStreamFunc		Decoder;
	MWHandleStreamFunc		Encoder;
	BOOL							IsCharset;
} StreamModuleStruct;

typedef struct {
	unsigned char				*Name;
	MWHandleStreamFunc		Decoder;
	MWHandleStreamFunc		Encoder;
	BOOL							IsCharset;
} ComposeModuleStruct;

typedef struct {
	unsigned long				ModuleType;
	union {
		TemplateModuleStruct	Template;
		StreamModuleStruct	Stream;
		ComposeModuleStruct	Send;
	} Module;
} ModuleRegisterStruct;

typedef struct namedurlid {
	unsigned int NamedID;
	unsigned int URLID;
}NAMED_URL_ID;

#define NM_MAX_NAMED_URLIDS 2

enum NamedURLS {
	NM_REFRESH_CALENDAR = 1,
};



/* 
	The exported functions; of general interest 

	This is split into two sections; on NetWare, we can just define the prototypes, on Windows,
	Solaris, Linux (and probably the other Unix platforms with shared libraries we actually
	need to export the pointers to the parents functions...
*/


/* modweb.c - main & basic functions; public */

#if defined(NETWARE) || defined(LIBC)
#define	APIFUNC(Command)		Command
#define	MWAPISetup
#define	MWAPIDefine				void *Ignored
#define	MWAPISet
#define	MWAPIArg					void *Ignored

#endif /* NETWARE || LIBC	*/

#if defined(LINUX) || defined(SOLARIS) || defined(WIN32) || defined(S390RH)
#define	APIFUNC(Command)	(* Command)
typedef struct _MWAPIStruct {
#endif /* LINUX || SOLARIS || WIN32 || S390RH */

int					APIFUNC(MWDirectClientRead)(struct _ConnectionStruct *Client, unsigned char *Buf, int Len);
int					APIFUNC(MWDirectClientWrite)(struct _ConnectionStruct *Client, unsigned char *Buf, int Len);
int					APIFUNC(MWDirectNMAPRead)(struct _SessionStruct *Session, unsigned char *Buf, int Len);
int					APIFUNC(MWDirectNMAPWrite)(struct _SessionStruct *Session, unsigned char *Buf, int Len);
BOOL					APIFUNC(MWFlushClient)(struct _ConnectionStruct *Client);
BOOL					APIFUNC(MWSendClient)(struct _ConnectionStruct *Client, unsigned char *Data, int Len);
BOOL					APIFUNC(MWHTMLSendClient)(struct _ConnectionStruct *Client, unsigned char *Data, int Len);
BOOL					APIFUNC(MWSendNMAPServer)(struct _SessionStruct *Session, unsigned char *Data, int Len);
int					APIFUNC(MWGetNMAPAnswer)(struct _SessionStruct *Session, unsigned char *Reply, int ReplyLen, BOOL CheckForResult);
BOOL					APIFUNC(MWReadClientLine)(struct _ConnectionStruct *Client);
BOOL					APIFUNC(MWProtectNMAP)(struct _ConnectionStruct *Client, BOOL Protect);

/* modwebs.c - session management; public */
BOOL					APIFUNC(MWConnectUserToNMAPServer)(struct _SessionStruct *Session);
BOOL					APIFUNC(MWDestroySession)(struct _SessionStruct *Session);

/* modwebu.c - utilities; public */
BOOL					APIFUNC(MWQuickCmp)(unsigned char *str1, unsigned char *str2);
BOOL					APIFUNC(MWQuickNCmp)(unsigned char *str1, unsigned char *str2, int len);
long					APIFUNC(MWGetQuotedString)(unsigned char *Src, unsigned char *Dest, unsigned long DestLen);
#define				MWGetFormName(Client, Name, NameSize)		MWGetFormNameEx((Client), (Name), NULL, NULL, (NameSize))
BOOL					APIFUNC(MWGetFormNameEx)(struct _ConnectionStruct *Client, unsigned char *Name, unsigned char *Type, unsigned char *Filename, unsigned long NameSize);
unsigned long		APIFUNC(MWGetFormValue)(struct _ConnectionStruct *Client, unsigned char *Value, unsigned long *ValueSize);
BOOL					APIFUNC(MWEncodeURL)(struct _SessionStruct *Session, unsigned char *URL, unsigned char Type, unsigned long Request, unsigned long Arg1, unsigned long Arg2, unsigned long Arg3, unsigned long Arg4);
BOOL					APIFUNC(MWEncodeURLEx)(struct _SessionStruct *Session, unsigned char *URL, unsigned char Type, unsigned long Request, unsigned long Arg1, unsigned long Arg2, unsigned long Arg3, unsigned long Arg4, BOOL ResumeOK);
BOOL					APIFUNC(MWRedirectClient)(struct _ConnectionStruct *Client, unsigned char *URL);
BOOL					APIFUNC(MWSendURLExtra)(struct _ConnectionStruct *Client, const unsigned char *Extra);
unsigned long		APIFUNC(MWURLExtraDecode)(struct _ConnectionStruct *Client, unsigned char *Target, unsigned long TargetSize);

/* modwebt.c - template & preference management */
long					APIFUNC(MWFindTemplate)(unsigned char *TemplateName);
long					APIFUNC(MWFindTemplatePage)(unsigned char *Name, unsigned long Template);
BOOL					APIFUNC(MWSetSessionTemplate)(unsigned long Template, unsigned long Language, struct _SessionStruct *Session);

/* modwebd.c - page display and processing; public */
BOOL					APIFUNC(MWSendHTTPHeader)(struct _ConnectionStruct *Client, unsigned char *Type, unsigned long Size, unsigned char *Filename, BOOL Cache);
BOOL					APIFUNC(MWHandleTemplate)(struct _ConnectionStruct *Client, struct _SessionStruct *Session, unsigned long TemplateID);
BOOL					APIFUNC(MWHandlePublicTemplate)(struct _ConnectionStruct *Client, struct _SessionStruct *Session, unsigned long TemplateID);

/* modwebm.c - module management; public */
BOOL					APIFUNC(MWRegisterModule)(ModuleRegisterStruct *Register);
BOOL					APIFUNC(MWRegisterNamedURLs)( NAMED_URL_ID *IDList, int IDCount);


/* modwebr.c - stream management; public */
int					APIFUNC(MWStreamFromMemory)(StreamStruct *Codec, StreamStruct *NextCodec);
int					APIFUNC(MWStreamFromChunkedMemory)(StreamStruct *Codec, StreamStruct *NextCodec);
int					APIFUNC(MWStreamToMemory)(StreamStruct *Codec, StreamStruct *NextCodec);
int					APIFUNC(MWStreamFromFile)(StreamStruct *Codec, StreamStruct *NextCodec);
int					APIFUNC(MWStreamToFile)(StreamStruct *Codec, StreamStruct *NextCodec);
int					APIFUNC(MWStreamFromMWNMAP)(StreamStruct *Codec, StreamStruct *NextCodec);
int					APIFUNC(MWStreamToMWClient)(StreamStruct *Codec, StreamStruct *NextCodec);
#define				MWSetStreamMemoryInput(Codec, MemIn, Len)	(Codec)->StreamData=MemIn; (Codec)->StreamLength=Len;
#define				MWSetStreamFileInput(Codec, Filehandle) (Codec)->StreamData=Filehandle;
#define				MWSetStreamFileInput(Codec, Filehandle) (Codec)->StreamData=Filehandle;
StreamStruct		*APIFUNC(MWGetStream)(StreamStruct *PrevCodec, unsigned char *Charset, BOOL Encoder);
BOOL					APIFUNC(MWReleaseStream)(StreamStruct *Stream);
BOOL					APIFUNC(MWReleaseStreamData)(void *Data);
StreamCodecFunc	APIFUNC(MWFindCodec)(unsigned char *Charset, BOOL Encoder);
BOOL					APIFUNC(MWAddStreamTemplateHandler)(unsigned char *Charset, TemplateHandlerFunc Handler);
BOOL					APIFUNC(MWResetStreamChain)(StreamStruct *Stream);
StreamDescStruct	*APIFUNC(MWGetStreamTable)(void);
BOOL					APIFUNC(MWHandleNamedURL)(struct _ConnectionStruct *Client, struct _SessionStruct *Session, struct _URLStruct *URL);
BOOL					APIFUNC(MWDisplayMIMEParam)(struct _ConnectionStruct *Client, unsigned char *Value, StreamStruct **MIMEParamStream);
void					APIFUNC(MWReleaseStreams)(StreamStruct *FirstStream);

BOOL                    APIFUNC(MWSendIcs)(struct _ConnectionStruct *Client, struct _SessionStruct *Session);

#if defined(LINUX) || defined(SOLARIS) || defined(WIN32) || defined(S390RH)
} MWAPIStruct;

#ifdef __cplusplus
}
#endif

#ifndef MODWEB_BUILD_INTERNAL

extern	MWAPIStruct				*MWAPI;
#define	MWAPIDefine				MWAPIStruct *MWAPI = NULL
#define	MWAPISet					MWAPI=(MWAPIStruct *)MWAPIIn
#define	MWAPIArg					void *MWAPIIn

#define	MWDirectClientRead	MWAPI->MWDirectClientRead
#define	MWDirectClientWrite	MWAPI->MWDirectClientWrite
#define	MWDirectNMAPRead		MWAPI->MWDirectNMAPRead
#define	MWDirectNMAPWrite		MWAPI->MWDirectNMAPWrite
#define	MWFlushClient			MWAPI->MWFlushClient
#define	MWSendClient			MWAPI->MWSendClient
#define	MWHTMLSendClient		MWAPI->MWHTMLSendClient
#define	MWSendNMAPServer		MWAPI->MWSendNMAPServer
#define	MWGetNMAPAnswer		MWAPI->MWGetNMAPAnswer
#define	MWReadClientLine		MWAPI->MWReadClientLine
#define	MWProtectNMAP			MWAPI->MWProtectNMAP

#define	MWConnectUserToNMAPServer	MWAPI->MWConnectUserToNMAPServer
#define	MWDestroySession		MWAPI->MWDestroySession

#define	MWQuickCmp				MWAPI->MWQuickCmp
#define	MWQuickNCmp				MWAPI->MWQuickNCmp
#define	MWGetQuotedString		MWAPI->MWGetQuotedString
#define	MWGetFormNameEx		MWAPI->MWGetFormNameEx
#define	MWGetFormValue			MWAPI->MWGetFormValue
#define	MWEncodeURL				MWAPI->MWEncodeURL
#define	MWEncodeURLEx			MWAPI->MWEncodeURLEx
#define	MWRedirectClient		MWAPI->MWRedirectClient
#define	MWSendURLExtra			MWAPI->MWSendURLExtra
#define	MWURLExtraDecode		MWAPI->MWURLExtraDecode

#define	MWFindTemplate			MWAPI->MWFindTemplate
#define	MWFindTemplatePage	MWAPI->MWFindTemplatePage
#define	MWSetSessionTemplate	MWAPI->MWSetSessionTemplate

#define	MWSendHTTPHeader		MWAPI->MWSendHTTPHeader
#define	MWHandleTemplate		MWAPI->MWHandleTemplate
#define	MWHandlePublicTemplate			MWAPI->MWHandlePublicTemplate
#define	MWRegisterModule		MWAPI->MWRegisterModule
#define  MWRegisterNamedURLs  MWAPI->MWRegisterNamedURLs
#define	MWStreamFromMemory	MWAPI->MWStreamFromMemory
#define	MWStreamFromChunkedMemory		MWAPI->MWStreamFromChunkedMemory
#define	MWStreamToMemory		MWAPI->MWStreamToMemory
#define	MWStreamFromFile		MWAPI->MWStreamFromFile
#define	MWStreamToFile			MWAPI->MWStreamToFile
#define	MWStreamFromMWNMAP	MWAPI->MWStreamFromMWNMAP
#define	MWStreamToMWClient	MWAPI->MWStreamToMWClient
#define	MWGetStream				MWAPI->MWGetStream
#define	MWReleaseStream		MWAPI->MWReleaseStream
#define	MWReleaseStreamData	MWAPI->MWReleaseStreamData
#define	MWFindCodec				MWAPI->MWFindCodec
#define	MWAddStreamTemplateHandler		MWAPI->MWAddStreamTemplateHandler
#define	MWResetStreamChain	MWAPI->MWResetStreamChain
#define	MWGetStreamTable		MWAPI->MWGetStreamTable
#define	MWHandleNamedURL		MWAPI->MWHandleNamedURL
#define	MWDisplayMIMEParam	MWAPI->MWDisplayMIMEParam
#define	MWReleaseStreams		MWAPI->MWReleaseStreams
#define MWSendIcs MWAPI->MWSendIcs

#else

int					MWDirectClientRead(struct _ConnectionStruct *Client, unsigned char *Buf, int Len);
int					MWDirectClientWrite(struct _ConnectionStruct *Client, unsigned char *Buf, int Len);
int					MWDirectNMAPRead(struct _SessionStruct *Session, unsigned char *Buf, int Len);
int					MWDirectNMAPWrite(struct _SessionStruct *Session, unsigned char *Buf, int Len);
BOOL					MWFlushClient(struct _ConnectionStruct *Client);
BOOL					MWSendClient(struct _ConnectionStruct *Client, unsigned char *Data, int Len);
BOOL					MWHTMLSendClient(struct _ConnectionStruct *Client, unsigned char *Data, int Len);
BOOL					MWSendNMAPServer(struct _SessionStruct *Session, unsigned char *Data, int Len);
int					MWGetNMAPAnswer(struct _SessionStruct *Session, unsigned char *Reply, int ReplyLen, BOOL CheckForResult);
BOOL					MWReadClientLine(struct _ConnectionStruct *Client);
BOOL					MWProtectNMAP(struct _ConnectionStruct *Client, BOOL Protect);

/* modwebs.c - session management; public */
BOOL					MWConnectUserToNMAPServer(struct _SessionStruct *Session);
BOOL					MWDestroySession(struct _SessionStruct *Session);

/* modwebu.c - utilities; public */
BOOL					MWQuickCmp(unsigned char *str1, unsigned char *str2);
BOOL					MWQuickNCmp(unsigned char *str1, unsigned char *str2, int len);
long					MWGetQuotedString(unsigned char *Src, unsigned char *Dest, unsigned long DestLen);
#define				MWGetFormName(Client, Name, NameSize)		MWGetFormNameEx((Client), (Name), NULL, NULL, (NameSize))
BOOL					MWGetFormNameEx(struct _ConnectionStruct *Client, unsigned char *Name, unsigned char *Type, unsigned char *Filename, unsigned long NameSize);
unsigned long		MWGetFormValue(struct _ConnectionStruct *Client, unsigned char *Value, unsigned long *ValueSize);
BOOL					MWEncodeURL(struct _SessionStruct *Session, unsigned char *URL, unsigned char Type, unsigned long Request, unsigned long Arg1, unsigned long Arg2, unsigned long Arg3, unsigned long Arg4);
BOOL					MWEncodeURLEx(struct _SessionStruct *Session, unsigned char *URL, unsigned char Type, unsigned long Request, unsigned long Arg1, unsigned long Arg2, unsigned long Arg3, unsigned long Arg4, BOOL ResumeOK);
BOOL					MWRedirectClient(struct _ConnectionStruct *Client, unsigned char *URL);
BOOL					MWSendURLExtra(struct _ConnectionStruct *Client, const unsigned char *Extra);
unsigned long		MWURLExtraDecode(struct _ConnectionStruct *Client, unsigned char *Target, unsigned long TargetSize);

/* modwebt.c - template & preference management */
long					MWFindTemplate(unsigned char *TemplateName);
long					MWFindTemplatePage(unsigned char *Name, unsigned long Template);
BOOL					MWSetSessionTemplate(unsigned long Template, unsigned long Language, struct _SessionStruct *Session);

/* modwebd.c - page display and processing; public */
BOOL					MWSendHTTPHeader(struct _ConnectionStruct *Client, unsigned char *Type, unsigned long Size, unsigned char *Filename, BOOL Cache);
BOOL					MWHandleTemplate(struct _ConnectionStruct *Client, struct _SessionStruct *Session, unsigned long TemplateID);
BOOL					MWHandlePublicTemplate(struct _ConnectionStruct *Client, struct _SessionStruct *Session, unsigned long TemplateID);

/* modwebm.c - module management; public */
BOOL					MWRegisterModule(ModuleRegisterStruct *Register);
BOOL              MWRegisterNamedURLs( NAMED_URL_ID *IDList, int IDCount);

/* modwebr.c - stream management; public */
int					MWStreamFromMemory(StreamStruct *Codec, StreamStruct *NextCodec);
int					MWStreamFromChunkedMemory(StreamStruct *Codec, StreamStruct *NextCodec);
int					MWStreamToMemory(StreamStruct *Codec, StreamStruct *NextCodec);
int					MWStreamFromFile(StreamStruct *Codec, StreamStruct *NextCodec);
int					MWStreamToFile(StreamStruct *Codec, StreamStruct *NextCodec);
int					MWStreamFromMWNMAP(StreamStruct *Codec, StreamStruct *NextCodec);
int					MWStreamToMWClient(StreamStruct *Codec, StreamStruct *NextCodec);
#define				MWSetStreamMemoryInput(Codec, MemIn, Len)	(Codec)->StreamData=MemIn; (Codec)->StreamLength=Len;
#define				MWSetStreamFileInput(Codec, Filehandle) (Codec)->StreamData=Filehandle;
#define				MWSetStreamFileInput(Codec, Filehandle) (Codec)->StreamData=Filehandle;
StreamStruct		*MWGetStream(StreamStruct *PrevCodec, unsigned char *Charset, BOOL Encoder);
BOOL					MWReleaseStream(StreamStruct *Stream);
BOOL					MWReleaseStreamData(void *Data);
StreamCodecFunc	MWFindCodec(unsigned char *Charset, BOOL Encoder);
BOOL					MWAddStreamTemplateHandler(unsigned char *Charset, TemplateHandlerFunc Handler);
BOOL					MWResetStreamChain(StreamStruct *Stream);
StreamDescStruct	*MWGetStreamTable(void);
BOOL					MWHandleNamedURL(struct _ConnectionStruct *Client, struct _SessionStruct *Session, struct _URLStruct *URL);
BOOL					MWDisplayMIMEParam(struct _ConnectionStruct *Client, unsigned char *Value, StreamStruct **MIMEParamStream);
void					MWReleaseStreams(StreamStruct *FirstStream);

BOOL                    MWSendIcs(struct _ConnectionStruct *Client, struct _SessionStruct *Session);

#define	MWAPISetup																\
	MWAPI.MWDirectClientRead=MWDirectClientRead;							\
	MWAPI.MWDirectClientWrite=MWDirectClientWrite;						\
	MWAPI.MWDirectNMAPRead=MWDirectNMAPRead;								\
	MWAPI.MWDirectNMAPWrite=MWDirectNMAPWrite;							\
	MWAPI.MWFlushClient=MWFlushClient;										\
	MWAPI.MWSendClient=MWSendClient;											\
	MWAPI.MWHTMLSendClient=MWHTMLSendClient;								\
	MWAPI.MWSendNMAPServer=MWSendNMAPServer;								\
	MWAPI.MWGetNMAPAnswer=MWGetNMAPAnswer;									\
	MWAPI.MWReadClientLine=MWReadClientLine;								\
	MWAPI.MWProtectNMAP=MWProtectNMAP;										\
																						\
	MWAPI.MWConnectUserToNMAPServer=MWConnectUserToNMAPServer;		\
	MWAPI.MWDestroySession=MWDestroySession;								\
																						\
	MWAPI.MWQuickCmp=MWQuickCmp;												\
	MWAPI.MWQuickNCmp=MWQuickNCmp;											\
	MWAPI.MWGetQuotedString=MWGetQuotedString;							\
	MWAPI.MWGetFormNameEx=MWGetFormNameEx;									\
	MWAPI.MWGetFormValue=MWGetFormValue;									\
	MWAPI.MWEncodeURL=MWEncodeURL;											\
	MWAPI.MWEncodeURLEx=MWEncodeURLEx;										\
	MWAPI.MWRedirectClient=MWRedirectClient;								\
	MWAPI.MWSendURLExtra=MWSendURLExtra;									\
	MWAPI.MWURLExtraDecode=MWURLExtraDecode;								\
																						\
	MWAPI.MWFindTemplate=MWFindTemplate;									\
	MWAPI.MWFindTemplatePage=MWFindTemplatePage;							\
	MWAPI.MWSetSessionTemplate=MWSetSessionTemplate;					\
																						\
	MWAPI.MWSendHTTPHeader=MWSendHTTPHeader;								\
	MWAPI.MWHandleTemplate=MWHandleTemplate;								\
	MWAPI.MWHandlePublicTemplate=MWHandlePublicTemplate;				\
																						\
	MWAPI.MWRegisterModule=MWRegisterModule;								\
	MWAPI.MWRegisterNamedURLs=MWRegisterNamedURLs;						\
																						\
	MWAPI.MWStreamFromMemory=MWStreamFromMemory;							\
	MWAPI.MWStreamFromChunkedMemory=MWStreamFromChunkedMemory;		\
	MWAPI.MWStreamToMemory=MWStreamToMemory;								\
	MWAPI.MWStreamFromFile=MWStreamFromFile;								\
	MWAPI.MWStreamToFile=MWStreamToFile;									\
	MWAPI.MWStreamFromMWNMAP=MWStreamFromMWNMAP;							\
	MWAPI.MWStreamToMWClient=MWStreamToMWClient;							\
	MWAPI.MWGetStream=MWGetStream;											\
	MWAPI.MWReleaseStream=MWReleaseStream;									\
	MWAPI.MWReleaseStreamData=MWReleaseStreamData;						\
	MWAPI.MWFindCodec=MWFindCodec;											\
	MWAPI.MWAddStreamTemplateHandler=MWAddStreamTemplateHandler;	\
	MWAPI.MWResetStreamChain=MWResetStreamChain;							\
	MWAPI.MWGetStreamTable=MWGetStreamTable;								\
	MWAPI.MWHandleNamedURL=MWHandleNamedURL;								\
	MWAPI.MWDisplayMIMEParam=MWDisplayMIMEParam;							\
	MWAPI.MWReleaseStreams=MWReleaseStreams; \
    MWAPI.MWSendIcs=MWSendIcs; \

#endif /* MODWEB_BUILD_INTERNAL */

#ifndef _UNICODE_TYPE_DEFINED
#define _UNICODE_TYPE_DEFINED
#define  unicode unsigned short    /* Unicode data must be 16 bits   */
#endif

#endif /* LINUX || SOLARIS || WIN32 || S390RH */
