---
lastmod: 2015-01-27
date: 2013-07-01
menu:
  main:
    parent: content
notoc: true
prev: /content/ordering
next: /content/markdown-extras
title: Summaries
weight: 65
---

With the use of the `.Summary` [page variable](/templates/variables/), Hugo can generate summaries of content to show snippets in summary views. The summary view snippets are automatically generated by Hugo. Where a piece of content is split for the content summary depends on whether the split is Hugo-defined or user-defined.

Content summaries may also provide links to the original content, usually in the form of a "Read More..." link, with the help of the `.RelPermalink` or `.Permalink` variable, as well as the `.Truncated` boolean variable to determine whether such "Read More..." link is necessary.

## Hugo-defined: automatic summary split

By default, Hugo automatically takes the first 70 words of your content as its summary and stores it into the `.Summary` variable, which you may use in your templates.

* Pros: Automatic, no additional work on your part.
* Cons: All HTML tags are stripped from the summary, and the first 70 words, whether they belong to a heading or to different paragraphs, are all lumped into one paragraph.  Some people like it, but some people don't.

## User-defined: manual summary split:

Alternatively, you may add the <code>&#60;&#33;&#45;&#45;more&#45;&#45;&#62;</code> summary divider[^1] where you want to split the article.  Content prior to the summary divider will be used as that content's summary, and stored into the `.Summary` variable with all HTML formatting intact.

[^1]: The **summary divider** is also called "more tag", "excerpt separator", etc. in other literature.

* Pros: Freedom, precision, and improved rendering.  All formatting is preserved.
* Cons: Need to remember to type <code>&#60;&#33;&#45;&#45;more&#45;&#45;&#62;</code> in your content file.  :-)

Be careful to enter <code>&#60;&#33;&#45;&#45;more&#45;&#45;&#62;</code> exactly, i.e. all lowercase with no whitespace, otherwise it would be treated as regular comment and ignored.


## Showing Summaries

You can show content summaries with the following code. You could do this, for example, on a [list](/templates/list/) page.

    {{ range first 10 .Data.Pages }}
      <div class="summary">
        <h4><a href="{{ .RelPermalink }}">{{ .Title }}</a></h4>
        {{ .Summary }}
      </div>
      {{ if .Truncated }}
      <div class="read-more-link">
        <a href="{{ .RelPermalink }}">Read More…</a>
      </div>
      {{ end }}
    {{ end }}

Note how the `.Truncated` boolean valuable may be used to hide the "Read More..." link when the content is not truncated, i.e. when the summary contains the entire article.
