---
title: Custom 404 Page
linktitle: 404 Page
description: If you know how to create a single page template, you have unlimited options for creating a custom 404.
date: 2017-02-01
publishdate: 2017-02-01
lastmod: 2017-03-31
categories: [templates]
keywords: [404, page not found]
menu:
  docs:
    parent: "templates"
    weight: 120
weight: 120	#rem
draft: false
aliases: []
toc: false
---

When using Hugo with [GitHub Pages](https://pages.github.com/), you can provide your own template for a [custom 404 error page](https://help.github.com/articles/custom-404-pages/) by creating a 404.html template file in your `/layouts` folder. When Hugo generates your site, the `404.html` file will be placed in the root.

404 pages will have all the regular [page variables][pagevars] available to use in the templates.

In addition to the standard page variables, the 404 page has access to all site content accessible from `.Pages`.

```
▾ layouts/
    404.html
```

## 404.html

This is a basic example of a 404.html template:

{{< code file="layouts/404.html" download="404.html" >}}
{{ define "main"}}
    <main id="main">
      <div>
       <h1 id="title"><a href="{{ "/" | relURL }}">Go Home</a></h1>
      </div>
    </main>
{{ end }}
{{< /code >}}

## Automatic Loading

Your 404.html file can be set to load automatically when a visitor enters a mistaken URL path, dependent upon the web serving environment you are using. For example:

* [GitHub Pages](/hosting-and-deployment/hosting-on-github/) and [GitLab Pages](/hosting-and-deployment/hosting-on-gitlab/). The 404 page is automatic.
* Apache. You can specify `ErrorDocument 404 /404.html` in an `.htaccess` file in the root of your site.
* Nginx. You might specify `error_page 404 /404.html;` in your `nginx.conf` file. [Details here](https://nginx.org/en/docs/http/ngx_http_core_module.html#error_page).
* Amazon AWS S3. When setting a bucket up for static web serving, you can specify the error file from within the S3 GUI.
* Amazon CloudFront. You can specify the page in the Error Pages section in the CloudFront Console. [Details here](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
* Caddy Server. Use the `handle_errors` directive to specify error pages for one or more status codes. [Details here](https://caddyserver.com/docs/caddyfile/directives/handle_errors)
* Netlify. Add `/* /404.html 404` to `content/_redirects`. [Details Here](https://www.netlify.com/docs/redirects/#custom-404)
* Azure Static website. You can specify the `Error document path` in the Static website configuration page of the Azure portal. [More details are available in the Static website documentation](https://docs.microsoft.com/en-us/azure/storage/blobs/storage-blob-static-website).
* DigitalOcean App Platform. You can specify `error_document` in your app specification file or use control panel to set up error document. [Details here](https://docs.digitalocean.com/products/app-platform/references/app-specification-reference/).

{{% note %}}
`hugo server` will not automatically load your custom `404.html` file, but you
can test the appearance of your custom "not found" page by navigating your
browser to `/404.html`.
{{% /note %}}

[pagevars]: /variables/page/
