# -*- coding: UTF8 -*-

# Python module hubackup.py
# Autogenerated from hubackup.glade
# Generated on Wed Apr 12 11:55:54 2006

# Warning: Do not modify any context comment such as #--
# They are required to keep user's code

import os
import sys

sys.path.append("../")

import gtk
import gnome

from SimpleGladeApp import SimpleGladeApp
from SimpleGladeApp import bindtextdomain


from gettext import gettext as _

from HUBackup.common import HUB
import gobject
from HUBackup.backend import fsInfo
from HUBackup.backend import BackupEngine
from HUBackup.backend import ISOBuilder
from HUBackup.backend import CDBurner
from HUBackup.backend import fsMisc
import time
import pango
from HUBackup.backend.DeviceInfo import *

DEBUG_PRINT = False

app_name = "hubackup"
app_version = "0.0.1"

glade_dir = ""
locale_dir = "/usr/share/locale"

bindtextdomain(app_name, locale_dir)


class MainBackup(SimpleGladeApp):

    def __init__(self, path="hubackup.glade",
                 root="main_backup",
                 domain=app_name, **kwargs):
        # display a note to the user about stuff that takes place behind the scenes so he won't
        # be irritated for having to wait
        self.please_wait_probing_devices()
        path = os.path.join(glade_dir, path)
        self.volProps = None
        self.volDevNode = None
        self.media_include_flag = True # include media files by default
        self.reference_is_also_target_flag = False
        self.lastIsoBurnt = None
        self.bkpEngine = None
        self.curBkp = None        
        self.myIsoBuilder = None
        self.myCdBurner = None
        self.curCdBurn = None
        self.curIsoBuild = None
        self.spawnedProcOBJ = None # required to hold spawned object, and then later get its pty fd.
        self.curPrecent = 0 # global precentage holder of spawned process that report it or can be calc'd it
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)

    #-- MainBackup.new {
    def new(self):
        self.isobuilder = None
        self.diffBackup = False
        self.aborted = False
        self.checkForDbus()
        self.checkForHal()
        self.userinfo = fsInfo.UserInfo()
        self.filechooserbutton1.set_current_folder(self.userinfo.homedir())
        self.updateDeviceLists()
        self.hide_please_wait_probing_devices()
        
    #-- MainBackup.new }

    #-- MainBackup custom methods {

    def checkForDbus(self):
        ver = getattr(dbus, 'version', (0, 0, 0))
        if ver < (0, 40, 0):
            dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL, 
                                       gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                       _("The DBus Python Bindings you are using are too old. "
                                       "Make sure you have the latest version!"))
            dialog.run()
            sys.exit(1)
            
    def checkForHal(self):
        try:
            checkHalIsRunning()
        except NoHaldError:
            dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                       _("Could not get device list. ""Make sure hald is running!"))
            dialog.run()
            sys.exit(1)


    def installDeviceChangeNotification(self):
        # to be implemented maybe in the next version or after I finish everything else
        pass
    
    def updateDeviceLists(self):
        # target device list
        self.populateDeviceList("treeview1", True, True, [_('Type'),_('Name'),_('Free'),_('Capacity')], 1, 1)
        self.prob_progress.set_fraction(0.5)
        self.prob_progress.set_text("50%")        
        while gtk.events_pending():
            gtk.main_iteration()
        self.prob_progress.set_fraction(1.0)
        self.prob_progress.set_text("100%")
        while gtk.events_pending():
            gtk.main_iteration()
        # source / reference media device list
        self.populateDeviceList("treeview2", False, True, [_('Type'),_('Name'),_('Free'),_('Capacity')], 1, 1)
    
    def populateDeviceList(self, treeWN, rwOnly, rmvOnly, wantedColumns, sort_col, search_col): # treeWM = Treeview Widget Name
        '''
        Takes a treeview widget and populates it with available devices on the system according to criteria.
        '''
        # first device run to mount whatever we can, to allow better detection of free space in pluggable drives.
        firstRoundDevList = HUBDeviceDict(rwOnly,rmvOnly)
        for d in firstRoundDevList:
            fsMisc.dumb_mount(d)
        # TODO: Attached this method to a HAL plug event to have it updated in "real time".
        setattr(self,"%s_backup_devices" % treeWN,HUBDeviceDict(rwOnly, rmvOnly))
        setattr(self,"%s_liststore" % treeWN, gtk.ListStore(str, str, str, str, str)) # stock-item (=type), name, free_space, capacity, (hidden) device_node
        tmpWRef = getattr(self, treeWN)
        for col in wantedColumns:
            setattr(self, "%s_tvcol_%s" % (treeWN, col) , gtk.TreeViewColumn(col))
            tmpColRef = getattr(self, "%s_tvcol_%s" % (treeWN, col))
            tmpWRef.append_column(tmpColRef)

        # Populate the liststore's model with available devices we can backup to.
        tmpDeviceList = getattr(self, "%s_backup_devices" % treeWN)
        tmpListRef = getattr(self, "%s_liststore" % treeWN)
        tmpWRef.set_model(tmpListRef)
        self.blankCount = 0
        for i in tmpDeviceList:
            thisDevice = tmpDeviceList[i]
            StockId = self.giveStockIcon(thisDevice['Type'])
            Name = thisDevice['Name']
            print "Name = %s" % Name
            print "StockId = %s" % StockId
            self.thisVolumes =  thisDevice['Volumes']
            if self.thisVolumes=={}:
                # has no voluesm, special case when this is a blank CD / multisess that's not mounted
                # we need to use cdrdao to probe how much minutes are left on it, and translate it
                # to available size in bytes.
                # If this is not a cdrom device, then let's assume this device has not been formatted
                # and thus is not usable as a target media until it becomes so, and not list it.
                #if treeWN=="treeview1":
                #    if thisDevice['Type']=="cdrom":
                #        print "i = %s" % i
                #        tmpListRef.append([StockId,Name,_("BLANK"),_("700M"),i])
                #
                # --- commenting out, since this currently displays empty devices in the target list
                continue
            self.volDevNode, self.volProps = self.thisVolumes.popitem()
            (theSize, sizeSpec)  = fsInfo.getSizeSpecifier(self.volProps['FreeSpaceBytes'])
            Free = str(theSize) + sizeSpec
            if self.volProps.has_key('Capacity'):
                (theSize, sizeSpec) = fsInfo.getSizeSpecifier(self.volProps['Capacity'])
                Capacity = str(theSize) + sizeSpec
            else:
                Capacity = _("N/A")
            if thisDevice['Type']=="cdrom" and self.volProps["Blank"]:
                Free = _("BLANK")
            if thisDevice['Type']=="disk" and self.volProps["VolumeIsMounted"]:
                pass
            else:
                Free = _("N/A")
            print "%s,  %s" %(self.volDevNode, self.thisVolumes)
            print "Free = %s" % Free
            print "Capacity = %s" % Capacity
            if treeWN=="treeview2":
                if thisDevice['Type'] == "cdrom":
                    if  not self.volProps['Blank']:
                        tmpListRef.append([StockId,Name,Free,Capacity,i])

                if thisDevice['Type'] == "disk":
                    tmpListRef.append([StockId,Name,Free,Capacity,i])
            else:
                # if self.volProps['Appendable'] or self.volProps['Blank']:
                if thisDevice['Type'] == "cdrom":
                    if self.volProps['Blank']:
                        tmpListRef.append([StockId,Name,Free,Capacity,i])
                if thisDevice['Type'] == "disk":
                    tmpListRef.append([StockId,Name,Free,Capacity,i])

        incrementor = 0
        for col in wantedColumns:
            tmpColRef = getattr(self, "%s_tvcol_%s" % (treeWN, col))
            if col!= _("Type"):
                setattr(self, "%s_cell_%s" % (treeWN, col), gtk.CellRendererText())
                tmpCellRef = getattr(self, "%s_cell_%s" % (treeWN, col))
                tmpColRef.pack_start(tmpCellRef, True)
                tmpColRef.add_attribute(tmpCellRef, "text", incrementor)
            else:
                setattr(self, "%s_cell_%s" % (treeWN,col), gtk.CellRendererPixbuf())
                tmpCellRef = getattr(self, "%s_cell_%s" % (treeWN, col))
                tmpColRef.pack_start(tmpCellRef, True)
                tmpColRef.add_attribute(tmpCellRef, "stock_id", incrementor)
            if incrementor==1:
                tmpColRef.set_sort_column_id(sort_col)
            incrementor += 1

        tmpWRef.set_search_column(search_col)

    def giveStockIcon(self, device_type):
        if device_type=="cdrom":
            return gtk.STOCK_CDROM
        if device_type=="disk":
            return gtk.STOCK_HARDDISK
        if device_type=="floppy":
            return gtk.STOCK_FLOPPY
        
    def stopBackup(self, widget, data=None):
        # TODO: add removal code for the pushGUIBackup and watch_Backup_pty_callback methods
        print "Abort backup requested. Stopping!"
#        widget.destroy()        
        self.progress_window.destroy()
        self.bkpEngine.abort()
        self.aborted = True
        self.main_backup.show()

    def please_wait_probing_devices(self):
        self.wait_dialog = None
        self.prob_progress = None
        xml = gtk.glade.XML("/usr/share/hubackup/progress-dialog.glade",domain=app_name)
        self.wait_dialog = xml.get_widget("wait_dialog")
        self.wait_dialog.show()
        self.prob_progress = xml.get_widget("prob_progress")
        self.prob_progress.set_fraction(0.25)
        self.prob_progress.set_text("25%")
        while gtk.events_pending():
            gtk.main_iteration()

    def hide_please_wait_probing_devices(self):
        self.wait_dialog.destroy()

    def GUIBackupPrepare(self):
        if DEBUG_PRINT: print "Enterting GUIBackupPrepare method."

        # set up the backup stages func list exlucindg the startup stage (GUIBackupPrepare)
        # GUIBurnPrepare is not here since burning is done after each ISO creation , kick started by
        # GUIIsolatePrepare.

        # If we are creating a backup against a pluggable drive, we can skip iso building and burning.
        attr = "backup_target_device_type"
        target_type = getattr(self,attr)
        if target_type == "gtk-cdrom":
            self.stages = ['GUIIsolatePrepare','GUIIsoPrepare','GUIVerifyPrepare','GUIFinish']
        elif target_type == "gtk-harddisk":
            self.stages = ['GUIIsolatePrepare', 'GUIVerifyPrepare','GUIFinish']
        else:
            print "* No support for this backup target device is available yet!"
            sys.exit(1)
        print "* Stages: %s" % self.stages
            
        self.stages.reverse() # so we'll get the first item we inserted when popping
        self.aborted = False
        
        # load the progess dialog glade xml
        xml = gtk.glade.XML("/usr/share/hubackup/progress-dialog.glade",domain=app_name)

        # get a reference to the GtkWidgets we've created in the glade file
        self.progress_window = xml.get_widget("progress_dialog")
        self.button_abort = xml.get_widget("button_abort")
        self.progressbar_backup = xml.get_widget("operation_progressbar")
        self.progressbar_isloate = xml.get_widget("operation_progressbar")
        self.progressbar_burn_cd = xml.get_widget("operation_progressbar")
        self.action_label = xml.get_widget("label_action")

        # get the current reporting output widgets
        self.pbar = self.progressbar_backup
        self.reportLabel = xml.get_widget("report_label")
        self.cdBurnProcessLabel = self.action_label

        # hide main program window.
        self.main_backup.hide()

        # more setup of the needed widgets
        self.progress_window.set_modal(True)
        self.progress_window.set_resizable(False)
        self.progress_window.connect("destroy", self.stopBackup)
        self.button_abort.connect("clicked", self.stopBackup)

        # settings up the label for the detailed line outputs
        self.reportLabel.set_markup(_("<b> Starting backup operation....Please wait. </b>"))
        self.reportLabel.set_width_chars(60)
        self.reportLabel.set_max_width_chars(60)
        self.reportLabel.set_ellipsize(pango.ELLIPSIZE_END)

        # finally show the progress window
        self.progress_window.show()

        if self.backup_reference_device:
            myRefPath = None
            print "Creating a differential backup."
            try:
                myRefPath = fsMisc.mount(self.backup_reference_device)
            except fsMisc.fsMiscMountError:
                self.popupMountErrorMessage()
                self.goBack()
                return
            print "*** myRefPath = %s ****" % myRefPath
            if target_type == "gtk-cdrom":
                self.bkpEngine = BackupEngine.Backup(self.backup_slice_size,
                                                     sourcePath=self.filechooserbutton1.get_filename(),
                                                     referencePath=myRefPath+"/",
                                                     mediaInclude=self.media_include_flag)
            elif target_type == "gtk-harddisk":
                try:
                    self.backup_target_device_mount_point = fsMisc.mount(self.backup_target_device) + "/"
                except fsMisc.fsMiscMountError:
                    self.popupMountErrorMessage()
                    self.goBack()
                    return
                self.bkpEngine = BackupEngine.Backup(self.backup_slice_size,
                                                     sourcePath=self.filechooserbutton1.get_filename(),
                                                     referencePath=myRefPath+"/",
                                                     target=self.backup_target_device_mount_point,
                                                     mediaInclude=self.media_include_flag)
        else:
            print "Creating a master backup."
            # not giving any target for storing the backup files as we want them to be on hd
            # we will need to give it when it is a USB disk for instance, that's been mounted by us
            # remember BackupEngine deals only withe creating backup data, not with the actual burning.
            ## setting hard coded slice size for testing for now.
            if target_type == "gtk-cdrom":
                self.bkpEngine = BackupEngine.Backup(self.backup_slice_size,
                                                     sourcePath=self.filechooserbutton1.get_filename(),
                                                     mediaInclude=self.media_include_flag)
            elif target_type == "gtk-harddisk":
                try:
                    self.backup_target_device_mount_point = fsMisc.mount(self.backup_target_device) + "/"
                except fsMisc.fsMiscMountError:
                    self.popupMountErrorMessage()
                    self.goBack()
                    return
                self.bkpEngine = BackupEngine.Backup(self.backup_slice_size,
                                                     sourcePath=self.filechooserbutton1.get_filename(),
                                                     target=self.backup_target_device_mount_point,
                                                     mediaInclude=self.media_include_flag)
        self.running = True
        try:
            self.spawnedProcOBJ = self.bkpEngine.pre_build_kick()
        except BackupEngine.NoCatalogError:
            self.popupCatalogNeeded()
            self.goBack()
            return
        self.curBkp = self.bkpEngine.build()
        self.cur_line = _("Archiving...</b>")

    def GUIIsolatePrepare(self):
        # Disabling catalog creation when doing a differential backup
        # Limiting the differential backup size to only once CD makes this un-neccessary
        self.pbar = self.progressbar_isloate
        if self.diffBackup:
            self.reportLabel.set_markup(_("<b> Differential backup, skipping...</b>"))
            self.nextPhase(self.stages)
            return
        self.running = True
        self.spawnedProcOBJ = self.bkpEngine.pre_isolate_kick()
        self.curBkp = self.bkpEngine.isolate()
        self.cur_line = _("<b> Extracting Catalogue...</b>")
        self.pushBkpTagID =  gobject.timeout_add(100,self.pushGUIBackup)
        gobject.io_add_watch(self.spawnedProcOBJ.fileno(), gobject.IO_IN, self.watch_Backup_pty_callback)
 
    def GUIIsoPrepare(self): # prepares file lists and kicks the first iso build
        catalogSliceList = None
        archiveSliceList = None
        if self.diffBackup:
            self.catalogSliceList = self.bkpEngine.getExistantDiffCatalogSlices()
            self.archiveSliceList = self.bkpEngine.getExistantDiffArchiveSlices()
        else:
            self.catalogSliceList = self.bkpEngine.getExistantCatalogSlices() # catalog of a master archive
            self.archiveSliceList = self.bkpEngine.getExistantArchiveSlices()
        if DEBUG_PRINT:
            print "* detected archive files = %s" % archiveSliceList
            print "* detected catalog files = %s" % catalogSliceList

        self.iso_build_file_list = self.archiveSliceList + self.catalogSliceList

        tmpList = []
        for f in self.iso_build_file_list:
            tmpList.append(f)
            tmpList.append(f + ".iso")
    
        self.iso_build_file_list = tmpList
        self.iso_build_file_list.reverse()
        
        curFile = self.iso_build_file_list.pop()
        self.GUIBuildIso(curFile)


    def GUIBuildIso(self, fileName):
        self.pbar = self.progressbar_burn_cd
        vol_lable = None
        media_device = None
        if self.diffBackup:
            media_device = self.backup_reference_device
            cdTypeQualifier = "CHANGES-CD"
        else:
            media_device = self.backup_target_device
            cdTypeQualifier = "MASTER-CD"
            
        if DEBUG_PRINT:
            print "* Building an iso file for: %s" % fileName

        myhome = self.userinfo.homedir()

        self.cdBurnProcessLabel.set_markup(_("<b> Creating ISO image for CD #%s</b>") %
                                           self.bkpEngine.getSliceNum(fileName))
        
        vol_lable = cdTypeQualifier + self.bkpEngine.getSliceNum(fileName) + "_"  + time.strftime("%d-%b-%Y_%H:%M")

        if self.diffBackup and self.reference_is_also_target_flag:
            try:
                fsMisc.eject(self.backup_target_device)
            except fsMisc.fsMiscEjectError:
                self.popupMountErrorMessage(_("Could not eject media. Choose OK to go back and then retry."))
                return
            pre_iso_build_message = _("Please take out the CD in drive , and insert your CHANGES backup CD instead."
                                      "If this is the first time you are creating a differential backup snapshot,"
                                      "insert a blank CD onto which the archive will be burnt")
            
            dialog = gtk.MessageDialog(self.main_backup, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                                       gtk.MESSAGE_QUESTION,
                                       gtk.BUTTONS_OK_CANCEL,
                                       pre_iso_build_message)
            dialog.show()
            res = dialog.run()
            dialog.destroy()
            if res==gtk.RESPONSE_CANCEL:
                print "Build aborted."
                return
            else:
                print "* Starting ISO build process."
        
        try:
            self.myIsoBuilder =  ISOBuilder.ISOBuilder(myhome + HUB.TEMP_DIR + fileName,
                                                       myhome + HUB.TEMP_DIR + fileName + ".iso" ,
                                                       self.diffBackup,
                                                       media_device,
                                                       vol_lable)
        except ISOBuilder.NotMultiSessoinCD:
            print "* Creating new multi session differential backup storage CD."
            self.myIsoBuilder =  ISOBuilder.ISOBuilder(myhome + HUB.TEMP_DIR + fileName,
                                                       myhome + HUB.TEMP_DIR + fileName + ".iso" ,
                                                       False,
                                                       media_device,
                                                       vol_lable)

        except ISOBuilder.CannotUnMountError:
            self.popupMountErrorMessage(_("Cannont unmount chosen reference device."
                                          "This is neccessary to continue. Click OK to go back"
                                          "and retry starting backup operation."))
            self.goBack()
        
        self.spawnedProcOBJ = self.myIsoBuilder.pre_build_kick()
        self.curIsoBuild = self.myIsoBuilder.build()
        # set the label above the progress bar
        self.pushBkpTagID =  gobject.timeout_add(100,self.pushGUIIsoBuild)
        gobject.io_add_watch(self.spawnedProcOBJ.fileno(), gobject.IO_IN, self.watch_IsoBuilder_pty_callback)


    def GUIVerifyPrepare(self, standalone=False):
        # standalone parameter indicated weather we are executed part of a complete backup process and
        # scheduled by self.nextPhase(..) or weather we were called as a response to cliking on the
        # "Verfiy Integrity" Button from the main backup/restore dialog.
        # Another thing, since this method is not a first method to kick up a process,
        # we need to attach the progress propogation stuff inside of it, to distinguish from the backup method which
        # actually starts a complete backup process, and thus has someone else to take care of that for it.
        if DEBUG_PRINT: print "* Entering GUIVerifyPrepare method."
        self.aborted = False

        # Before everything else, display a message to the user we're going to do a verify pass on the backup
        # tell him to insert the first medium of his just created backup be it a diff or master, to drive
        # and confirm to continue.

        msg = _("It's recommended that you verify the integrity of the newly created backup archive."
                "Would you like to proceed with verification? (Make sure the first medium of the newly"
                "created backup archive is accessible or loaded in drive)")
        if standalone:
            pass
        else:
            ret_code = self.popupMsg(msg)
            if ret_code:
                pass
            else:
                return False

        selection = self.treeview2.get_selection()
        (model, iter) = selection.get_selected()
        print "* Device selected for reading reference backup from:"
        if iter!=None:
            self.backup_reference_device = model.get_value(iter, 4)
            self.backup_slice_size = model.get_value(iter, 3)[:-1]
            print self.backup_reference_device
        elif not standalone and self.backup_target_device:
            self.backup_reference_device = self.backup_target_device
        else:
            self.backup_reference_device = None
            print "no device chosen for reference to verify backup data on"
            myresult = self.popupMsg(_("Plesae go back and choose a reference device where media with backup data is available."),
                                     buttonsSpec=gtk.BUTTONS_OK)
            return
        
        # load the progess dialog glade xml
        xml = gtk.glade.XML("/usr/share/hubackup/restore-progress.glade",domain=app_name)

        # hide the previous progress window if it exists at this stage.
        try:
            if self.progress_window:
                self.progress_window.hide() 
        except AttributeError:
            pass

        # get a reference to the GtkWidgets we've created in the glade file            
        self.progress_window = xml.get_widget("restore_progress_dialog")
        self.button_abort = xml.get_widget("button_abort")
        self.progressbar_restore = xml.get_widget("progressbar_restore")

        # get the current reporting output widgets
        self.pbar = self.progressbar_restore
        self.reportLabel = xml.get_widget("report_label")

        # more setup of the needed widgets
        self.progress_window.set_modal(True)
        self.progress_window.set_resizable(False)
        self.progress_window_discon_id = self.progress_window.connect("destroy", self.stopBackup)
        self.button_abort_discon_id =  self.button_abort.connect("clicked", self.stopBackup)

        # settings up the label for the detailed line outputs
        self.reportLabel.set_markup(_("<b> Starting backup verification operation....Please wait. </b>"))
        self.reportLabel.set_width_chars(60)
        self.reportLabel.set_max_width_chars(60)
        self.reportLabel.set_ellipsize(pango.ELLIPSIZE_END)


        try:
            bkpSourceMountPoint = fsMisc.mount(self.backup_reference_device) # replaced with the reference device for the verify
        except fsMisc.fsMiscMountError:
            print "* Cannot mount source device. Aboring."
            # removed reference passing for the 'parent' window to allow calling this from hurestore
            dialog = gtk.MessageDialog(None , gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                                       gtk.MESSAGE_WARNING,
                                       gtk.BUTTONS_OK,
                                       _("Unable to mount storage device, aborting.\n"))
            dialog.show()
            res = dialog.run()
            dialog.destroy()
            return


        self.bkpEngine = BackupEngine.Backup(referencePath=bkpSourceMountPoint+"/")


        # hide main program window.
        try:
            self.main_backup.hide()
        except AttributeError:
            self.main_restore.hide()

        # show the progress window
        self.progress_window.show()        
        
        try:
            self.running = True
            self.spawnedProcOBJ =  self.bkpEngine.pre_test_kick(testArchiveType="diff")
        except BackupEngine.NoArchiveError:
            if DEBUG_PRINT: print "* Diff archive not found, trying master."
            try:
                self.running = True
                self.spawnedProcOBJ =  self.bkpEngine.pre_test_kick(testArchiveType="master")
            except BackupEngine.NoArchiveError:
                self.running = False
                if DEBUG_PRINT: print "* Master archive not found. aborting. Can't continue"
                dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT, 
                                           gtk.MESSAGE_WARNING,
                                           gtk.BUTTONS_OK,
                                           _("The media does not seem to contain valid HUBackup data.\n" 
                                             "Please make sure media #1 of your backup set is in drive and retry."
                                             "(You can always use the \"Verify\" button independently)"))
                dialog.show()
                res = dialog.run()
                dialog.destroy()
                self.stopBackup(None,None)

        self.curBkp = self.bkpEngine.test()
        self.cur_line = _("Starting Verification Process...")
        print "self.spawnedProcOBJ = %s" % self.spawnedProcOBJ
        print "self.spawnedProcOBJ.fileno() = %s" % self.spawnedProcOBJ.fileno()
        self.pushBkpTagID =  gobject.timeout_add(100,self.pushGUIBackup)
        gobject.io_add_watch(self.spawnedProcOBJ.fileno(), gobject.IO_IN, self.watch_Backup_pty_callback)

    def popupMsg(self, msg, buttonsSpec=gtk.BUTTONS_OK_CANCEL):
        dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                                   gtk.MESSAGE_QUESTION,
                                   buttonsSpec,
                                   msg)
        dialog.show()
        res = dialog.run()
        dialog.destroy()
        if res==gtk.RESPONSE_OK:
            return True
        else:
            return False
        
                

    def popupLabelingInstructionMessage(self):
        label_cd_msg = _("Suggested label for this CD:\n")
        print "* popupLabelingInstructionMessage:: self.lastIsoBurnt = %s" % self.lastIsoBurnt
        if self.lastIsoBurnt:
            if self.diffBackup:
                if self.lastIsoBurnt.find("catalog") > 0:
                    label_cd_msg += _("HUBackup CHANGES ARCHIVE CATALOG CD #%s")
                    label_cd_msg = label_cd_msg % self.bkpEngine.getSliceNum(self.lastIsoBurnt)
                else:
                    label_cd_msg += _("HUBackup CHANGES ARCHIVE CD #%s")
                    label_cd_msg = label_cd_msg % self.bkpEngine.getSliceNum(self.lastIsoBurnt)
            else:
                if self.lastIsoBurnt.find("catalog") > 0:
                    label_cd_msg += _("HUBackup MASTER ARCHIVE CATALOG CD #%s")
                    label_cd_msg = label_cd_msg % self.bkpEngine.getSliceNum(self.lastIsoBurnt)
                else:
                    label_cd_msg += _("HUBackup MASTER ARCHIVE CD #%s")
                    label_cd_msg = label_cd_msg % self.bkpEngine.getSliceNum(self.lastIsoBurnt)
            self.lastIsoBurnt = None            

            dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                                       gtk.MESSAGE_QUESTION,
                                       gtk.BUTTONS_OK_CANCEL,
                                       label_cd_msg)
            dialog.show()
            res = dialog.run()
            dialog.destroy()
            if res==gtk.RESPONSE_CANCEL:
                print "Labeling aborted."
                return
            else:
                print "* Moving to next cd burn process "

    def popupCatalogNeeded(self):
        catalogNeededMsg = _("The reference device you have specificed does not seem to contain a valid"
                             "catalog neccessary for creating a differential backup snapshot.\n"
                             "Please provide this in the reference device you have chosen."
                             "If you've backed up to CDs, this is the CD labeled:\n"
                             "'HUBackup MASTER ARCHIVE CATALOG #1'")
        dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                                   gtk.MESSAGE_ERROR,
                                   gtk.BUTTONS_OK,
                                   catalogNeededMsg)
        dialog.show()
        res = dialog.run()
        dialog.destroy()

    def popupMountErrorMessage(self,msg=None):
        if msg:
            myMsg = msg
        else:
            myMsg = _("Error mounting media. Make sure the media is not blank and retry.")
        dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                                   gtk.MESSAGE_ERROR,
                                   gtk.BUTTONS_OK,
                                   myMsg)
        dialog.show()
        res = dialog.run()
        dialog.destroy()

    def goBack(self):
        self.progress_window.hide()
        try:
            self.main_backup.show()
        except AttributeError:
            self.main_restore.show()

    def GUIBurnIso(self, fileName):
        self.pbar = self.progressbar_burn_cd
        media_device = self.backup_target_device
        if DEBUG_PRINT:
            print "* Burning %s to %s" % (fileName, media_device)
        myhome = self.userinfo.homedir()

        if self.diffBackup:
            pre_burn_message = _("Please make sure the your CHANGES backup CD is in drive to continue.\n")
        else:
            pre_burn_message = _("Please make sure a blank media is in chosen target drive to continue.")
            
        dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                                   gtk.MESSAGE_QUESTION,
                                   gtk.BUTTONS_OK_CANCEL,
                                   pre_burn_message)
        dialog.show()
        res = dialog.run()
        dialog.destroy()
        if res==gtk.RESPONSE_CANCEL:
            print "Burn aborted."
            return
        else:
            print "* Starting burn process."
        

        self.cdBurnProcessLabel.set_markup(_("<b> Burning CD #%s</b>") %
                                           self.bkpEngine.getSliceNum(fileName))

        try:
            self.myCdBurner = CDBurner.CDBurner(media_device,
                                                myhome + HUB.TEMP_DIR + fileName,
                                                self.diffBackup)
        except CDBurner.CannotUnMountError:
            self.popupMountErrorMessage(_("Cannont unmount %s !") % media_device)
        
        self.spawnedProcOBJ = self.myCdBurner.pre_build_kick()
        self.curCdBurn = self.myCdBurner.build()
        self.cur_line = _("<b> Burning CD #%s...</b>") % self.bkpEngine.getSliceNum(fileName)
        self.lastIsoBurnt = fileName
        print "GUIBurnIso::self.lastIsoBurnt = %s" % self.lastIsoBurnt
        self.pushBkpTagID =  gobject.timeout_add(100,self.pushGUIIsoBuild)
        gobject.io_add_watch(self.spawnedProcOBJ.fileno(), gobject.IO_IN, self.watch_CdBurn_pty_callback)


    def nextPhase(self, funcNameList):
        try:
            prepare_call_name = funcNameList.pop()
        except IndexError:
            prepare_call_name = None
        if prepare_call_name!=None:
            if self.aborted:
                print "  * Inside abort sequence, skipping..."
                return
            print "* Moving to next stage: %s" % prepare_call_name
            getattr(self, prepare_call_name)()


    def pushGUIBackup(self, goNext=True):
        message = None
        if DEBUG_PRINT:
            print "pushGUIBackup:: self = %s" % id(self)
        if self.spawnedProcOBJ.isalive():
            while gtk.events_pending():
                gtk.main_iteration()
            self.reportLabel.set_text(self.cur_line)
            self.pbar.pulse()
            while gtk.events_pending():
                gtk.main_iteration()
            # check for slice changes which mean CD changes
            if self.bkpEngine.waitingForSliceChange():
                if self.bkpEngine.changeSliceReason()=="next":
                    message = _("Please insert backup media #%s") % self.bkpEngine.reportNeededSliceNumber()
                elif self.bkpEngine.changeSliceReason()=="last":
                    message = _("Please insert the last backup media and click okay to continue")
                else:
                    message = _("Fatal error occured, exiting in error!")
                    self.popupMsg(message)
                    sys.exit(1)
                    
                my_result = self.popupMsg(message)
                if my_result:
                    self.bkpEngine.sliceChanged()
                    self.running = self.curBkp.next()
                else:
                    self.stopBackup(None,None)
                    return False
            return True
        else:
            self.reportLabel.set_markup(_("<b> Finished. </b>"))
            self.pbar.set_fraction(1.0)
            if goNext:
                self.nextPhase(self.stages)
            return False

    def isoNextPhase(self, fileNameList): # this kicks up a iso build/burn phase, based on the filename
        self.popupLabelingInstructionMessage()                                                            
        try:
            cur_slice_filename = fileNameList.pop()
        except IndexError:
            self.nextPhase(self.stages)
            return False
        if cur_slice_filename!=None:
            if self.aborted:
                print "  * Inside abort sequence, skipping..."
                return False
            if cur_slice_filename.endswith(".dar"):
                print "* Moving to preparing iso: %s" % cur_slice_filename                
                self.GUIBuildIso(cur_slice_filename)
            elif cur_slice_filename.endswith(".iso"):
                print "* Moving to BURNING iso: %s" % cur_slice_filename
                self.GUIBurnIso(cur_slice_filename)

    def pushGUIIsoBuild(self): # actually this is the push and progress propogation function for burning cd's as well ;-)
        if self.spawnedProcOBJ.isalive():
            while gtk.events_pending():
                gtk.main_iteration()
            self.reportLabel.set_text('')
            #self.pbar.pulse()
            self.pbar.set_fraction(self.curPrecent / 100.0)
            self.pbar.set_text(str(self.curPrecent)+"%")
            while gtk.events_pending():
                gtk.main_iteration()
            return True
        else:
            self.reportLabel.set_markup(_("<b> Finished. </b>"))
            self.pbar.set_fraction(1.0)
            return self.isoNextPhase(self.iso_build_file_list)

    def watch_Backup_pty_callback(self, source, condition):
        if DEBUG_PRINT:
            print "watch_Backup_pty_callback:: self = %s" % id(self)        
        while gtk.events_pending():
            gtk.main_iteration()
        self.running = self.curBkp.next()
        while gtk.events_pending():
            gtk.main_iteration()
        if self.running:
            self.cur_line = self.bkpEngine.reportLine()
            return True
        return False

    def watch_IsoBuilder_pty_callback(self, source, condition):
        while gtk.events_pending():
            gtk.main_iteration()
        self.running = self.curIsoBuild.next()
        while gtk.events_pending():
            gtk.main_iteration()
        if self.running:
            self.curPrecent = self.myIsoBuilder.reportPrecent()
            return True
        return False

    def watch_CdBurn_pty_callback(self, source, condition): # for watching the pty progress of a CDBurner.
        while gtk.events_pending():
            gtk.main_iteration()
        self.running = self.curCdBurn.next()
        while gtk.events_pending():
            gtk.main_iteration()
        if self.running:
            self.curPrecent = self.myCdBurner.reportPrecent()
            return True
        return False

        
    #-- MainBackup custom methods }

    #-- MainBackup.on_all_files_toggled {
    def on_all_files_toggled(self, widget, *args):
        sensitivity = self.all_files = widget.get_active()
        self.scrolledwindow2.set_sensitive(not sensitivity)
        self.label52.set_sensitive(not sensitivity)
        self.reference_is_also_target.set_sensitive(not sensitivity)
        self.label64.set_sensitive(not sensitivity)
        self.diffBackup = not self.diffBackup
    #-- MainBackup.on_all_files_toggled }

    #-- MainBackup.on_reference_is_also_target_toggled {
    def on_reference_is_also_target_toggled(self, widget, *args):
        self.reference_is_also_target_flag = widget.get_active()
        if self.reference_is_also_target_flag:
            print "* Reference device will be used as backup target device. Do you have only one burner in your system? :-)"
        else:
            print "* Reference device will NOT be used as the backup target device."
    #-- MainBackup.on_reference_is_also_target_toggled }

    #-- MainBackup.on_media_include_toggled {
    def on_media_include_toggled(self, widget, *args):
        print "on_media_include_toggled called with self.%s" % widget.get_name()
        self.media_include_flag = widget.get_active()
        if self.media_include_flag:
            print "Will include media files in the backup."
        else:
            print "Will NOT include media files in the backup."
    #-- MainBackup.on_media_include_toggled }

    #-- MainBackup.on_button7_clicked {
    # start the backup process.
    def on_button7_clicked(self, widget, *args):
        print "on_button7_clicked called with self.%s" % widget.get_name()
        print "Starting backup sequence..."
        selection = self.treeview2.get_selection()
        (model, iter) = selection.get_selected()
        print "* Device selected for reading reference backup from:"
        if iter!=None:
            self.backup_reference_device_type = model.get_value(iter, 0)
            if self.backup_reference_device_type == "gtk-cdrom":
                self.backup_slice_size = model.get_value(iter, 3)[:-1]
            elif self.backup_reference_device_type == "gtk-harddisk":
                self.backup_slice_size = model.get_value(iter, 2)[:-1]
            self.backup_reference_device = model.get_value(iter, 4)

            print self.backup_reference_device
            print self.backup_reference_device_type
        else:
            self.backup_reference_device = None
            print "no device chosen for reference backup"
        selection = self.treeview1.get_selection()
        (model, iter) = selection.get_selected()
        if iter!=None or self.reference_is_also_target_flag:
            # do backup to a external media device
            if not self.reference_is_also_target_flag:
                self.backup_target_device_type = model.get_value(iter, 0)
                if self.backup_target_device_type == "gtk-cdrom":
                    self.backup_slice_size = model.get_value(iter, 3)[:-1]
                elif self.backup_target_device_type == "gtk-harddisk":
                    self.backup_slice_size = model.get_value(iter, 2)[:-1]
                self.backup_target_device = model.get_value(iter, 4)
            else:
                self.backup_target_device = self.backup_reference_device
                self.backup_target_device_type = self.backup_reference_device_type

            print "Backup slice size: %s " % self.backup_slice_size
            print "* backup_target_device = %s" % self.backup_target_device
            print "* backup_target_device_type = %s" % self.backup_target_device_type
            self.GUIBackupPrepare()
            self.pushBkpTagID =  gobject.timeout_add(100,self.pushGUIBackup)
            gobject.io_add_watch(self.spawnedProcOBJ.fileno(), gobject.IO_IN, self.watch_Backup_pty_callback)
        else:
            self.backup_slice_size = "700M"
            self.backup_target_device = None
            print "no chosen device for saving backup to"
            dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT, 
                                       gtk.MESSAGE_QUESTION,
                                       gtk.BUTTONS_YES_NO,
                                       _("You didn't choose a device to store the backup to.\n" 
                                       "Would you like to continue and temporarily sore it on the hard drive?"))
            dialog.show()
            res = dialog.run()
            dialog.destroy()
            if res==gtk.RESPONSE_NO:
                print "Backup Aborted."
                return
            else:
                print "Storing backup only on HD as a temporal storage. Please make sure you burn it to CDs"

            print "run summary:"
            print "------------"
            print "* Backup media files : %s" % self.media_include_flag
            print "* Do a differential / a reference backup location has been choosen : %s " % self.backup_reference_device
            print "* Target device choosen for storing backup to : %s" % self.backup_target_device
            print "* Source dir to make backup of : %s " % self.filechooserbutton1.get_filename()
            self.GUIBackupPrepare()
            print "self.spawnedProcOBJ = %s" % self.spawnedProcOBJ
            print "self.spawnedProcOBJ.fileno() = %s" % self.spawnedProcOBJ.fileno()
            self.pushBkpTagID =  gobject.timeout_add(100,self.pushGUIBackup)
            gobject.io_add_watch(self.spawnedProcOBJ.fileno(), gobject.IO_IN, self.watch_Backup_pty_callback)

    #-- MainBackup.on_button7_clicked }

    #-- MainBackup.on_button8_clicked {
    def on_button8_clicked(self, widget, *args):
        self.GUIVerifyPrepare(standalone=True) # indicate we're running stand alone, and not part of a complete backup process

    #-- MainBackup.on_button8_clicked }


#-- main {

def main():
    gnome.program_init("hubackup", "0.0.1")
    main_backup = MainBackup()

    main_backup.run()

if __name__ == "__main__":
    main()

#-- main }



