/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include "includes/OptionsDialog.h"
#include "includes/optionsspider.h"
#include "../main/includes/httraqt.h"

optionsSpider::optionsSpider(QWidget* parent, Qt::WFlags fl)
    : QWidget(parent, fl), Ui::spiderForm()
{
    setupUi(this);

    QString t;
    QStringList sl;

    parentDialog = (OptionsDialog*)parent;

    t = translateString(LISTDEF_7);
    sl = t.split("\n");
    spiderForm::label1238->addItems(sl);

    t = translateString(LISTDEF_8);
    sl = t.split("\n");
    spiderForm::label1033_2->addItems(sl);

    opts = &((OptionsDialog*)(parentDialog))->_tabTextInfos;

    initTextPoints();
}

optionsSpider::~optionsSpider()
{
}


void optionsSpider::initTextPoints()
{
    *opts << (trWidgets) {
        spiderForm::label1245, _CHECK_DOC_TYPE, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        spiderForm::label1256, _SPIDER, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        spiderForm::label1237, _ACCEPT_COOK, "Cookies", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        spiderForm::label1239, _PARSE_JAVA, "ParseJava", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        spiderForm::label1242, _UPDATE_HACK, "UpdateHack", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        spiderForm::label1243, _URL_HACK, "URLHack", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        spiderForm::label1241, _TOL_REQ, "TolerantRequests", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        spiderForm::label1240, _FORCE_OLD, "HTTP10", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        spiderForm::label1238, -1, "CheckType", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        spiderForm::label1033_2, -1, "FollowRobotsTxt", COMBOBOX, INTEGER, 0
    };
}

/*$SPECIALIZATION$*/


