/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include "includes/OptionsDialog.h"
#include "includes/optionsproxy.h"
#include "../main/includes/httraqt.h"

optionsProxy::optionsProxy(QWidget* parent, Qt::WFlags fl)
    : QWidget(parent, fl), Ui::proxyForm()
{
    setupUi(this);

    parentDialog = (OptionsDialog*)parent;

    opts = &((OptionsDialog*)(parentDialog))->_tabTextInfos;

    initTextPoints();
}

optionsProxy::~optionsProxy()
{
}


void optionsProxy::initTextPoints()
{
    *opts << (trWidgets) {
        proxyForm::label1223, _PROX_ADDR, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::label1224, _PRIM_SCAN, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::groupBox_2, _PROX_PORT, "", GROUPBOX, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::label1223, _LOGIN, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::label1224, _PROX_PORT, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::label1227, _PASS, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::label1274, _HIDE_PASS, "", CHECKBOX, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::label1021_4, _USE_PROXY, "UseHTTPProxyForFTP", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        proxyForm::label1036_2, -1, "Proxy", EDITLINE, TEXT, ""
    };
    *opts << (trWidgets) {
        proxyForm::label1222, -1, "ProxyPort", EDITLINE, TEXT, ""
    };
    *opts << (trWidgets) {
        proxyForm::label1038_2, -1, "ProxyLogin", EDITLINE, TEXT, ""
    };
    *opts << (trWidgets) {
        proxyForm::label1039, -1, "ProxyPass", EDITLINE, TEXT, ""
    };
}



/*$SPECIALIZATION$*/


