/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include "includes/OptionsDialog.h"
#include "includes/optionslog.h"
#include "../main/includes/httraqt.h"

optionsLog::optionsLog(QWidget* parent, Qt::WFlags fl)
    : QWidget(parent, fl), Ui::logForm()
{
    setupUi(this);

    parentDialog = (OptionsDialog*)parent;

    QString t = translateString(LISTDEF_9);
    QStringList sl = t.split("\n");
    logForm::comboLogType->addItems(sl);

    opts = &((OptionsDialog*)(parentDialog))->_tabTextInfos;

    initTextPoints();
}


optionsLog::~optionsLog()
{
}


void optionsLog::initTextPoints()
{
    *opts << (trWidgets) {
        logForm::comboLogType, -1, "LogType", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        logForm::checkStoreAll, _STORE_CACHE, "StoreAllInCache", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        logForm::checkNoRecatch, _NO_REDOWNLOAD, "NoRecatch", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        logForm::checkLogFiles, _CREATE_LOG, "Log", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        logForm::checkMakeIndex, _MAKE_INDEX, "Index", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        logForm::checkBuildTopIndex, _MAKE_TOPINDEX, "BuildTopIndex", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        logForm::checkMakeWordbase, _MAKE_WORD_INDEX, "WordIndex", CHECKBOX, BOOLEAN, 0
    };
}


/*$SPECIALIZATION$*/


