/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include "includes/OptionsDialog.h"
#include "includes/optionslinks.h"
#include "../main/includes/httraqt.h"

optionsLinks::optionsLinks(QWidget* parent, Qt::WFlags fl)
    : QWidget(parent, fl), Ui::linksForm()
{
    setupUi(this);

    parentDialog = (OptionsDialog*)parent;

    opts = &((OptionsDialog*)(parentDialog))->_tabTextInfos;

    initTextPoints();
}

optionsLinks::~optionsLinks()
{
}

void optionsLinks::initTextPoints()
{

    *opts << (trWidgets) {
        linksForm::label1023, _ALL_LINKS_MATCH, "ParseAll", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        linksForm::label1022, _GET_NHTML, "Near", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        linksForm::label1021, _TEST_LINKS, "Test", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        linksForm::label1024, _GET_HTML_FIRST, "HTMLFirst", CHECKBOX, BOOLEAN, 0
    };
}


/*$SPECIALIZATION$*/


