/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include "includes/OptionsDialog.h"
#include "includes/optionslimits.h"
#include "../main/includes/httraqt.h"

optionsLimits::optionsLimits(QWidget* parent, Qt::WFlags fl)
    : QWidget(parent, fl), Ui::limitsForm()
{
    setupUi(this);

    parentDialog = (OptionsDialog*)parent;

    QStringList maxTime;
    maxTime << "" << "120" << "900" << "1800" << "3600" << "7200";
    limitsForm::comboMaxTime->insertItems(0, maxTime);    // max time overall

    connect (limitsForm::comboMaxTime->lineEdit(), SIGNAL(editingFinished()), this, SLOT(editingFinished()));
    //     connect (limitsForm::comboMaxTime->lineEdit(), SIGNAL(returnPressed()), this, SLOT(editingFinished()));

    QStringList connSec;
    connSec << "" << "1" << "2" << "4" << "8" << "16" << "32" << "64" << "128";
    limitsForm::comboMaxConn->insertItems(0, connSec);    // max connections/sec

    connect (limitsForm::comboMaxConn->lineEdit(), SIGNAL(editingFinished()), this, SLOT(editingFinished()));
    //     connect (limitsForm::comboMaxConn->lineEdit(), SIGNAL(returnPressed()), this, SLOT(editingFinished()));

    limitsForm::comboMaxDep->insertItems(0, connSec); // max depth

    connect (limitsForm::comboMaxDep->lineEdit(), SIGNAL(editingFinished()), this, SLOT(editingFinished()));
    //     connect (limitsForm::comboMaxDep->lineEdit(), SIGNAL(returnPressed()), this, SLOT(editingFinished()));

    QStringList extD;
    extD << "" << "0" << "1" << "2" << "4" << "8" << "16" << "32" << "64" << "128";
    limitsForm::comboMaxExtDep->insertItems(0, extD); // max links
    connect (limitsForm::comboMaxExtDep->lineEdit(), SIGNAL(editingFinished()), this, SLOT(editingFinished()));
    //     connect (limitsForm::comboMaxExtDep->lineEdit(), SIGNAL(returnPressed()), this, SLOT(editingFinished()));

    QStringList maxLinks;
    maxLinks << "" << "100000" << "200000" << "1000000" << "5000000";
    limitsForm::comboMaxLinks->insertItems(0, maxLinks);    // max links

    connect (limitsForm::comboMaxLinks->lineEdit(), SIGNAL(editingFinished()), this, SLOT(editingFinished()));
    //     connect (limitsForm::comboMaxLinks->lineEdit(), SIGNAL(returnPressed()), this, SLOT(editingFinished()));

    QStringList maxTransferRate;
    maxTransferRate << "" << "0.01" << "0.1" << "0.5" << "1" << "5" << "20" << "50" << "75" << "100" << "250";
    limitsForm::comboMaxTransf->insertItems(0, maxTransferRate);   // max transfer rate

    connect (limitsForm::comboMaxTransf->lineEdit(), SIGNAL(editingFinished()), this, SLOT(editingFinished()));
    //     connect (limitsForm::comboMaxTransf->lineEdit(), SIGNAL(returnPressed()), this, SLOT(editingFinished()));

    opts = &((OptionsDialog*)(parentDialog))->_tabTextInfos;

    initTextPoints();

    limitsForm::labelMaxHtml->setText("MB");
    limitsForm::labelMaxNHtml->setText("MB");
    limitsForm::labelMaxSize->setText("MB");
    limitsForm::labelMaxTransf->setText("MB/s");

    frame->setHidden(true);

    //     connect(limitsForm::radioButton1, SIGNAL(clicked(bool)), this, SLOT(unitChanged(bool)));
    //     connect(limitsForm::radioButton2, SIGNAL(clicked(bool)), this, SLOT(unitChanged(bool)));
    //     connect(limitsForm::radioButton3, SIGNAL(clicked(bool)), this, SLOT(unitChanged(bool)));
    //
    //     limitsForm::radioButton1->click();
}


optionsLimits::~optionsLimits()
{
}

#if 0
void optionsLimits::unitChanged(bool on)
{
    QStringList maxTransferRate;
    limitsForm::comboMaxTransf->clear();

    QRadioButton* rb = (QRadioButton*)sender();

    if (rb == limitsForm::radioButton1) {
        limitsForm::labelMaxHtml->setText("MB");
        limitsForm::labelMaxNHtml->setText("MB");
        limitsForm::labelMaxSize->setText("MB");
        limitsForm::labelMaxTransf->setText("MB/s");
        maxTransferRate << "" << "1" << "5" << "20" << "50" << "75" << "100" << "250";
    }

    if (rb == limitsForm::radioButton2) {
        limitsForm::labelMaxHtml->setText("kB");
        limitsForm::labelMaxNHtml->setText("kB");
        limitsForm::labelMaxSize->setText("kB");
        limitsForm::labelMaxTransf->setText("kB/s");
        maxTransferRate << "" << "500" << "2000" << "5000" << "25000" << "50000" << "100000" << "250000";
    }

    if (rb == limitsForm::radioButton3) {
        limitsForm::labelMaxHtml->setText("B");
        limitsForm::labelMaxNHtml->setText("B");
        limitsForm::labelMaxSize->setText("B");
        limitsForm::labelMaxTransf->setText("B/s");
        maxTransferRate << "" << "500" << "2000" << "5000" << "25000" << "50000" << "100000" << "250000";
    }

    limitsForm::comboMaxTransf->insertItems(0, maxTransferRate);   // max transfer rate
}
#endif

// check the entered value depended from combobox
void optionsLimits::editingFinished()
{
    QLineEdit* from;
    bool valGood;
    QString t;
    from = (QLineEdit*)sender();
    QComboBox *par = (QComboBox*)from->parent();
    t = from->text();

    //     qDebug() << from << t;
    if (t == "" || t == "\n") {
        limitsForm::comboMaxConn->setCurrentIndex(0); // first element, = -1
        return;
    }

    disconnect (from, SIGNAL(editingFinished()), this, SLOT(editingFinished()));

    if (from == limitsForm::comboMaxConn->lineEdit()) { // int, range: space, 0..255
        int tmp = t.toInt(&valGood);

        if (valGood == true) {
            if (!(tmp >= 0 && tmp <= 255)) {
                qDebug() << "wrong" << from << tmp;
                valGood = false;
            }
        }
    }

    if (from == limitsForm::comboMaxDep->lineEdit()) { // int, range: space, 0..9999
        int tmp = t.toInt(&valGood);

        if (valGood == true) {
            if (!(tmp >= 0 && tmp <= 9999)) {
                qDebug() << "wrong" << from << tmp;
                valGood = false;
            }
        }
    }

    if (from == limitsForm::comboMaxExtDep->lineEdit()) { // int, range: space, 0..9999
        int tmp = t.toInt(&valGood);

        if (valGood == true) {
            if (!(tmp >= 0 && tmp <= 9999)) {
                qDebug() << "wrong" << from << tmp;
                valGood = false;
            }
        }
    }

    if (from == limitsForm::comboMaxTime->lineEdit()) { // int, range: space, 0..99999 sec
        int tmp = t.toInt(&valGood);

        if (valGood == true) {
            if (!(tmp >= 0 && tmp <= 99999)) {
                qDebug() << "wrong" << from << tmp;
                valGood = false;
            }
        }
    }

    if (from == limitsForm::comboMaxTransf->lineEdit()) { // float, range: space, 0..1000 MB/s
        float tmp = t.toFloat(&valGood);

        if (valGood == true) {
            if (!(tmp >= 0 && tmp <= 1000)) {
                qDebug() << "wrong" << from << tmp;
                valGood = false;
            }
        }
    }

    if (from == limitsForm::comboMaxLinks->lineEdit()) { // int, range: space, 0..5000000
        int tmp = t.toInt(&valGood);

        if (valGood == true) {
            if (!(tmp >= 0 && tmp <= 5000000)) {
                qDebug() << "wrong" << from << tmp;
                valGood = false;
            }
        }
    }

    if (valGood == true) {
        //         qDebug() << "right" << t;
        int currInd = par->findText(t);

        if ( currInd < 0) {
            par->addItem(t);
            par->model()->sort(0);
            int tInd = par->findText(t);
            par->setCurrentIndex(tInd);
        } else {
            par->setCurrentIndex(currInd);
        }
    }

    connect (from, SIGNAL(editingFinished()), this, SLOT(editingFinished()));
}


void optionsLimits::initTextPoints()
{
    *opts << (trWidgets) {
        limitsForm::label1141, _MAX_FROM_ROOT, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        limitsForm::label1143, _MAX_EXTERNAL, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        limitsForm::label1205, _MAX_SIZE_HTML, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        limitsForm::label1209_2, _MAX_SIZE_NHTML, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        limitsForm::labelUnits, _UNITS, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        limitsForm::label1206, _SIZE_LIMIT, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        limitsForm::label1210, _PAUSE_DOWN, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        limitsForm::label1207, _MAX_TIME, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        limitsForm::label1208, _MAX_RATE, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        limitsForm::label1211, _MAX_CONN_SEC, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        limitsForm::label1212, _MAX_LINKS, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        limitsForm::comboMaxDep, -1, "Depth", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        limitsForm::comboMaxExtDep, -1, "ExtDepth", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        limitsForm::comboMaxTime, -1, "MaxTime", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        limitsForm::comboMaxTransf, -1, "MaxRate", COMBOBOX, FLOAT, 0
    };
    *opts << (trWidgets) {
        limitsForm::comboMaxConn, -1, "MaxConn", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        limitsForm::comboMaxLinks, -1, "MaxLinks", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        limitsForm::editMaxHtml, -1, "MaxHtml", EDITLINE, FLOAT, 0
    };
    *opts << (trWidgets) {
        limitsForm::editMaxNHtml, -1, "MaxOther", EDITLINE, FLOAT, 0
    };
    *opts << (trWidgets) {
        limitsForm::editMaxSize, -1, "MaxAll", EDITLINE, FLOAT, 0
    };
    *opts << (trWidgets) {
        limitsForm::editPause, -1, "MaxWait", EDITLINE, INTEGER, 0
    };
}


/*$SPECIALIZATION$*/


