/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include "includes/optionsflow.h"
#include "includes/OptionsDialog.h"
#include "../main/includes/httraqt.h"



optionsFlow::optionsFlow(QWidget* parent, Qt::WFlags fl)
    : QWidget(parent, fl), Ui::flowForm()
{
    setupUi(this);

    parentDialog = (OptionsDialog*)parent;

    QStringList connections;
    connections << "";

    for (int i = 1; i < 15; i++) {
        connections << QString::number(i);
    }

    flowForm::label1051->insertItems(0, connections);

    QStringList timeout;
    timeout << "" << "30" << "60" << "120" << "180" << "300" << "600" << "1200";
    flowForm::label1052->insertItems(0, timeout);

    QStringList retries;
    retries << "" << "0" << "1" << "2" << "3" << "6";
    flowForm::label1057->insertItems(0, retries);

    opts = &((OptionsDialog*)(parentDialog))->_tabTextInfos;

    initTextPoints();
}


optionsFlow::~optionsFlow()
{
}


void optionsFlow::initTextPoints()
{
    *opts << (trWidgets) {
        flowForm::label1201_2, _NR_CONN, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        flowForm::label1290, _TIMEOUTS, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        flowForm::label1203, _RETRIES, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        flowForm::label1202_2, _MIN_RATE, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        flowForm::label1055, -1, "RateOut", EDITLINE, INTEGER, 0
    };
    *opts << (trWidgets) {
        flowForm::label1051, -1, "Sockets", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        flowForm::label1052, -1, "TimeOut", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        flowForm::label1057, -1, "Retry", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        flowForm::label1033, _KEEP_ALIVE, "KeepAlive", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        flowForm::label1031_2, _CANCEL_TIMEOUT, "RemoveTimeout", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        flowForm::label1032, _CANCEL_SLOW, "RemoveRateout", CHECKBOX, BOOLEAN, 0
    };
}


/*$SPECIALIZATION$*/


