/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include "includes/OptionsDialog.h"
#include "includes/optionsexperts.h"
#include "../main/includes/httraqt.h"

optionsExperts::optionsExperts(QWidget* parent, Qt::WFlags fl)
    : QWidget(parent, fl), Ui::expertsForm()
{
    QString t;
    QStringList sl;

    setupUi(this);

    parentDialog = (OptionsDialog*)parent;

    t = translateString(LISTDEF_4);
    sl = t.split("\n");
    expertsForm::label1046->addItems(sl);

    t = translateString(LISTDEF_5);
    sl = t.split("\n");
    expertsForm::label1047->addItems(sl);

    t = translateString(LISTDEF_6);
    sl = t.split("\n");
    expertsForm::label1048->addItems(sl);

    t = translateString(LISTDEF_11);
    sl = t.split("\n");
    expertsForm::label1049->addItems(sl);

    opts = &((OptionsDialog*)(parentDialog))->_tabTextInfos;

    initTextPoints();
}

optionsExperts::~optionsExperts()
{
}


void optionsExperts::initTextPoints()
{
    *opts << (trWidgets) {
        expertsForm::label1257, _ONLY_EXPERTS, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        expertsForm::label1193, _PRIM_SCAN, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        expertsForm::label1200, _TRAVEL_MODE, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        expertsForm::label1201, _GLOBAL_TRAVEL, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        expertsForm::label1202, _REWRITE_LINKS, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        expertsForm::label1046, -1, "PrimaryScan", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        expertsForm::label1047, -1, "Travel", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        expertsForm::label1048, -1, "GlobalTravel", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        expertsForm::label1049, -1, "RewriteLinks", COMBOBOX, INTEGER, 0
    };
    *opts << (trWidgets) {
        expertsForm::label1029, _USE_CACHE, "Cache", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        expertsForm::label1021_2, _DEBUG_MODE, "Debug", CHECKBOX, BOOLEAN, 0
    };
}


/*$SPECIALIZATION$*/


