/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include <QtGui>

#include "../main/includes/httraqt.h"
#include "includes/OptionsDialog.h"


OptionsDialog::OptionsDialog(QWidget* parent, Qt::WFlags fl)
    : QDialog(parent, fl)
{
    setupUi(this);

    this->parent = (HTTraQt*)parent;
    // qDebug() << "init OptionsDialog";
    _tabTextInfos.clear();

    QToolButton* b[] = {buttonLinks, buttonBuild, buttonRulez, buttonLimits, buttonProxy,
                        buttonExperts, buttonMime, buttonFlow, buttonSpider, buttonBrowser, buttonLog
                       };
    memcpy(buttons, b, OPTION_SITES * sizeof(QToolButton*));

    int h[] = {_LINKS, _BUILD, _SCANRULEZ, _LIMITS, _PROXY, _EXPERTS, _MIMETYPES, _FLOWCONTROL,
               _SPIDER, _BROWSERID, _LOGINDEX
              };
    memcpy(headers, h, OPTION_SITES * sizeof(int));

    for (int i = 0; i < OPTION_SITES; i++) {
        //         headers[i] = buttons[i]->text();
        buttons[i]->setText(translateString(headers[i]));
    }

    pBuild = new optionsBuild(this);
    gridLayoutM->addWidget((QWidget*)pBuild);

    pBrowser = new optionsBrowser(this);
    gridLayoutM->addWidget((QWidget*)pBrowser);

    pFlow = new optionsFlow(this);
    gridLayoutM->addWidget((QWidget*)pFlow);

    pLimits = new optionsLimits(this);
    gridLayoutM->addWidget((QWidget*)pLimits);

    pLinks = new optionsLinks(this);
    gridLayoutM->addWidget((QWidget*)pLinks);

    pProxy = new optionsProxy(this);
    gridLayoutM->addWidget((QWidget*)pProxy);

    pRulez = new optionsRulez(this);
    gridLayoutM->addWidget((QWidget*)pRulez);

    pExperts = new optionsExperts(this);
    gridLayoutM->addWidget((QWidget*)pExperts);

    pLog = new optionsLog(this);
    gridLayoutM->addWidget((QWidget*)pLog);

    pSpider = new optionsSpider(this);
    gridLayoutM->addWidget((QWidget*)pSpider);

    pMime = new optionsMime(this);
    gridLayoutM->addWidget((QWidget*)pMime);

    initOptions();

    setToGUI();

    setFontForWidgets();

    connect(buttonOk, SIGNAL(clicked()), this, SLOT(onOk()));
    connect(buttonCancel, SIGNAL(clicked()), this, SLOT(reject()));
    connect(pushDefault, SIGNAL(clicked()), this, SLOT(onSaveDefOptions()));
    connect(buttonHelp, SIGNAL(clicked()), this, SLOT(onHelp()));

    for (int i = 0; i < OPTION_SITES; i++) {
        connect(buttons[i], SIGNAL(toggled(bool)), this, SLOT(switchPages()));
    }

    QWidget* p[] = {pLinks, pBuild, pRulez, pLimits, pProxy, pExperts, pMime, pFlow, pSpider, pBrowser, pLog};
    memcpy(pages, p, OPTION_SITES * sizeof(QWidget*));

    buttons[0]->setChecked(true);
}


OptionsDialog::~OptionsDialog()
{
    delete pBuild;
    delete pBrowser;
    delete pFlow;
    delete pLimits;
    delete pLinks;
    delete pProxy;
    delete pRulez;
    delete pExperts;
    delete pLog;
    delete pSpider;
    delete pMime;
}


void OptionsDialog::setFontForWidgets(void)
{
    QFont f = parent->sysFont;

    setFont(f);

    pBuild->setFont(f);
    pBrowser->setFont(f);
    pFlow->setFont(f);
    pLimits->setFont(f);
    pLinks->setFont(f);
    pProxy->setFont(f);
    pRulez->setFont(f);
    pExperts->setFont(f);
    pLog->setFont(f);
    pSpider->setFont(f);
    pMime->setFont(f);

    QString sSheet = QString().sprintf("font-size: %dpt", parent->fontSize + 4);

    labelMain->setStyleSheet(sSheet);
}


void OptionsDialog::initOptions()
{
    QVector<options>::iterator iopt;

    for (iopt = parent->prOptions.begin(); iopt != parent->prOptions.end(); ++iopt) {
        QVector<trWidgets>::iterator ivec;
        bool found = false;

        for (ivec = _tabTextInfos.begin(); ivec != _tabTextInfos.end(); ++ivec) {
            if ((*ivec).idString == (*iopt).name) {
                found = true;

                (*ivec).value = (*iopt).value;
            }
        }

#ifdef MY_DEBUG

        if (found == false) {
            qDebug() << "set to gui" << (*iopt).name << "not found in gui!";
        }

#endif
    }
}


void OptionsDialog::getFromGUI()
{
    QVector<options>::iterator iopt;

    for (iopt = parent->prOptions.begin(); iopt != parent->prOptions.end(); ++iopt) {
        QVector<trWidgets>::iterator ivec;
        bool found = false;

        for (ivec = _tabTextInfos.begin(); ivec != _tabTextInfos.end(); ++ivec) {
            if ((*ivec).idString == (*iopt).name) {
                found = true;

                switch ((*ivec).wtype) {
                    case CHECKBOX:
                        (*ivec).value = ((QCheckBox*)(*ivec).wg)->isChecked() ? 1 : 0;
                        break;

                    case EDITLINE: {
                        if ((*ivec).opttype == INTEGER) {
                            if (((QLineEdit*)(*ivec).wg)->text().length() > 0) {
                                (*ivec).value = ((QLineEdit*)(*ivec).wg)->text().toInt();
                            }
                        } else {
                            (*ivec).value = -1;
                        }

                        if ((*ivec).opttype == FLOAT) {
                            if (((QLineEdit*)(*ivec).wg)->text().length() > 0) {
                                (*ivec).value = ((QLineEdit*)(*ivec).wg)->text().toFloat();
                            } else {
                                (*ivec).value = -1;
                            }
                        }

                        if ((*ivec).opttype == TEXT) {
                            (*ivec).value = ((QLineEdit*)(*ivec).wg)->text();
                        }

                        break;
                    }

                    case LABEL: {
                        if ((*ivec).opttype == TEXT) {
                            (*ivec).value = ((QLabel*)(*ivec).wg)->text();
                        }

                        break;
                    }

                    case TEXTEDIT: { // this one only for rulez->scanList
                        (*ivec).value = ((QTextEdit*)(*ivec).wg)->toPlainText();
                        break;
                    }

                    case RADIO: // not exists
                        break;

                    case GROUPBOX: {
                        if ((*ivec).opttype == BOOLEAN) {
                            (*ivec).value = ((QGroupBox*)(*ivec).wg)->isChecked() ? 1 : 0;
                        }

                        break;
                    }

                    case COMBOBOX: {
                        if ((*ivec).opttype == TEXT) {
                            (*ivec).value = ((QComboBox*)(*ivec).wg)->currentText();
                        }

                        if ((*ivec).opttype == INTEGER || (*ivec).opttype == FLOAT) {
                            bool ok;
                            QString ct = ((QComboBox*)(*ivec).wg)->currentText();

                            if (ct == "" || ct == "-") {
                                //                                 qDebug() << "get options combo" << (*ivec).idString << (*ivec).value;
                                if ((*ivec).opttype == INTEGER ) {
                                    (*ivec).value = -1;
                                }

                                if ((*ivec).opttype == FLOAT ) {
                                    (*ivec).value = -1.0;
                                }
                            } else {
                                if ((*ivec).opttype == INTEGER ) {
                                    int  num = ct.toInt(&ok);

                                    if (ok == true) {
                                        (*ivec).value = num;
                                    } else {
                                        (*ivec).value = ((QComboBox*)(*ivec).wg)->currentIndex();
                                    }
                                } else {
                                    float  num = ct.toFloat(&ok);

                                    if (ok == true) {
                                        (*ivec).value = num;
                                    } else {
                                        (*ivec).value = ((QComboBox*)(*ivec).wg)->currentIndex();
                                    }
                                }
                            }
                        }

                        break;
                    }
                }

                (*iopt).value = (*ivec).value;
            }
        }

#ifdef MY_DEBUG

        if (found == false) {
            qDebug() << "get from gui" << (*iopt).name << "not found in gui!";
        }

#endif
    }
}


void OptionsDialog::setToGUI()
{
    QVector<trWidgets>::iterator ivec;

    for (ivec = _tabTextInfos.begin(); ivec != _tabTextInfos.end(); ++ivec) {
        switch ((*ivec).wtype) {
            case LABEL: {
                if ((*ivec).opttype == NOTYPE) {
                    ((QLabel*)(*ivec).wg)->setText(translateString((*ivec).gui_ID));
                } else {
                    ((QLabel*)(*ivec).wg)->setText(translateString((*ivec).value.toInt()));
                }

                break;
            }

            case TEXTEDIT: { // this one only for rulez->scanList, without translation
                ((QTextEdit*)(*ivec).wg)->setText((*ivec).value.toString());
                break;
            }

            case BUTTON: {
                ((QPushButton*)(*ivec).wg)->setText(translateString((*ivec).gui_ID));
                break;
            }

            case CHECKBOX: {
                if ((*ivec).opttype == TEXT) {
                    ((QCheckBox*)(*ivec).wg)->setText(translateString((*ivec).gui_ID));
                } else {
                    ((QCheckBox*)(*ivec).wg)->setText(translateString((*ivec).gui_ID));

                    if ((*ivec).value.toInt() == 1) {
                        ((QCheckBox*)(*ivec).wg)->setCheckState(Qt::Checked);
                    } else {
                        ((QCheckBox*)(*ivec).wg)->setCheckState(Qt::Checked); // for toggling
                        ((QCheckBox*)(*ivec).wg)->setCheckState(Qt::Unchecked);
                    }
                }

                break;
            }

            case GROUPBOX: {
                ((QGroupBox*)(*ivec).wg)->setTitle(translateString((*ivec).gui_ID));

                if ((*ivec).opttype == BOOLEAN) {
                    if ((*ivec).value.toInt() == 1) {
                        ((QGroupBox*)(*ivec).wg)->setChecked(true);
                    } else {
                        ((QGroupBox*)(*ivec).wg)->setChecked(false);
                    }
                }

                break;
            }

            case COMBOBOX: {
                if ((*ivec).opttype == TEXT) {
                    int index = ((QComboBox*)(*ivec).wg)->findText((*ivec).value.toString());

                    if (index >= 0) {
                        ((QComboBox*)(*ivec).wg)->setCurrentIndex(index);
                    } else {
                        QString t = (*ivec).value.toString();
                        ((QComboBox*)(*ivec).wg)->addItem(t);
                        ((QComboBox*)(*ivec).wg)->model()->sort(0);
                        int tInd = ((QComboBox*)(*ivec).wg)->findText(t);
                        ((QComboBox*)(*ivec).wg)->setCurrentIndex(tInd);
                    }
                } else {
                    int num;

                    if (((QComboBox*)(*ivec).wg)->findText("") == -1) {
                        num = (*ivec).value.toInt();
                        ((QComboBox*)(*ivec).wg)->setCurrentIndex(num);
                        break;
                    }

                    //                     if ((*ivec).gui_ID != -1) {
                    //                         ((QComboBox*)(*ivec).wg)->addItem(translateString((*ivec).gui_ID));
                    //                     }

                    if ((*ivec).opttype == INTEGER) {
                        int pos;

                        num = (*ivec).value.toInt();

                        if ( num == -1) {
                            pos = ((QComboBox*)(*ivec).wg)->findText("");
                            ((QComboBox*)(*ivec).wg)->setCurrentIndex(pos);
                        } else {
                            pos = ((QComboBox*)(*ivec).wg)->findText(QString::number(num));

                            if (pos >= 0) {
                                ((QComboBox*)(*ivec).wg)->setCurrentIndex(pos);
                            } else {
                                QString t = QString::number((*ivec).value.toInt());
                                ((QComboBox*)(*ivec).wg)->addItem(t);
                                ((QComboBox*)(*ivec).wg)->model()->sort(0);
                                int tInd = ((QComboBox*)(*ivec).wg)->findText(t);
                                ((QComboBox*)(*ivec).wg)->setCurrentIndex(tInd);
                            }
                        }

                        break;
                    }

                    if ((*ivec).opttype == FLOAT) {
                        int pos;

                        // qDebug() << "set to gui" << (*ivec).idString << (*ivec).value;
                        if ((*ivec).value.toFloat() == -1.0) {
                            pos = ((QComboBox*)(*ivec).wg)->findText("");
                            ((QComboBox*)(*ivec).wg)->setCurrentIndex(pos);
                        } else {
                            pos = ((QComboBox*)(*ivec).wg)->findText(QString::number((*ivec).value.toFloat()));

                            if (pos >= 0) {
                                ((QComboBox*)(*ivec).wg)->setCurrentIndex(pos);
                            } else {
                                QString t = QString::number((*ivec).value.toFloat());
                                ((QComboBox*)(*ivec).wg)->addItem(t);
                                ((QComboBox*)(*ivec).wg)->model()->sort(0);
                                int tInd = ((QComboBox*)(*ivec).wg)->findText(t);
                                ((QComboBox*)(*ivec).wg)->setCurrentIndex(tInd);
                            }
                        }

                        break;
                    }
                }

                break;
            }

            case RADIO: {
                ((QRadioButton*)(*ivec).wg)->setText(translateString((*ivec).gui_ID));
                break;
            }

            case EDITLINE: {// no translate for edit widget
                if ((*ivec).opttype == INTEGER) {
                    if ((*ivec).value.toInt() == -1) {
                        ((QLineEdit*)(*ivec).wg)->setText("");
                    } else {
                        ((QLineEdit*)(*ivec).wg)->setText(QString::number((*ivec).value.toInt()));
                    }
                }

                if ((*ivec).opttype == FLOAT) {
                    if ((*ivec).value.toFloat() == -1.0) {
                        ((QLineEdit*)(*ivec).wg)->setText("");
                    } else {
                        ((QLineEdit*)(*ivec).wg)->setText(QString::number((*ivec).value.toFloat()));
                    }
                }

                if ((*ivec).opttype == TEXT) {
                    ((QLineEdit*)(*ivec).wg)->setText((*ivec).value.toString());
                }

                break;
            }
        }
    }
}


void OptionsDialog::onHelp()
{
    QDesktopServices::openUrl(QUrl::fromLocalFile(qPrintable( parent->helpDir + "/step9.html")));
}


void OptionsDialog::switchPages()
{
    int n = -1;
    QToolButton* s = (QToolButton*)sender();

    for (int i = 0; i < OPTION_SITES; i++) {
        if (buttons[i] == s) {
            n = i;
            break;
        }
    }

    if (n == -1) {
        return;
    }

    pages[n]->show();
    labelMain->setText(translateString(headers[n]));


    for (int i = 0; i < OPTION_SITES; i++) {
        disconnect(buttons[i], SIGNAL(toggled(bool)), this, SLOT(switchPages()));
    }


    for (int i = 0; i < OPTION_SITES; i++) {
        if (i == n) {
            continue;
        }

        pages[i]->hide();

        buttons[i]->setChecked(false);
    }

    buttons[n]->setChecked(true);

    for (int i = 0; i < OPTION_SITES; i++) {
        connect(buttons[i], SIGNAL(toggled(bool)), this, SLOT(switchPages()));
    }
}


void OptionsDialog::onResetDefOptions()
{
    //     getFromGUI();
    parent->resetDefaultOptions();
    parent->writeSettings(true);
}


void OptionsDialog::onSaveDefOptions()
{
    getFromGUI();
    parent->writeSettings(true);
}


void OptionsDialog::onOk()
{
    getFromGUI();
    parent->writeSettings(false); // project settings

    reject();
}





