/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2013 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/


using namespace std;

#include <QMainWindow>
#include <QCloseEvent>
#include <QStringList>
#include <QString>
#include <QSystemTrayIcon>
#include <QTreeView>
#include <QTime>
#include <QtGui>
#include <QGroupBox>
#include <QtCore/QSharedMemory>


#ifndef HTTRAQ_H
#define HTTRAQ_H


#include "../../icons/main.h"

#include "lang.h"

#include "ui_mainForm.h"


// #define HTS_URLMAXSIZE      4096
#define PROGRAM_NAME        "HTTraQt"
#define PROGRAM_FULL_NAME   "HTTraQt Website Copier v.%s (Qt4 based)"

#define LAST_ACTION         6

/* Location */
#define WHTT_LOCATION(a) WhttLocation=(a)

#ifndef HTS_DEF_FWSTRUCT_lien_back
#define HTS_DEF_FWSTRUCT_lien_back

#endif


#define NStatsBuffer     14
#define MAX_LEN_INPROGRESS 40

#include "htinterface.h"


class buttonPanel;
class QAction;
class QMenu;
class QTextEdit;


struct hInfo {
    QString name;
    QString tInfo;
    int num;
};


struct options {
    QString name;
    short   type; // TEXT or INTEGER. if not number, default text
    QVariant value;
};


typedef struct {
    QString name;
    QString file;
    QString state;
    QString url_sav;    // pour cancel
    QString url_adr;
    QString url_fil;
    qint64 size;
    qint64 sizetot;
    int offset;
    int back;
    int actived;    // pour disabled
} t_StatsBuffer;



// QString translateString(const QString& id);
QString translateString(int id);
int  messageBox(const QString &title, const QString &text, int ticon);

class DirModel : public QDirModel
{
    public:
        QVariant headerData ( int section, Qt::Orientation orientation, int role ) const;
};


class TimerBox : public QMessageBox
{
    public:
        void showEvent ( QShowEvent * event );
        void timerEvent(QTimerEvent *event);
        void setAutoClose(bool v);
        void setTimeout(int t);

    private:
        int timeout;
        bool autoClose;
        int currentTime;
};

class MyThread : public QThread
{
    public:
        void run();
};

class HTTraQt: public QMainWindow, public Ui_MainWindow
{
        Q_OBJECT

    public:
        HTTraQt(QWidget* parent = 0, Qt::WindowFlags flags = 0);
        ~HTTraQt();
        bool rebuildWorkDirView();
        void activatePage(int pagenum);
        void onCancelAll();
        void onQuit();
        bool getLangTable();
        void setLangGUI();
        void translateActions();
        void translateActions(QAction* act, int id);
        void launch();
        void getMainOptionsFromGUI();
        void setMainOptionsToGUI();
        void initSInfo();

        void readGUISettings();
        void readSettings(bool global);
        void writeSettings(bool global);
        void writeGUISettings(void);

        void SetProfile(QString variName, float val);
        void SetProfile(QString variName, int val);
        void SetProfile(QString variName, const QString &val);

        void GetProfile(QString variName, int &val);
        void GetProfile(QString variName, float &val);
        void GetProfile(QString variName, QString &val);
        void clearStatsBuffer(void);
        void setFontForWidgets(void);
        void getOptions();
        void onEndMirror();
        bool checkContinue(bool msg);
        void afterChangepathlog();
        void resetDefaultOptions();
        bool RemoveEmptyDir(QString path);

    public slots:
        void pauseTransfer();
        void onStopAll();
        void displayOutputMsg();
        void displayProgressMsg();
        void processFinished(int exitCode, QProcess::ExitStatus exitStatus);
        bool treeItemClicked(const QModelIndex &m);
        void resizeTabs(QResizeEvent* re);
        void refreshDirModel();

    protected:
        void closeEvent(QCloseEvent *event);
        //         void changeEvent(QEvent* re);

    private slots:
        void threadFinished();
        void newProject();
        void browseSites();
        void setLang(QAction* mnu);
        void quit();
        void loadDefaultOptions();
        void saveDefaultOptions();
        void resetToDefault();
        void loadOptionsFromFile();
        void saveOptionsAs();
        void selectFontSize(QAction* mnu);
        void modifyOptions();
        void setOptions();
        void viewLog();
        void viewErrorLog();
        void viewTransfers();
        void hideWindow();
        void restoreWindow();
        //         void createFontSizeMenu();
        bool readLangDir();
        void checkUpdates();
        void contens();
        void stepByStep();
        void about();
        void aboutQt();
        void iconActivated(QSystemTrayIcon::ActivationReason reason);

    private:
        void createTrayIcon();
        void renameOldToNew();
        void convertTranslateFile();
        QString sizeToText(qint64 s);
        void gOptions(bool d);
        QString getLocaleString();
        int  removeFolder(QDir & dir);
        bool getStrOption(const QString optName, QString& ret);
        bool getIntOption(const QString optName, int& ret);
        void createActions();
        void createToolBars();
        void createStatusBar();
        void loadOptions(QSettings *s);
        void saveOptions(QSettings *s, bool gl);

        void cmdArgumentsOptions();
        void StripControls(QString& st);
        QString change(char* chaine, char c);
        void profile_code(QString& from);
        void profile_decode(QString& from);
        bool checkInstanceRuns();

        void contextMenuEvent(QContextMenuEvent *);

    public:
        QTimer *timerProgressUpdate;
        QTimer *timerDirRefresh;
        QWidget *widgets[6];
        QVector<options> prOptions;
        buttonPanel* buttonsWidget;
        int maxProgressRows;
        int  m_todo;

    private:
        QSharedMemory *_singular;
        QString filename;
        QString selectedLang;
        MyThread* mth;
        QString agumentsLine;
        QStringList lastDirs;
        QVector<QAction*> actLangSelect;
        QVector<QAction*> actFSizeSelect;
        QMenu *langMenu;
        QAction* restAct;
        //         QAction *actionExit;
        //         QAction *actionHide;
        //         QAction *actionRestore;
        QActionGroup* langGroup;
        int dictFormat; // 0 no file, 1 old, 2 new
        // System tray icon

        // System tray menu
        QMenu* trayIconMenu;

    public:
        QStringList lst;
        char* argv[256];
        short argc;
        QProcess* process;
        QString cmdOpt;

        // flag de termination
        int termine;
        static int arretbrutal;
        int termine_requested;
        int shell_terminated;
        bool use_show;
        int soft_term_requested;
        httrackp *global_opt;
        bool inprogress;
        int currentTab;
        QFont sysFont;
        short fontSize;
        QString programStyleSheet;
        QSystemTrayIcon* trayIcon;

        /*static*/
        t_InpInfo SInfo;
        t_StatsBuffer StatsBuffer[NStatsBuffer]; // interface to progres tab
        QStringList translateTable;
        QString currentProject;
        QStringList langFiles;
        DirModel dModel;

        QMutex mutex;
        QString currentOptionsFile;
        QString defaultOptionsFile;
        QString currentWorkDir;
        QString currentAppDir;
        QString helpDir;
        QString langDir;
        QString currentLang;
};

#endif
