/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2013 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#ifndef NEWPROJECTWIDGET_H
#define NEWPROJECTWIDGET_H

#include "ui_NewProjTab.h"
#include "httraqt.h"


class HTTraQt;

class NewProjTab : public QWidget, public Ui_NewProjTab
{
        Q_OBJECT

    public:
        NewProjTab(QWidget* parent = 0, Qt::WFlags fl = 0);
        ~NewProjTab();
        void translate();
        bool testIt();
        void rebuildDirList();
        void selectProj(const QString& name);
        /*$PUBLIC_FUNCTIONS$*/

    protected:
        QStringList currentsubdirs;
        /*$PROTECTED_FUNCTIONS$*/

    protected slots:
        /*$PROTECTED_SLOTS$*/
    private:
        QString editedName;
        HTTraQt* parent;

    private slots:
        void workDirChanged();
        void projectInfoSelected();
        void projectInfoEntered();
        //         void onSelectBatchFile();

        void onBrowseProject();
        //     void onProjectNameChanged();
        void onDirChanged();
        void changeProjname(QString stl);
};

#endif

