/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include "includes/httraqt.h"
#include "includes/ConfirmTab.h"
#include "includes/buttonPanel.h"

buttonPanel::buttonPanel(QWidget *parent, Qt::WFlags fl)
    : QWidget(parent, fl)
{
    setupUi(this);

    this->parent = (HTTraQt*)parent;

    connect(backButton, SIGNAL(clicked()), this, SLOT(onBack()));
    connect(nextButton, SIGNAL(clicked()), this, SLOT(onNext()));
    connect(stopButton, SIGNAL(clicked()), this, SLOT(onStop()));
    connect(helpButton, SIGNAL(clicked()), this, SLOT(onHelp()));

    onButtons(0);
}


void buttonPanel::onStop()
{
    //     disconnect(stopButton, SIGNAL(clicked()), this, SLOT(onStop()));

    // progress tab
    if (parent->currentTab == 4) {
        int ans = messageBox(translateString(_STOPQ), translateString(_STOPPROG), QMessageBox::Question);

        if (ans == QMessageBox::Yes) {
            parent->onStopAll();
        }

        return;
    }

    if (parent->currentTab == 5 || parent->currentTab >= 0 || parent->currentTab <= 3) {
        //         qDebug() << "QUIT???????";
        parent->onQuit();
    }

    //     connect(stopButton, SIGNAL(clicked()), this, SLOT(onStop()));
}


void buttonPanel::translate()
{
    if (parent->programStyleSheet.length() > 0) {
        setStyleSheet(parent->programStyleSheet);
    }

    backButton->setText(translateString(_PREVIOUS));
    helpButton->setText(translateString(_HELP));

    switch (parent->currentTab) {
        case 0: { // start tab
            nextButton->setText(translateString(_NEXT));
            stopButton->setText(translateString(_EXIT));
            break;
        }

        case 1: { // select proj tab
            nextButton->setText(translateString(_NEXT));
            stopButton->setText(translateString(_EXIT));
            break;
        }

        case 2: { // options tab
            nextButton->setText(translateString(_NEXT));
            stopButton->setText(translateString(_EXIT));
            break;
        }

        case 3: { // confirm tab
            nextButton->setText(translateString(_READY));
            stopButton->setText(translateString(_EXIT));
            break;
        }

        case 4: { // progress tab
            nextButton->setText(translateString(_NEXT));
            stopButton->setText(translateString(_STOP));
            break;
        }

        case 5: { // log tab
            nextButton->setText(translateString(_READY));
            stopButton->setText(translateString(_EXIT));
            break;
        }

        default:
            break;
    }
}


void buttonPanel::onButtons(int n)
{
    // for: start; select proj; options; delay; progress; log pages
    unsigned char mask[8] = {0x06, 0x07, 0x07, 0x07, 0x02, 0x06, 0x00};
    unsigned char m;

    if (n < 0 || n > 5) {
        return;
    }

    m = mask[n];

    translate();

    backButton->setEnabled((m & 0x01));
    stopButton->setEnabled((m & 0x02));
    nextButton->setEnabled((m & 0x04));
}


void buttonPanel::onHelp()
{
}


void buttonPanel::onBack()
{
    if (parent->currentTab == 0) {
        return;
    }

    parent->activatePage(parent->currentTab - 1);
}


void buttonPanel::onNext()
{
    if (parent->currentTab == 5) {
        parent->activatePage(0);
        return;
    }

    if (parent->currentTab == 3) {
        if ((*(ConfirmTab*)parent->widgets[3]).label01->isChecked() == false) {
            parent->getMainOptionsFromGUI();
            parent->writeSettings(false); // write project settings
            parent->activatePage(0);
            return;
        }
    }

    parent->activatePage(parent->currentTab + 1);
}

