/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include <QtGui>

#include "includes/StartTab.h"
#include "../icons/httraqt_icon.h"
#include "includes/httraqt.h"
#include "../version.h"


StartTab::StartTab(QWidget *parent, Qt::WFlags fl)
    : QWidget(parent, fl)
{
    setupUi(this);

    this->parent = (HTTraQt*)parent;

    label01->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

    label->setPixmap(QPixmap(httraq_xpm));

    //  guiText = label01->text();
}


void StartTab::translate(void)
{
    QString v;

    if (parent->programStyleSheet.length() > 0) {
        setStyleSheet(parent->programStyleSheet);
    }

    label01->setText(translateString(_WELCOME));
    v = QString().sprintf("%s v.%s (%s)", PROGRAM_NAME, HTTQTVERSION, PROGRAM_DATE);
    l_version->setText(v);
}



