/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include <QtGui>
#include <QProgressBar>
#include <QPushButton>

#ifndef NStatsBuffer
#define NStatsBuffer  14
#endif

#ifdef __cplusplus
extern "C" {
#endif


// #include <htscore.h>
#include "httrack-library.h"
#include "htsopt.h"

extern int hts_is_parsing(httrackp *opt, int flag);
extern int hts_setpause(httrackp *opt, int flag);
extern int hts_is_testing(httrackp *opt);
extern int hts_is_exiting(httrackp *opt);

#ifdef __cplusplus
}
#endif



#include "includes/ProgressTab.h"
#include "includes/httraqt.h"


ProgressTab::ProgressTab(QWidget *parent, Qt::WFlags fl)
    : QWidget(parent, fl)
{
    setupUi(this);

    this->parent = (HTTraQt*)parent;
    this->parent->global_opt = NULL;

    tableWidget->setColumnCount(4);
    //     tableWidget->setColumnHidden(3 , true);
    tableWidget->setRowCount(NStatsBuffer);

    QPalette* palette1 = new QPalette();
    palette1->setColor(QPalette::ButtonText, Qt::red);

    // qDebug() << "progresstab" << NStatsBuffer;
    for (int i = 0; i < NStatsBuffer; i++) {
        tableWidget->setCellWidget(i, 0, new QLabel());

        QProgressBar* pb = new QProgressBar();
        pb->setRange(0, 1000);
        tableWidget->setRowHeight(i, 20);
        tableWidget->setCellWidget(i, 1, pb);

        tableWidget->setCellWidget(i, 2, new QLabel());
        // "<font color=darkred><b>X</b></font>"

        QPushButton *nb;
        nb = new QPushButton("X");
        nb->setToolTip(translateString(_CANCEL)); // cancel downloading of current file
        nb->setPalette(*palette1);
        nb->setHidden(true);
        cancelButtons << nb;

        tableWidget->setCellWidget( i, 3, nb);// for cancelButtons
        //         tableWidget->cellWidget(i, 3)->setHidden(true);

        connect(nb, SIGNAL(pressed()), this, SLOT(cancelDwnload()));
    }

    //     for (int i = 0; i < NStatsBuffer; i++) {
    //         tableWidget->setRowHidden(i, (i >= this->parent->maxProgressRows));
    //     }
}


void ProgressTab::resizeEvent(QResizeEvent *event)
{
    int tableWidth = width();
    tableWidget->setColumnWidth(0, tableWidth * 0.12);
    tableWidget->setColumnWidth(1, tableWidth * 0.50);
    tableWidget->setColumnWidth(2, tableWidth * 0.12); // for size
    tableWidget->setColumnWidth(3, tableWidth * 0.10); // for "cancel" button
}


void ProgressTab::translate()
{
    //     int maxRows = 32;//parent->maxConnections;
    if (parent->programStyleSheet.length() > 0) {
        setStyleSheet(parent->programStyleSheet);
    }

    l_process->setText(translateString(_INPROGRESS) + " " + parent->currentProject);
    groupBox->setTitle(translateString(_INFO));
    l_saved->setText(translateString(_BYTESSAVED));
    l_time->setText(translateString(_TIME));
    l_rate->setText(translateString(_TRRATE));
    l_actconn->setText(translateString(_CONNECTIONS));
    l_scanned->setText(translateString(_LINKSSCANNED));
    l_written->setText(translateString(_FILESWR));
    l_updated->setText(translateString(_FILESUP));
    l_errors->setText(translateString(_ERRORS));

    QStringList horzHeaders;
    horzHeaders << translateString(_OP)
                << QString(translateString(_FILE) + "/" + translateString(_PROGR))
                << translateString(_SIZE)
                << "";

    tableWidget->setHorizontalHeaderLabels(horzHeaders);

    //     for (int i = 0; i < NStatsBuffer; i++) {
    //         tableWidget->setRowHidden(i, (i >= parent->maxProgressRows));
    //     }
}


void ProgressTab::cancelDwnload()
{
    QObject *p;
    p = sender();

    for(int i = 0; i < cancelButtons.count(); ++i) {
        if (p == cancelButtons[i]) {
            hts_cancel_file_push(parent->global_opt, parent->StatsBuffer[i].url_sav.toLatin1());
            break;
        }
    }
}


// Refresh
void ProgressTab::update()
{
    if (parent->global_opt == NULL) {
        return;
    }

    parent->mutex.lock();

    if (!parent->termine) {
        if (parent->SInfo.refresh) {
            hts_is_parsing(parent->global_opt, 0);        // refresh demandé si en mode parsing

            // while(INFILLMEM_LOCKED) Sleep(10);    // attendre au cas où
            if (!parent->termine) {
                inProcessRefresh();    // on refresh!
            }
        }

        //         parent->SInfo.ask_refresh = 1;
    }

    parent->mutex.unlock();
}


void ProgressTab::inProcessRefresh()
{
    static int toggle = 0;

    if (!((!parent->termine) && (!parent->termine_requested))) {
        return;
    }

    if (!parent->SInfo.refresh) {
        return;
    }

    QString lnk;

    l_process->setText(translateString(_INPROGRESS) + " " + parent->currentProject);

    if (parent->SInfo.stat_back) {
        lnk.sprintf("%d/%d (+%d)", parent->SInfo.lien_n, parent->SInfo.lien_tot - 1, parent->SInfo.stat_back);
    } else {
        lnk.sprintf("%d/%d", parent->SInfo.lien_n, parent->SInfo.lien_tot - 1);
    }

    bool isIconic = parent->trayIcon->isVisible();

    // not Iconmodus
    if (isIconic == false) {
        bool parsing = false;

        if (!parent->soft_term_requested) {
            if (!hts_setpause(parent->global_opt, -1)) {
                if (!(parsing = hts_is_parsing(parent->global_opt, -1))) {
                    inforun->setText(translateString(_RECFILES));
                } else {
                    switch (hts_is_testing(parent->global_opt)) {
                        case 0:
                            inforun->setText(translateString(_PARSHTML));
                            break;

                        case 1:
                            inforun->setText(translateString(_TESTINGLINKS));
                            break;

                        case 2:
                            inforun->setText(translateString(_PURG));
                            break;

                        case 3:
                            inforun->setText(translateString(_LCACHE));
                            break;

                        case 4:
                            inforun->setText(translateString(_WAITTIME));
                            break;

                        case 5:
                            inforun->setText(translateString(_TRDATA));
                            break;
                    }
                }
            } else {
                if (((toggle++) / 5) % 2) {
                    inforun->setText(translateString(_PAUSED));
                } else {
                    inforun->setText("");
                }
            }
        } else {
            if (((toggle++) / 5) % 2) {
                inforun->setText(translateString(_STOPNOW));
            } else {
                inforun->setText("");
            }
        }

        if (parent->SInfo.stat_time > 0) {
            QString st = QString::number(parent->SInfo.stat_time);
            i1->setText(st);        // time
        } else {
            QString st = QString::number(parent->SInfo.stat_time);
            i1->setText(st);          // time
        }

        float mbytes = parent->SInfo.stat_bytes / 1e6;

        if (mbytes > 1.0 && mbytes < 1024.0) {
            i0->setText(QString().sprintf("%.2f MB", mbytes));       // bytes
        } else if (mbytes > 1024.0) {
            i0->setText(QString().sprintf("%.4f GB", mbytes / 1024.0));     // bytes
        } else {
            i0->setText(QString::number(parent->SInfo.stat_bytes));
        }

        i2->setText(lnk);    // scanned

        if (parent->SInfo.stat_nsocket > 0 && parent->SInfo.stat_nsocket < 32) {
            QString st = QString::number(parent->SInfo.stat_nsocket);
            i3->setText(st);          // socks
        } else {
            i3->setText("none");       // wait
        }

        QString st;

        if (parent->SInfo.rate < 0 || parent->SInfo.rate > 1e6) {
            parent->SInfo.rate = 0;
        }

        st.sprintf("%d (%d)", parent->SInfo.irate, parent->SInfo.rate);

        i4->setText(st);    // rate

        i5->setText(QString::number(parent->SInfo.stat_errors));

        i6->setText(QString::number(parent->SInfo.stat_written));

        QString tempo;
        int pc = 0;

        if (parent->SInfo.stat_written) {
            pc = (int)((parent->SInfo.stat_updated * 100) / (parent->SInfo.stat_written));
        }

        if (pc) {
            tempo.sprintf("%d (%d%%)", parent->SInfo.stat_updated, pc);
        } else {
            tempo.sprintf("%d", parent->SInfo.stat_updated);
        }

        i7->setText(tempo);

        for (int j = 0; j < NStatsBuffer; j++) {
            tableWidget->setRowHidden(j, (j >= parent->maxProgressRows));
            //         tableWidget->cellWidget(i, 3)->setHidden(false);
        }

        /*if (!parsing)*/
        {
            {
                for(int i = 0; i < NStatsBuffer; i++) {
                    if (parent->StatsBuffer[i].sizetot > 0) {
                        TStamp d = ((TStamp) parent->StatsBuffer[i].size * 1000);
                        d = d / ((TStamp) parent->StatsBuffer[i].sizetot);
                        parent->StatsBuffer[i].offset = (int) d;
                    } else {
                        parent->StatsBuffer[i].offset = 0;
                    }
                }
            }

            QProgressBar *p;

            if (!parsing) {
                p = (QProgressBar *) tableWidget->cellWidget(0, 1);
                p->setRange(0, 1000);

                p = (QProgressBar *) tableWidget->cellWidget(0, 1);
                p->setValue(parent->StatsBuffer[0].offset);
            }

            for (int j = 1; j < 14; j++) {
                p = (QProgressBar *) tableWidget->cellWidget(j, 1);
                p->setRange(0, 1000);

                p = (QProgressBar *) tableWidget->cellWidget(j, 1);
                p->setValue(parent->StatsBuffer[j].offset);
            }

            // redraw en boucle
            {
                int i = 0;

                if (parsing) {
                    i++;
                }

                for( ; i < NStatsBuffer; i++) {
                    QString st;
                    QLabel *ti = (QLabel*) tableWidget->cellWidget(i, 0);
                    st = parent->StatsBuffer[i].state;
                    st.replace("&", "&&");

                    if (st.length() == 0) {
                        //tableWidget->cellWidget(i, 3)->setHidden(true);
                        if (tableWidget->isRowHidden(i) == false){
                            tableWidget->setRowHidden(i, true);
                        }
                    } else {
                        //tableWidget->cellWidget(i, 3)->setHidden(false);
                        if (tableWidget->isRowHidden(i) == true){
                            tableWidget->setRowHidden(i, false);
                        }
                        ti->setText(st);

                        p = (QProgressBar *) tableWidget->cellWidget(i, 1);
                        //ti = (QLabel*) tableWidget->cellWidget(i, 1);
                        st = parent->StatsBuffer[i].name;
                        st.replace("&", "&&");
                        p->setFormat( st);

                        st = parent->StatsBuffer[i].file;
                        st.replace("&", "&&");
                        p->setToolTip(st);

                        if (!parsing) {
                            if ((parent->StatsBuffer[i].state.length() == 0) != parent->StatsBuffer[i].actived) {
                                parent->StatsBuffer[i].actived = !parent->StatsBuffer[i].actived;

                                if (!parent->StatsBuffer[i].actived) {
                                    tableWidget->cellWidget(i, 3)->setHidden(true);
                                } else {
                                    tableWidget->cellWidget(i, 3)->setHidden(false);
                                }

                                //                         inprogress->element[3][i]->RedrawWindow();
                            }
                        } else {
                            tableWidget->cellWidget(i, 3)->setHidden(true);
                        }
                    }
                }
            }
            //
        }

        /* else*/
        if (parsing) {  // parsing
            //
            QProgressBar *p;
            p = (QProgressBar *) tableWidget->cellWidget(0, 1);
            p->setRange(0, 100);
            p->setValue(parsing);
            //             inprogress->m_sl0.SetRange(0, 100);
            //             inprogress->m_sl0.SetPos(parsing);
            QLabel *ti = (QLabel*) tableWidget->cellWidget(0, 0);
            ti->setText(translateString(_SCANNING));
            //             SetWindowTextCP(inprogress->element[0][0], LANG(LANG_F14 /*"scanning","parcours"*/));
            p = (QProgressBar *) tableWidget->cellWidget(0, 1);
            p->setFormat(parent->StatsBuffer[0].name);

            //             tableWidget->cellWidget(0, 3)->setHidden(true);
            //             SetWindowTextCP(inprogress->element[4][0], "");
            //inprogress->element[0][1]->SetWindowTextCP(this, );
        }
    }


    QString info;
    QTableWidgetItem * ti;

    if ((parent->SInfo.stat_nsocket == -1)) {
        ti = tableWidget->item(0, 0);

        if (ti == NULL) {
            return;
        }

        ti->setText(translateString(_WAITSPECHOUR));

        if (isIconic == true /*&& ( !this_CSplitterFrame->iconifie )*/) {    // minimise mais pas en icone
            info.sprintf("[%d s]", parent->SInfo.stat_time);
            parent->trayIcon->setToolTip(info);
        } else {
            info =  translateString(_MIRRWAIT);
            info.replace("%d", QString::number(parent->SInfo.stat_time));
        }
    } else {
        if (isIconic == true ) {    // iconmodus
            info = QString("[" +  lnk + "]");
            parent->trayIcon->setToolTip(info);
        } else {
            QString byteb;

            if (parent->SInfo.stat_bytes > 1e6) {
                byteb = QString().sprintf("%.2f MB", parent->SInfo.stat_bytes / 1e6);     // bytes
            } else {
                byteb = QString().sprintf("%d B", parent->SInfo.stat_bytes);
            }

            info = translateString(_MIRRINPROGRESS);

            if (byteb.length() > 0) {
                info.replace("%s,", QString(lnk + ","));
                info.replace("%s", QString(byteb));
            } else {
                info.replace(", %s", lnk);
            }
        }
    }

    static QString last_info = "";

    if (info != last_info) {    /* a change */
        if (info.length() > 0) {
            last_info = info;
            parent->setWindowTitle(last_info);
        }
    }

    //             parent->clearStatsBuffer();
}



