/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include <QtGui>

#include "includes/httraqt.h"
#include "includes/InsertUrlDialog.h"


InsertUrlDialog::InsertUrlDialog(QWidget *parent)
    : QDialog(parent)
{
    setupUi(this);

    this->parent = (HTTraQt*)parent;

    connect(label2, SIGNAL(clicked()), this, SLOT(close()));
    connect(label1, SIGNAL(clicked()), this, SLOT(onOk()));

    translate();
}


void InsertUrlDialog::translate()
{
    if (parent->programStyleSheet.length() > 0) {
        setStyleSheet(parent->programStyleSheet);
    }

    groupBox->setTitle(translateString(_AUTH));
    label1226->setText(translateString(_LOGIN));
    label1227->setText(translateString(_PASS));
    label2->setText(translateString(_CANCEL));
    label1->setText(translateString(_OK));
}


void InsertUrlDialog::onOk()
{
    m_urllogin = label1233->text();
    m_urlpass = label1232->text();
    m_urladr = label1234->text();
    accept();
}




