/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include <QDesktopServices>
#include <QUrl>

#include "includes/httraqt.h"
#include "includes/FinalTab.h"


FinalTab::FinalTab(QWidget *parent, Qt::WFlags fl)
    : QWidget(parent, fl)
{
    setupUi(this);

    this->parent = (HTTraQt*)parent;

    connect(label3, SIGNAL(clicked()), this, SLOT(onViewLog()));
    connect(label4, SIGNAL(clicked()), this, SLOT(onBrowseLocalWebsite()));
}


void FinalTab::translate(void)
{
    if (parent->programStyleSheet.length() > 0) {
        setStyleSheet(parent->programStyleSheet);
    }

    label3->setText(translateString(_VIEWLOG));
    label4->setText(translateString(_BROWSEWEBSITE));
}


void FinalTab::onViewLog()
{
    QDesktopServices::openUrl(QUrl::fromLocalFile(qPrintable( parent->currentWorkDir + "/" + parent->currentProject + "/hts-log.txt")));
}

void FinalTab::onBrowseLocalWebsite()
{
    QDesktopServices::openUrl(QUrl::fromLocalFile(parent->currentWorkDir + "/" + parent->currentProject + "/index.html"));
}


