/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include <QtGui>
// #include <QDesktopServices>
#include <QUrl>

#include "includes/httraqt.h"
#include "includes/AboutDialog.h"
#include "../icons/httraqt_icon.h"
#include "../version.h"


AboutDialog::AboutDialog(QWidget *parent, Qt::WFlags fl)
    : QDialog(parent, fl)
{
    setupUi(this);

    this->parent = (HTTraQt*)parent;

    setStyleSheet(this->parent->programStyleSheet);

    translate();
    connect(pushButton, SIGNAL(clicked()), this, SLOT(reject()));
    label_2->setPixmap(QPixmap(httraq_xpm));

    adjustSize();
}


void AboutDialog::translate()
{
    if (parent->programStyleSheet.length() > 0) {
        setStyleSheet(parent->programStyleSheet);
    }

    pushButton->setText(translateString(_CLOSE));

    QString str2 = translateString(_NOTIFY);
    str2.replace("\n", "<br>");

    //    QString str3 = ;
    QString str4 = translateString(_VISITPAGE);

    QString outStr = QString().sprintf(PROGRAM_FULL_NAME, HTTQTVERSION) + "<br>" + str2 + "<br><br>" + str4;
    outStr += QString().sprintf("<br>HTTrack <a href=\"%s\">%s</a>", HTTRACK_STR, HTTRACK_STR);
    outStr += QString().sprintf("<br>HTTraQt <a href=\"%s\">%s</a>", HTTRAQT_STR, HTTRAQT_STR);

    label->setText(outStr);

    // В знак благодарности вы можете:
    // Поделиться ссылкой на программу
    // Написать о неточностях, ошибках в программе
    // Отблагодарить в денежном эквиваленте
    QString l = QString().sprintf(" <a href=\"%s\">PayPal link</a>", DONATE_STR);
    QString t = "<b>" + translateString(_HOW_THANK) + "</b><br><br>"
                "- " + translateString(_SHARE_LINK) + "<br>"
                "- " + translateString(_REPORT_BUG) + "<br>"
                "- " + translateString(_MAKE_DONATE) + l;

    label_3->setText(t);
    label_3->setTextFormat(Qt::RichText);
    label_3->setTextInteractionFlags(Qt::TextBrowserInteraction);
    label_3->setOpenExternalLinks(true);
}

