<?php

//    include/en.inc.php
//    English sentences and messages
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: en.inc.php,v 1.20 2004/06/01 08:56:19 angusgb Exp $

if ( defined( '__ENGLISH_INC' ) ) return;
define( '__ENGLISH_INC', 1 );

/* Main Page */
$strMainPage   =  "Main Page";
$strNumDBs     =  "\$numdbs ht://Check databases have been found on \$hostname";
$strNoDBs      =  "Sorry. No ht://Check databases have been found on \$hostname";
$strChooseaDB  =  "Choose";
$strSelectaDB  =  "Select a database";

/* Main page of a database */

$strDBSelected =  "Database '<strong>\$dbname</strong>' selected";
$strGeneralInfo   = "General info";
$strServersEncountered  =  "Servers encountered";
$strScheduledURLS =  "Scheduled URLS (both visited and discarded)";
$strRetrievedURLS =  "Retrieved URLS";
$strHTMLStatements   =  "HTML statements";
$strHTMLAttributes   =  "HTML attributes";
$strLinks      =  "Links";
$strShowListUrls        =  "Show the complete URLs list";
$strShowListUrlsSeen    =  "Show the list of URLs that have been seen";
$strShowNotFoundUrls    =  "Show the list of not found URLs (Status code 404)";
$strShowListLinks       =  "Show the list of links retrieved";
$strShowListUrlsFltr    =  "Show the retrieved URLs list (with filter)";

$strHTTPRequestsResults    =  "Summary of HTTP requests results";
$strServersSeenOrdIDServer =  "Summary of HTTP Servers that have been seen (ordered by requests)";
$strConnectionResults      =  "Summary of Connection results";
$strContentTypeResults     =  "Summary of Content-Type encountered";
$strCookiesReport     =  "Summary of the cookies retrieved";
$strUser    =  "MySQL user who performed the crawl";
$strStartTime  = "Start Time";
$strEndTime  = "End Time";

/* Sections */
$strListofUrls =  "List of retrieved Urls";
$strListofAllUrls =  "List of retrieved and not retrieved Urls";
$strListofLinks =  "List of the links";
$strShowUrl    =  "URL info";
$strShowLink   =  "Link info";
$strShowUrlSource    =  "URL Source";
$strDBHome =  "'<strong>\$dbname</strong>' Home Page";
$strDBDeletion =  "Database deletion";
$strDBDeleted  =  "Database '<strong>\$dbname</strong>' dropped";

/* General */

$strUrl              =  "URL";
$strRequests         =  "Requests";
$strProtocol         =  "Protocol";
$strConnectionStatus =  "Connection Status";
$strContentType      =  "Content type";
$strCharset          =  "Charset";
$strDocType          =  "DocType";
$strContentLanguage  =  "Content language";
$strTransferEncoding =  "Transfer Encoding";
$strStatusCode       =  "Status Code";
$strReasonPhrase     =  "Reason Phrase";
$strNumber           =  "Number";
$strNoOccurrencies   =  "No occurrencies";
$strWebServerInfo    =  "Web Server Info";
$strLastModified     =  "Last modified time";
$strNoLastModified   =  "not available";
$strLastAccess       =  "Last access time";
$strNoLastAccess     =  "not available";
$strLocation         =  "Location";
$strSize             =  "Size";
$strTitle            =  "Page title";
$strDescription      =  "Page description";
$strKeywords         =  "Page keywords";
$strSizeAdd          =  "Size of resources loaded together (images, sounds, ...)";
$strPageWeight       =  "Total weight of the page (caching supposed)";
$strRetrievingFlag   =  "URL marked as";
$strLinkType         =  "Link type";
$strLinkResult       =  "Result";
$strLinkDomain       =  "Link domain";
$strHTMLStatement    =  "HTML statement";
$strHTMLStatementRow =  "Row number of HTML statement";
$strHTMLAttribute    =  "HTML attribute";
$strAnchor           =  "Anchor";
$strReferer          =  "Referer URL";
$strHopCount         =  "Hop count (distance in clicks from the starting page)";
$strUnknown          =  "Unknown";
$strOther            =  "Other";
$strNull             =  "Not defined";
$strServer           =  "Select a server";

/* Page Management */
$strRecordFound   =  "Records found:";
$strListPageInfo  =  "List from n. %s to %s out of %s records found";
$strNext          =  "Next";
$strPrevious      =  "Previous";
$strFirst         =  "First";
$strLast          =  "Last";
$strBack          =  "Back";
$strAll           =  "Full list";

/* Filters */
$strFilterLinks   =  "Set the filter for the list of links";
$strLike          =  "Like";
$strNotLike       =  "Not like";
$strRegExp        =  "RegExp";
$strNotRegExp     =  "Not RegExp";
$strGt            =  "Greater than";
$strLt            =  "Less than";

/* List of links page */
$strLinkSubmit    =  "Submit";
$strAllLinks      =  "All of them";
$strOK            =  "OK";
$strNotChecked    =  "Not checked";
$strBroken        =  "Broken link";
$strRedirected    =  "Redirected link";
$strAnchorNotFound =  "Anchor not found";
$strNotAuthorized =  "Not Authorized";
$strEMail         =  "E-m@il address";
$strJavascript    =  "Javascript URL";
$strBadEncoded    =  "Bad encoded URL";
$strNormal        =  "Normal link";
$strDirect        =  "Direct link";
$strRedirection   =  "HTTP Redirection";
$strSameServer    =  "Same Web server (host:port)";
$strInternal      =  "Internal";
$strExternal      =  "External";
$strHelpOnString  =  "You can set patterns to be matched with '$strLike' "
                     . "and '$strNotLike'. The first, gives you back results that "
                     . "match your SQL pattern, whereas the latter gives back those "
                     . "that don't match it. You can use wildcard characters like "
                     . "'%' (any sequence of characters) and '_' (any single "
                     . "character).";
$strHelpOnRegExp  =  "By choosing the '$strRegExp' option, you can use the extended "
                     . "regular expression match. Results that match your expression "
                     . "are given back. In order to obtain those records that "
                     . "don't match your regular expression, use '$strNotRegExp'."; 

/* Show Url page */
$strFilterUrls       =  "Set the filter for the list of URLs";
$strInfoAvailable    =  "Info available";
$strSizeInfo         =  "Info about the size of the resource";
$strRetrievingInfo   =  "Info about the retrieving process";
$strOutgoingLinks    =  "Info about outgoing links";
$strIncomingLinks    =  "Info about incoming links";
$strNotRetrieved     =  "URL not retrieved";
$strShow             =  "Show";
$strAllCTypes        =  "All";
$strAllCharsets      =  "All";
$strAllDocTypes      =  "All";
$strAllSCodes        =  "All";

/* Show Link page */
$strReferencingUrl   =  "Referencing URL";
$strReferencedUrl    =  "Referenced URL";
$strLinkIssued       =  "This link has been issued by";
$strOperations       =  "Available operations";
$strOpenThisUrl      =  "Open this URL in a new window";
$strShowThisUrlSource   =  "Show the HTML source of this URL in a new window";
$strShowTidyReport   =  "Show the output generated by 'tidy' for this URL";
$strOpenReferencingUrl  =  "Open referencing URL in a new window";
$strOpenReferencedUrl   =  "Open referenced URL in a new window";

/* Database Drop Page */
$strDBDropSure =  "Are you sure you want to drop the database? "
                  . "All data will be lost forever";
$strDBDrop     =  "Yes, I want to drop the database";
$strDBCancel   =  "No, I'd better keep it alive";

/* Web structure mining indexes */
$strWSM_Notes = 'Notes';
$strWSM_Indexes = "Indexes of Web Structure Mining";
$strWSM_L = "<strong>L</strong>: links, both ingoing (from different documents) and outgoing for this URL";
$strWSM_D = "<strong>D</strong>: documents, related to this URL by both outgoing and incoming links";
 
$strWSM_OL = "<strong>OL</strong>: outgoing links from this URL to others";
$strWSM_IL = "<strong>IL</strong>: incoming links coming to this URL from different ones";
$strWSM_OD = "<strong>OD</strong>: documents linked to this URL by outgoing links within it";
$strWSM_ID = "<strong>ID</strong>: documents which have links to this URL";
$strWSM_NumOL = "Number of OL";
$strWSM_NumIL = "Number of IL";
$strWSM_NumOD = "Number of OD";
$strWSM_NumID = "Number of ID";
$strWSM_ProOL = "OL/L";
$strWSM_ProIL = "IL/L";
$strWSM_ProOD = "OD/D";
$strWSM_ProID = "ID/D";
$strWSM_RatioL = "OL/IL";
$strWSM_RatioD = "OD/ID";
$strWSM_ExplaL = "Characteristics of links";
$strWSM_ExplaD = "Characteristics of linked  documents";
$strWSM_ExplaIn = "Incoming";
$strWSM_ExplaOut = "Outgoing";
$strWSM_Ratios = "Rapporti";

/* Tidy support */
$strTidyMessages    = "The execution of 'tidy' produced the following 'messages'";
$strTidyWarnings    = "The execution of 'tidy' produced the following 'warnings'";
$strTidyErrors    = "The execution of 'tidy' produced the following 'errors'";
$strTidyHTML    =  "Here is the HTML source code proposed by 'tidy'";
$strTidyRow    =  "row";
$strTidyColumn    =  "column";
$strErrorNoTidy    =  "Error! The application for the validation of the HTML source code (tidy) is not properly set. Look at the configuration file";
$strErrorNoDirTmp    =  "Error! The temporary directory for tidy is not valid. Check the configuration file";
$strErrorFileTmp    =  "Error! It is impossibile to write a temporary file for tidy. Check the permissions for the user the Web server is running as, in the temporary directory";

/* Errors */
$strErrorNoDBSelected   =  "Error! No database has been selected. Go back.";
$strErrorNoUrlSelected  =  "Error! No Url has been selected. Go back.";
$strErrorMissingInfo    =  "Error! Missing Info. Go back.";

/* Open Accessibility Checks (http://checker.atrc.utoronto.ca/) */

$strShowListAchecks      =  "Show the list of accessibility checks (with filter)";
$strListAchecks =  'List of the accessibility errors that have been discovered';
$strAcheckInfo = 'Information regarding the accessibility error';
$strAcheckError = 'Error';
$strAcheckDescription = 'OAC description';
$strAcheckHowToRepair = 'How to repair';
$strAcheckCode       =  "Error code:";
$strSelectAchecks = 'Choose which accessibility errors to search';

$strAchecks = array();

// OAC #1
$strAchecks[1] = array(
	'description' => 'All IMG elements must have an ALT attribute',
	'error' => 'IMG missing ALT attribute',
	'repair' => 'Add an ALT attribute to your IMG element'
);

// OAC #2 
$strAchecks[2] = array(
	'description' => 'IMG element cannot have ALT attribute value '
		. 'that is the same as its SRC attribute',
	'error' => 'Suspicious ALT text (same as filename)',
	'repair' => ''
);

// OAC #3 
$strAchecks[3] = array(
	'description' => 'IMG element must have ALT attribute value of '
		. 'less than 150 characters (English)',
	'error' => 'ALT text may be too long (greater than 150 characters)',
	'repair' => ''
);

// OAC # 7
$strAchecks[7] = array(
	'description' => 'IMG element cannot have ALT attribute value of '
		. 'null or whitespace if the IMG element is contained by an '
		. 'A element',
	'error' => 'Image used as anchor is missing valid ALT text',
	'repair' => 'Modify the text in the ALT attribute to your IMG element'
);

// OAC #27 
$strAchecks[27] = array(
	'description' => 'This error is generated for all BLINK elements',
	'error' => 'BLINK element used',
	'repair' => 'Remove the BLINK element (replace with STRONG or EM)'
);

// OAC #37 
$strAchecks[37] = array(
	'description' => 'First heading element prior to H2 element must be '
		. 'an H1 element',
	'error' => 'Header nesting - H2 does not follow an H1',
	'repair' => 'Modify the header levels so H2 follows H1'
);

// OAC #38 
$strAchecks[38] = array(
	'description' => 'First heading element prior to H3 element must be '
		. 'an H2 element',
	'error' => 'Header nesting - H3 does not follow an H2',
	'repair' => 'Modify the header levels so H3 follows H2'
);

// OAC #39 
$strAchecks[39] = array(
	'description' => 'First heading element prior to H4 element must be '
		. 'an H3 element',
	'error' => 'Header nesting - H4 does not follow an H3',
	'repair' => 'Modify the header levels so H4 follows H3'
);

// OAC #40 
$strAchecks[40] = array(
	'description' => 'First heading element prior to H5 element must be '
		. 'an H4 element',
	'error' => 'Header nesting - H5 does not follow an H4',
	'repair' => 'Modify the header levels so H5 follows H4'
);

// OAC #41 
$strAchecks[41] = array(
	'description' => 'First heading element prior to H6 element must be '
		. 'an H5 element',
	'error' => 'Header nesting - H6 does not follow an H5',
	'repair' => 'Modify the header levels so H6 follows H5'
);

// OAC #48 
$strAchecks[48] = array(
	'description' => 'HTML element must contain a LANG attribute',
	'error' => 'Document language not identified',
	'repair' => 'Add a LANG attribute to the HTML element of your '
		. 'document. The LANG attribute must be set to a valid 2 or '
		. '3 letter language code as defined in the ISO specification 639'
);

// OAC #50 
$strAchecks[50] = array(
	'description' => 'TITLE element must be present in HEAD section of document',
	'error' => 'Document missing TITLE element',
	'repair' => 'Add a TITLE element to the HEAD section of your document'
);

// OAC #51 
$strAchecks[51] = array(
	'description' => 'TITLE element content cannot be empty or whitespace',
	'error' => 'TITLE element is empty',
	'repair' => 'Add text to the TITLE element'
);

// OAC #52 
$strAchecks[52] = array(
	'description' => 'TITLE element content must be less than 150 '
		. 'characters (English)',
	'error' => 'TITLE text may be too long',
	'repair' => ''
);

// OAC #58 
$strAchecks[58] = array(
	'description' => 'INPUT element that contains a TYPE attribute '
		. 'value of "image" must have an ALT attribute',
	'error' => 'Image used for INPUT control is missing ALT text',
	'repair' => 'Add an ALT attribute that describes the image to INPUT control'
);

// OAC #116 
$strAchecks[116] = array(
	'description' => 'This error will be generated for all B elements',
	'error' => 'B element used (use EM or STRONG instead)',
	'repair' => 'Replace your B elements with EM or STRONG'
);

// OAC #117 
$strAchecks[117] = array(
	'description' => 'This error will be generated for all I elements',
	'error' => 'I element used (use EM or STRONG instead)',
	'repair' => 'Replace your I elements with EM or STRONG'
);

/*
// OAC #NUM 
$strAchecks[NUM] = array(
	'description' => 'TXT',
	'error' => 'TXT',
	'repair' => 'TXT'
);
*/

?>
