///////
   //    HtmlAttribute.cc
   //    HtmlAttribute Class definitions
   //
   //    Class for Html statements
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: HtmlAttribute.cc,v 1.7 2003/12/30 09:38:47 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#ifdef HAVE_CONFIG_H
#include "htconfig.h"
#endif /* HAVE_CONFIG_H */

#include "HtmlAttribute.h"

   // Static variables initialization
      int HtmlAttribute::debug = 0;

///////
   //    Construction
///////

HtmlAttribute::HtmlAttribute()
{
   Reset();
}

///////
   //    Destruction
///////

HtmlAttribute::~HtmlAttribute ()
{
}

///////
   //    Reset the schedule content
///////

void HtmlAttribute::Reset()
{
   IDUrl = 0;
   TagPosition = 0;
   AttrPosition = 0;
   Attribute = 0;
   Content = 0;
}


///////
   //    Output HtmlAttribute object
///////

ostream& operator<<(ostream& output, const HtmlAttribute& s)

{
   output << s.IDUrl << " / " << s.TagPosition << " / " << s.AttrPosition;
   
   if (s.debug < 3) return output;
   
   // Only if debug level is greater than 2
   
   output << " (Attribute : " << s.Attribute << " - Content <"
      << s.Content << ">)";
   
   return output;
}
