/***************************************************************************
 *   Copyright (C) 2008 by Paul Hardwick,,,   *
 *   paul@peck.org.uk   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/* $Id: main.c 117 2008-10-25 23:29:49Z paul $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

/* -------------------------------------------------------------------------------------------*/
/* Usage :     hsolinkcontrol down dev_num #bring down hso link and restore resolv.conf                      */
/*             hsolinkcontrol up dev_num dns1 dns2 ip #bring up link and create new resolv.conf              */
/*             hsolinkcontrol bind|unbind para1 para2 #attempt to manage USB driver ;)
/* -------------------------------------------------------------------------------------------*/

int main (argc, argv)
     int argc;
     char *argv[];


{
    char xbuffer[512],buffer[512],cmd[128];
    int resolvconf, res;
    FILE *sfp;
    setreuid(0,0);

    if (argc == 4) { /* bind|unbind */
        if (strcmp(argv[1],"bind") == 0){
            sprintf(buffer,argv[2],"bind");
            sfp = fopen( buffer,"w");
            fprintf(sfp,argv[3]);
            fflush(sfp);
            fclose(sfp);
            return(0);
        }
        else if (strcmp(argv[1],"unbind") == 0){
            sprintf(buffer,argv[2],"unbind");
            sfp = fopen( buffer,"w");
            fprintf(sfp,argv[3]);
            fflush(sfp);
            fclose(sfp);
            return(0);
        }
        
    }
    sfp = fopen("/sbin/resolvconf","r");
    if (sfp == NULL) {
        resolvconf = 0;
        printf("Direct control of resolv.conf.\n");
    }
    else {
        resolvconf = 1;
        printf("Using resolvconf.\n");
        fclose(sfp);
    }

    if (argc == 3) {    /* the down */
        if (strcmp(argv[1],"down") == 0){
            if (resolvconf == 1){
                sprintf(buffer, "/sbin/resolvconf -d hso%s",argv[2]);
                res = system(buffer);
                if (res != 0) {
                   printf("File access error /sbin/resolvconf . Permissions?\n");
                    return(1);
                }
                sprintf(buffer,"route delete default dev hso%s",argv[2]);
                res = system(buffer);
                if (res != 0) {
                   printf("File access error `route` . Permissions?\n");
                    return(1);
                }
                 return(0);
            }
            /* else use standard overwrite scheme */
            else {
            	sprintf(buffer,"mv -f /etc/resolv.conf.hsoc%s.tmp /etc/resolv.conf",argv[2]);
            	res = system(buffer);
                if (res != 0) {
                   printf("File access error /etc/resolv.conf . Permissions?\n");
                    return(1);
                }
            }
        sprintf(buffer,"/sbin/ifconfig hso%s down",argv[2]);    	
        res = system(buffer);
        if (res != 0) {
           printf("File access error /sbin/ifconfig . Permissions?\n");
           return(1);
        }
        
        return(0);
        }
        else return(1);
    }
    else if(argc == 6) { /* the up */
        if (strcmp(argv[1],"up") == 0){
            sprintf(buffer,"#Created by hsolinkcontrol\nnameserver %s\nnameserver %s\n",argv[3],argv[4]);
            printf(buffer);
            if (resolvconf == 1){
                sprintf(cmd,"/sbin/resolvconf -a \"hso%s\"",argv[2]);
                sfp = popen(cmd,"w");
                if (sfp == NULL) {
                   printf("File access error /sbin/resolvconf . Permissions?\n");
                    return(1);
                }

                fprintf(sfp,buffer);
                fflush(sfp);
                pclose(sfp);
            }
            else {
                sprintf(xbuffer,"cp -f /etc/resolv.conf /etc/resolv.conf.hsoc%s.tmp",argv[2]);
                system(xbuffer);
                sfp = fopen("/etc/resolv.conf","w");
                if (sfp == NULL) {
                    printf("File access error /etc/resolv.conf . Permissions?\n");
                    return(1);
                }
                fprintf(sfp,buffer);
                fflush(sfp);
                fclose(sfp);
                printf("\ncopied resolv.conf\n");
            }
            sprintf(buffer,"/sbin/ifconfig hso%s %s netmask 255.255.255.255 up",argv[2],argv[5]);
            printf(buffer);
            res = system(buffer);
               if (res != 0 ){
                   printf("File access error /sbin/ifconfig . Permissions?\n");
                    return(1);
                }
            sprintf(buffer,"/sbin/route add default dev hso%s",argv[2]);
            res = system(buffer);
               if (res != 0) {
                   printf("File access error /sbin/route . Permissions?\n");
                    return(1);
                }
            printf("\nadded route\n");
            return(0);
        }
    }
    else { 
        printf("hsolinkcontrol Version: 0.4 build:%s - see man page for details\n",VERSION);
        printf("Usage :     hsolinkcontrol down port_num #bring down hso link and restore resolv.conf\n            hsolinkcontrol up port_num dns1 dns2 ip #bring up link and create new resolv.conf\n");
        return(0);
    }
   return(1);
 
}


