-- An utility to split a source Haskell file
-- generated by hsffig into smaller parts as guided
-- by the special comments found in the file.

module Main where

import System.Environment
import System.IO
import Control.Monad
import Maybe

import SplitBounds

main = do
       args <- getArgs
       case args of
         [] -> usage
         other -> splitModule $ head args

-- Print the usage information.

usage = putStrLn "Usage: splitter filename"

-- Do the actual module split. The file name is expected
-- to be in the form [path/]MODULENAME[.suffix]. Path will be preserved.
-- Suffix will be replaced with .hs. Names of modules will be derived from
-- MODULENAME.

splitModule fn = do
  let [fnname, fnpath] = map reverse $ (\t -> [fst t, snd t]) $ break ( == '/') $ reverse fn 
      (modbase, fnsuffix) = break ( == '.') fnname

-- Open the file

  src <- (readFile fn)

  let srcln = lines src 

  procLines Nothing fnpath srcln

  return ()

-- Line-by-line processor.

procLines _ _ [] = return ()

procLines handle fnpath (l:ls) = do
  let derivefn  app = fnpath ++ app ++ ".hs"
      skipline = do procLines handle fnpath ls
                    return ()
      startfile app = do handle' <- openFile (derivefn app) WriteMode
                         procLines (Just handle') fnpath ls
                         return ()
      endfile = do when (handle /= Nothing) $ hClose (fromJust handle)
                   procLines Nothing fnpath ls
                   return ()
      nextline = do when (handle /= Nothing) $ hPutStrLn (fromJust handle) l
                    procLines handle fnpath ls
                    return ()
  case l of
    _ | l == splitOpen -> skipline                    -- these comments
    _ | l == splitClose -> skipline                   -- are removed
    _ | (takeWhile (/= '/') l) == splitBegin -> startfile $ drop 1 $ dropWhile (/= '/') l
    _ | l == splitEnd -> endfile
    other -> nextline
  return ()


