#ifndef DEVICE_H
#define DEVICE_H

/*
   device.h - Interface of the Device class

   Copyright (C) 2003 Tim Stadelmann

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/



/** HEADERS **/

/* Class declarations in place of headers.  */
class QString;


/** MACROS **/

#define BUFFER_LENGTH 256

class Device
{
 public:
  Device (QWidget *parent_arg,
	  const unsigned int ide_controller_arg,
	  QString hotswap_path_arg);
  ~Device ();
  bool present ();
  QString name ();
  bool insert ();
  bool remove ();
  bool mounted ();
 private:
  QWidget *parent;
  unsigned int ide_controller;
  QString hotswap_path;
  bool present_flag;
  char model_string[40];
  char buffer[BUFFER_LENGTH];
  void probe ();
  bool call_backend (QString arguments);
};

#endif /* DEVICE_H */
