-- $Horde: horde/scripts/sql/create.msde.sql,v 1.1.2.2 2006/03/21 02:07:30 selsky Exp $

USE master
GO

CREATE DATABASE horde
GO

EXEC sp_addlogin 'horde', 'horde_mgr', 'horde'
GO

USE horde
GO

EXEC sp_grantdbaccess 'horde'
GO

CREATE TABLE horde_users (
    user_uid VARCHAR(255) NOT NULL,
    user_pass VARCHAR(255) NOT NULL,

    PRIMARY KEY (user_uid)
)
GO

GRANT SELECT, INSERT, UPDATE, DELETE ON horde_users TO horde
GO

CREATE TABLE horde_prefs (
    pref_uid VARCHAR(200) NOT NULL,
    pref_scope VARCHAR(16) NOT NULL DEFAULT '',
    pref_name VARCHAR(32) NOT NULL,
    pref_value TEXT NULL,

    PRIMARY KEY (pref_uid, pref_scope, pref_name)
)
GO

GRANT SELECT, INSERT, UPDATE, DELETE ON horde_prefs TO horde
GO

CREATE TABLE horde_datatree (
    datatree_id INT NOT NULL,
    group_uid VARCHAR(255) NOT NULL,
    user_uid VARCHAR(255) NOT NULL,
    datatree_name VARCHAR(255) NOT NULL,
    datatree_parents VARCHAR(255) NOT NULL,
    datatree_order INT,
    datatree_data TEXT,
    datatree_serialized SMALLINT DEFAULT 0 NOT NULL,
    datatree_updated TIMESTAMP,

    PRIMARY KEY (datatree_id)
)
GO

GRANT SELECT, INSERT, UPDATE, DELETE ON horde_datatree TO horde
GO

CREATE INDEX datatree_datatree_name_idx ON horde_datatree (datatree_name)
CREATE INDEX datatree_group_idx ON horde_datatree (group_uid)
CREATE INDEX datatree_user_idx ON horde_datatree (user_uid)
CREATE INDEX datatree_serialized_idx ON horde_datatree (datatree_serialized)
GO

CREATE TABLE horde_datatree_attributes (
    datatree_id INT NOT NULL,
    attribute_name VARCHAR(255) NOT NULL,
    attribute_key VARCHAR(255) DEFAULT '' NOT NULL,
    attribute_value TEXT
)
GO

GRANT SELECT, INSERT, UPDATE, DELETE ON horde_datatree TO horde
GO

CREATE INDEX datatree_attribute_idx ON horde_datatree_attributes (datatree_id)
CREATE INDEX datatree_attribute_name_idx ON horde_datatree_attributes (attribute_name)
CREATE INDEX datatree_attribute_key_idx ON horde_datatree_attributes (attribute_key)
GO

CREATE TABLE horde_tokens (
    token_address VARCHAR(100) NOT NULL,
    token_id VARCHAR(32) NOT NULL,
    token_timestamp BIGINT NOT NULL,

    PRIMARY KEY (token_address, token_id)
)
GO

GRANT SELECT, INSERT, UPDATE, DELETE ON horde_tokens TO horde
GO

CREATE TABLE horde_vfs (
    vfs_id BIGINT NOT NULL,
    vfs_type SMALLINT NOT NULL,
    vfs_path VARCHAR(255) NOT NULL,
    vfs_name VARCHAR(255) NOT NULL,
    vfs_modified BIGINT NOT NULL,
    vfs_owner VARCHAR(255) NOT NULL,
    vfs_data TEXT,

    PRIMARY KEY   (vfs_id)
)
GO

GRANT SELECT, INSERT, UPDATE, DELETE ON horde_vfs TO horde
GO

CREATE INDEX vfs_path_idx ON horde_vfs (vfs_path)
CREATE INDEX vfs_name_idx ON horde_vfs (vfs_name)
GO
