<?php
/**
 * Highlights simple markup as used in emails or usenet postings.
 *
 * $Horde: framework/Text_Filter/Filter/simplemarkup.php,v 1.1.10.4 2006/01/01 21:28:38 jan Exp $
 *
 * Copyright 2004-2006 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you did
 * not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Jan Schneider <jan@horde.org>
 * @since   Horde 3.0
 * @package Horde_Text
 */
class Text_Filter_simplemarkup extends Text_Filter {

    /**
     * Returns a hash with replace patterns.
     *
     * @return array  Patterns hash.
     */
    function getPatterns()
    {
        $regexp = array(
            // Bold.
            '/(\s|\n)(\*[^*\s]+\*)(\s|\r|\n|<br)/i' => '\1<strong>\2</strong>\3',

            // Underline.
            '/(\s|\n)(_[^_\s]+_)(\s|\r|\n|<br)/i' => '\1<u>\2</u>\3',

            // Italic.
            ';(\s|\n)(/[^/\s]+/)(\s|\r|\n|<br);i' => '\1<em>\2</em>\3');

        return array('regexp' => $regexp);
    }

}
