{- This module was generated from data in the Kate syntax
   highlighting file python.xml, version 2.22, by Michael Bueker -}

module Text.Highlighting.Kate.Syntax.Python
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import qualified Text.Highlighting.Kate.Syntax.Modelines
import qualified Text.Highlighting.Kate.Syntax.Alert_indent
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Python"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.py;*.pyw;SConstruct;SConscript"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Python","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Python","Normal") -> return ()
      ("Python","#CheckForString") -> (popContext) >> pEndLine
      ("Python","CheckForStringNext") -> (popContext) >> pEndLine
      ("Python","StringVariants") -> return ()
      ("Python","CommentVariants") -> return ()
      ("Python","Dictionary") -> return ()
      ("Python","List") -> return ()
      ("Python","Tuple") -> return ()
      ("Python","Hash comment") -> (popContext) >> pEndLine
      ("Python","Tripple A-comment") -> return ()
      ("Python","Tripple Q-comment") -> return ()
      ("Python","Single A-comment") -> return ()
      ("Python","Single Q-comment") -> return ()
      ("Python","stringformat") -> return ()
      ("Python","Tripple A-string") -> return ()
      ("Python","Raw Tripple A-string") -> return ()
      ("Python","Tripple Q-string") -> return ()
      ("Python","Raw Tripple Q-string") -> return ()
      ("Python","Single A-string") -> return ()
      ("Python","Single Q-string") -> return ()
      ("Python","Raw A-string") -> return ()
      ("Python","Raw Q-string") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_prep = Set.fromList $ words $ "import from as"
list_defs = Set.fromList $ words $ "class def del global lambda nonlocal"
list_operators = Set.fromList $ words $ "and in is not or"
list_flow = Set.fromList $ words $ "assert break continue elif else except finally for if pass raise return try while with yield"
list_builtinfuncs = Set.fromList $ words $ "__import__ abs all any apply ascii basestring bin bool buffer bytearray bytes callable chr classmethod cmp coerce compile complex delattr dict dir divmod enumerate eval exec execfile file filter float format frozenset getattr globals hasattr hash help hex id input int intern isinstance issubclass iter len list locals long map max memoryview min next object oct open ord pow print property range raw_input reduce reload repr reversed round set setattr slice sorted staticmethod str sum super tuple type unichr unicode vars xrange zip"
list_specialvars = Set.fromList $ words $ "None self True False NotImplemented Ellipsis __debug__ __file__ __name__"
list_bindings = Set.fromList $ words $ "SIGNAL SLOT connect"
list_overloaders = Set.fromList $ words $ "__new__ __init__ __del__ __repr__ __str__ __lt__ __le__ __eq__ __ne__ __gt__ __ge__ __cmp__ __rcmp__ __hash__ __nonzero__ __unicode__ __getattr__ __setattr__ __delattr__ __getattribute__ __get__ __set__ __delete__ __call__ __len__ __getitem__ __setitem__ __delitem__ __iter__ __reversed__ __contains__ __getslice__ __setslice__ __delslice__ __add__ __sub__ __mul__ __floordiv__ __mod__ __divmod__ __pow__ __lshift__ __rshift__ __and__ __xor__ __or__ __div__ __truediv__ __radd__ __rsub__ __rmul__ __rdiv__ __rtruediv__ __rfloordiv__ __rmod__ __rdivmod__ __rpow__ __rlshift__ __rrshift__ __rand__ __rxor__ __ror__ __iadd__ __isub__ __imul__ __idiv__ __itruediv__ __ifloordiv__ __imod__ __ipow__ __ilshift__ __irshift__ __iand__ __ixor__ __ior__ __neg__ __pos__ __abs__ __invert__ __complex__ __int__ __long__ __float__ __oct__ __hex__ __index__ __coerce__ __enter__ __exit__ __bytes__ __format__ __next__ __dir__"
list_exceptions = Set.fromList $ words $ "ArithmeticError AssertionError AttributeError BaseException BlockingIOError BrokenPipeError BufferError BytesWarning ChildProcessError ConnectionAbortedError ConnectionError ConnectionRefusedError ConnectionResetError DeprecationWarning EnvironmentError EOFError Exception FileExistsError FileNotFoundError FloatingPointError FutureWarning GeneratorExit ImportError ImportWarning IndentationError IndexError InterruptedError IOError IsADirectoryError KeyboardInterrupt KeyError LookupError MemoryError NameError NotADirectoryError NotImplementedError OSError OverflowError PendingDeprecationWarning PermissionError ProcessLookupError ReferenceError ResourceWarning RuntimeError RuntimeWarning StandardError StopIteration SyntaxError SyntaxWarning SystemError SystemExit TabError TimeoutError TypeError UnboundLocalError UnicodeDecodeError UnicodeEncodeError UnicodeError UnicodeTranslateError UnicodeWarning UserWarning ValueError Warning WindowsError ZeroDivisionError"

regex_'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ'5f0'2d9'5d'7b2'2c'7d = compileRegex True "[a-zA-Z_][a-zA-Z_0-9]{2,}"
regex__'28'28'28'5b0'2d9'5d'2a'5c'2e'5b0'2d9'5d'2b'7c'5b0'2d9'5d'2b'5c'2e'29'7c'28'5b0'2d9'5d'2b'7c'28'5b0'2d9'5d'2a'5c'2e'5b0'2d9'5d'2b'7c'5b0'2d9'5d'2b'5c'2e'29'29'5beE'5d'28'5c'2b'7c'2d'29'3f'5b0'2d9'5d'2b'29'7c'5b0'2d9'5d'2b'29'5bjJ'5d = compileRegex True " ((([0-9]*\\.[0-9]+|[0-9]+\\.)|([0-9]+|([0-9]*\\.[0-9]+|[0-9]+\\.))[eE](\\+|-)?[0-9]+)|[0-9]+)[jJ]"
regex_'40'5b'5fa'2dzA'2dZ'5d'5b'5c'2e'5fa'2dzA'2dZ0'2d9'5d'2a = compileRegex True "@[_a-zA-Z][\\._a-zA-Z0-9]*"
regex_'25'28'28'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'29'3f'5b'230'5c'2d_'2b'5d'3f'28'5b1'2d9'5d'5b0'2d9'5d'2a'7c'5c'2a'29'3f'28'5c'2e'28'5b1'2d9'5d'5b0'2d9'5d'2a'7c'5c'2a'29'29'3f'5bhlL'5d'3f'5bcrsdiouxXeEfFgG'25'5d'7cprog'7cdefault'29 = compileRegex True "%((\\([a-zA-Z0-9_]+\\))?[#0\\- +]?([1-9][0-9]*|\\*)?(\\.([1-9][0-9]*|\\*))?[hlL]?[crsdiouxXeEfFgG%]|prog|default)"
regex_'5c'7b'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'7c'5b0'2d9'5d'2b'29'28'5c'2e'5ba'2dzA'2dZ0'2d9'5f'5d'2b'7c'5c'5b'5b'5e_'5c'5d'5d'2b'5c'5d'29'2a'28'21'5brs'5d'29'3f'28'3a'28'5b'5e'7d'5d'3f'5b'3c'3e'3d'5e'5d'29'3f'5b_'2b'2d'5d'3f'23'3f0'3f'5b0'2d9'5d'2a'28'5c'2e'5b0'2d9'5d'2b'29'3f'5bbcdeEfFgGnosxX'25'5d'3f'29'3f'5c'7d = compileRegex True "\\{([a-zA-Z0-9_]+|[0-9]+)(\\.[a-zA-Z0-9_]+|\\[[^ \\]]+\\])*(![rs])?(:([^}]?[<>=^])?[ +-]?#?0?[0-9]*(\\.[0-9]+)?[bcdeEfFgGnosxX%]?)?\\}"

parseRules ("Python","Normal") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_prep >>= withAttribute CharTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_defs >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_operators >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" Set.empty >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_flow >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_builtinfuncs >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_specialvars >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_bindings >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_exceptions >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_overloaders >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ'5f0'2d9'5d'7b2'2c'7d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex__'28'28'28'5b0'2d9'5d'2a'5c'2e'5b0'2d9'5d'2b'7c'5b0'2d9'5d'2b'5c'2e'29'7c'28'5b0'2d9'5d'2b'7c'28'5b0'2d9'5d'2a'5c'2e'5b0'2d9'5d'2b'7c'5b0'2d9'5d'2b'5c'2e'29'29'5beE'5d'28'5c'2b'7c'2d'29'3f'5b0'2d9'5d'2b'29'7c'5b0'2d9'5d'2b'29'5bjJ'5d >>= withAttribute OtherTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   (withChildren (pInt >>= withAttribute DecValTok) ((pString False "L" >>= withAttribute DecValTok)))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("Python","Dictionary"))
   <|>
   ((pDetectChar False '[' >>= withAttribute NormalTok) >>~ pushContext ("Python","List"))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Python","Tuple"))
   <|>
   ((parseRules ("Python","CommentVariants")))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Python","Hash comment"))
   <|>
   ((parseRules ("Python","StringVariants")))
   <|>
   ((pAnyChar "+*/%\\|=;\\!<>!^&~-" >>= withAttribute NormalTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'40'5b'5fa'2dzA'2dZ'5d'5b'5c'2e'5fa'2dzA'2dZ0'2d9'5d'2a >>= withAttribute OtherTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Python","#CheckForString") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pLineContinue >>= withAttribute NormalTok) >>~ pushContext ("Python","CheckForStringNext"))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Python","CheckForStringNext") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pLineContinue >>= withAttribute NormalTok) >>~ pushContext ("Python","CheckForStringNext"))
   <|>
   ((parseRules ("Python","StringVariants")))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Python","StringVariants") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pString False "'''" >>= withAttribute StringTok) >>~ pushContext ("Python","Tripple A-string"))
   <|>
   ((pString False "u'''" >>= withAttribute StringTok) >>~ pushContext ("Python","Tripple A-string"))
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ pushContext ("Python","Tripple Q-string"))
   <|>
   ((pString False "u\"\"\"" >>= withAttribute StringTok) >>~ pushContext ("Python","Tripple Q-string"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("Python","Single A-string"))
   <|>
   ((pDetect2Chars False 'u' '\'' >>= withAttribute StringTok) >>~ pushContext ("Python","Single A-string"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Python","Single Q-string"))
   <|>
   ((pDetect2Chars False 'u' '"' >>= withAttribute StringTok) >>~ pushContext ("Python","Single Q-string"))
   <|>
   ((pString False "r'''" >>= withAttribute StringTok) >>~ pushContext ("Python","Raw Tripple A-string"))
   <|>
   ((pString False "ur'''" >>= withAttribute StringTok) >>~ pushContext ("Python","Raw Tripple A-string"))
   <|>
   ((pString False "r\"\"\"" >>= withAttribute StringTok) >>~ pushContext ("Python","Raw Tripple Q-string"))
   <|>
   ((pString False "ur\"\"\"" >>= withAttribute StringTok) >>~ pushContext ("Python","Raw Tripple Q-string"))
   <|>
   ((pString False "r'" >>= withAttribute StringTok) >>~ pushContext ("Python","Raw A-string"))
   <|>
   ((pString False "ur'" >>= withAttribute StringTok) >>~ pushContext ("Python","Raw A-string"))
   <|>
   ((pString False "r\"" >>= withAttribute StringTok) >>~ pushContext ("Python","Raw Q-string"))
   <|>
   ((pString False "ur\"" >>= withAttribute StringTok) >>~ pushContext ("Python","Raw Q-string"))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","StringVariants")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Python","CommentVariants") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pFirstNonSpace >> pString False "'''" >>= withAttribute CommentTok) >>~ pushContext ("Python","Tripple A-comment"))
   <|>
   ((pFirstNonSpace >> pString False "u'''" >>= withAttribute CommentTok) >>~ pushContext ("Python","Tripple A-comment"))
   <|>
   ((pFirstNonSpace >> pString False "\"\"\"" >>= withAttribute CommentTok) >>~ pushContext ("Python","Tripple Q-comment"))
   <|>
   ((pFirstNonSpace >> pString False "u\"\"\"" >>= withAttribute CommentTok) >>~ pushContext ("Python","Tripple Q-comment"))
   <|>
   ((pFirstNonSpace >> pDetectChar False '\'' >>= withAttribute CommentTok) >>~ pushContext ("Python","Single A-comment"))
   <|>
   ((pFirstNonSpace >> pDetect2Chars False 'u' '\'' >>= withAttribute CommentTok) >>~ pushContext ("Python","Single A-comment"))
   <|>
   ((pFirstNonSpace >> pDetectChar False '"' >>= withAttribute CommentTok) >>~ pushContext ("Python","Single Q-comment"))
   <|>
   ((pFirstNonSpace >> pDetect2Chars False 'u' '"' >>= withAttribute CommentTok) >>~ pushContext ("Python","Single Q-comment"))
   <|>
   ((pFirstNonSpace >> pString False "r'''" >>= withAttribute CommentTok) >>~ pushContext ("Python","Tripple A-comment"))
   <|>
   ((pFirstNonSpace >> pString False "ur'''" >>= withAttribute CommentTok) >>~ pushContext ("Python","Tripple A-comment"))
   <|>
   ((pFirstNonSpace >> pString False "r\"\"\"" >>= withAttribute CommentTok) >>~ pushContext ("Python","Tripple Q-comment"))
   <|>
   ((pFirstNonSpace >> pString False "ur\"\"\"" >>= withAttribute CommentTok) >>~ pushContext ("Python","Tripple Q-comment"))
   <|>
   ((pFirstNonSpace >> pString False "r'" >>= withAttribute CommentTok) >>~ pushContext ("Python","Single A-comment"))
   <|>
   ((pFirstNonSpace >> pString False "ur'" >>= withAttribute CommentTok) >>~ pushContext ("Python","Single A-comment"))
   <|>
   ((pFirstNonSpace >> pString False "r\"" >>= withAttribute CommentTok) >>~ pushContext ("Python","Single Q-comment"))
   <|>
   ((pFirstNonSpace >> pString False "ur\"" >>= withAttribute CommentTok) >>~ pushContext ("Python","Single Q-comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","CommentVariants")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Python","Dictionary") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules ("Python","StringVariants")))
   <|>
   ((parseRules ("Python","Normal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Dictionary")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Python","List") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules ("Python","StringVariants")))
   <|>
   ((parseRules ("Python","Normal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","List")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Python","Tuple") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules ("Python","StringVariants")))
   <|>
   ((parseRules ("Python","Normal")))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Tuple")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Python","Hash comment") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((Text.Highlighting.Kate.Syntax.Modelines.parseExpression (Just ("Modelines","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Hash comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Python","Tripple A-comment") =
  (((pString False "'''" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression (Just ("Alerts_indent","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Tripple A-comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Python","Tripple Q-comment") =
  (((pHlCChar >>= withAttribute CommentTok))
   <|>
   ((pString False "\"\"\"" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression (Just ("Alerts_indent","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Tripple Q-comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Python","Single A-comment") =
  (((pHlCStringChar >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression (Just ("Alerts_indent","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Single A-comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Python","Single Q-comment") =
  (((pHlCStringChar >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression (Just ("Alerts_indent","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Single Q-comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Python","stringformat") =
  (((pRegExpr regex_'25'28'28'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'29'3f'5b'230'5c'2d_'2b'5d'3f'28'5b1'2d9'5d'5b0'2d9'5d'2a'7c'5c'2a'29'3f'28'5c'2e'28'5b1'2d9'5d'5b0'2d9'5d'2a'7c'5c'2a'29'29'3f'5bhlL'5d'3f'5bcrsdiouxXeEfFgG'25'5d'7cprog'7cdefault'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'7b'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'7c'5b0'2d9'5d'2b'29'28'5c'2e'5ba'2dzA'2dZ0'2d9'5f'5d'2b'7c'5c'5b'5b'5e_'5c'5d'5d'2b'5c'5d'29'2a'28'21'5brs'5d'29'3f'28'3a'28'5b'5e'7d'5d'3f'5b'3c'3e'3d'5e'5d'29'3f'5b_'2b'2d'5d'3f'23'3f0'3f'5b0'2d9'5d'2a'28'5c'2e'5b0'2d9'5d'2b'29'3f'5bbcdeEfFgGnosxX'25'5d'3f'29'3f'5c'7d >>= withAttribute OtherTok))
   <|>
   ((pDetect2Chars False '{' '{' >>= withAttribute OtherTok))
   <|>
   ((pDetect2Chars False '}' '}' >>= withAttribute OtherTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","stringformat")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Python","Tripple A-string") =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((parseRules ("Python","stringformat")))
   <|>
   ((pString False "'''" >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Tripple A-string")) >> pDefault >>= withAttribute StringTok))

parseRules ("Python","Raw Tripple A-string") =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((parseRules ("Python","stringformat")))
   <|>
   ((pString False "'''" >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Raw Tripple A-string")) >> pDefault >>= withAttribute StringTok))

parseRules ("Python","Tripple Q-string") =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((parseRules ("Python","stringformat")))
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Tripple Q-string")) >> pDefault >>= withAttribute StringTok))

parseRules ("Python","Raw Tripple Q-string") =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((parseRules ("Python","stringformat")))
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Raw Tripple Q-string")) >> pDefault >>= withAttribute StringTok))

parseRules ("Python","Single A-string") =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((parseRules ("Python","stringformat")))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Single A-string")) >> pDefault >>= withAttribute StringTok))

parseRules ("Python","Single Q-string") =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((parseRules ("Python","stringformat")))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Single Q-string")) >> pDefault >>= withAttribute StringTok))

parseRules ("Python","Raw A-string") =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((parseRules ("Python","stringformat")))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Raw A-string")) >> pDefault >>= withAttribute StringTok))

parseRules ("Python","Raw Q-string") =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((parseRules ("Python","stringformat")))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Python","Raw Q-string")) >> pDefault >>= withAttribute StringTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing
parseRules ("Modelines", _) = Text.Highlighting.Kate.Syntax.Modelines.parseExpression Nothing
parseRules ("Alerts_indent", _) = Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression Nothing

parseRules x = parseRules ("Python","Normal") <|> fail ("Unknown context" ++ show x)
