{- This module was generated from data in the Kate syntax
   highlighting file changelog.xml, version 1.04, by Dominik Haumann (dhdev@gmx.de) -}

module Text.Highlighting.Kate.Syntax.Changelog
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "ChangeLog"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "ChangeLog"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("ChangeLog","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("ChangeLog","Normal") -> return ()
      ("ChangeLog","line") -> (popContext) >> pEndLine
      ("ChangeLog","entry") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'5cd'5cd'5cd'5cd'5cs'2a'2d'5cs'2a'5cd'5cd'5cs'2a'2d'5cs'2a'5cd'5cd'5cs'2a = compileRegex True "\\d\\d\\d\\d\\s*-\\s*\\d\\d\\s*-\\s*\\d\\d\\s*"
regex_'28'5cw'5cs'2a'29'2b = compileRegex True "(\\w\\s*)+"
regex_'3c'2e'2a'3e'5cs'2a'24 = compileRegex True "<.*>\\s*$"
regex_'2e'2a'3a = compileRegex True ".*:"

parseRules ("ChangeLog","Normal") =
  (((pFirstNonSpace >> pDetectChar False '*' >>= withAttribute DecValTok) >>~ pushContext ("ChangeLog","entry"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5cd'5cd'5cd'5cd'5cs'2a'2d'5cs'2a'5cd'5cd'5cs'2a'2d'5cs'2a'5cd'5cd'5cs'2a >>= withAttribute DataTypeTok) >>~ pushContext ("ChangeLog","line"))
   <|>
   (currentContext >>= \x -> guard (x == ("ChangeLog","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ChangeLog","line") =
  (((pRegExpr regex_'28'5cw'5cs'2a'29'2b >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'3c'2e'2a'3e'5cs'2a'24 >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ChangeLog","line")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ChangeLog","entry") =
  (((pRegExpr regex_'2e'2a'3a >>= withAttribute DecValTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ChangeLog","entry")) >> pDefault >>= withAttribute NormalTok))


parseRules x = parseRules ("ChangeLog","Normal") <|> fail ("Unknown context" ++ show x)
