{- This module was generated from data in the Kate syntax
   highlighting file json.xml, version 1.2, by Sebastian Pipping (sebastian@pipping.org) -}

module Text.Highlighting.Kate.Syntax.Json
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "JSON"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.json"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("JSON","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("JSON","Normal") -> return ()
      ("JSON","Pair") -> return ()
      ("JSON","String_Key") -> return ()
      ("JSON","Value") -> return ()
      ("JSON","String_Value") -> return ()
      ("JSON","Array") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_Constants = Set.fromList $ words $ "null true false"

regex_'5c'5c'28'3f'3a'5b'22'5c'5c'2fbfnrt'5d'7cu'5b0'2d9a'2dfA'2df'5d'7b4'7d'29 = compileRegex "\\\\(?:[\"\\\\/bfnrt]|u[0-9a-fA-f]{4})"
regex_'2d'3f'28'3f'3a'5b0'2d9'5d'7c'5b1'2d9'5d'5b0'2d9'5d'2b'29'5c'2e'5b0'2d9'5d'2b'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f = compileRegex "-?(?:[0-9]|[1-9][0-9]+)\\.[0-9]+(?:[eE][+-]?[0-9]+)?"
regex_'2d'3f'28'3f'3a'5b0'2d9'5d'7c'5b1'2d9'5d'5b0'2d9'5d'2b'29'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f = compileRegex "-?(?:[0-9]|[1-9][0-9]+)(?:[eE][+-]?[0-9]+)?"

parseRules ("JSON","Normal") =
  (((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("JSON","Pair"))
   <|>
   ((pDetectChar False '[' >>= withAttribute NormalTok) >>~ pushContext ("JSON","Array"))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("JSON","Normal")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("JSON","Pair") =
  (((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ pushContext ("JSON","String_Key"))
   <|>
   ((pDetectChar False ':' >>= withAttribute NormalTok) >>~ pushContext ("JSON","Value"))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False ',' >>= withAttribute NormalTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("JSON","Pair")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("JSON","String_Key") =
  (((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'28'3f'3a'5b'22'5c'5c'2fbfnrt'5d'7cu'5b0'2d9a'2dfA'2df'5d'7b4'7d'29 >>= withAttribute DataTypeTok))
   <|>
   (currentContext >>= \x -> guard (x == ("JSON","String_Key")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("JSON","Value") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("JSON","String_Value"))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("JSON","Pair"))
   <|>
   ((pDetectChar False '[' >>= withAttribute NormalTok) >>~ pushContext ("JSON","Array"))
   <|>
   ((lookAhead (pDetectChar False '}') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pDetectChar False ',') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Constants >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'2d'3f'28'3f'3a'5b0'2d9'5d'7c'5b1'2d9'5d'5b0'2d9'5d'2b'29'5c'2e'5b0'2d9'5d'2b'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'2d'3f'28'3f'3a'5b0'2d9'5d'7c'5b1'2d9'5d'5b0'2d9'5d'2b'29'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f >>= withAttribute DecValTok))
   <|>
   (currentContext >>= \x -> guard (x == ("JSON","Value")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("JSON","String_Value") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'28'3f'3a'5b'22'5c'5c'2fbfnrt'5d'7cu'5b0'2d9a'2dfA'2df'5d'7b4'7d'29 >>= withAttribute StringTok))
   <|>
   (currentContext >>= \x -> guard (x == ("JSON","String_Value")) >> pDefault >>= withAttribute StringTok))

parseRules ("JSON","Array") =
  (((pDetectChar False ',' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("JSON","Pair"))
   <|>
   ((pDetectChar False '[' >>= withAttribute NormalTok) >>~ pushContext ("JSON","Array"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("JSON","String_Value"))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Constants >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'2d'3f'28'3f'3a'5b0'2d9'5d'7c'5b1'2d9'5d'5b0'2d9'5d'2b'29'5c'2e'5b0'2d9'5d'2b'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'2d'3f'28'3f'3a'5b0'2d9'5d'7c'5b1'2d9'5d'5b0'2d9'5d'2b'29'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f >>= withAttribute DecValTok))
   <|>
   (currentContext >>= \x -> guard (x == ("JSON","Array")) >> pDefault >>= withAttribute ErrorTok))


parseRules x = parseRules ("JSON","Normal") <|> fail ("Unknown context" ++ show x)
