{- This module was generated from data in the Kate syntax
   highlighting file ada.xml, version 1.07, by  -}

module Text.Highlighting.Kate.Syntax.Ada
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Ada"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.adb;*.ads;*.ada;*.a"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Ada","Default")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Ada","Default") -> return ()
      ("Ada","Region Marker") -> (popContext) >> pEndLine
      ("Ada","String") -> (popContext) >> pEndLine
      ("Ada","Comment") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "abort abs abstract accept access aliased all and array at begin body constant declare delay delta digits do else elsif end entry exception exit for function generic goto in interface is limited mod new not null of or others out overriding package pragma private procedure protected raise range rem record renames requeue return reverse separate subtype tagged task terminate then type until use when while with xor"
list_pragmas = Set.fromList $ words $ "all_calls_remote assert assertion_policy asynchronous atomic atomic_components attach_handler controlled convention detect_blocking discard_names elaborate elaborate_all elaborate_body export import inline inspection_point interrupt_handler interrupt_priority linker_options list locking_policy no_return normalize_scalars optimize pack page partition_elaboration_policy preelaborable_initialization preelaborate priority priority_specific_dispatching profile pure queuing_policy relative_deadline remote_call_interface remote_types restrictions reviewable shared_passive storage_size suppress task_dispatching_policy unchecked_union unsuppress volatile volatile_components"
list_types = Set.fromList $ words $ "boolean char float integer long_float long_integer long_long_float long_long_integer short_float short_integer string wide_string wide_char wide_wide_char wide_wide_string"

regex_'5cbrecord'5cb = compileRegex "\\brecord\\b"
regex_'5cbend'5cs'2brecord'5cb = compileRegex "\\bend\\s+record\\b"
regex_'5cbcase'5cb = compileRegex "\\bcase\\b"
regex_'5cbend'5cs'2bcase'5cb = compileRegex "\\bend\\s+case\\b"
regex_'5cbif'5cb = compileRegex "\\bif\\b"
regex_'5cbend'5cs'2bif'5cb = compileRegex "\\bend\\s+if\\b"
regex_'5cbloop'5cb = compileRegex "\\bloop\\b"
regex_'5cbend'5cs'2bloop'5cb = compileRegex "\\bend\\s+loop\\b"
regex_'5cbselect'5cb = compileRegex "\\bselect\\b"
regex_'5cbend'5cs'2bselect'5cb = compileRegex "\\bend\\s+select\\b"
regex_'5cbbegin'5cb = compileRegex "\\bbegin\\b"
regex_'5cbend'5cb = compileRegex "\\bend\\b"
regex_'27'2e'27 = compileRegex "'.'"

parseRules ("Ada","Default") =
  (((pRegExpr regex_'5cbrecord'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbend'5cs'2brecord'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbcase'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbend'5cs'2bcase'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbif'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbend'5cs'2bif'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbloop'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbend'5cs'2bloop'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbselect'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbend'5cs'2bselect'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbbegin'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbend'5cb >>= withAttribute KeywordTok))
   <|>
   ((pFirstNonSpace >> pString False "--  BEGIN" >>= withAttribute RegionMarkerTok) >>~ pushContext ("Ada","Region Marker"))
   <|>
   ((pFirstNonSpace >> pString False "--  END" >>= withAttribute RegionMarkerTok) >>~ pushContext ("Ada","Region Marker"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_pragmas >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'27'2e'27 >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Ada","String"))
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext ("Ada","Comment"))
   <|>
   ((pAnyChar ":!%&()+,-/.*<=>|" >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Ada","Default")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Ada","Region Marker") =
  (currentContext >>= \x -> guard (x == ("Ada","Region Marker")) >> pDefault >>= withAttribute RegionMarkerTok)

parseRules ("Ada","String") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Ada","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Ada","Comment") =
  (currentContext >>= \x -> guard (x == ("Ada","Comment")) >> pDefault >>= withAttribute CommentTok)


parseRules x = parseRules ("Ada","Default") <|> fail ("Unknown context" ++ show x)
