{- This module was generated from data in the Kate syntax
   highlighting file xorg.xml, version 1.01, by Jan Janssen (medhefgo@web.de) -}

module Text.Highlighting.Kate.Syntax.Xorg
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)

-- | Full name of language.
syntaxName :: String
syntaxName = "x.org Configuration"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "xorg.conf"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "x.org Configuration" }
  context <- currentContext <|> (pushContext "xorg" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("x.org Configuration",["xorg"])], synStLanguage = "x.org Configuration", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "xorg" -> return ()
    "Section" -> return ()
    "Section Content" -> return ()
    "Keyword" -> (popContext) >> pEndLine
    "Comment" -> (popContext) >> pEndLine
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))


regex_'5cb'5cw'2b'5cb = compileRegex "\\b\\w+\\b"
regex_'5b'5cw'5cd'5d'2b = compileRegex "[\\w\\d]+"

defaultAttributes = [("xorg",NormalTok),("Section",NormalTok),("Section Content",NormalTok),("Keyword",KeywordTok),("Comment",CommentTok)]

parseRules "xorg" =
  (((pString False "Section" >>= withAttribute FunctionTok) >>~ pushContext "Section")
   <|>
   ((pDetectChar False '#' >>= withAttribute NormalTok) >>~ pushContext "Comment"))

parseRules "Section" =
  (((pRangeDetect '"' '"' >>= withAttribute StringTok) >>~ pushContext "Section Content")
   <|>
   ((pRangeDetect '\'' '\'' >>= withAttribute StringTok) >>~ pushContext "Section Content")
   <|>
   ((pDetectIdentifier >>= withAttribute ErrorTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute NormalTok) >>~ pushContext "Comment"))

parseRules "Section Content" =
  (((pString False "EndSection" >>= withAttribute FunctionTok) >>~ (popContext >> popContext))
   <|>
   ((pString False "EndSubSection" >>= withAttribute FunctionTok) >>~ (popContext >> popContext))
   <|>
   ((pString False "SubSection" >>= withAttribute FunctionTok) >>~ pushContext "Section")
   <|>
   ((pRegExpr regex_'5cb'5cw'2b'5cb >>= withAttribute NormalTok) >>~ pushContext "Keyword")
   <|>
   ((pDetectChar False '#' >>= withAttribute NormalTok) >>~ pushContext "Comment"))

parseRules "Keyword" =
  (((pRangeDetect '"' '"' >>= withAttribute DataTypeTok))
   <|>
   ((pRangeDetect '\'' '\'' >>= withAttribute DataTypeTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5b'5cw'5cd'5d'2b >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute KeywordTok) >>~ pushContext "Comment"))

parseRules "Comment" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok)))

parseRules "" = parseRules "xorg"

parseRules x = fail $ "Unknown context" ++ x
