{- This module was generated from data in the Kate syntax
   highlighting file vhdl.xml, version 1.10, by Rocky Scaletta (rocky@purdue.edu), Stefan Endrullis (stefan@endrullis.de), Florent Ouchet (outchy@users.sourceforge.net), Chris Higgs (chiggs.99@gmail.com), Jan Michel (jan@mueschelsoft.de) -}

module Text.Highlighting.Kate.Syntax.Vhdl
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "VHDL"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.vhdl;*.vhd"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "VHDL" }
  context <- currentContext <|> (pushContext "start" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("VHDL",["start"])], synStLanguage = "VHDL", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "start" -> return ()
    "package" -> return ()
    "packagebody" -> return ()
    "architecture_main" -> return ()
    "arch_decl" -> return ()
    "detect_arch_parts" -> return ()
    "generate1" -> return ()
    "generate2" -> return ()
    "process1" -> return ()
    "proc_rules" -> return ()
    "instance" -> return ()
    "forOrWhile" -> return ()
    "if_start" -> return ()
    "if" -> return ()
    "case1" -> return ()
    "case2" -> return ()
    "caseWhen" -> return ()
    "entity" -> return ()
    "entity_main" -> return ()
    "preDetection" -> return ()
    "generalDetection" -> return ()
    "comment" -> (popContext) >> pEndLine
    "string" -> return ()
    "attribute" -> (popContext) >> pEndLine
    "quot in att" -> return ()
    "signal" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywordsToplevel = Set.fromList $ words $ "file library use"
list_keywords = Set.fromList $ words $ "access after alias all array assert assume assume_guarantee attribute begin block body bus component constant context cover default disconnect downto end exit fairness file force function generate generic group guarded impure inertial is label linkage literal map new next null of on open others parameter port postponed procedure process property protected pure range record register reject release report return select sequence severity signal shared strong subtype to transport type unaffected units until variable vmode vprop vunit wait when with note warning error failure in inout out buffer and abs or xor xnor not mod nand nor rem rol ror sla sra sll srl"
list_if = Set.fromList $ words $ "if else elsif then"
list_forOrWhile = Set.fromList $ words $ "loop"
list_directions = Set.fromList $ words $ "in inout out buffer linkage"
list_signals = Set.fromList $ words $ "signal variable constant type"
list_range = Set.fromList $ words $ "to downto others"
list_case = Set.fromList $ words $ "case when"
list_types = Set.fromList $ words $ "bit bit_vector character boolean boolean_vector integer integer_vector real real_vector time time_vector delay_length string severity_level positive natural file_open_kind file_open_status signed unsigned unresolved_unsigned unresolved_signed line text side width std_logic std_logic_vector std_ulogic std_ulogic_vector x01 x01z ux01 ux01z qsim_state qsim_state_vector qsim_12state qsim_12state_vector qsim_strength mux_bit mux_vector reg_bit reg_vector wor_bit wor_vector"

regex_'28'5cb'29'28package'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bis'29'5cb = compileRegex "(\\b)(package\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+is)\\b"
regex_'28'5cb'29'28package'5cs'2bbody'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bis'29'5cb = compileRegex "(\\b)(package\\s+body\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+is)\\b"
regex_architecture'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bof'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bis = compileRegex "architecture\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+of\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+is"
regex_'28'5cb'29generate'5cb = compileRegex "(\\b)generate\\b"
regex_'28'5cb'29end'5cs'2bgenerate'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b = compileRegex "(\\b)end\\s+generate(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;"
regex_'28'5cb'29'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'28'3f'3d'5cs'2a'3a'28'3f'21'3d'29'29 = compileRegex "(\\b)\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b(?=\\s*:(?!=))"
regex_'28'5cb'29'28if'29'5cb = compileRegex "(\\b)(if)\\b"
regex_'28'5cb'29'28'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2a'3a'5cs'2a'29'3f'28'28for'7cwhile'29'5cs'2b'2e'2b'5cs'2b'29'3floop'5cb = compileRegex "(\\b)((\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*:\\s*)?((for|while)\\s+.+\\s+)?loop\\b"
regex_'28'5cb'29end'5cs'2bloop'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b = compileRegex "(\\b)end\\s+loop(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;"
regex_'28'5cb'29end'5cs'2bif'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b = compileRegex "(\\b)end\\s+if(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;"
regex_'28'5cb'29end'5cs'2bcase'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b = compileRegex "(\\b)end\\s+case(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;"
regex_'28'5cb'29when'5cb = compileRegex "(\\b)when\\b"
regex_'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29 = compileRegex "(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)"
regex_generic = compileRegex "generic"
regex_port = compileRegex "port"

defaultAttributes = [("start",NormalTok),("package",NormalTok),("packagebody",NormalTok),("architecture_main",NormalTok),("arch_decl",NormalTok),("detect_arch_parts",NormalTok),("generate1",NormalTok),("generate2",NormalTok),("process1",NormalTok),("proc_rules",NormalTok),("instance",NormalTok),("forOrWhile",NormalTok),("if_start",NormalTok),("if",NormalTok),("case1",NormalTok),("case2",NormalTok),("caseWhen",NormalTok),("entity",NormalTok),("entity_main",NormalTok),("preDetection",NormalTok),("generalDetection",NormalTok),("comment",CommentTok),("string",StringTok),("attribute",BaseNTok),("quot in att",BaseNTok),("signal",NormalTok)]

parseRules "start" =
  (((parseRules "preDetection"))
   <|>
   ((lookAhead (pRegExprDynamic "architecture\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)") >> pushContext "architecture_main" >> currentContext >>= parseRules))
   <|>
   ((pString False "entity" >>= withAttribute KeywordTok) >>~ pushContext "entity")
   <|>
   ((lookAhead (pRegExpr regex_'28'5cb'29'28package'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bis'29'5cb) >> pushContext "package" >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'5cb'29'28package'5cs'2bbody'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bis'29'5cb) >> pushContext "packagebody" >> currentContext >>= parseRules))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywordsToplevel >>= withAttribute KeywordTok)))

parseRules "package" =
  (((pString True "%2" >>= withAttribute KeywordTok))
   <|>
   ((parseRules "preDetection"))
   <|>
   ((pString False "begin" >>= withAttribute KeywordTok))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+package)?(\\s+%3)?\\s*;" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules "generalDetection")))

parseRules "packagebody" =
  (((pString True "%2" >>= withAttribute KeywordTok))
   <|>
   ((parseRules "preDetection"))
   <|>
   ((pString False "begin" >>= withAttribute KeywordTok))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+package)?(\\s+%3)?\\s*;" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules "generalDetection")))

parseRules "architecture_main" =
  (((parseRules "preDetection"))
   <|>
   ((pRegExpr regex_architecture'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bof'5cs'2b'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2bis >>= withAttribute KeywordTok) >>~ pushContext "arch_decl")
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+architecture)?(\\s+%1)?\\s*;" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+architecture)?(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*;" >>= withAttribute ErrorTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "detect_arch_parts")))

parseRules "arch_decl" =
  (((parseRules "preDetection"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_signals >>= withAttribute OtherTok) >>~ pushContext "signal")
   <|>
   ((pString False "component" >>= withAttribute KeywordTok) >>~ pushContext "entity")
   <|>
   ((pString False "begin" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules "generalDetection")))

parseRules "detect_arch_parts" =
  (((lookAhead (pRegExprDynamic "(\\b)((\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*:\\s*)(if|for).*\\s+generate\\b") >> pushContext "generate1" >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)((\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*:\\s*)?process\\b") >> pushContext "process1" >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExprDynamic "\\b(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*:\\s*(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)") >> pushContext "instance" >> currentContext >>= parseRules))
   <|>
   ((parseRules "generalDetection")))

parseRules "generate1" =
  (((parseRules "preDetection"))
   <|>
   ((pRegExpr regex_'28'5cb'29generate'5cb >>= withAttribute KeywordTok) >>~ pushContext "generate2")
   <|>
   ((pRegExprDynamic "(\\b)%3\\b" >>= withAttribute KeywordTok))
   <|>
   ((pString False "for" >>= withAttribute KeywordTok))
   <|>
   ((pString False "if" >>= withAttribute KeywordTok))
   <|>
   ((parseRules "generalDetection")))

parseRules "generate2" =
  (((parseRules "preDetection"))
   <|>
   ((pString False "begin" >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5cb'29end'5cs'2bgenerate'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "detect_arch_parts")))

parseRules "process1" =
  (((parseRules "preDetection"))
   <|>
   ((pRegExprDynamic "end\\s+process(\\s+%3)?\\s*;" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExprDynamic "end\\s+process(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?" >>= withAttribute ErrorTok) >>~ (popContext))
   <|>
   ((pString False "process" >>= withAttribute KeywordTok))
   <|>
   ((pString False "begin" >>= withAttribute KeywordTok))
   <|>
   ((parseRules "proc_rules")))

parseRules "proc_rules" =
  (((pRegExpr regex_'28'5cb'29'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'28'3f'3d'5cs'2a'3a'28'3f'21'3d'29'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5cb'29'28if'29'5cb >>= withAttribute KeywordTok) >>~ pushContext "if_start")
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)(case)\\b") >> pushContext "case1" >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'28'5cb'29'28'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'5cs'2a'3a'5cs'2a'29'3f'28'28for'7cwhile'29'5cs'2b'2e'2b'5cs'2b'29'3floop'5cb >>= withAttribute KeywordTok) >>~ pushContext "forOrWhile")
   <|>
   ((parseRules "generalDetection")))

parseRules "instance" =
  (((parseRules "preDetection"))
   <|>
   ((pRegExprDynamic "\\b%1\\b" >>= withAttribute KeywordTok))
   <|>
   ((pRegExprDynamic "\\b%2\\b" >>= withAttribute KeywordTok))
   <|>
   ((pDetect2Chars False ')' ';' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules "generalDetection")))

parseRules "forOrWhile" =
  (((pRegExpr regex_'28'5cb'29end'5cs'2bloop'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_forOrWhile >>= withAttribute KeywordTok))
   <|>
   ((parseRules "proc_rules")))

parseRules "if_start" =
  (((parseRules "preDetection"))
   <|>
   ((pString False "then" >>= withAttribute KeywordTok) >>~ pushContext "if")
   <|>
   ((parseRules "generalDetection")))

parseRules "if" =
  (((parseRules "preDetection"))
   <|>
   ((pRegExpr regex_'28'5cb'29end'5cs'2bif'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "proc_rules"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_if >>= withAttribute KeywordTok)))

parseRules "case1" =
  (((parseRules "preDetection"))
   <|>
   ((pString False "is" >>= withAttribute KeywordTok) >>~ pushContext "case2")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_case >>= withAttribute KeywordTok)))

parseRules "case2" =
  (((parseRules "preDetection"))
   <|>
   ((pRegExpr regex_'28'5cb'29end'5cs'2bcase'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pString False "when" >>= withAttribute KeywordTok) >>~ pushContext "caseWhen")
   <|>
   ((parseRules "proc_rules")))

parseRules "caseWhen" =
  (((parseRules "preDetection"))
   <|>
   ((lookAhead (pRegExpr regex_'28'5cb'29when'5cb) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'5cb'29end'5cs'2bcase'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules "proc_rules")))

parseRules "entity" =
  (((parseRules "preDetection"))
   <|>
   ((pRegExpr regex_'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29 >>= withAttribute KeywordTok) >>~ pushContext "entity_main")
   <|>
   ((parseRules "generalDetection")))

parseRules "entity_main" =
  (((parseRules "preDetection"))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+(entity|component))?(\\s+%1)?\\s*;" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+(entity|component))?(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;" >>= withAttribute ErrorTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_generic >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_port >>= withAttribute KeywordTok))
   <|>
   ((parseRules "generalDetection")))

parseRules "preDetection" =
  (((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext "comment")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "string")
   <|>
   ((pAnyChar "[&><=:+\\-*\\/|].," >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute BaseNTok) >>~ pushContext "attribute"))

parseRules "generalDetection" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_signals >>= withAttribute OtherTok) >>~ pushContext "signal")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_range >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok)))

parseRules "comment" =
  pzero

parseRules "string" =
  ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))

parseRules "attribute" =
  (((pDetectChar False '"' >>= withAttribute BaseNTok) >>~ pushContext "quot in att")
   <|>
   ((pDetectChar False ' ' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '\'' >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pAnyChar "()=<>" >>= withAttribute BaseNTok) >>~ (popContext)))

parseRules "quot in att" =
  ((pDetectChar False '"' >>= withAttribute BaseNTok) >>~ (popContext))

parseRules "signal" =
  (((parseRules "preDetection"))
   <|>
   ((pDetectChar False ';' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules "generalDetection")))

parseRules "" = parseRules "start"

parseRules x = fail $ "Unknown context" ++ x
