{- This module was generated from data in the Kate syntax
   highlighting file texinfo.xml, version 0.2, by Daniel Franke (franke.daniel@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Texinfo
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)

-- | Full name of language.
syntaxName :: String
syntaxName = "Texinfo"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.texi"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Texinfo" }
  context <- currentContext <|> (pushContext "Normal Text" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Texinfo",["Normal Text"])], synStLanguage = "Texinfo", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal Text" -> return ()
    "singleLineComment" -> (popContext) >> pEndLine
    "multiLineComment" -> return ()
    "nodeFolding" -> return ()
    "folding" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))


regex_'40c'28omment'29'3f'5cb = compileRegex "@c(omment)?\\b"
regex_'40ignore'5cb = compileRegex "@ignore\\b"
regex_'40node'5cb = compileRegex "@node\\b"
regex_'40'28menu'7csmallexample'7ctable'7cmultitable'29'5cb = compileRegex "@(menu|smallexample|table|multitable)\\b"
regex_'40'5b'5cw'5d'2b'28'5c'7b'28'5b'5cw'5d'2b'5b'5cs'5d'2a'29'2b'5c'7d'29'3f = compileRegex "@[\\w]+(\\{([\\w]+[\\s]*)+\\})?"
regex_'40end_'28menu'7csmallexample'7ctable'7cmultitable'29'5cb = compileRegex "@end (menu|smallexample|table|multitable)\\b"

defaultAttributes = [("Normal Text",NormalTok),("singleLineComment",CommentTok),("multiLineComment",CommentTok),("nodeFolding",NormalTok),("folding",NormalTok)]

parseRules "Normal Text" =
  (((pRegExpr regex_'40c'28omment'29'3f'5cb >>= withAttribute CommentTok) >>~ pushContext "singleLineComment")
   <|>
   ((pRegExpr regex_'40ignore'5cb >>= withAttribute CommentTok) >>~ pushContext "multiLineComment")
   <|>
   ((pRegExpr regex_'40node'5cb >>= withAttribute FunctionTok) >>~ pushContext "nodeFolding")
   <|>
   ((pRegExpr regex_'40'28menu'7csmallexample'7ctable'7cmultitable'29'5cb >>= withAttribute FunctionTok) >>~ pushContext "folding")
   <|>
   ((pRegExpr regex_'40'5b'5cw'5d'2b'28'5c'7b'28'5b'5cw'5d'2b'5b'5cs'5d'2a'29'2b'5c'7d'29'3f >>= withAttribute FunctionTok)))

parseRules "singleLineComment" =
  ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))

parseRules "multiLineComment" =
  (((pString False "@end ignore" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "nodeFolding" =
  (((lookAhead (pRegExpr regex_'40node'5cb) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules "Normal Text")))

parseRules "folding" =
  (((pRegExpr regex_'40end_'28menu'7csmallexample'7ctable'7cmultitable'29'5cb >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((parseRules "Normal Text")))

parseRules "" = parseRules "Normal Text"

parseRules x = fail $ "Unknown context" ++ x
