{- This module was generated from data in the Kate syntax
   highlighting file python.xml, version 2.11, by Michael Bueker -}

module Text.Highlighting.Kate.Syntax.Python
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert_indent
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Python"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.py;*.pyw;SConstruct;SConscript"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Python" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Python",["Normal"])], synStLanguage = "Python", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "CheckForString" -> (popContext) >> pEndLine
    "parenthesised" -> return ()
    "Hash comment" -> (popContext) >> pEndLine
    "Tripple A-comment" -> return ()
    "Tripple Q-comment" -> return ()
    "Single A-comment" -> return ()
    "Single Q-comment" -> return ()
    "stringformat" -> return ()
    "Tripple A-string" -> return ()
    "Raw Tripple A-string" -> return ()
    "Tripple Q-string" -> return ()
    "Raw Tripple Q-string" -> return ()
    "Single A-string" -> return ()
    "Single Q-string" -> return ()
    "Raw A-string" -> return ()
    "Raw Q-string" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_prep = Set.fromList $ words $ "import from as"
list_defs = Set.fromList $ words $ "class def del global lambda nonlocal"
list_operators = Set.fromList $ words $ "and in is not or"
list_commands = Set.fromList $ words $ "exec print"
list_flow = Set.fromList $ words $ "assert break continue elif else except finally for if pass raise return try while with yield"
list_builtinfuncs = Set.fromList $ words $ "__future__ __import__ __name__ abs all any apply basestring bin bool buffer callable chr classmethod cmp coerce compile complex delattr dict dir divmod enumerate eval execfile file filter float format frozenset getattr globals hasattr hash help hex id input int intern isinstance issubclass iter len list locals long map max min next object oct open ord pow property range raw_input reduce reload repr reversed round set setattr slice sorted staticmethod str sum super tuple type unichr unicode vars xrange zip"
list_specialvars = Set.fromList $ words $ "None self True False NotImplemented Ellipsis __debug__ __file__"
list_bindings = Set.fromList $ words $ "SIGNAL SLOT connect"
list_overloaders = Set.fromList $ words $ "__new__ __init__ __del__ __repr__ __str__ __lt__ __le__ __eq__ __ne__ __gt__ __ge__ __cmp__ __rcmp__ __hash__ __nonzero__ __unicode__ __getattr__ __setattr__ __delattr__ __getattribute__ __get__ __set__ __delete__ __call__ __len__ __getitem__ __setitem__ __delitem__ __iter__ __reversed__ __contains__ __getslice__ __setslice__ __delslice__ __add__ __sub__ __mul__ __floordiv__ __mod__ __divmod__ __pow__ __lshift__ __rshift__ __and__ __xor__ __or__ __div__ __truediv__ __radd__ __rsub__ __rmul__ __rdiv__ __rtruediv__ __rfloordiv__ __rmod__ __rdivmod__ __rpow__ __rlshift__ __rrshift__ __rand__ __rxor__ __ror__ __iadd__ __isub__ __imul__ __idiv__ __itruediv__ __ifloordiv__ __imod__ __ipow__ __ilshift__ __irshift__ __iand__ __ixor__ __ior__ __neg__ __pos__ __abs__ __invert__ __complex__ __int__ __long__ __float__ __oct__ __hex__ __index__ __coerce__ __enter__ __exit__"
list_exceptions = Set.fromList $ words $ "ArithmeticError AssertionError AttributeError BaseException DeprecationWarning EnvironmentError EOFError Exception FloatingPointError FutureWarning GeneratorExit IOError ImportError ImportWarning IndexError KeyError KeyboardInterrupt LookupError MemoryError NameError NotImplementedError OSError OverflowError PendingDeprecationWarning ReferenceError RuntimeError RuntimeWarning StandardError StopIteration SyntaxError SyntaxWarning SystemError SystemExit TypeError UnboundLocalError UserWarning UnicodeError UnicodeWarning UnicodeEncodeError UnicodeDecodeError UnicodeTranslateError ValueError Warning WindowsError ZeroDivisionError"

regex_'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ'5f0'2d9'5d'2b = compileRegex "[a-zA-Z_][a-zA-Z_0-9]+"
regex__'28'28'28'5b0'2d9'5d'2a'5c'2e'5b0'2d9'5d'2b'7c'5b0'2d9'5d'2b'5c'2e'29'7c'28'5b0'2d9'5d'2b'7c'28'5b0'2d9'5d'2a'5c'2e'5b0'2d9'5d'2b'7c'5b0'2d9'5d'2b'5c'2e'29'29'5beE'5d'28'5c'2b'7c'2d'29'3f'5b0'2d9'5d'2b'29'7c'5b0'2d9'5d'2b'29'5bjJ'5d = compileRegex " ((([0-9]*\\.[0-9]+|[0-9]+\\.)|([0-9]+|([0-9]*\\.[0-9]+|[0-9]+\\.))[eE](\\+|-)?[0-9]+)|[0-9]+)[jJ]"
regex_u'3f'27'27'27 = compileRegex "u?'''"
regex_u'3f'22'22'22 = compileRegex "u?\"\"\""
regex_'40'5b'5fa'2dzA'2dZ'5d'5b'5c'2e'5fa'2dzA'2dZ0'2d9'5d'2a = compileRegex "@[_a-zA-Z][\\._a-zA-Z0-9]*"
regex_'25'28'28'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'29'3f'5b'230'5c'2d_'2b'5d'3f'28'5b1'2d9'5d'5b0'2d9'5d'2a'7c'5c'2a'29'3f'28'5c'2e'28'5b1'2d9'5d'5b0'2d9'5d'2a'7c'5c'2a'29'29'3f'5bhlL'5d'3f'5bcrsdiouxXeEfFgG'25'5d'7cprog'7cdefault'29 = compileRegex "%((\\([a-zA-Z0-9_]+\\))?[#0\\- +]?([1-9][0-9]*|\\*)?(\\.([1-9][0-9]*|\\*))?[hlL]?[crsdiouxXeEfFgG%]|prog|default)"

defaultAttributes = [("Normal",NormalTok),("CheckForString",NormalTok),("parenthesised",NormalTok),("Hash comment",CommentTok),("Tripple A-comment",CommentTok),("Tripple Q-comment",CommentTok),("Single A-comment",CommentTok),("Single Q-comment",CommentTok),("stringformat",OtherTok),("Tripple A-string",StringTok),("Raw Tripple A-string",StringTok),("Tripple Q-string",StringTok),("Raw Tripple Q-string",StringTok),("Single A-string",StringTok),("Single Q-string",StringTok),("Raw A-string",StringTok),("Raw Q-string",StringTok)]

parseRules "Normal" =
  (((pLineContinue >>= withAttribute NormalTok) >>~ pushContext "CheckForString")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_prep >>= withAttribute CharTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_defs >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_operators >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_commands >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_flow >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_builtinfuncs >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_specialvars >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_bindings >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_exceptions >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_overloaders >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ'5f0'2d9'5d'2b >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex__'28'28'28'5b0'2d9'5d'2a'5c'2e'5b0'2d9'5d'2b'7c'5b0'2d9'5d'2b'5c'2e'29'7c'28'5b0'2d9'5d'2b'7c'28'5b0'2d9'5d'2a'5c'2e'5b0'2d9'5d'2b'7c'5b0'2d9'5d'2b'5c'2e'29'29'5beE'5d'28'5c'2b'7c'2d'29'3f'5b0'2d9'5d'2b'29'7c'5b0'2d9'5d'2b'29'5bjJ'5d >>= withAttribute OtherTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   (withChildren (pInt >>= withAttribute DecValTok) ((pString False "L" >>= withAttribute DecValTok)))
   <|>
   ((pString False "r'''" >>= withAttribute StringTok) >>~ pushContext "Raw Tripple A-string")
   <|>
   ((pString False "r\"\"\"" >>= withAttribute StringTok) >>~ pushContext "Raw Tripple Q-string")
   <|>
   ((pString False "r'" >>= withAttribute StringTok) >>~ pushContext "Raw A-string")
   <|>
   ((pString False "r\"" >>= withAttribute StringTok) >>~ pushContext "Raw Q-string")
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext "Hash comment")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_u'3f'27'27'27 >>= withAttribute CommentTok) >>~ pushContext "Tripple A-comment")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_u'3f'22'22'22 >>= withAttribute CommentTok) >>~ pushContext "Tripple Q-comment")
   <|>
   ((pString False "'''" >>= withAttribute StringTok) >>~ pushContext "Tripple A-string")
   <|>
   ((pString False "u'''" >>= withAttribute StringTok) >>~ pushContext "Tripple A-string")
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ pushContext "Tripple Q-string")
   <|>
   ((pString False "u\"\"\"" >>= withAttribute StringTok) >>~ pushContext "Tripple Q-string")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "Single A-string")
   <|>
   ((pDetect2Chars False 'u' '\'' >>= withAttribute StringTok) >>~ pushContext "Single A-string")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "Single Q-string")
   <|>
   ((pDetect2Chars False 'u' '"' >>= withAttribute StringTok) >>~ pushContext "Single Q-string")
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "parenthesised")
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pAnyChar "+*/%\\|=;\\!<>!^&~-" >>= withAttribute NormalTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'40'5b'5fa'2dzA'2dZ'5d'5b'5c'2e'5fa'2dzA'2dZ0'2d9'5d'2a >>= withAttribute OtherTok)))

parseRules "CheckForString" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pString False "'''" >>= withAttribute StringTok) >>~ pushContext "Tripple A-string")
   <|>
   ((pString False "u'''" >>= withAttribute StringTok) >>~ pushContext "Tripple A-string")
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ pushContext "Tripple Q-string")
   <|>
   ((pString False "u\"\"\"" >>= withAttribute StringTok) >>~ pushContext "Tripple Q-string")
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "parenthesised" =
  ((parseRules "Normal"))

parseRules "Hash comment" =
  ((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression >>= ((withAttribute CommentTok) . snd)))

parseRules "Tripple A-comment" =
  (((pString False "'''" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "Tripple Q-comment" =
  (((pHlCChar >>= withAttribute CommentTok))
   <|>
   ((pString False "\"\"\"" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "Single A-comment" =
  (((pHlCStringChar >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "Single Q-comment" =
  (((pHlCStringChar >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "stringformat" =
  ((pRegExpr regex_'25'28'28'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'29'3f'5b'230'5c'2d_'2b'5d'3f'28'5b1'2d9'5d'5b0'2d9'5d'2a'7c'5c'2a'29'3f'28'5c'2e'28'5b1'2d9'5d'5b0'2d9'5d'2a'7c'5c'2a'29'29'3f'5bhlL'5d'3f'5bcrsdiouxXeEfFgG'25'5d'7cprog'7cdefault'29 >>= withAttribute OtherTok))

parseRules "Tripple A-string" =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((parseRules "stringformat"))
   <|>
   ((pString False "'''" >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Raw Tripple A-string" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((parseRules "stringformat"))
   <|>
   ((pString False "'''" >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Tripple Q-string" =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((parseRules "stringformat"))
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Raw Tripple Q-string" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((parseRules "stringformat"))
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Single A-string" =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((parseRules "stringformat"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Single Q-string" =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((parseRules "stringformat"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Raw A-string" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((parseRules "stringformat"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Raw Q-string" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((parseRules "stringformat"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
