{- This module was generated from data in the Kate syntax
   highlighting file doxygen.xml, version 1.32, by Dominik Haumann (dhdev@gmx.de) -}

module Text.Highlighting.Kate.Syntax.Doxygen
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Doxygen"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.dox;*.doxygen"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Doxygen" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Doxygen",["Normal"])], synStLanguage = "Doxygen", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "LineComment" -> (popContext) >> pEndLine
    "BlockComment" -> return ()
    "ML_TagWord" -> (popContext) >> pEndLine
    "ML_TagParam" -> (popContext) >> pEndLine
    "ML_TagWordWord" -> (popContext) >> pEndLine
    "ML_Tag2ndWord" -> (popContext >> popContext) >> pEndLine
    "ML_TagString" -> (popContext) >> pEndLine
    "ML_TagWordString" -> (popContext) >> pEndLine
    "ML_htmltag" -> return ()
    "ML_htmlcomment" -> return ()
    "ML_identifiers" -> return ()
    "ML_types1" -> return ()
    "ML_types2" -> return ()
    "SL_TagWord" -> (popContext) >> pEndLine
    "SL_TagParam" -> (popContext) >> pEndLine
    "SL_TagWordWord" -> (popContext) >> pEndLine
    "SL_Tag2ndWord" -> (popContext >> popContext) >> pEndLine
    "SL_TagString" -> (popContext) >> pEndLine
    "SL_TagWordString" -> (popContext) >> pEndLine
    "SL_htmltag" -> (popContext) >> pEndLine
    "SL_htmlcomment" -> (popContext) >> pEndLine
    "SL_identifiers" -> (popContext) >> pEndLine
    "SL_types1" -> (popContext) >> pEndLine
    "SL_types2" -> (popContext) >> pEndLine
    "SL_DetectEnv" -> (popContext) >> pEndLine
    "SL_DetectComment" -> (popContext) >> pEndLine
    "Code" -> return ()
    "Verbatim" -> return ()
    "Formula" -> return ()
    "Msc" -> return ()
    "Dot" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_TagOnly = Set.fromList $ words $ "\\arg \\attention \\author \\callgraph \\callergraph \\details \\dot \\else \\endcond \\enddot \\endhtmlonly \\endif \\endlatexonly \\endlink \\endmanonly \\endmsc \\endverbatim \\endxmlonly \\f[ \\f] \\f$ \\hideinitializer \\htmlonly \\interface \\internal \\invariant \\~ \\@ \\$ \\\\ \\# \\latexonly \\li \\manonly \\msc \\n \\nosubgrouping \\note \\only \\post \\pre \\private \\privatesection \\protected \\protectedsection \\public \\publicsection \\remarks \\return \\returns \\showinitializer \\since \\test \\todo \\verbatim \\warning \\xmlonly @arg @attention @author @callgraph @callergraph @details @dot @else @endcond @enddot @endhtmlonly @endif @endlatexonly @endlink @endmanonly @endmsc @endverbatim @endxmlonly @f[ @f] @f$ @hideinitializer @htmlonly @interface @internal @invariant @~ @@ @$ @\\ @# @latexonly @li @manonly @msc @n @nosubgrouping @note @only @post @pre @pivate @pivatesection @protected @protectedsection @public @publicsection @remarks @return @returns @showinitializer @since @test @todo @verbatim @warning @xmlonly"
list_TagWord = Set.fromList $ words $ "\\addtogroup \\a \\anchor \\b \\c \\class \\cond \\copybrief \\copydetails \\copydoc \\def \\dir \\dontinclude \\dotfile \\e \\elseif \\em \\enum \\example \\exception \\exceptions \\extends \\file \\htmlinclude \\if \\ifnot \\implements \\include \\includelineno \\link \\memberof \\namespace \\p \\package \\property \\protocol \\ref \\relatesalso \\relates \\retval \\throw \\throws \\verbinclude \\version \\xrefitem @addtogroup @a @anchor @b @c @class @cond @copybrief @copydetails @copydoc @def @dir @dontinclude @dotfile @e @elseif @em @enum @example @exception @exceptions @extends @file @htmlinclude @if @ifnot @implements @include @includelineno @link @memberof @namespace @p @package @property @prtocol @ref @relatesalso @relates @retval @throw @throws @verbinclude @version @xrefitem"
list_TagParam = Set.fromList $ words $ "\\param \\tparam @param @tparam"
list_TagWordWord = Set.fromList $ words $ "\\image @image"
list_TagWordString = Set.fromList $ words $ "\\category \\defgroup \\headerfile \\page \\paragraph \\section \\struct \\subpage \\subsection \\subsubsection \\union \\weakgroup @category @defgroup @headerfile @page @paragraph @section @struct @subpage @subsection @subsubsection @union @weakgroup"
list_TagString = Set.fromList $ words $ "\\addindex \\brief \\bug \\date \\deprecated \\fn \\ingroup \\line \\mainpage \\name \\overload \\par \\sa \\see \\short \\skip \\skipline \\typedef \\until \\var @addindex @brief @bug @date @deprecated @fn @ingroup @line @mainpage @name @overload @par @sa @see @short @skip @skipline @typedef @until @var"

regex_'2f'2f'28'21'7c'28'2f'28'3f'3d'5b'5e'2f'5d'7c'24'29'29'29'3c'3f = compileRegex "//(!|(/(?=[^/]|$)))<?"
regex_'2f'5c'2a'28'5c'2a'5b'5e'2a'2f'5d'7c'21'7c'5b'2a'21'5d'3c'7c'5c'2a'24'29 = compileRegex "/\\*(\\*[^*/]|!|[*!]<|\\*$)"
regex_'2f'2f'5cs'2a'40'5c'7b'5cs'2a'24 = compileRegex "//\\s*@\\{\\s*$"
regex_'2f'2f'5cs'2a'40'5c'7d'5cs'2a'24 = compileRegex "//\\s*@\\}\\s*$"
regex_'2f'5c'2a'5cs'2a'40'5c'7b'5cs'2a'5c'2a'2f = compileRegex "/\\*\\s*@\\{\\s*\\*/"
regex_'2f'5c'2a'5cs'2a'40'5c'7d'5cs'2a'5c'2a'2f = compileRegex "/\\*\\s*@\\}\\s*\\*/"
regex_'3c'5c'2f'3f'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a = compileRegex "<\\/?[a-zA-Z_:][a-zA-Z0-9._:-]*"
regex_'5c'5c'28'3c'7c'3e'29 = compileRegex "\\\\(<|>)"
regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 = compileRegex "\\S(?=([][,?;()]|\\.$|\\.?\\s))"
regex_'5cS = compileRegex "\\S"
regex_'2e = compileRegex "."
regex_'5cs'2a'3d'5cs'2a = compileRegex "\\s*=\\s*"
regex_'5cs'2a'23'3f'5ba'2dzA'2dZ0'2d9'5d'2a = compileRegex "\\s*#?[a-zA-Z0-9]*"
regex_'5b'40'5c'5c'5dcode = compileRegex "[@\\\\]code"
regex_'5b'40'5c'5c'5dverbatim = compileRegex "[@\\\\]verbatim"
regex_'5b'40'5c'5c'5df'5c'5b = compileRegex "[@\\\\]f\\["
regex_'5b'40'5c'5c'5dmsc = compileRegex "[@\\\\]msc"
regex_'5b'40'5c'5c'5ddot = compileRegex "[@\\\\]dot"
regex_'5b'40'5c'5c'5dendcode = compileRegex "[@\\\\]endcode"
regex_'5b'40'5c'5c'5dendverbatim = compileRegex "[@\\\\]endverbatim"
regex_'5b'40'5c'5c'5df'5c'5d = compileRegex "[@\\\\]f\\]"
regex_'5b'40'5c'5c'5dendmsc = compileRegex "[@\\\\]endmsc"
regex_'5b'40'5c'5c'5denddot = compileRegex "[@\\\\]enddot"

defaultAttributes = [("Normal",NormalTok),("LineComment",CommentTok),("BlockComment",CommentTok),("ML_TagWord",CommentTok),("ML_TagParam",CommentTok),("ML_TagWordWord",CommentTok),("ML_Tag2ndWord",CommentTok),("ML_TagString",CommentTok),("ML_TagWordString",CommentTok),("ML_htmltag",OtherTok),("ML_htmlcomment",CommentTok),("ML_identifiers",OtherTok),("ML_types1",DataTypeTok),("ML_types2",DataTypeTok),("SL_TagWord",CommentTok),("SL_TagParam",CommentTok),("SL_TagWordWord",CommentTok),("SL_Tag2ndWord",CommentTok),("SL_TagString",CommentTok),("SL_TagWordString",CommentTok),("SL_htmltag",OtherTok),("SL_htmlcomment",CommentTok),("SL_identifiers",OtherTok),("SL_types1",DataTypeTok),("SL_types2",DataTypeTok),("SL_DetectEnv",NormalTok),("SL_DetectComment",NormalTok),("Code",CommentTok),("Verbatim",CommentTok),("Formula",CommentTok),("Msc",CommentTok),("Dot",CommentTok)]

parseRules "Normal" =
  (((pRegExpr regex_'2f'2f'28'21'7c'28'2f'28'3f'3d'5b'5e'2f'5d'7c'24'29'29'29'3c'3f >>= withAttribute CommentTok) >>~ pushContext "LineComment")
   <|>
   ((pRegExpr regex_'2f'5c'2a'28'5c'2a'5b'5e'2a'2f'5d'7c'21'7c'5b'2a'21'5d'3c'7c'5c'2a'24'29 >>= withAttribute CommentTok) >>~ pushContext "BlockComment")
   <|>
   ((pRegExpr regex_'2f'2f'5cs'2a'40'5c'7b'5cs'2a'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pRegExpr regex_'2f'2f'5cs'2a'40'5c'7d'5cs'2a'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pRegExpr regex_'2f'5c'2a'5cs'2a'40'5c'7b'5cs'2a'5c'2a'2f >>= withAttribute RegionMarkerTok))
   <|>
   ((pRegExpr regex_'2f'5c'2a'5cs'2a'40'5c'7d'5cs'2a'5c'2a'2f >>= withAttribute RegionMarkerTok)))

parseRules "LineComment" =
  (((pLineContinue >>= withAttribute CommentTok))
   <|>
   ((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((parseRules "SL_DetectEnv"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagOnly >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWord >>= withAttribute KeywordTok) >>~ pushContext "SL_TagWord")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagParam >>= withAttribute KeywordTok) >>~ pushContext "SL_TagParam")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWordWord >>= withAttribute KeywordTok) >>~ pushContext "SL_TagWordWord")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagString >>= withAttribute KeywordTok) >>~ pushContext "SL_TagString")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWordString >>= withAttribute KeywordTok) >>~ pushContext "SL_TagWordString")
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext "SL_htmlcomment")
   <|>
   ((pDetect2Chars False '<' '<' >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'3c'5c'2f'3f'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "SL_htmltag"))

parseRules "BlockComment" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '@' '{' >>= withAttribute RegionMarkerTok))
   <|>
   ((pDetect2Chars False '@' '}' >>= withAttribute RegionMarkerTok))
   <|>
   ((parseRules "SL_DetectEnv"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagOnly >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWord >>= withAttribute KeywordTok) >>~ pushContext "ML_TagWord")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagParam >>= withAttribute KeywordTok) >>~ pushContext "ML_TagParam")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWordWord >>= withAttribute KeywordTok) >>~ pushContext "ML_TagWordWord")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagString >>= withAttribute KeywordTok) >>~ pushContext "ML_TagString")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWordString >>= withAttribute KeywordTok) >>~ pushContext "ML_TagWordString")
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5c'5c'28'3c'7c'3e'29 >>= withAttribute KeywordTok))
   <|>
   ((pDetect2Chars False '<' '<' >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'3c'5c'2f'3f'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "ML_htmltag")
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext "ML_htmlcomment"))

parseRules "ML_TagWord" =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules "SL_TagWord")))

parseRules "ML_TagParam" =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pString False "[in]" >>= withAttribute KeywordTok) >>~ pushContext "ML_Tag2ndWord")
   <|>
   ((pString False "[out]" >>= withAttribute KeywordTok) >>~ pushContext "ML_Tag2ndWord")
   <|>
   ((pString False "[in,out]" >>= withAttribute KeywordTok) >>~ pushContext "ML_Tag2ndWord")
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok)))

parseRules "ML_TagWordWord" =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext "ML_Tag2ndWord")
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok)))

parseRules "ML_Tag2ndWord" =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules "SL_Tag2ndWord")))

parseRules "ML_TagString" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext "ML_htmlcomment")
   <|>
   ((pDetect2Chars False '<' '<' >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'3c'5c'2f'3f'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "ML_htmltag")
   <|>
   ((pRegExpr regex_'2e >>= withAttribute StringTok)))

parseRules "ML_TagWordString" =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules "SL_TagWordString")))

parseRules "ML_htmltag" =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute OtherTok) >>~ pushContext "ML_identifiers"))

parseRules "ML_htmlcomment" =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pString False "-->" >>= withAttribute CommentTok) >>~ (popContext)))

parseRules "ML_identifiers" =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'5cs'2a'23'3f'5ba'2dzA'2dZ0'2d9'5d'2a >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '\'' >>= withAttribute DataTypeTok) >>~ pushContext "ML_types1")
   <|>
   ((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ pushContext "ML_types2"))

parseRules "ML_types1" =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectChar False '\'' >>= withAttribute DataTypeTok) >>~ (popContext >> popContext)))

parseRules "ML_types2" =
  (((lookAhead (pDetect2Chars False '*' '/') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ (popContext >> popContext)))

parseRules "SL_TagWord" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((lookAhead (pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}" list_TagWord) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok)))

parseRules "SL_TagParam" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pString False "[in]" >>= withAttribute KeywordTok) >>~ pushContext "SL_Tag2ndWord")
   <|>
   ((pString False "[out]" >>= withAttribute KeywordTok) >>~ pushContext "SL_Tag2ndWord")
   <|>
   ((pString False "[in,out]" >>= withAttribute KeywordTok) >>~ pushContext "SL_Tag2ndWord")
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok)))

parseRules "SL_TagWordWord" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext "SL_Tag2ndWord")
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok)))

parseRules "SL_Tag2ndWord" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok)))

parseRules "SL_TagString" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext "SL_htmlcomment")
   <|>
   ((pDetect2Chars False '<' '<' >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'3c'5c'2f'3f'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "SL_htmltag")
   <|>
   ((pRegExpr regex_'2e >>= withAttribute StringTok)))

parseRules "SL_TagWordString" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5cS'28'3f'3d'28'5b'5d'5b'2c'3f'3b'28'29'5d'7c'5c'2e'24'7c'5c'2e'3f'5cs'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute KeywordTok)))

parseRules "SL_htmltag" =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute OtherTok) >>~ pushContext "SL_identifiers"))

parseRules "SL_htmlcomment" =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pString False "-->" >>= withAttribute CommentTok) >>~ (popContext)))

parseRules "SL_identifiers" =
  (((pRegExpr regex_'5cs'2a'23'3f'5ba'2dzA'2dZ0'2d9'5d'2a >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '\'' >>= withAttribute DataTypeTok) >>~ pushContext "SL_types1")
   <|>
   ((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ pushContext "SL_types2"))

parseRules "SL_types1" =
  ((pDetectChar False '\'' >>= withAttribute DataTypeTok) >>~ (popContext >> popContext))

parseRules "SL_types2" =
  ((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ (popContext >> popContext))

parseRules "SL_DetectEnv" =
  (((pRegExpr regex_'5b'40'5c'5c'5dcode >>= withAttribute KeywordTok) >>~ pushContext "Code")
   <|>
   ((pRegExpr regex_'5b'40'5c'5c'5dverbatim >>= withAttribute KeywordTok) >>~ pushContext "Verbatim")
   <|>
   ((pRegExpr regex_'5b'40'5c'5c'5df'5c'5b >>= withAttribute KeywordTok) >>~ pushContext "Formula")
   <|>
   ((pRegExpr regex_'5b'40'5c'5c'5dmsc >>= withAttribute KeywordTok) >>~ pushContext "Msc")
   <|>
   ((pRegExpr regex_'5b'40'5c'5c'5ddot >>= withAttribute KeywordTok) >>~ pushContext "Dot"))

parseRules "SL_DetectComment" =
  ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext >> popContext))

parseRules "Code" =
  (((parseRules "SL_DetectComment"))
   <|>
   ((pRegExpr regex_'5b'40'5c'5c'5dendcode >>= withAttribute KeywordTok) >>~ (popContext)))

parseRules "Verbatim" =
  (((parseRules "SL_DetectComment"))
   <|>
   ((pRegExpr regex_'5b'40'5c'5c'5dendverbatim >>= withAttribute KeywordTok) >>~ (popContext)))

parseRules "Formula" =
  (((parseRules "SL_DetectComment"))
   <|>
   ((pRegExpr regex_'5b'40'5c'5c'5df'5c'5d >>= withAttribute KeywordTok) >>~ (popContext)))

parseRules "Msc" =
  (((parseRules "SL_DetectComment"))
   <|>
   ((pRegExpr regex_'5b'40'5c'5c'5dendmsc >>= withAttribute KeywordTok) >>~ (popContext)))

parseRules "Dot" =
  (((parseRules "SL_DetectComment"))
   <|>
   ((pRegExpr regex_'5b'40'5c'5c'5denddot >>= withAttribute KeywordTok) >>~ (popContext)))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
