{- This module was generated from data in the Kate syntax
   highlighting file bash.xml, version 2.12, by Wilbert Berendsen (wilbert@kde.nl) -}

module Text.Highlighting.Kate.Syntax.Bash
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Bash"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.sh;*.bash;*.ebuild;*.eclass;.bashrc;.bash_profile;.bash_login;.profile"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Bash" }
  context <- currentContext <|> (pushContext "Start" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Bash",["Start"])], synStLanguage = "Bash", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Start" -> return ()
    "FindAll" -> return ()
    "FindMost" -> return ()
    "FindComments" -> (popContext) >> pEndLine
    "Comment" -> (popContext) >> pEndLine
    "FindCommentsParen" -> (popContext) >> pEndLine
    "CommentParen" -> (popContext) >> pEndLine
    "FindCommentsBackq" -> (popContext) >> pEndLine
    "CommentBackq" -> (popContext) >> pEndLine
    "FindCommands" -> return ()
    "FindOthers" -> return ()
    "FindStrings" -> return ()
    "FindSubstitutions" -> return ()
    "FindTests" -> return ()
    "ExprDblParen" -> return ()
    "ExprDblParenSubst" -> return ()
    "ExprSubParen" -> return ()
    "ExprBracket" -> return ()
    "ExprDblBracket" -> return ()
    "Group" -> return ()
    "SubShell" -> return ()
    "Assign" -> (popContext) >> pEndLine
    "AssignArray" -> (popContext) >> pEndLine
    "AssignSubscr" -> (popContext) >> pEndLine
    "Subscript" -> return ()
    "FunctionDef" -> (popContext) >> pEndLine
    "VarName" -> (popContext) >> pEndLine
    "ProcessSubst" -> return ()
    "StringSQ" -> return ()
    "StringDQ" -> return ()
    "StringEsc" -> return ()
    "VarBrace" -> return ()
    "VarAlt" -> return ()
    "VarSubst" -> return ()
    "VarSubst2" -> return ()
    "VarSub" -> return ()
    "VarSub2" -> return ()
    "SubstFile" -> return ()
    "SubstCommand" -> return ()
    "SubstBackq" -> return ()
    "Case" -> return ()
    "CaseIn" -> return ()
    "CaseExpr" -> return ()
    "HereDoc" -> return ()
    "HereDocRemainder" -> (popContext) >> pEndLine
    "HereDocQ" -> return ()
    "HereDocNQ" -> return ()
    "HereDocIQ" -> return ()
    "HereDocINQ" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "else for function in select until while elif then set"
list_builtins = Set.fromList $ words $ ": source alias bg bind break builtin cd caller command compgen complete continue dirs disown echo enable eval exec exit fc fg getopts hash help history jobs kill let logout popd printf pushd pwd return set shift shopt suspend test time times trap type ulimit umask unalias wait"
list_builtins'5fvar = Set.fromList $ words $ "export unset declare typeset local read readonly"
list_unixcommands = Set.fromList $ words $ "arch awk bash bunzip2 bzcat bzcmp bzdiff bzegrep bzfgrep bzgrep bzip2 bzip2recover bzless bzmore cat chattr chgrp chmod chown chvt cp date dd deallocvt df dir dircolors dmesg dnsdomainname domainname du dumpkeys echo ed egrep false fgconsole fgrep fuser gawk getkeycodes gocr grep groff groups gunzip gzexe gzip hostname igawk install kbd_mode kbdrate killall last lastb link ln loadkeys loadunimap login ls lsattr lsmod lsmod.old lzcat lzcmp lzdiff lzegrep lzfgrep lzgrep lzless lzcat lzma lzmainfo lzmore mapscrn mesg mkdir mkfifo mknod mktemp more mount mv nano netstat nisdomainname nroff openvt pgawk pidof ping ps pstree pwd rbash readlink red resizecons rm rmdir run-parts sash sed setfont setkeycodes setleds setmetamode setserial sh showkey shred sleep ssed stat stty su sync tar tempfile touch troff true umount uname unicode_start unicode_stop unlink unlzma unxz utmpdump uuidgen vdir wall wc xz xzcat ypdomainname zcat zcmp zdiff zegrep zfgrep zforce zgrep zless zmore znew zsh aclocal aconnect aplay apm apmsleep apropos ar arecord as as86 autoconf autoheader automake awk basename bc bison c++ cal cat cc cdda2wav cdparanoia cdrdao cd-read cdrecord chfn chgrp chmod chown chroot chsh clear cmp co col comm cp cpio cpp cut dc dd df diff diff3 dir dircolors directomatic dirname du env expr fbset file find flex flex++ fmt free ftp funzip fuser g++ gawk gc gcc gdb getent getopt gettext gettextize gimp gimp-remote gimptool gmake gs head hexdump id install join kill killall ld ld86 ldd less lex ln locate lockfile logname lp lpr ls lynx m4 make man mkdir mknod msgfmt mv namei nasm nawk nice nl nm nm86 nmap nohup nop od passwd patch pcregrep pcretest perl perror pidof pr printf procmail prune ps2ascii ps2epsi ps2frag ps2pdf ps2ps psbook psmerge psnup psresize psselect pstops rcs rev rm scp sed seq setterm shred size size86 skill slogin snice sort sox split ssh ssh-add ssh-agent ssh-keygen ssh-keyscan stat strings strip sudo suidperl sum tac tail tee test tr uniq unlink unzip updatedb updmap uptime users vmstat w wc wget whatis whereis which who whoami write xargs yacc yes zip zsoelim dcop kdialog kfile xhost xmodmap xset"

regex_'5b'5cs'3b'5d'28'3f'3d'23'29 = compileRegex "[\\s;](?=#)"
regex_'5b'5e'29'5d'28'3f'3d'5c'29'29 = compileRegex "[^)](?=\\))"
regex_'5b'5e'60'5d'28'3f'3d'60'29 = compileRegex "[^`](?=`)"
regex_'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex "\\[\\[(?=($|\\s))"
regex_'5cs'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex "\\s\\[\\[(?=($|\\s))"
regex_'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex "\\[(?=($|\\s))"
regex_'5cs'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex "\\s\\[(?=($|\\s))"
regex_'5c'7b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex "\\{(?=($|\\s))"
regex_'5cbdo'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex "\\bdo(?![\\w$+-])"
regex_'5cbdone'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex "\\bdone(?![\\w$+-])"
regex_'5cbif_'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex "\\bif (?![\\w$+-])"
regex_'5cbfi'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex "\\bfi(?![\\w$+-])"
regex_'5cbcase'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex "\\bcase(?![\\w$+-])"
regex_'2d'5bA'2dZa'2dz0'2d9'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex "-[A-Za-z0-9][A-Za-z0-9_]*"
regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a = compileRegex "--[a-z][A-Za-z0-9_-]*"
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'2b'3f'3d = compileRegex "\\b[A-Za-z_][A-Za-z0-9_]*\\+?="
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'3f'3d'5c'5b'2e'2b'5c'5d'5c'2b'3f'3d'29 = compileRegex "\\b[A-Za-z_][A-Za-z0-9_]*(?=\\[.+\\]\\+?=)"
regex_'5cbfunction'5cb = compileRegex "\\bfunction\\b"
regex_'5c'2e'28'3f'3d'5cs'29 = compileRegex "\\.(?=\\s)"
regex_'5cd'2a'3c'3c'3c = compileRegex "\\d*<<<"
regex_'5b'3c'3e'5d'5c'28 = compileRegex "[<>]\\("
regex_'28'5b0'2d9'5d'2a'28'3e'7b1'2c2'7d'7c'3c'29'28'26'5b0'2d9'5d'2b'2d'3f'29'3f'7c'26'3e'7c'3e'26'7c'5b0'2d9'5d'2a'3c'3e'29 = compileRegex "([0-9]*(>{1,2}|<)(&[0-9]+-?)?|&>|>&|[0-9]*<>)"
regex_'28'5b'7c'26'5d'29'5c1'3f = compileRegex "([|&])\\1?"
regex_'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'5cs'2a'5c'28'5c'29 = compileRegex "[A-Za-z_:][A-Za-z0-9_:#%@-]*\\s*\\(\\)"
regex_'5c'5c'5b'5d'5b'3b'5c'5c'24'60'7b'7d'28'29'7c'26'3c'3e'2a_'5d = compileRegex "\\\\[][;\\\\$`{}()|&<>* ]"
regex_'5c'5c'24 = compileRegex "\\\\$"
regex_'5c'7b'28'3f'21'28'5cs'7c'24'29'29'5cS'2a'5c'7d = compileRegex "\\{(?!(\\s|$))\\S*\\}"
regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'2f'29 = compileRegex "([\\w_@.%*?+-]|\\\\ )*(?=/)"
regex_'7e'5cw'2a = compileRegex "~\\w*"
regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'2f'29'3a'3b'24'60'27'22'5d'7c'24'29'29 = compileRegex "/([\\w_@.%*?+-]|\\\\ )*(?=([\\s/):;$`'\"]|$))"
regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'5b = compileRegex "\\$[A-Za-z_][A-Za-z0-9_]*\\["
regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex "\\$[A-Za-z_][A-Za-z0-9_]*"
regex_'5c'24'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d = compileRegex "\\$[*@#?$!_0-9-]"
regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'5c'7d = compileRegex "\\$\\{[*@#?$!_0-9-]\\}"
regex_'5c'24'5c'7b'23'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'29'3f'5c'7d = compileRegex "\\$\\{#[A-Za-z_][A-Za-z0-9_]*(\\[[*@]\\])?\\}"
regex_'5c'24'5c'7b'21'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'7c'5b'2a'40'5d'29'3f'5c'7d = compileRegex "\\$\\{![A-Za-z_][A-Za-z0-9_]*(\\[[*@]\\]|[*@])?\\}"
regex_'5c'24'5c'7b'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex "\\$\\{[A-Za-z_][A-Za-z0-9_]*"
regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'28'3f'3d'5b'3a'23'25'2f'3d'3f'2b'2d'5d'29 = compileRegex "\\$\\{[*@#?$!_0-9-](?=[:#%/=?+-])"
regex_'5c'5c'5b'60'24'5c'5c'5d = compileRegex "\\\\[`$\\\\]"
regex_'2d'5babcdefghkprstuwxOGLSNozn'5d'28'3f'3d'5cs'29 = compileRegex "-[abcdefghkprstuwxOGLSNozn](?=\\s)"
regex_'2d'28'5bno'5dt'7cef'29'28'3f'3d'5cs'29 = compileRegex "-([no]t|ef)(?=\\s)"
regex_'28'5b'21'3d'5d'3d'3f'7c'5b'3e'3c'5d'29'28'3f'3d'5cs'29 = compileRegex "([!=]=?|[><])(?=\\s)"
regex_'2d'28eq'7cne'7c'5bgl'5d'5bte'5d'29'28'3f'3d'5cs'29 = compileRegex "-(eq|ne|[gl][te])(?=\\s)"
regex_'5cs'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex "\\s\\](?=($|[\\s;|&]))"
regex_'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex "\\](?=($|[\\s;|&]))"
regex_'5cs'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex "\\s\\]\\](?=($|[\\s;|&]))"
regex_'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex "\\]\\](?=($|[\\s;|&]))"
regex_'5b'5cw'3a'2c'2b'5f'2e'2f'2d'5d = compileRegex "[\\w:,+_./-]"
regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'28'5cs'2a'5c'28'5c'29'29'3f = compileRegex "\\s+[A-Za-z_:][A-Za-z0-9_:#%@-]*(\\s*\\(\\))?"
regex_'2d'5bA'2dZa'2dz0'2d9'5d'2b = compileRegex "-[A-Za-z0-9]+"
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex "\\b[A-Za-z_][A-Za-z0-9_]*"
regex_'5b'5e'5d'7d'29'7c'3b'60'26'3e'3c'5d = compileRegex "[^]})|;`&><]"
regex_'5c'5c'5b'60'22'5c'5c'24'5cn'5d = compileRegex "\\\\[`\"\\\\$\\n]"
regex_'5c'5c'5babefnrtv'5c'5c'27'5d = compileRegex "\\\\[abefnrtv\\\\']"
regex_'5c'5c'28'5b0'2d7'5d'7b1'2c3'7d'7cx'5bA'2dFa'2df0'2d9'5d'7b1'2c2'7d'7cc'2e'29 = compileRegex "\\\\([0-7]{1,3}|x[A-Fa-f0-9]{1,2}|c.)"
regex_'28'3a'3f'5b'2d'3d'3f'2b'5d'7c'23'23'3f'7c'25'25'3f'29 = compileRegex "(:?[-=?+]|##?|%%?)"
regex_'2f'2f'3f = compileRegex "//?"
regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex "[A-Za-z_][A-Za-z0-9_]*"
regex_'5b0'2d9'5d'2b'28'3f'3d'5b'3a'7d'5d'29 = compileRegex "[0-9]+(?=[:}])"
regex_'5b0'2d9'5d'28'3f'3d'5b'3a'7d'5d'29 = compileRegex "[0-9](?=[:}])"
regex_'5csin'5cb = compileRegex "\\sin\\b"
regex_'5cbesac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 = compileRegex "\\besac(?=$|[\\s;)])"
regex_esac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 = compileRegex "esac(?=$|[\\s;)])"
regex_'28'3c'3c'2d'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29 = compileRegex "(<<-\\s*\"([^|&;()<>\\s]+)\")"
regex_'28'3c'3c'2d'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29 = compileRegex "(<<-\\s*'([^|&;()<>\\s]+)')"
regex_'28'3c'3c'2d'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex "(<<-\\s*\\\\([^|&;()<>\\s]+))"
regex_'28'3c'3c'2d'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex "(<<-\\s*([^|&;()<>\\s]+))"
regex_'28'3c'3c'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29 = compileRegex "(<<\\s*\"([^|&;()<>\\s]+)\")"
regex_'28'3c'3c'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29 = compileRegex "(<<\\s*'([^|&;()<>\\s]+)')"
regex_'28'3c'3c'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex "(<<\\s*\\\\([^|&;()<>\\s]+))"
regex_'28'3c'3c'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex "(<<\\s*([^|&;()<>\\s]+))"

defaultAttributes = [("Start",NormalTok),("FindAll",NormalTok),("FindMost",NormalTok),("FindComments",NormalTok),("Comment",CommentTok),("FindCommentsParen",NormalTok),("CommentParen",CommentTok),("FindCommentsBackq",NormalTok),("CommentBackq",CommentTok),("FindCommands",NormalTok),("FindOthers",NormalTok),("FindStrings",NormalTok),("FindSubstitutions",NormalTok),("FindTests",NormalTok),("ExprDblParen",NormalTok),("ExprDblParenSubst",NormalTok),("ExprSubParen",NormalTok),("ExprBracket",NormalTok),("ExprDblBracket",NormalTok),("Group",NormalTok),("SubShell",NormalTok),("Assign",NormalTok),("AssignArray",NormalTok),("AssignSubscr",NormalTok),("Subscript",OtherTok),("FunctionDef",FunctionTok),("VarName",NormalTok),("ProcessSubst",NormalTok),("StringSQ",StringTok),("StringDQ",StringTok),("StringEsc",StringTok),("VarBrace",ErrorTok),("VarAlt",NormalTok),("VarSubst",NormalTok),("VarSubst2",NormalTok),("VarSub",ErrorTok),("VarSub2",ErrorTok),("SubstFile",NormalTok),("SubstCommand",NormalTok),("SubstBackq",NormalTok),("Case",NormalTok),("CaseIn",NormalTok),("CaseExpr",NormalTok),("HereDoc",NormalTok),("HereDocRemainder",NormalTok),("HereDocQ",NormalTok),("HereDocNQ",NormalTok),("HereDocIQ",NormalTok),("HereDocINQ",NormalTok)]

parseRules "Start" =
  ((parseRules "FindAll"))

parseRules "FindAll" =
  (((parseRules "FindComments"))
   <|>
   ((parseRules "FindCommands"))
   <|>
   ((parseRules "FindStrings"))
   <|>
   ((parseRules "FindSubstitutions"))
   <|>
   ((parseRules "FindOthers")))

parseRules "FindMost" =
  (((parseRules "FindComments"))
   <|>
   ((parseRules "FindStrings"))
   <|>
   ((parseRules "FindSubstitutions"))
   <|>
   ((parseRules "FindOthers")))

parseRules "FindComments" =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute NormalTok) >>~ pushContext "Comment"))

parseRules "Comment" =
  ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))

parseRules "FindCommentsParen" =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext "CommentParen")
   <|>
   ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute NormalTok) >>~ pushContext "CommentParen"))

parseRules "CommentParen" =
  (((pRegExpr regex_'5b'5e'29'5d'28'3f'3d'5c'29'29 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "FindCommentsBackq" =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext "CommentBackq")
   <|>
   ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute NormalTok) >>~ pushContext "CommentBackq"))

parseRules "CommentBackq" =
  (((pRegExpr regex_'5b'5e'60'5d'28'3f'3d'60'29 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "FindCommands" =
  (((pDetect2Chars False '(' '(' >>= withAttribute KeywordTok) >>~ pushContext "ExprDblParen")
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext "ExprDblBracket")
   <|>
   ((pRegExpr regex_'5cs'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext "ExprDblBracket")
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext "ExprBracket")
   <|>
   ((pRegExpr regex_'5cs'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext "ExprBracket")
   <|>
   ((pRegExpr regex_'5c'7b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext "Group")
   <|>
   ((pDetectChar False '(' >>= withAttribute KeywordTok) >>~ pushContext "SubShell")
   <|>
   ((pRegExpr regex_'5cbdo'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbdone'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbif_'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbfi'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbcase'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok) >>~ pushContext "Case")
   <|>
   ((pRegExpr regex_'2d'5bA'2dZa'2dz0'2d9'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'2b'3f'3d >>= withAttribute OtherTok) >>~ pushContext "Assign")
   <|>
   ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'3f'3d'5c'5b'2e'2b'5c'5d'5c'2b'3f'3d'29 >>= withAttribute OtherTok) >>~ pushContext "AssignSubscr")
   <|>
   ((pString False ":()" >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5cbfunction'5cb >>= withAttribute KeywordTok) >>~ pushContext "FunctionDef")
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'2e'28'3f'3d'5cs'29 >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_builtins >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_unixcommands >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_builtins'5fvar >>= withAttribute KeywordTok) >>~ pushContext "VarName")
   <|>
   ((pRegExpr regex_'5cd'2a'3c'3c'3c >>= withAttribute KeywordTok))
   <|>
   ((lookAhead (pString False "<<") >> pushContext "HereDoc" >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'5b'3c'3e'5d'5c'28 >>= withAttribute KeywordTok) >>~ pushContext "ProcessSubst")
   <|>
   ((pRegExpr regex_'28'5b0'2d9'5d'2a'28'3e'7b1'2c2'7d'7c'3c'29'28'26'5b0'2d9'5d'2b'2d'3f'29'3f'7c'26'3e'7c'3e'26'7c'5b0'2d9'5d'2a'3c'3e'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5b'7c'26'5d'29'5c1'3f >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'5cs'2a'5c'28'5c'29 >>= withAttribute FunctionTok)))

parseRules "FindOthers" =
  (((pRegExpr regex_'5c'5c'5b'5d'5b'3b'5c'5c'24'60'7b'7d'28'29'7c'26'3c'3e'2a_'5d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'5c'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'7b'28'3f'21'28'5cs'7c'24'29'29'5cS'2a'5c'7d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'2f'29 >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'7e'5cw'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'2f'29'3a'3b'24'60'27'22'5d'7c'24'29'29 >>= withAttribute NormalTok)))

parseRules "FindStrings" =
  (((pDetect2Chars False '\\' '\'' >>= withAttribute DataTypeTok))
   <|>
   ((pDetect2Chars False '\\' '"' >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "StringSQ")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "StringDQ")
   <|>
   ((pDetect2Chars False '$' '\'' >>= withAttribute StringTok) >>~ pushContext "StringEsc")
   <|>
   ((pDetect2Chars False '$' '"' >>= withAttribute StringTok) >>~ pushContext "StringDQ"))

parseRules "FindSubstitutions" =
  (((pRegExpr regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'5b >>= withAttribute OtherTok) >>~ pushContext "Subscript")
   <|>
   ((pRegExpr regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'5c'7d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'23'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'29'3f'5c'7d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'21'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'7c'5b'2a'40'5d'29'3f'5c'7d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok) >>~ pushContext "VarBrace")
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'28'3f'3d'5b'3a'23'25'2f'3d'3f'2b'2d'5d'29 >>= withAttribute OtherTok) >>~ pushContext "VarBrace")
   <|>
   ((pString False "$((" >>= withAttribute OtherTok) >>~ pushContext "ExprDblParenSubst")
   <|>
   ((pString False "$(<" >>= withAttribute KeywordTok) >>~ pushContext "SubstFile")
   <|>
   ((pString False "$(" >>= withAttribute OtherTok) >>~ pushContext "SubstCommand")
   <|>
   ((pDetectChar False '`' >>= withAttribute KeywordTok) >>~ pushContext "SubstBackq")
   <|>
   ((pRegExpr regex_'5c'5c'5b'60'24'5c'5c'5d >>= withAttribute DataTypeTok)))

parseRules "FindTests" =
  (((pRegExpr regex_'2d'5babcdefghkprstuwxOGLSNozn'5d'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'2d'28'5bno'5dt'7cef'29'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'28'5b'21'3d'5d'3d'3f'7c'5b'3e'3c'5d'29'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'2d'28eq'7cne'7c'5bgl'5d'5bte'5d'29'28'3f'3d'5cs'29 >>= withAttribute OtherTok)))

parseRules "ExprDblParen" =
  (((pDetect2Chars False ')' ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "ExprSubParen")
   <|>
   ((parseRules "FindMost")))

parseRules "ExprDblParenSubst" =
  (((pDetect2Chars False ')' ')' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "ExprSubParen")
   <|>
   ((parseRules "FindMost")))

parseRules "ExprSubParen" =
  (((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "ExprSubParen")
   <|>
   ((parseRules "FindMost")))

parseRules "ExprBracket" =
  (((pRegExpr regex_'5cs'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "ExprSubParen")
   <|>
   ((parseRules "FindTests"))
   <|>
   ((parseRules "FindMost")))

parseRules "ExprDblBracket" =
  (((pRegExpr regex_'5cs'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "ExprSubParen")
   <|>
   ((parseRules "FindTests"))
   <|>
   ((parseRules "FindMost")))

parseRules "Group" =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules "FindAll")))

parseRules "SubShell" =
  (((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules "FindAll")))

parseRules "Assign" =
  (((pDetectChar False '(' >>= withAttribute OtherTok) >>~ pushContext "AssignArray")
   <|>
   ((parseRules "FindStrings"))
   <|>
   ((parseRules "FindSubstitutions"))
   <|>
   ((parseRules "FindOthers"))
   <|>
   ((pRegExpr regex_'5b'5cw'3a'2c'2b'5f'2e'2f'2d'5d >>= withAttribute NormalTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "AssignArray" =
  (((pDetectChar False ')' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext "Subscript")
   <|>
   ((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext "Assign")
   <|>
   ((parseRules "FindMost")))

parseRules "AssignSubscr" =
  (((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext "Subscript")
   <|>
   ((pDetect2Chars False '+' '=' >>= withAttribute OtherTok) >>~ pushContext "Assign")
   <|>
   ((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext "Assign")
   <|>
   ((parseRules "FindStrings"))
   <|>
   ((parseRules "FindSubstitutions"))
   <|>
   ((parseRules "FindOthers"))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "Subscript" =
  (((pDetectChar False ']' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((parseRules "FindStrings"))
   <|>
   ((parseRules "FindSubstitutions"))
   <|>
   ((parseRules "FindOthers")))

parseRules "FunctionDef" =
  (((pRegExpr regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'28'5cs'2a'5c'28'5c'29'29'3f >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "VarName" =
  (((pRegExpr regex_'2d'5bA'2dZa'2dz0'2d9'5d'2b >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext "Subscript")
   <|>
   ((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext "Assign")
   <|>
   ((parseRules "FindMost"))
   <|>
   ((pRegExpr regex_'5b'5e'5d'7d'29'7c'3b'60'26'3e'3c'5d >>= withAttribute NormalTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "ProcessSubst" =
  (((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules "FindCommentsParen"))
   <|>
   ((parseRules "FindCommands"))
   <|>
   ((parseRules "FindStrings"))
   <|>
   ((parseRules "FindSubstitutions"))
   <|>
   ((parseRules "FindOthers")))

parseRules "StringSQ" =
  ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))

parseRules "StringDQ" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'5b'60'22'5c'5c'24'5cn'5d >>= withAttribute DataTypeTok))
   <|>
   ((parseRules "FindSubstitutions")))

parseRules "StringEsc" =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'5babefnrtv'5c'5c'27'5d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'5c'28'5b0'2d7'5d'7b1'2c3'7d'7cx'5bA'2dFa'2df0'2d9'5d'7b1'2c2'7d'7cc'2e'29 >>= withAttribute DataTypeTok)))

parseRules "VarBrace" =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext "Subscript")
   <|>
   ((pRegExpr regex_'28'3a'3f'5b'2d'3d'3f'2b'5d'7c'23'23'3f'7c'25'25'3f'29 >>= withAttribute OtherTok) >>~ pushContext "VarAlt")
   <|>
   ((pRegExpr regex_'2f'2f'3f >>= withAttribute OtherTok) >>~ pushContext "VarSubst")
   <|>
   ((pDetectChar False ':' >>= withAttribute OtherTok) >>~ pushContext "VarSub"))

parseRules "VarAlt" =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "FindStrings"))
   <|>
   ((parseRules "FindSubstitutions")))

parseRules "VarSubst" =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '/' >>= withAttribute OtherTok) >>~ pushContext "VarSubst2")
   <|>
   ((parseRules "FindStrings"))
   <|>
   ((parseRules "FindSubstitutions")))

parseRules "VarSubst2" =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules "FindStrings"))
   <|>
   ((parseRules "FindSubstitutions")))

parseRules "VarSub" =
  (((pDetectChar False ':' >>= withAttribute OtherTok) >>~ pushContext "VarSub2")
   <|>
   ((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'2b'28'3f'3d'5b'3a'7d'5d'29 >>= withAttribute OtherTok))
   <|>
   ((parseRules "FindSubstitutions")))

parseRules "VarSub2" =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'28'3f'3d'5b'3a'7d'5d'29 >>= withAttribute OtherTok))
   <|>
   ((parseRules "FindSubstitutions")))

parseRules "SubstFile" =
  (((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules "FindCommentsParen"))
   <|>
   ((parseRules "FindStrings"))
   <|>
   ((parseRules "FindSubstitutions"))
   <|>
   ((parseRules "FindOthers")))

parseRules "SubstCommand" =
  (((pDetectChar False ')' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((parseRules "FindCommentsParen"))
   <|>
   ((parseRules "FindCommands"))
   <|>
   ((parseRules "FindStrings"))
   <|>
   ((parseRules "FindSubstitutions"))
   <|>
   ((parseRules "FindOthers")))

parseRules "SubstBackq" =
  (((pDetectChar False '`' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules "FindCommentsBackq"))
   <|>
   ((parseRules "FindCommands"))
   <|>
   ((parseRules "FindStrings"))
   <|>
   ((parseRules "FindSubstitutions"))
   <|>
   ((parseRules "FindOthers")))

parseRules "Case" =
  (((pRegExpr regex_'5csin'5cb >>= withAttribute KeywordTok) >>~ pushContext "CaseIn")
   <|>
   ((parseRules "FindMost")))

parseRules "CaseIn" =
  (((pRegExpr regex_'5cbesac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ pushContext "CaseExpr")
   <|>
   ((pAnyChar "(|" >>= withAttribute KeywordTok))
   <|>
   ((parseRules "FindMost")))

parseRules "CaseExpr" =
  (((pDetect2Chars False ';' ';' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pFirstNonSpace >> lookAhead (pRegExpr regex_esac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules "FindAll")))

parseRules "HereDoc" =
  (((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29) >> pushContext "HereDocIQ" >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29) >> pushContext "HereDocIQ" >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext "HereDocIQ" >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext "HereDocINQ" >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29) >> pushContext "HereDocQ" >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29) >> pushContext "HereDocQ" >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext "HereDocQ" >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext "HereDocNQ" >> currentContext >>= parseRules))
   <|>
   ((pString False "<<" >>= withAttribute KeywordTok) >>~ (popContext)))

parseRules "HereDocRemainder" =
  ((parseRules "FindAll"))

parseRules "HereDocQ" =
  (((pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ pushContext "HereDocRemainder")
   <|>
   ((pColumn 0 >> pRegExprDynamic "%2\\b" >>= withAttribute KeywordTok) >>~ (popContext >> popContext)))

parseRules "HereDocNQ" =
  (((pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ pushContext "HereDocRemainder")
   <|>
   ((pColumn 0 >> pRegExprDynamic "%2\\b" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "FindSubstitutions")))

parseRules "HereDocIQ" =
  (((pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ pushContext "HereDocRemainder")
   <|>
   ((pColumn 0 >> pRegExprDynamic "\\t*%2\\b" >>= withAttribute KeywordTok) >>~ (popContext >> popContext)))

parseRules "HereDocINQ" =
  (((pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ pushContext "HereDocRemainder")
   <|>
   ((pColumn 0 >> pRegExprDynamic "\\t*%2\\b" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "FindSubstitutions")))

parseRules "" = parseRules "Start"

parseRules x = fail $ "Unknown context" ++ x
